/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.CustomMethodCall;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.17")
@CheckID(value="XVM.4.21.2")
@CheckName(value="XVM.4.21.2")
@CheckLabel(labels={RuleLabel.CONFIG_DB, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="uvm_config_db::get calls must have a corresponding uvm_config_db::set call")
@CheckDescription(value="All uvm_config_db::get calls should have a corresponding uvm_config_db set call in order to be able to retrieve the value set for that field.\n\nLIMITATION: This rule skips those calls for which the field name or instance name is not a literal string, or if the string contains the wildcard character '*'.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_4_21_2
extends OVMComplianceCheck {
    private Set<CustomMethodCall> getCalls = new HashSet<CustomMethodCall>();
    private Set<CustomMethodCall> setCalls = new HashSet<CustomMethodCall>();
    Map<String, RfClass> classMap = new HashMap<String, RfClass>();

    public Check_4_21_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.collectSetAndGetCalls(rfProject);
        this.fOVMProject.getAllClasses().forEach(x -> {
            RfClass rfClass = this.classMap.put(x.getName(), (RfClass)x);
        });
        for (CustomMethodCall getCall : this.getCalls) {
            RfClass getPathClass = this.computePath(getCall, this.getClassFromCntxt(getCall));
            this.notifyCheckAlive();
            boolean exists = false;
            for (CustomMethodCall setCall : this.setCalls) {
                if (!getCall.fieldName.equals(setCall.fieldName)) continue;
                if (getCall.instanceName == null || setCall.instanceName == null) {
                    exists = true;
                    break;
                }
                RfClass setPathClass = this.computePath(setCall, this.getClassFromCntxt(setCall));
                if (getPathClass == null || setPathClass == null || !setPathClass.equals(getPathClass)) continue;
                exists = true;
            }
            if (exists) continue;
            this.addHit(getCall.parserPath, getCall.methodCall.getOccurrence(), "'" + HidUtils.toNiceString((IHidObject)getCall.methodCall.getMethodHid()) + "' call for field name: " + getCall.fieldName.getName() + " does not have a corresponding uvm_config_db::set call!");
        }
    }

    private RfClass getClassFromCntxt(CustomMethodCall call) {
        IRfNamedElement associatedType;
        RfClass rfClass = null;
        if (call.cntxt instanceof RfHid) {
            IRfNamedElement element = ((RfHid)call.cntxt).getElement();
            if (element == null) {
                return null;
            }
            IRfScopeElement enclosingScope = element.getEnclosingScope();
            if (enclosingScope instanceof RfClass) {
                rfClass = (RfClass)enclosingScope;
            }
        }
        if (call.cntxt instanceof RfHidAccessArgs && (associatedType = ((RfHidAccessArgs)call.cntxt).getAssociatedType()) instanceof RfClass) {
            rfClass = (RfClass)associatedType;
        }
        return rfClass;
    }

    private RfClass computePath(CustomMethodCall call, RfClass rfClass) {
        if (call.instanceName == null) {
            return null;
        }
        int i = 0;
        String[] parts = call.instanceName.toString().replace("\"", "").split("\\.");
        if (rfClass == null) {
            if (parts.length == 0) {
                return null;
            }
            String baseClass = parts[i];
            RfClass elem = this.classMap.get(baseClass);
            if (elem == null) {
                Optional<RfClass> baseClassElem = this.classMap.values().stream().filter(clazz -> clazz.getFullName().equals(baseClass)).findFirst();
                if (!baseClassElem.isPresent()) {
                    return null;
                }
                elem = baseClassElem.get();
            }
            rfClass = elem;
            ++i;
        }
        while (i < parts.length) {
            RfClass memberClass;
            int indexOfBracket = parts[i].indexOf(91);
            String current = indexOfBracket == -1 ? parts[i] : parts[i].substring(0, indexOfBracket);
            IRfNamedElement member = rfClass.getMember(current, null, null, true, true, true, false, false);
            if (member == null) break;
            String memberDataTypeClassName = "";
            if (member instanceof RfField) {
                RfField field = (RfField)member;
                DataType dataType = field.getDataType();
                String string = memberDataTypeClassName = dataType != null ? dataType.getType() : null;
            }
            if ((memberClass = this.classMap.get(memberDataTypeClassName)) == null) break;
            ++i;
            rfClass = memberClass;
        }
        return rfClass;
    }

    private void collectSetAndGetCalls(RfProject rfProject) {
        rfProject.visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                if (hid == null) {
                    return true;
                }
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                IRfNamedElement hidNamedElement = hid.getElement();
                if (!(hidNamedElement instanceof RfFunction)) {
                    return true;
                }
                if (Check_4_21_2.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_4_21_2.this.notifyCheckAlive();
                String shortFileName = LintUtils.getFileShortName(this.parserPath.toString());
                if (Check_4_21_2.this.fOVMProject.isOVMFile(shortFileName)) {
                    return true;
                }
                if (this.isCalling(hid, "uvm_pkg::uvm_config_db")) {
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                    if (methodCalls.isEmpty()) {
                        return true;
                    }
                    for (MethodCall methodCall : methodCalls) {
                        CustomMethodCall customeMethodCall;
                        String methodName = methodCall.getMethodHid().getName();
                        if (!methodName.equals("get") && !methodName.equals("set") || (customeMethodCall = this.createCustomMethodCall(methodCall)) == null) continue;
                        if (methodName.equals("get")) {
                            Check_4_21_2.this.getCalls.add(customeMethodCall);
                            continue;
                        }
                        Check_4_21_2.this.setCalls.add(customeMethodCall);
                    }
                }
                return true;
            }

            private CustomMethodCall createCustomMethodCall(MethodCall methodCall) {
                if (methodCall.argumentValuesMapRaw == null) {
                    return null;
                }
                RfHidImplicit fieldName = null;
                RfHidImplicit instanceName = null;
                IHidObject cntxt = null;
                for (IRfNamedElement key : methodCall.argumentValuesMapRaw.keySet()) {
                    IHidObject value = (IHidObject)methodCall.argumentValuesMapRaw.get(key);
                    if (key.getName().equals("field_name") && value instanceof RfHidImplicit) {
                        fieldName = (RfHidImplicit)value;
                        continue;
                    }
                    if (key.getName().equals("inst_name") && value instanceof RfHidImplicit && !((RfHidImplicit)value).getName().contains("*")) {
                        instanceName = (RfHidImplicit)value;
                        continue;
                    }
                    if (!key.getName().equals("cntxt")) continue;
                    cntxt = value;
                }
                if (fieldName == null) {
                    return null;
                }
                return new CustomMethodCall(this.parserPath, methodCall, cntxt, instanceName, fieldName);
            }

            private boolean isCalling(RfHid rfHid, String calledFunction) {
                HidAccess parentAccess = rfHid.getParentAccess();
                if (parentAccess == null) {
                    return false;
                }
                IRfNamedElement associatedType = parentAccess.getAssociatedType();
                if (associatedType == null || !(associatedType instanceof RfClass)) {
                    return false;
                }
                String name = ((RfClass)associatedType).getFullName();
                return name != null && name.equals(calledFunction);
            }
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

