/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrenceBounds;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="16.1.31")
@CheckID(value="XVM.4.22")
@CheckName(value="XVM.4.22")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.ARGUMENT, RuleLabel.REGISTER, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Caller shall always check the status of UVM register layer API calls")
@CheckDescription(value="Status returned as an output argument of UVM register API calls (write, read, update, mirror, peek, poke) and the return value of the predict function must be checked.\nThe 'status' argument and the return value of the predict function can be checked either in an if condition, an assert condition or by using it as an argument for a function, after the API call.\n\nCheck supports pre-waiving.")
public class Check_4_22
extends OVMComplianceCheck {
    private final EnumSet<HidFlatteningOption> HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_SELECTS);
    private static final String UVM_REG = "uvm_reg";
    private static final String PREDICT_ERROR_MESSAGE = "The return value of {0} is not checked!";
    private static final Set<String> UVM_REGISTER_FUNCTION_NAMES = new HashSet<String>();
    @CheckParameter(defaultValue="mirror, peek, poke, read, update, write", description="Comma separated list of UVM register methods (mirror, peek, poke, predict, read, update, write) whose status must be checked.", name="checkedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pRegisterMethods;
    @CheckParameter(defaultValue="false", description="When true, multiple register API calls from different non-nested if/else or case branches can be checked once outside of the conditional block.", name="checkMultipleConditionalCalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckMultipleConditionalCalls;

    static {
        UVM_REGISTER_FUNCTION_NAMES.add("update");
        UVM_REGISTER_FUNCTION_NAMES.add("write");
        UVM_REGISTER_FUNCTION_NAMES.add("read");
        UVM_REGISTER_FUNCTION_NAMES.add("poke");
        UVM_REGISTER_FUNCTION_NAMES.add("peek");
        UVM_REGISTER_FUNCTION_NAMES.add("mirror");
    }

    public Check_4_22(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(1001);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        FirstRunVisitor operatorVisitor = new FirstRunVisitor();
        rfProject.visitHidObject(null, operatorVisitor);
        LocalHidVisitor hidVisitor = new LocalHidVisitor(operatorVisitor);
        rfProject.visitHidObject(rfProject, hidVisitor);
        hidVisitor.reportUnhandledPredictVariables();
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    class FirstRunVisitor
    implements IHidVisitor<IHidObject> {
        private RfFileDef scopeFile;
        private RfNamedElement scope;
        private Map<RfFileDef, Set<HidOccurrenceBounds>> allCheckAssertBounds = new HashMap<RfFileDef, Set<HidOccurrenceBounds>>();
        private Map<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> predictVariables = new HashMap<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>>();
        private Map<ParserPath, Set<HidOccurrence>> predictOccurrences;
        private Map<ParserPath, Map<RfActionBlock, Map<String, HidOccurrence>>> conditionalBlocksOccurences;
        private Map<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> statusVariables = new HashMap<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>>();
        DVTPair<RfActionBlock, DVTPair<String, HidOccurrence>> tempIfElseBlockOccurences;

        public FirstRunVisitor() {
            this.predictOccurrences = new HashMap<ParserPath, Set<HidOccurrence>>();
            this.conditionalBlocksOccurences = new HashMap<ParserPath, Map<RfActionBlock, Map<String, HidOccurrence>>>();
            this.tempIfElseBlockOccurences = new DVTPair(null, null);
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            this.scopeFile = this.scope != null ? this.scope.getFile() : null;
        }

        public boolean visit(IHidObject hidObject) {
            block36: {
                block34: {
                    HidOccurrence predictOccurrence;
                    HidOccurrence hidOccurrence;
                    IRfNamedElement element;
                    HidOperator operator;
                    block35: {
                        if (Check_4_22.this.checkPreWaivers(this.scopeFile)) {
                            return true;
                        }
                        if (!HidUtils.isOperator((IHidObject)hidObject)) break block34;
                        operator = (HidOperator)hidObject;
                        if (!operator.hasOccurrence(HidQualifierCache.IS_ASSERT_EXPRESSION_QUALIFIER)) break block35;
                        HidOperatorOccurrence operatorOccurrence = operator.getOccurrence();
                        if (this.scopeFile == null) {
                            return true;
                        }
                        Check_4_22.this.notifyCheckAlive();
                        Set<HidOccurrenceBounds> checkAssertBounds = this.allCheckAssertBounds.get(this.scopeFile);
                        if (checkAssertBounds == null) {
                            checkAssertBounds = new HashSet<HidOccurrenceBounds>();
                        }
                        checkAssertBounds.add(operatorOccurrence.getBounds());
                        this.allCheckAssertBounds.put(this.scopeFile, checkAssertBounds);
                        break block36;
                    }
                    if (!Check_4_22.this.pRegisterMethods.contains("predict") || !operator.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS)) break block36;
                    Set rhHids = operator.getRHHids(Check_4_22.this.HID_FLATTENING);
                    if (rhHids == null) {
                        return true;
                    }
                    Check_4_22.this.notifyCheckAlive();
                    boolean foundPredict = false;
                    RfHid foundHid = null;
                    for (IHid hid : rhHids) {
                        IRfScopeElement scope;
                        if (!(hid instanceof RfHid) || !hid.getName().equals("predict") || !hid.isMethodCall(false) || (element = hid.getElement()) == null || !(element instanceof RfNamedElement) || (scope = element.getEnclosingScope()) == null || !(scope instanceof RfClass) || !scope.getName().equals(Check_4_22.UVM_REG)) continue;
                        foundPredict = true;
                        foundHid = (RfHid)hid;
                    }
                    if (!foundPredict) break block36;
                    IHidObject lhValue = operator.getLHValue();
                    if (HidUtils.isHid((IHidObject)lhValue) && HidUtils.isResolved((IHidObject)lhValue) && (hidOccurrence = this.getHidOccurrence(operator, (Hid)lhValue)) != null) {
                        List<HidOccurrence> predictVariableOccurrences;
                        element = ((Hid)lhValue).getElement();
                        Map<ParserPath, List<HidOccurrence>> predictVariableOccurrencesMap = this.predictVariables.get(element);
                        if (predictVariableOccurrencesMap == null) {
                            predictVariableOccurrencesMap = new HashMap<ParserPath, List<HidOccurrence>>();
                        }
                        if ((predictVariableOccurrences = predictVariableOccurrencesMap.get(this.scopeFile.getParserPath())) == null) {
                            predictVariableOccurrences = new ArrayList<HidOccurrence>();
                        }
                        predictVariableOccurrences.add(hidOccurrence);
                        predictVariableOccurrencesMap.put(this.scopeFile.getParserPath(), predictVariableOccurrences);
                        this.predictVariables.put(element, predictVariableOccurrencesMap);
                    }
                    if ((predictOccurrence = this.getHidOccurrence(operator, foundHid)) == null) break block36;
                    Set<HidOccurrence> occurrences = this.predictOccurrences.get(this.scopeFile.getParserPath());
                    if (occurrences == null) {
                        occurrences = new HashSet<HidOccurrence>();
                    }
                    occurrences.add(predictOccurrence);
                    this.predictOccurrences.put(this.scopeFile.getParserPath(), occurrences);
                    break block36;
                }
                if (HidUtils.isHid((IHidObject)hidObject)) {
                    Hid hid = (Hid)hidObject;
                    if (!Check_4_22.this.pRegisterMethods.contains(hid.getName()) || hid.getName().equals("predict")) {
                        return true;
                    }
                    IRfNamedElement element = hid.getElement();
                    if (element == null) {
                        return true;
                    }
                    RfNamedElement hidEnclosingScope = ((RfNamedElement)element).getEnclosingScope();
                    if (hidEnclosingScope == null || !(hidEnclosingScope instanceof RfClass) || !hidEnclosingScope.getName().equals(Check_4_22.UVM_REG)) {
                        return true;
                    }
                    if (!hid.hasAccesses()) {
                        return true;
                    }
                    Check_4_22.this.notifyCheckAlive();
                    for (HidAccess hidAccess : hid.getAccesses()) {
                        ListContainer listContainer;
                        IHidObject firstArg;
                        List<? extends IHidObject> argValues;
                        if (!hidAccess.isMethodCall(false) || !(hidAccess instanceof RfHidAccessArgs) || (argValues = ((RfHidAccessArgs)hidAccess).getArgumentValues()) == null || argValues.isEmpty() || !HidUtils.isOperator((IHidObject)(firstArg = argValues.get(0)))) continue;
                        RfHidOperator statusOperator = (RfHidOperator)firstArg;
                        String argName = MethodCallUtils.getMethodArgumentName((IHidObject)firstArg);
                        if (MethodCallUtils.isNamedConnected((IHidObject)firstArg) && !"status".equals(argName)) {
                            statusOperator = null;
                            for (IHidObject iHidObject : argValues) {
                                if (!HidUtils.isOperator((IHidObject)iHidObject) || !"status".equals(argName = MethodCallUtils.getMethodArgumentName((IHidObject)iHidObject))) continue;
                                statusOperator = (RfHidOperator)iHidObject;
                                break;
                            }
                        }
                        if (statusOperator == null || !statusOperator.hasOccurrence(HidOperatorQualifier.IS_ARGUMENT_VALUE) || (listContainer = statusOperator.getRHValues()) == null || listContainer.isEmpty()) continue;
                        for (IHidObject rhValue : listContainer) {
                            HidOccurrence occurrence;
                            List<HidOccurrence> originalOccurrences;
                            Hid valueHid;
                            IRfNamedElement valueElement;
                            if (!HidUtils.isHid((IHidObject)rhValue) || (valueElement = (valueHid = (Hid)rhValue).getElement()) == null) continue;
                            Map<ParserPath, List<HidOccurrence>> originalOccurrencesMap = this.statusVariables.get(valueElement);
                            if (originalOccurrencesMap == null) {
                                originalOccurrencesMap = new HashMap<ParserPath, List<HidOccurrence>>();
                            }
                            if ((originalOccurrences = originalOccurrencesMap.get(this.scopeFile.getParserPath())) == null) {
                                originalOccurrences = new ArrayList<HidOccurrence>();
                            }
                            HidOccurrence valueHidOccurrence = this.getHidOccurrence(statusOperator, valueHid);
                            originalOccurrences.add(valueHidOccurrence);
                            originalOccurrencesMap.put(this.scopeFile.getParserPath(), originalOccurrences);
                            this.statusVariables.put(valueElement, originalOccurrencesMap);
                            if (!Check_4_22.this.pCheckMultipleConditionalCalls || !(this.scope instanceof RfActionBlock)) continue;
                            RfActionBlock block = (RfActionBlock)this.scope;
                            String expression = block.getExpression();
                            if (block.isCaseItem()) {
                                HidOccurrence existingOccurence;
                                Map<String, HidOccurrence> occurences;
                                RfNamedElement caseBlock = block.getEnclosingScope();
                                if (!(caseBlock instanceof RfActionBlock)) continue;
                                RfActionBlock actionBlock = (RfActionBlock)caseBlock;
                                Map<RfActionBlock, Map<String, HidOccurrence>> blocksPerFile = this.conditionalBlocksOccurences.get(this.scopeFile.getParserPath());
                                if (blocksPerFile == null) {
                                    blocksPerFile = new HashMap<RfActionBlock, Map<String, HidOccurrence>>();
                                    this.conditionalBlocksOccurences.put(this.scopeFile.getParserPath(), blocksPerFile);
                                }
                                if ((occurences = blocksPerFile.get(actionBlock)) == null) {
                                    occurences = new HashMap<String, HidOccurrence>();
                                    blocksPerFile.put(actionBlock, occurences);
                                }
                                if ((existingOccurence = occurences.get(expression)) == null) {
                                    occurences.put(expression, valueHidOccurrence);
                                    continue;
                                }
                                int offset = existingOccurence.getOffset() - valueHidOccurrence.getOffset();
                                if (offset == 0) {
                                    offset = existingOccurence.getVirtualOffset() - valueHidOccurrence.getVirtualOffset();
                                }
                                if (offset >= 0) continue;
                                occurences.put(expression, valueHidOccurrence);
                                continue;
                            }
                            if (block.isElsIf()) {
                                this.tempIfElseBlockOccurences.setKey(null);
                                this.tempIfElseBlockOccurences.setValue(null);
                                continue;
                            }
                            if (block.isIf()) {
                                if (this.tempIfElseBlockOccurences.getKey() == null) {
                                    DVTPair pair = new DVTPair((Object)expression, (Object)valueHidOccurrence);
                                    this.tempIfElseBlockOccurences.setKey((Object)block);
                                    this.tempIfElseBlockOccurences.setValue((Object)pair);
                                    continue;
                                }
                                DVTPair existingOccurrence = (DVTPair)this.tempIfElseBlockOccurences.getValue();
                                if (!block.equals(this.tempIfElseBlockOccurences.getKey()) || !((String)existingOccurrence.getKey()).equals(expression)) {
                                    DVTPair pair = new DVTPair((Object)expression, (Object)valueHidOccurrence);
                                    this.tempIfElseBlockOccurences.setKey((Object)block);
                                    this.tempIfElseBlockOccurences.setValue((Object)pair);
                                    continue;
                                }
                                HidOccurrence occurrence2 = (HidOccurrence)existingOccurrence.getValue();
                                int offset = occurrence2.getOffset() - valueHidOccurrence.getOffset();
                                if (offset == 0) {
                                    offset = occurrence2.getVirtualOffset() - valueHidOccurrence.getVirtualOffset();
                                }
                                if (offset >= 0) continue;
                                existingOccurrence.setValue((Object)valueHidOccurrence);
                                continue;
                            }
                            if (!block.isElse()) continue;
                            Map<RfActionBlock, Map<String, HidOccurrence>> blockOccurences = this.conditionalBlocksOccurences.get(this.scopeFile.getParserPath());
                            if (blockOccurences == null) {
                                blockOccurences = new HashMap<RfActionBlock, Map<String, HidOccurrence>>();
                                this.conditionalBlocksOccurences.put(this.scopeFile.getParserPath(), blockOccurences);
                            }
                            Map<String, HidOccurrence> occurrences = null;
                            if (this.tempIfElseBlockOccurences.getKey() != null) {
                                String tempExpression = expression.substring(2, expression.length() - 1);
                                if (tempExpression.equals(((DVTPair)this.tempIfElseBlockOccurences.getValue()).getKey())) {
                                    occurrences = new HashMap<String, HidOccurrence>();
                                    occurrences.put((String)((DVTPair)this.tempIfElseBlockOccurences.getValue()).getKey(), (HidOccurrence)((DVTPair)this.tempIfElseBlockOccurences.getValue()).getValue());
                                    occurrences.put(expression, valueHidOccurrence);
                                    blockOccurences.put(block, occurrences);
                                }
                                this.tempIfElseBlockOccurences.setKey(null);
                                this.tempIfElseBlockOccurences.setValue(null);
                                continue;
                            }
                            occurrences = blockOccurences.get(block);
                            if (occurrences == null || (occurrence = occurrences.get(expression)) == null) continue;
                            int offset = occurrence.getOffset() - valueHidOccurrence.getOffset();
                            if (offset == 0) {
                                offset = occurrence.getVirtualOffset() - valueHidOccurrence.getVirtualOffset();
                            }
                            if (offset >= 0) continue;
                            occurrences.put(expression, valueHidOccurrence);
                        }
                    }
                }
            }
            return true;
        }

        private HidOccurrence getHidOccurrence(HidOperator operator, Hid lhValue) {
            if (lhValue == null) {
                return null;
            }
            HidOccurrence occurrence = lhValue.getOccurrence();
            if (occurrence == null) {
                return null;
            }
            int offset = occurrence.getOffset();
            int virtualOffset = occurrence.getVirtualOffset();
            HidOperatorOccurrence operatorOccurrence = operator.getOccurrence();
            if (offset == operator.getOpenBoundary() && offset == operator.getCloseBoundary() && operatorOccurrence.getOpenVirtualBoundary() < virtualOffset && operatorOccurrence.getCloseVirtualBoundary() > virtualOffset) {
                return occurrence;
            }
            if (operator.getOpenBoundary() <= offset && operator.getCloseBoundary() >= offset) {
                return occurrence;
            }
            return null;
        }

        public Map<RfFileDef, Set<HidOccurrenceBounds>> getAllCheckAssertBounds() {
            return this.allCheckAssertBounds;
        }

        public Map<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> getPredictVariables() {
            for (Map.Entry<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> entry : this.predictVariables.entrySet()) {
                Map<ParserPath, List<HidOccurrence>> value = entry.getValue();
                for (Map.Entry<ParserPath, List<HidOccurrence>> mapEntry : value.entrySet()) {
                    mapEntry.getValue().sort((o1, o2) -> {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return 1;
                        }
                        if (o2 == null) {
                            return -1;
                        }
                        if (o1.getOffset() == o2.getOffset()) {
                            return o1.getVirtualOffset() - o2.getVirtualOffset();
                        }
                        return o1.getOffset() - o2.getOffset();
                    });
                }
            }
            return this.predictVariables;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }

        public Map<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> getStatusVariables() {
            for (Map.Entry<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> entry : this.statusVariables.entrySet()) {
                Map<ParserPath, List<HidOccurrence>> value = entry.getValue();
                for (Map.Entry<ParserPath, List<HidOccurrence>> mapEntry : value.entrySet()) {
                    mapEntry.getValue().sort((o1, o2) -> {
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1 == null) {
                            return 1;
                        }
                        if (o2 == null) {
                            return -1;
                        }
                        if (o1.getOffset() == o2.getOffset()) {
                            return o1.getVirtualOffset() - o2.getVirtualOffset();
                        }
                        return o1.getOffset() - o2.getOffset();
                    });
                }
            }
            return this.statusVariables;
        }

        public Map<ParserPath, Set<HidOccurrence>> getPredictOccurrences() {
            return this.predictOccurrences;
        }

        public Map<ParserPath, Map<RfActionBlock, Map<String, HidOccurrence>>> getConditionalBlocksOccurences() {
            return this.conditionalBlocksOccurences;
        }
    }

    class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath parserPath;
        private Map<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> predictVariables;
        private Map<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> handledPredictVariableOccurrences;
        private Map<ParserPath, Set<HidOccurrence>> predictOccurrences;
        private Map<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> statusVariables;
        private Map<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> handledStatusVariableOccurrences;
        private RfNamedElement scope;
        private Map<RfFileDef, Set<HidOccurrenceBounds>> allCheckAssertBounds;
        private Set<HidOccurrenceBounds> checkAssertBounds;
        private Map<ParserPath, Map<RfActionBlock, Map<String, HidOccurrence>>> conditionalBlocksOccurrences;

        public LocalHidVisitor(FirstRunVisitor operatorVisitor) {
            this.allCheckAssertBounds = operatorVisitor.getAllCheckAssertBounds();
            this.checkAssertBounds = new HashSet<HidOccurrenceBounds>();
            this.predictVariables = new HashMap<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>>(operatorVisitor.getPredictVariables());
            this.handledPredictVariableOccurrences = new HashMap<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>>();
            this.statusVariables = new HashMap<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>>(operatorVisitor.getStatusVariables());
            this.handledStatusVariableOccurrences = new HashMap<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>>();
            this.predictOccurrences = new HashMap<ParserPath, Set<HidOccurrence>>(operatorVisitor.getPredictOccurrences());
            this.conditionalBlocksOccurrences = new HashMap<ParserPath, Map<RfActionBlock, Map<String, HidOccurrence>>>(operatorVisitor.getConditionalBlocksOccurences());
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            RfFileDef file = this.scope != null ? this.scope.getFile() : null;
            Set<HidOccurrenceBounds> set = this.checkAssertBounds = file != null ? this.allCheckAssertBounds.get(file) : null;
            if (this.checkAssertBounds == null) {
                this.checkAssertBounds = Collections.emptySet();
            }
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            if (Check_4_22.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (hidObject.getHidKind() != IHidObject.HidKind.OPERATOR && hidObject.getHidKind() == IHidObject.HidKind.HID) {
                Hid hid = (Hid)hidObject;
                IRfNamedElement element = hid.getElement();
                if (element == null) {
                    return true;
                }
                Map<ParserPath, List<HidOccurrence>> predictOccurencesMap = this.predictVariables.get(element);
                if (predictOccurencesMap != null) {
                    this.handleVariable(hid, false);
                    return true;
                }
                Map<ParserPath, List<HidOccurrence>> originalOccurencesMap = this.statusVariables.get(element);
                if (originalOccurencesMap != null) {
                    this.handleVariable(hid, true);
                    return true;
                }
                String hidName = element.getName();
                if (!Check_4_22.this.pRegisterMethods.contains(hidName)) {
                    return true;
                }
                if ("predict".equals(hidName)) {
                    this.handlePredict(hid);
                    return true;
                }
                return true;
            }
            return true;
        }

        private void handleVariable(Hid hid, boolean isStatus) {
            IRfNamedElement element = hid.getElement();
            Map<ParserPath, List<HidOccurrence>> originalOccurrencesMap = null;
            originalOccurrencesMap = isStatus ? this.statusVariables.get(element) : this.predictVariables.get(element);
            Check_4_22.this.notifyCheckAlive();
            if (originalOccurrencesMap == null) {
                return;
            }
            List<HidOccurrence> originalOccurrences = originalOccurrencesMap.get(this.parserPath);
            HidOccurrence hidOccurrence = hid.getOccurrence();
            if (hidOccurrence != null && originalOccurrences != null && !originalOccurrences.contains(hidOccurrence)) {
                HidOccurrence handledOccurrence = null;
                for (HidOccurrence originalOccurence : originalOccurrences) {
                    if (hidOccurrence.getOffset() <= originalOccurence.getOffset() && (hidOccurrence.getOffset() != originalOccurence.getOffset() || hidOccurrence.getVirtualOffset() <= originalOccurence.getVirtualOffset())) break;
                    handledOccurrence = originalOccurence;
                }
                if (handledOccurrence != null) {
                    if (hidOccurrence.hasQualifier(HidQualifier.HID_IS_IF_CASE_LOOP_EXPR) || hidOccurrence.hasQualifier(HidQualifier.HID_IS_ACTUAL_PART)) {
                        this.addToHandledVariableOccurrences(element, this.parserPath, handledOccurrence, isStatus ? this.handledStatusVariableOccurrences : this.handledPredictVariableOccurrences);
                        return;
                    }
                    int virtualOffset = hidOccurrence.getVirtualOffset();
                    for (HidOccurrenceBounds bound : this.checkAssertBounds) {
                        if (!bound.contains(hidOccurrence.getOffset(), virtualOffset)) continue;
                        this.addToHandledVariableOccurrences(element, this.parserPath, handledOccurrence, isStatus ? this.handledStatusVariableOccurrences : this.handledPredictVariableOccurrences);
                        return;
                    }
                }
            }
        }

        private void addToHandledVariableOccurrences(IRfNamedElement element, ParserPath path, HidOccurrence handledOccurrence, Map<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> handledVariableOccurrences) {
            List<HidOccurrence> handledOccurrences;
            Map<ParserPath, List<HidOccurrence>> handledMap;
            if (handledVariableOccurrences == null) {
                handledVariableOccurrences = new HashMap<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>>();
            }
            if ((handledMap = handledVariableOccurrences.get(element)) == null) {
                handledMap = new HashMap<ParserPath, List<HidOccurrence>>();
            }
            if ((handledOccurrences = handledMap.get(path)) == null) {
                handledOccurrences = new ArrayList<HidOccurrence>();
            }
            if (handledOccurrence != null) {
                handledOccurrences.add(handledOccurrence);
            }
            handledMap.put(path, handledOccurrences);
            handledVariableOccurrences.put(element, handledMap);
            if (Check_4_22.this.pCheckMultipleConditionalCalls) {
                Map<RfActionBlock, Map<String, HidOccurrence>> occurrences = this.conditionalBlocksOccurrences.get(path);
                if (occurrences == null || occurrences.isEmpty()) {
                    return;
                }
                for (Map.Entry<RfActionBlock, Map<String, HidOccurrence>> entry : occurrences.entrySet()) {
                    if (!occurrences.get(entry.getKey()).values().contains(handledOccurrence)) continue;
                    Map<String, HidOccurrence> map = entry.getValue();
                    handledOccurrences.addAll(map.values());
                }
            }
        }

        private void handlePredict(Hid hid) {
            if (!hid.isMethodCall(false)) {
                return;
            }
            IRfNamedElement predictFunction = hid.getElement();
            if (predictFunction.getEnclosingScope() == null || !Check_4_22.UVM_REG.equals(predictFunction.getEnclosingScope().getName())) {
                return;
            }
            Check_4_22.this.notifyCheckAlive();
            HidOccurrence hidOccurrence = hid.getOccurrence();
            if (hidOccurrence == null) {
                return;
            }
            if (hidOccurrence.hasQualifier(HidQualifier.HID_IS_IF_CASE_LOOP_EXPR) || hidOccurrence.hasQualifier(HidQualifier.HID_IS_ACTUAL_PART)) {
                return;
            }
            int virtualOffset = hidOccurrence.getVirtualOffset();
            for (HidOccurrenceBounds bound : this.checkAssertBounds) {
                if (!bound.contains(hidOccurrence.getOffset(), virtualOffset)) continue;
                return;
            }
            Set<HidOccurrence> occurrences = this.predictOccurrences.get(this.parserPath);
            if (occurrences != null && occurrences.contains(hidOccurrence)) {
                return;
            }
            Check_4_22.this.addHit(this.parserPath, hidOccurrence, MessageFormat.format(Check_4_22.PREDICT_ERROR_MESSAGE, LintUtils.getHierarchicalPath(hid)));
        }

        public void reportUnhandledPredictVariables() {
            List<HidOccurrence> handledOccurrences;
            List<HidOccurrence> statusOccurrences;
            ParserPath path;
            Map<ParserPath, List<HidOccurrence>> handledOccurrencesMap;
            Map<ParserPath, List<HidOccurrence>> statusMap;
            IRfNamedElement element;
            for (Map.Entry<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> statusEntry : this.predictVariables.entrySet()) {
                element = statusEntry.getKey();
                if (!(element instanceof RfNamedElement)) continue;
                statusMap = statusEntry.getValue();
                handledOccurrencesMap = this.handledPredictVariableOccurrences.get(element);
                if (handledOccurrencesMap == null || handledOccurrencesMap.isEmpty()) {
                    for (Map.Entry<ParserPath, List<HidOccurrence>> entry : statusMap.entrySet()) {
                        path = entry.getKey();
                        for (HidOccurrence occurrence : entry.getValue()) {
                            Check_4_22.this.addHit(path, occurrence, "Variable '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "'" + " used as return value for predict is not checked!");
                        }
                    }
                    continue;
                }
                for (Map.Entry<ParserPath, List<HidOccurrence>> entry : statusMap.entrySet()) {
                    path = entry.getKey();
                    statusOccurrences = entry.getValue();
                    handledOccurrences = handledOccurrencesMap.get(path);
                    if (handledOccurrences != null) {
                        statusOccurrences.removeAll(handledOccurrences);
                    }
                    for (HidOccurrence occurrence : statusOccurrences) {
                        Check_4_22.this.addHit(path, occurrence, "Variable '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "'" + " used as return value for predict is not checked!");
                    }
                }
            }
            for (Map.Entry<IRfNamedElement, Map<ParserPath, List<HidOccurrence>>> statusEntry : this.statusVariables.entrySet()) {
                element = statusEntry.getKey();
                if (!(element instanceof RfNamedElement)) continue;
                statusMap = statusEntry.getValue();
                handledOccurrencesMap = this.handledStatusVariableOccurrences.get(element);
                if (handledOccurrencesMap == null || handledOccurrencesMap.isEmpty()) {
                    for (Map.Entry<ParserPath, List<HidOccurrence>> entry : statusMap.entrySet()) {
                        path = entry.getKey();
                        for (HidOccurrence occurrence : entry.getValue()) {
                            Check_4_22.this.addHit(path, occurrence, "'" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "'" + " output argument is not checked!");
                        }
                    }
                    continue;
                }
                for (Map.Entry<ParserPath, List<HidOccurrence>> entry : statusMap.entrySet()) {
                    path = entry.getKey();
                    statusOccurrences = entry.getValue();
                    handledOccurrences = handledOccurrencesMap.get(path);
                    if (handledOccurrences != null) {
                        statusOccurrences.removeAll(handledOccurrences);
                    }
                    for (HidOccurrence occurrence : statusOccurrences) {
                        Check_4_22.this.addHit(path, occurrence, "'" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "'" + " output argument is not checked!");
                    }
                }
            }
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

