/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractSetConfigurationFunctionCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="18.1.8")
@CheckID(value="XVM.4.23")
@CheckName(value="XVM.4.23")
@CheckLabel(labels={RuleLabel.PERFORMANCE, RuleLabel.NAME, RuleLabel.FIELD, RuleLabel.CONFIG_DB, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use wildcards or regex for field names when setting configuration properties")
@CheckDescription(value="Up until UVM-1.1d, using wildcards or regex for specifying field names can lead to a significant overhead because the lookup is linear instead of logarithmic.\nThe performance is also affected by the extra overhead of regular expressions.\n\nImplementation details:\nOnly the field name passed by literal value is checked.\n\nCheck supports pre-waiving.")
public class Check_4_23
extends AbstractSetConfigurationFunctionCheck {
    private static final Pattern REGEX_MATCHER = Pattern.compile("/.*/");
    private static final Pattern WILDCARDS_MATCHER = Pattern.compile("[\\{\\}\\*\\+\\?\\|\\^\\$]");

    public Check_4_23(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
        this.checkSetConfig = true;
    }

    public void checkForWildcards(String fieldName, RfHid hid, ParserPath parserPath) {
        if (fieldName == null) {
            return;
        }
        Matcher hasWildcards = REGEX_MATCHER.matcher(fieldName);
        if (hasWildcards.find()) {
            String matchedWildcard = hasWildcards.group();
            this.addHit(parserPath, hid, "Regex '" + matchedWildcard + "' is used for field name in method '" + LintUtils.getNamedElementFullName((RfNamedElement)hid.getElement()) + "'!");
            return;
        }
        hasWildcards = WILDCARDS_MATCHER.matcher(fieldName);
        if (hasWildcards.find()) {
            String matchedWildcard = hasWildcards.group();
            this.addHit(parserPath, hid, "Wildcard '" + matchedWildcard + "' is used for field name in method '" + LintUtils.getNamedElementFullName((RfNamedElement)hid.getElement()) + "'!");
        }
    }

    @Override
    protected void checkMethodCalls(List<MethodCall> methodCalls, RfHid hid, ParserPath parserPath) {
        for (MethodCall methodCall : methodCalls) {
            String hidName;
            if (methodCall == null || methodCall.argumentValuesMapRaw == null) continue;
            IHidObject fieldName = null;
            for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                IRfNamedElement key = (IRfNamedElement)entry.getKey();
                if (!"field_name".equals(key.getName())) continue;
                fieldName = (IHidObject)entry.getValue();
            }
            if (fieldName == null || (hidName = hid.getName()) == null || !"set".equals(hidName) && !SET_FUNCTION_WRAPPERS.contains(hidName) || !(fieldName instanceof RfHidImplicit)) continue;
            this.checkForWildcards(((RfHidImplicit)fieldName).getName(), hid, parserPath);
        }
    }
}

