/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="18.1.22")
@CheckID(value="XVM.4.24")
@CheckName(value="XVM.4.24")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.REGISTER, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use uvm_reg.update() after using uvm_reg.predict()")
@CheckDescription(value="uvm_reg.predict() updates the mirrored and desired value for the register, while uvm_reg.update() updates the register in the design in order to match the desired value. Therefore, using update() after predict() does not make any changes because after prediction the mirrored and desired value are the same.\n\nCheck supports pre-waiving.")
public class Check_4_24
extends OVMComplianceCheck {
    private static final String UPDATE = "update";
    private static final String PREDICT = "predict";
    private static final String UVM_REG = "uvm_reg";
    private Map<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> predictCallsMap = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();
    private Map<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> updateCallsMap = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();
    private Map<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>> validUpdateCallsMap = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();

    public Check_4_24(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.predictCallsMap = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();
        this.updateCallsMap = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();
        this.validUpdateCallsMap = new HashMap<RfHidAccess, Map<RfNamedElement, Set<HidOccurrence>>>();
        this.getAllPredictAndUpdateHids();
        this.checkRegistersOtherAppearances();
        Set<RfHidAccess> registers = this.updateCallsMap.keySet();
        for (RfHidAccess register : registers) {
            if (!this.predictCallsMap.containsKey((Object)register)) continue;
            Map<RfNamedElement, Set<HidOccurrence>> updateCalls = this.updateCallsMap.get((Object)register);
            Map<RfNamedElement, Set<HidOccurrence>> predictCalls = this.predictCallsMap.get((Object)register);
            Map<RfNamedElement, Set<HidOccurrence>> validUpdatesCalls = this.validUpdateCallsMap.get((Object)register);
            Set<RfNamedElement> updateCallsScopes = updateCalls.keySet();
            for (RfNamedElement scope : updateCallsScopes) {
                Set<HidOccurrence> updateCallHidOccurrences;
                Set<HidOccurrence> predictCallHidOccurrences;
                if (!predictCalls.containsKey(scope) || this.checkPreWaivers(scope.getFile()) || (predictCallHidOccurrences = predictCalls.get(scope)) == null || predictCallHidOccurrences.isEmpty() || (updateCallHidOccurrences = updateCalls.get(scope)) == null || updateCallHidOccurrences.isEmpty()) continue;
                Set<HidOccurrence> validUpdateOccurrencesInScope = validUpdatesCalls != null ? validUpdatesCalls.get(scope) : null;
                for (HidOccurrence occurrence : updateCallHidOccurrences) {
                    HidOccurrence lastPredict;
                    if (validUpdateOccurrencesInScope != null && validUpdateOccurrencesInScope.contains(occurrence) || (lastPredict = this.getLastPredictBeforeOffset(predictCallHidOccurrences, occurrence.getOffset())) == null || register.getParentHid() == null) continue;
                    RfDefElement scopeDeclaration = scope.getDeclaration();
                    String file = scopeDeclaration.getDefFile().getName();
                    String registerName = register.getParentHid().getName();
                    this.addHit(scopeDeclaration.getParserPath(), occurrence, "update used after predict on register " + registerName + "!\n" + registerName + ".predict " + this.link("at line " + lastPredict.getLine() + " in file " + file, file, lastPredict.getLine()) + "\n" + registerName + ".update " + this.link("at line " + occurrence.getLine() + " in file " + file, file, occurrence.getLine()));
                }
            }
        }
    }

    private void getAllPredictAndUpdateHids() {
        RfHidVisitor visitor = new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (!hidObject.isMethodCall(false)) {
                    return true;
                }
                if (Check_4_24.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                HidAccess parentAccess = hidObject.getParentAccess();
                Hid parentHid = hidObject.getParentHid();
                if (parentHid == null || !(parentAccess instanceof RfHidAccess) || parentAccess.getAssociatedType() == null) {
                    return true;
                }
                if (!Check_4_24.UVM_REG.equals(parentAccess.getAssociatedType().getName())) {
                    return true;
                }
                if (!(this.holder instanceof RfHidHolder)) {
                    return true;
                }
                IRfNamedElement scope = ((RfHidHolder)this.holder).getScope();
                if (!(scope instanceof RfNamedElement)) {
                    return true;
                }
                Check_4_24.this.notifyCheckAlive();
                if (!(parentAccess instanceof RfHidAccess)) {
                    return true;
                }
                RfHidAccess hidAccess = (RfHidAccess)parentAccess;
                if (Check_4_24.PREDICT.equals(hidObject.getName())) {
                    Map<RfNamedElement, Set<HidOccurrence>> map;
                    Set<HidOccurrence> predictCallOccurrencesInScope;
                    if (!Check_4_24.this.predictCallsMap.containsKey((Object)hidAccess)) {
                        Check_4_24.this.predictCallsMap.put(hidAccess, new HashMap());
                    }
                    if ((predictCallOccurrencesInScope = (map = Check_4_24.this.predictCallsMap.get((Object)hidAccess)).get(scope)) == null) {
                        predictCallOccurrencesInScope = new LinkedHashSet<HidOccurrence>();
                        map.put((RfNamedElement)scope, predictCallOccurrencesInScope);
                    }
                    predictCallOccurrencesInScope.add(hidObject.getOccurrence());
                } else if (Check_4_24.UPDATE.equals(hidObject.getName())) {
                    Map<RfNamedElement, Set<HidOccurrence>> map;
                    Set<HidOccurrence> updateCallOccurrencesInScope;
                    if (!Check_4_24.this.updateCallsMap.containsKey((Object)hidAccess)) {
                        Check_4_24.this.updateCallsMap.put(hidAccess, new HashMap());
                    }
                    if ((updateCallOccurrencesInScope = (map = Check_4_24.this.updateCallsMap.get((Object)hidAccess)).get(scope)) == null) {
                        updateCallOccurrencesInScope = new LinkedHashSet<HidOccurrence>();
                        map.put((RfNamedElement)scope, updateCallOccurrencesInScope);
                    }
                    updateCallOccurrencesInScope.add(hidObject.getOccurrence());
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
    }

    private void checkRegistersOtherAppearances() {
        Set<RfHidAccess> registerAccesses = this.updateCallsMap.keySet();
        for (RfHidAccess register : registerAccesses) {
            if (!this.predictCallsMap.containsKey((Object)register)) continue;
            Map<RfNamedElement, Set<HidOccurrence>> updateCalls = this.updateCallsMap.get((Object)register);
            Map<RfNamedElement, Set<HidOccurrence>> predictCalls = this.predictCallsMap.get((Object)register);
            Set<RfNamedElement> updateCallsScopes = updateCalls.keySet();
            for (RfNamedElement scope : updateCallsScopes) {
                if (!predictCalls.containsKey(scope)) continue;
                this.checkRegisterAppearancesInScope(register, scope, (Collection<HidOccurrence>)predictCalls.get(scope), (Collection<HidOccurrence>)updateCalls.get(scope));
            }
        }
    }

    private void checkRegisterAppearancesInScope(final RfHidAccess register, final RfNamedElement scope, final Collection<HidOccurrence> predictHidInScope, final Collection<HidOccurrence> updateHidInScope) {
        if (register == null || scope == null || predictHidInScope == null || updateHidInScope == null) {
            return;
        }
        IHidVisitor<IHidObject> visitor = new IHidVisitor<IHidObject>(){
            private ParserPath parserPath;

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public boolean visit(IHidObject hidObject) {
                if (Check_4_24.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (hidObject instanceof RfHid) {
                    RfHid hid = (RfHid)hidObject;
                    if (!hid.isMethodCall(false)) {
                        return true;
                    }
                    if (Check_4_24.UPDATE.equals(hid.getName()) || Check_4_24.PREDICT.equals(hid.getName())) {
                        return true;
                    }
                    HidAccess parentAccess = hid.getParentAccess();
                    if (parentAccess == null || parentAccess.getAssociatedType() == null) {
                        return true;
                    }
                    if (!Check_4_24.UVM_REG.equals(parentAccess.getAssociatedType().getName())) {
                        return true;
                    }
                    if (!(parentAccess instanceof RfHidAccess) || !register.equals(parentAccess)) {
                        return true;
                    }
                    Check_4_24.this.checkOccurrences((IHidObject)hid, updateHidInScope, predictHidInScope, register, scope);
                } else if (hidObject instanceof RfHidOperator) {
                    RfHidOperator hid = (RfHidOperator)hidObject;
                    if (!hid.isEqualAssignment()) {
                        return true;
                    }
                    IHidObject leftValue = hid.getLHValue();
                    if (!(leftValue instanceof RfHid)) {
                        return true;
                    }
                    RfHid left = (RfHid)leftValue;
                    HidAccess hidAccess = left.getParentAccess();
                    if (hidAccess == null) {
                        IRfNamedElement element = left.getElement();
                        if (!(element instanceof RfField)) {
                            return true;
                        }
                        RfClass associatedType = LintUtils.getFieldFinalClassTypeOrNull((RfField)element);
                        if (associatedType == null || !Check_4_24.UVM_REG.equals(associatedType.getName())) {
                            return true;
                        }
                        if (register.getParentHid() == null || !register.getParentHid().equals((Object)left)) {
                            return true;
                        }
                        Check_4_24.this.checkOccurrences((IHidObject)hid, updateHidInScope, predictHidInScope, register, scope);
                    } else {
                        RfNamedElement associatedType = (RfNamedElement)hidAccess.getAssociatedType();
                        if (associatedType == null || !Check_4_24.UVM_REG.equals(associatedType.getName())) {
                            return true;
                        }
                        if (!(hidAccess instanceof RfHidAccess) || !register.equals(hidAccess)) {
                            return true;
                        }
                        Check_4_24.this.checkOccurrences((IHidObject)hid, updateHidInScope, predictHidInScope, register, scope);
                    }
                } else if (hidObject instanceof RfHidAccessArgs) {
                    RfHidAccessArgs hid = (RfHidAccessArgs)hidObject;
                    Hid parentHid = hid.getParentHid();
                    if (parentHid == null) {
                        return true;
                    }
                    if (Check_4_24.PREDICT.equals(parentHid.getName()) || Check_4_24.UPDATE.equals(parentHid.getName())) {
                        return true;
                    }
                    List<? extends IHidObject> arguments = hid.getArgumentValues();
                    for (IHidObject iHidObject : arguments) {
                        if (!(iHidObject instanceof RfHidOperator)) {
                            return true;
                        }
                        ListContainer rightValues = ((RfHidOperator)iHidObject).getRHValues();
                        for (IHidObject value : rightValues) {
                            if (!(value instanceof RfHid)) continue;
                            HidAccess parentAccess = ((RfHid)value).getParentAccess();
                            if (!value.equals(register.getParentHid()) && !register.equals(parentAccess)) {
                                return true;
                            }
                            Check_4_24.this.checkOccurrences((IHidObject)hid, updateHidInScope, predictHidInScope, register, scope);
                        }
                    }
                }
                return true;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        };
        scope.visitHidObject(this.fOVMProject.getRfProject(), visitor);
    }

    private void checkOccurrences(IHidObject hid, Collection<HidOccurrence> updateOccurrences, Collection<HidOccurrence> predictOccurrences, RfHidAccess register, RfNamedElement scope) {
        if (hid == null) {
            return;
        }
        if (hid instanceof RfHid) {
            HidOccurrence occurrence = ((RfHid)hid).getOccurrence();
            this.checkIfBetweenPredictAndUpdate(occurrence.getOffset(), updateOccurrences, predictOccurrences, register, scope);
        } else if (hid instanceof RfHidOperator) {
            HidOperatorOccurrence occurrence = ((RfHidOperator)hid).getOccurrence();
            this.checkIfBetweenPredictAndUpdate(occurrence.getOffset(), updateOccurrences, predictOccurrences, register, scope);
        } else if (hid instanceof RfHidAccessArgs) {
            HidOccurrence occurrence = ((RfHidAccessArgs)hid).getOccurrence();
            this.checkIfBetweenPredictAndUpdate(occurrence.getOffset(), updateOccurrences, predictOccurrences, register, scope);
        }
    }

    private void checkIfBetweenPredictAndUpdate(int offset, Collection<HidOccurrence> updateOccurrences, Collection<HidOccurrence> predictOccurrences, RfHidAccess register, RfNamedElement scope) {
        for (HidOccurrence update : updateOccurrences) {
            HidOccurrence lastPredict;
            if (update.getOffset() < offset || (lastPredict = this.getLastPredictBeforeOffset(predictOccurrences, update.getOffset())) != null && (lastPredict.getOffset() >= offset || update.getOffset() <= offset)) continue;
            if (!this.validUpdateCallsMap.containsKey((Object)register)) {
                this.validUpdateCallsMap.put(register, new HashMap());
            }
            if (!this.validUpdateCallsMap.get((Object)register).containsKey(scope)) {
                this.validUpdateCallsMap.get((Object)register).put(scope, new LinkedHashSet());
            }
            this.validUpdateCallsMap.get((Object)register).get(scope).add(update);
        }
    }

    private HidOccurrence getLastPredictBeforeOffset(Collection<HidOccurrence> predictOccurrences, int offset) {
        if (predictOccurrences == null || predictOccurrences.isEmpty()) {
            return null;
        }
        HidOccurrence lastOccurence = null;
        for (HidOccurrence occurrence : predictOccurrences) {
            if (occurrence.getOffset() >= offset) break;
            lastOccurence = occurrence;
        }
        return lastOccurence;
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

