/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractSetConfigurationFunctionCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="18.1.23")
@CheckID(value="XVM.4.25")
@CheckName(value="XVM.4.25")
@CheckLabel(labels={RuleLabel.CONFIG_DB, RuleLabel.ARGUMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use 'null' for context when setting configuration properties")
@CheckDescription(value="Do not use 'null' for context when setting configuration properties. To set in the global context use uvm_root::get() instead.\n\nExamples:\nuvm_config_db #()::set(null, \"instance\", \"field\", object); // Not allowed\nuvm_config_db #()::set(uvm_root::get(), \"instance\", \"field\", object); // Allowed\n\nCheck supports pre-waiving.")
public class Check_4_25
extends AbstractSetConfigurationFunctionCheck {
    private static final String ARG_NAME = "cntxt";

    public Check_4_25(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
        this.checkSetConfig = true;
    }

    @Override
    protected void checkMethodCalls(List<MethodCall> methodCalls, RfHid hid, ParserPath parserPath) {
        if (!hid.isMethodCall(false)) {
            return;
        }
        RfField arg = ((RfFunction)hid.getElement()).getArgumentWithPrefix(ARG_NAME, 1);
        if (arg == null) {
            return;
        }
        for (MethodCall methodCall : methodCalls) {
            IHidObject argumentHidObject = (IHidObject)methodCall.argumentValuesMapRaw.get(arg);
            IHidObject actualPart = MethodCallUtils.getActualPartRaw((IHidObject)argumentHidObject, (long)HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER);
            if (!HidUtils.isHidImplicit((IHidObject)actualPart) || !((RfHidImplicit)actualPart).isLiteralNull()) continue;
            this.addHit(parserPath, hid, "'null' is used for context in method '" + LintUtils.getNamedElementFullName((RfNamedElement)hid.getElement()) + "'!");
        }
    }
}

