/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractSetConfigurationFunctionCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfStringType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="18.1.42")
@CheckID(value="XVM.4.27")
@CheckName(value="XVM.4.27")
@CheckLabel(labels={RuleLabel.CONFIG_DB, RuleLabel.ARGUMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use whitespaces for instance name or field name parameters when setting or getting configuration properties")
@CheckDescription(value="Do not use whitespaces for instance name or field name parameters when setting or getting configuration properties.\n\nExamples:\nuvm_config_db #()::set(uvm_root::get(), \"instance name\", \"field name\", object); // Not allowed\nuvm_config_db #()::set(uvm_root::get(), \"instance_name\", \"field_name\", object); // Allowed\n\nCheck supports pre-waiving.")
public class Check_4_27
extends AbstractSetConfigurationFunctionCheck {
    public Check_4_27(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
        this.checkGetConfig = true;
        this.checkSetConfig = true;
    }

    @Override
    protected void checkMethodCalls(List<MethodCall> methodCalls, RfHid hid, ParserPath parserPath) {
        if (!hid.isMethodCall(false)) {
            return;
        }
        block0: for (MethodCall methodCall : methodCalls) {
            for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                Pattern pattern;
                Matcher matcher;
                IRfNamedElement key = (IRfNamedElement)entry.getKey();
                if (!"inst_name".equals(key.getName()) && !"field_name".equals(key.getName())) continue;
                IHidObject value = (IHidObject)entry.getValue();
                String passedValue = null;
                if (value instanceof RfHidImplicit) {
                    passedValue = ((RfHidImplicit)value).getName();
                } else if (value instanceof RfHid) {
                    IRfNamedElement element = ((RfHid)value).getElement();
                    if (!(element instanceof RfField)) continue;
                    IRfNamedElement argumentType = ((RfField)element).getAssociatedType();
                    if (argumentType instanceof RfTypeAlias) {
                        argumentType = ((RfTypeAlias)argumentType).getTranslatedType();
                    }
                    if (!(argumentType instanceof RfStringType)) continue;
                    passedValue = ((RfField)element).getInitialValue(false);
                }
                if (passedValue == null || !(matcher = (pattern = Pattern.compile("\\s")).matcher(passedValue)).find()) continue;
                if ("inst_name".equals(key.getName())) {
                    this.addHit(parserPath, methodCall.occurrence, "Whitespace is used for instance name parameter inside method '" + LintUtils.getNamedElementFullName((RfNamedElement)hid.getElement()) + "'!");
                    continue block0;
                }
                this.addHit(parserPath, methodCall.occurrence, "Whitespace is used for field name parameter inside method '" + LintUtils.getNamedElementFullName((RfNamedElement)hid.getElement()) + "'!");
                continue block0;
            }
        }
    }
}

