/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfSuperImplicitVariable;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.utils.Utils;

@CheckVersion(value="20.1.33")
@CheckID(value="XVM.4.28")
@CheckName(value="XVM.4.28")
@CheckLabel(labels={RuleLabel.CONFIG_DB, RuleLabel.RUN_PHASE, RuleLabel.METHOD, RuleLabel.PERFORMANCE, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not call UVM Resource Database and UVM Configuration Database API from run phases")
@CheckDescription(value="Calling API from the uvm_resource_db or the uvm_config_db classes is performance intensive and should not occur in the run phase.\nThis rule flags the following method calls: uvm_config_db::get, uvm_config_db::set, uvm_resource_db::get_by_name, uvm_resource_db::get_by_type,\nuvm_resource_db::read_by_name, uvm_resource_db::read_by_type, uvm_resource_db::set, uvm_resource_db::set_anonymous, uvm_resource_db::set_default,\nuvm_resource_db::set_override, uvm_resource_db::set_override_name, uvm_resource_db::set_override_type, uvm_resource_db::write_by_name, uvm_resource_db::write_by_type\nwhen they are called from run phases and other methods called from run phases.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_4_28
extends OVMComplianceCheck {
    private static final Set<String> UVM_RESOURCE_DB_FUNCTIONS = new HashSet<String>();
    @CheckParameter(defaultValue="", description="Comma separated list of loop statements inside which UVM Resource and Configuration Database API calls are not allowed. If empty, all calls will be reported. One or more of the following: for, repeat, foreach, while, do, forever.", name="checkAPICallsInLoops", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCheckAPICallsInLoops;
    @CheckParameter(defaultValue="false", description="When true, only the shortest path to a forbidden function call will be shown.", name="enableRootCauseMode", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pEnableRootCauseModeValue;
    @CheckParameter(defaultValue="false", description="When true, skip calls made inside a sequence class.", name="skipCallsFromSequences", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipCallsFromSequences;
    private Map<HidInformation, List<List<DVTPair<RfFunction, String>>>> callStacksForHid;
    private Set<PotentialHit> potentialHits;
    RfClass sequenceBaseClass;
    private Set<RfClass> allXVMSequences;
    private Map<String, Set<RfFunction>> functionsInPotentialHitPath;

    static {
        UVM_RESOURCE_DB_FUNCTIONS.add("get_by_name");
        UVM_RESOURCE_DB_FUNCTIONS.add("get_by_type");
        UVM_RESOURCE_DB_FUNCTIONS.add("read_by_name");
        UVM_RESOURCE_DB_FUNCTIONS.add("read_by_type");
        UVM_RESOURCE_DB_FUNCTIONS.add("set");
        UVM_RESOURCE_DB_FUNCTIONS.add("set_anonymous");
        UVM_RESOURCE_DB_FUNCTIONS.add("set_default");
        UVM_RESOURCE_DB_FUNCTIONS.add("set_override");
        UVM_RESOURCE_DB_FUNCTIONS.add("set_override_name");
        UVM_RESOURCE_DB_FUNCTIONS.add("set_override_type");
        UVM_RESOURCE_DB_FUNCTIONS.add("write_by_name");
        UVM_RESOURCE_DB_FUNCTIONS.add("write_by_type");
    }

    @Override
    public void configure() {
        super.configure();
        for (String paramValue : this.pCheckAPICallsInLoops) {
            if (LintUtilsConstants.REPETITIVE_STATEMENTS.contains(paramValue)) continue;
            this.signalParamError("Invalid value for the 'checkAPICallsInLoops' parameter: " + paramValue + "!", true);
        }
    }

    public Check_4_28(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<RfClass> visited;
        this.potentialHits = new HashSet<PotentialHit>();
        this.callStacksForHid = new HashMap<HidInformation, List<List<DVTPair<RfFunction, String>>>>();
        this.allXVMSequences = new HashSet<RfClass>();
        this.functionsInPotentialHitPath = new HashMap<String, Set<RfFunction>>();
        String componentClassName = "uvm_pkg::uvm_component";
        String sequenceBaseClassName = "uvm_pkg::uvm_sequence_base";
        RfClass baseComponentClass = this.fOVMProject.getRfProject().getClass(componentClassName, true);
        this.sequenceBaseClass = this.fOVMProject.getRfProject().getClass(sequenceBaseClassName, true);
        if (baseComponentClass != null) {
            visited = new HashSet<RfClass>();
            this.checkClass(baseComponentClass, visited);
        }
        if (this.sequenceBaseClass != null && !this.pSkipCallsFromSequences) {
            visited = new HashSet();
            this.checkClass(this.sequenceBaseClass, visited);
        }
        this.applyHits();
    }

    private void checkClass(RfClass currentClass, Set<RfClass> visited) {
        Set<RfClass> classes;
        if (currentClass == null) {
            return;
        }
        if (visited.contains(currentClass)) {
            return;
        }
        visited.add(currentClass);
        RfFileDef file = currentClass.getFile();
        if (file == null) {
            return;
        }
        this.notifyCheckAlive();
        if (!this.fOVMProject.isOVMElement(currentClass) && !this.checkPreWaivers(file.getParserPath())) {
            List<RfFunction> functions = currentClass.getLocalMembers(RfFunction.class);
            if (functions == null || functions.isEmpty()) {
                return;
            }
            for (RfFunction function : functions) {
                if (function.isPredefined() || (this.pSkipCallsFromSequences ? !LintUtilsConstants.RUN_PHASE_FUNCTIONS.contains(function.getName()) : !LintUtilsConstants.RUN_PHASE_BODY_FUNCTIONS.contains(function.getName()))) continue;
                HashSet<RfFunction> visitedFunctions = new HashSet<RfFunction>();
                ArrayList<DVTPair<RfFunction, String>> functionCallTree = new ArrayList<DVTPair<RfFunction, String>>();
                visitedFunctions.add(function);
                functionCallTree.add(new DVTPair((Object)function, (Object)""));
                function.visitHidObject(this.fOVMProject.getRfProject(), new SetOrGetConfigurationFunctionVisitor(visitedFunctions, functionCallTree, false));
            }
        }
        if ((classes = currentClass.getChildren()) == null || classes.isEmpty()) {
            return;
        }
        for (RfClass eachClass : classes) {
            this.checkClass(eachClass, visited);
        }
    }

    private boolean isCalling(RfHid rfHid, String calledFunction) {
        HidAccess parentAccess = rfHid.getParentAccess();
        if (parentAccess == null) {
            return false;
        }
        IRfNamedElement associatedType = parentAccess.getAssociatedType();
        if (associatedType == null || !(associatedType instanceof RfClass)) {
            return false;
        }
        String name = ((RfClass)associatedType).getFullName();
        return name != null && name.equals(calledFunction);
    }

    private Set<RfFunction> getChildImplementations(RfFunction function, List<DVTPair<RfFunction, String>> functionCallTree) {
        LinkedHashSet<RfFunction> result = new LinkedHashSet<RfFunction>();
        if (function == null) {
            return result;
        }
        RfClass enclosingClass = function.getEnclosingScope(RfClass.class);
        if (enclosingClass == null) {
            return result;
        }
        Set<RfClass> children = enclosingClass.getChildren();
        if (children == null || children.isEmpty()) {
            return result;
        }
        for (RfClass child : children) {
            HashSet<RfClass> visited = new HashSet<RfClass>();
            this.recursiveCollectImplementations(function, result, child, functionCallTree, visited);
        }
        return result;
    }

    private void recursiveCollectImplementations(RfFunction function, Set<RfFunction> result, RfClass clazz, List<DVTPair<RfFunction, String>> functionCallTree, Set<RfClass> visited) {
        Set<RfClass> children;
        if (visited.contains(clazz)) {
            return;
        }
        visited.add(clazz);
        RfFunction implementation = clazz.getLocalMember(RfFunction.class, function.getName(), false);
        if (implementation != null) {
            boolean validImplementation = true;
            for (DVTPair<RfFunction, String> pair : functionCallTree) {
                RfFunction calledFunction = (RfFunction)pair.getKey();
                RfFunction enclosingFunctionImplementation = clazz.getLocalMember(RfFunction.class, calledFunction.getName(), false);
                if (enclosingFunctionImplementation == null) continue;
                SuperVisitor visitor = new SuperVisitor(calledFunction.getName());
                enclosingFunctionImplementation.visitHidObject(this.fOVMProject.getRfProject(), visitor);
                if (visitor.getFoundSuper()) continue;
                validImplementation = false;
                break;
            }
            if (validImplementation) {
                result.add(implementation);
            }
        }
        if ((children = clazz.getChildren()) == null || children.isEmpty()) {
            return;
        }
        for (RfClass child : children) {
            this.recursiveCollectImplementations(function, result, child, functionCallTree, visited);
        }
    }

    protected String getFailMessage(String hidName, List<DVTPair<RfFunction, String>> functionCallTree) {
        String message = "Function " + hidName + " called!";
        StringBuilder callStack = new StringBuilder();
        int index = 0;
        for (DVTPair<RfFunction, String> pair : functionCallTree) {
            if (index == functionCallTree.size() - 1) break;
            callStack.append("\n" + index + ": ").append((String)pair.getValue());
            ++index;
        }
        if (callStack.length() != 0) {
            message = String.valueOf(message) + " Call stack: " + callStack.toString();
        }
        return message;
    }

    private void addCallStackInformation(ParserPath parserPath, RfHid hid, List<DVTPair<RfFunction, String>> callStack) {
        HidInformation hidInformation = new HidInformation(hid.getLine(), HidUtils.toNiceString((IHidObject)hid), parserPath);
        if (!this.callStacksForHid.containsKey(hidInformation)) {
            this.callStacksForHid.put(hidInformation, new ArrayList());
        }
        ArrayList<DVTPair> newList = new ArrayList<DVTPair>();
        for (DVTPair<RfFunction, String> element : callStack) {
            newList.add(new DVTPair((Object)((RfFunction)element.getKey()), (Object)((String)element.getValue())));
        }
        this.callStacksForHid.get(hidInformation).add(newList);
    }

    private void applyHits() {
        if (this.pEnableRootCauseModeValue) {
            for (Map.Entry<HidInformation, List<List<DVTPair<RfFunction, String>>>> hitInformation : this.callStacksForHid.entrySet()) {
                ParserPath parserPath = hitInformation.getKey().getParserPath();
                Integer line = hitInformation.getKey().getLine();
                String hidName = hitInformation.getKey().getName();
                List<DVTPair<RfFunction, String>> smallestStack = hitInformation.getValue().get(0);
                int smallestSize = hitInformation.getValue().get(0).size();
                for (List<DVTPair<RfFunction, String>> callStack : hitInformation.getValue()) {
                    if (callStack.size() >= smallestSize) continue;
                    smallestSize = callStack.size();
                    smallestStack = callStack;
                }
                this.addHit(parserPath, line, this.getFailMessage(hidName, smallestStack), null);
            }
        } else {
            for (Map.Entry<HidInformation, List<List<DVTPair<RfFunction, String>>>> hitInformation : this.callStacksForHid.entrySet()) {
                ParserPath parserPath = hitInformation.getKey().getParserPath();
                Integer line = hitInformation.getKey().getLine();
                String hidName = hitInformation.getKey().getName();
                for (List<DVTPair<RfFunction, String>> callStack : hitInformation.getValue()) {
                    this.addHit(parserPath, line, this.getFailMessage(hidName, callStack), null);
                }
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.callStacksForHid != null) {
            this.callStacksForHid.clear();
        }
        if (this.potentialHits != null) {
            this.potentialHits.clear();
        }
        if (this.allXVMSequences != null) {
            this.allXVMSequences.clear();
        }
        if (this.functionsInPotentialHitPath != null) {
            this.functionsInPotentialHitPath.clear();
        }
    }

    private static class HidInformation {
        private Integer line;
        private String name;
        private ParserPath parserPath;

        public HidInformation(Integer line, String name, ParserPath parserPath) {
            this.line = line;
            this.name = name;
            this.parserPath = parserPath;
        }

        public Integer getLine() {
            return this.line;
        }

        public String getName() {
            return this.name;
        }

        public ParserPath getParserPath() {
            return this.parserPath;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HidInformation other = (HidInformation)obj;
            return Objects.equals(this.line, other.line) && Objects.equals(this.name, other.name) && Objects.equals(this.parserPath, other.parserPath);
        }

        public int hashCode() {
            return Objects.hash(this.line, this.name, this.parserPath);
        }
    }

    private static final class PotentialHit {
        private List<DVTPair<RfFunction, String>> functionCallTree = new ArrayList<DVTPair<RfFunction, String>>();
        private ParserPath parserPath;
        private RfHid hid;

        public PotentialHit(List<DVTPair<RfFunction, String>> functionCallTree, ParserPath parserPath, RfHid hid) {
            for (DVTPair<RfFunction, String> oldPair : functionCallTree) {
                this.functionCallTree.add((DVTPair<RfFunction, String>)new DVTPair((Object)((RfFunction)oldPair.getKey()), (Object)((String)oldPair.getValue())));
            }
            this.parserPath = parserPath;
            this.hid = hid;
        }

        public List<DVTPair<RfFunction, String>> getFunctionCallTree() {
            return this.functionCallTree;
        }

        public RfHid getHid() {
            return this.hid;
        }

        public ParserPath getParserPath() {
            return this.parserPath;
        }
    }

    private class SetOrGetConfigurationFunctionVisitor
    extends RfHidVisitor {
        private ArrayList<DVTPair<RfFunction, String>> functionCallTree;
        private Set<RfFunction> visitedFunctions = new HashSet<RfFunction>();
        private boolean isInLoop;
        private IRfNamedElement scope;

        public SetOrGetConfigurationFunctionVisitor(Set<RfFunction> visitedFunctions, ArrayList<DVTPair<RfFunction, String>> functionCallTree, boolean isInLoop) {
            this.visitedFunctions = visitedFunctions;
            this.functionCallTree = functionCallTree;
            this.isInLoop = isInLoop;
        }

        public void setScope(IRfNamedElement scope) {
            this.scope = scope;
        }

        public boolean visit(RfHid hid) {
            if (hid == null) {
                return true;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            if (Check_4_28.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            RfFunction function = (RfFunction)hidNamedElement;
            boolean tempIsInLoop = this.isInLoop;
            if (!tempIsInLoop && !Check_4_28.this.pCheckAPICallsInLoops.isEmpty()) {
                tempIsInLoop = this.isInLoop();
            }
            if (Check_4_28.this.pSkipCallsFromSequences && this.isInSequence()) {
                return true;
            }
            if (Check_4_28.this.isCalling(hid, "uvm_pkg::uvm_config_db")) {
                methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                if (methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    if (!methodCall.getMethodHid().getName().equals("get") && !methodCall.getMethodHid().getName().equals("set")) continue;
                    if (!tempIsInLoop && !Check_4_28.this.pCheckAPICallsInLoops.isEmpty()) {
                        this.functionCallTree.get(this.functionCallTree.size() - 1).setValue((Object)this.getMessage(hid, function));
                        for (DVTPair<RfFunction, String> pair : this.functionCallTree) {
                            Check_4_28.this.functionsInPotentialHitPath.putIfAbsent(((RfFunction)pair.getKey()).getFullName(), new HashSet());
                            Check_4_28.this.functionsInPotentialHitPath.get(((RfFunction)pair.getKey()).getFullName()).add((RfFunction)pair.getKey());
                        }
                        Check_4_28.this.potentialHits.add(new PotentialHit(this.functionCallTree, this.parserPath, hid));
                        continue;
                    }
                    Check_4_28.this.addCallStackInformation(this.parserPath, hid, this.functionCallTree);
                }
            } else if (Check_4_28.this.isCalling(hid, "uvm_pkg::uvm_resource_db")) {
                methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                if (methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    if (!UVM_RESOURCE_DB_FUNCTIONS.contains(methodCall.getMethodHid().getName())) continue;
                    if (!tempIsInLoop && !Check_4_28.this.pCheckAPICallsInLoops.isEmpty()) {
                        this.functionCallTree.get(this.functionCallTree.size() - 1).setValue((Object)this.getMessage(hid, function));
                        for (DVTPair<RfFunction, String> pair : this.functionCallTree) {
                            Check_4_28.this.functionsInPotentialHitPath.putIfAbsent(((RfFunction)pair.getKey()).getFullName(), new HashSet());
                            Check_4_28.this.functionsInPotentialHitPath.get(((RfFunction)pair.getKey()).getFullName()).add((RfFunction)pair.getKey());
                        }
                        Check_4_28.this.potentialHits.add(new PotentialHit(this.functionCallTree, this.parserPath, hid));
                        continue;
                    }
                    Check_4_28.this.addCallStackInformation(this.parserPath, hid, this.functionCallTree);
                }
            } else {
                if (this.visitedFunctions.contains(function)) {
                    if (!Check_4_28.this.pCheckAPICallsInLoops.isEmpty()) {
                        this.functionCallTree.get(this.functionCallTree.size() - 1).setValue((Object)this.getMessage(hid, function));
                        this.addPotentialHit(function, tempIsInLoop);
                    }
                    return true;
                }
                this.visitedFunctions.add(function);
            }
            if (Check_4_28.this.fOVMProject.isOVMElement(function)) {
                return true;
            }
            String message = this.getMessage(hid, function);
            this.functionCallTree.get(this.functionCallTree.size() - 1).setValue((Object)message);
            this.functionCallTree.add((DVTPair<RfFunction, String>)new DVTPair((Object)function, (Object)""));
            function.visitHidObject(Check_4_28.this.fOVMProject.getRfProject(), new SetOrGetConfigurationFunctionVisitor(this.visitedFunctions, this.functionCallTree, tempIsInLoop));
            this.functionCallTree.remove(this.functionCallTree.size() - 1);
            if (!function.isVirtual()) {
                return true;
            }
            Set<RfFunction> implementations = Check_4_28.this.getChildImplementations(function, this.functionCallTree);
            if (implementations == null || implementations.isEmpty()) {
                return true;
            }
            for (RfFunction implementation : implementations) {
                if (implementation == null || implementation.isPredefined()) continue;
                if (this.visitedFunctions.contains(implementation)) {
                    if (Check_4_28.this.pCheckAPICallsInLoops.isEmpty()) continue;
                    this.addPotentialHit(implementation, tempIsInLoop);
                    continue;
                }
                this.visitedFunctions.add(implementation);
                this.functionCallTree.add((DVTPair<RfFunction, String>)new DVTPair((Object)function, (Object)""));
                implementation.visitHidObject(Check_4_28.this.fOVMProject.getRfProject(), new SetOrGetConfigurationFunctionVisitor(this.visitedFunctions, this.functionCallTree, tempIsInLoop));
                this.functionCallTree.remove(this.functionCallTree.size() - 1);
            }
            return true;
        }

        public boolean isInSequence() {
            RfClass classScope = this.scope instanceof RfClass ? (RfClass)this.scope : (RfClass)this.scope.getEnclosingScope(RfClass.class);
            if (classScope == null) {
                return false;
            }
            if (Check_4_28.this.allXVMSequences == null || Check_4_28.this.allXVMSequences.isEmpty()) {
                Check_4_28.this.allXVMSequences = Check_4_28.this.fOVMProject.getAllXVMSubClasses(Check_4_28.this.sequenceBaseClass);
            }
            return Check_4_28.this.allXVMSequences.contains(classScope);
        }

        public String getMessage(RfHid hid, RfFunction function) {
            RfFunction caller = (RfFunction)this.functionCallTree.get(this.functionCallTree.size() - 1).getKey();
            String link = Check_4_28.this.link(String.valueOf(Utils.getInstance().getFileName(this.parserPath.path)) + ":" + hid.getOccurrence().getLine(), this.parserPath.path, hid.getOccurrence().getLine());
            String message = String.valueOf(Check_4_28.this.link(caller)) + "() - calls " + function + "() in " + link;
            return message;
        }

        private void addPotentialHit(RfFunction function, boolean isInLoop) {
            if (!isInLoop) {
                return;
            }
            Set<RfFunction> potentialFunctionsInStack = Check_4_28.this.functionsInPotentialHitPath.get(function.getFullName());
            if (potentialFunctionsInStack == null || !potentialFunctionsInStack.contains(function)) {
                return;
            }
            HashSet<PotentialHit> potentialHitsToBeRemoved = new HashSet<PotentialHit>();
            for (PotentialHit potentialHit : Check_4_28.this.potentialHits) {
                boolean foundFunction = false;
                ArrayList<DVTPair<RfFunction, String>> tempFunctionCallTree = null;
                for (DVTPair<RfFunction, String> functionPair : potentialHit.getFunctionCallTree()) {
                    if (foundFunction && tempFunctionCallTree != null) {
                        tempFunctionCallTree.add(functionPair);
                        continue;
                    }
                    String functionName = ((RfFunction)functionPair.getKey()).getFullName();
                    if (!functionName.equals(function.getFullName()) || !((RfFunction)functionPair.getKey()).equals(function)) continue;
                    tempFunctionCallTree = new ArrayList<DVTPair<RfFunction, String>>();
                    for (DVTPair<RfFunction, String> oldPair : this.functionCallTree) {
                        tempFunctionCallTree.add(new DVTPair((Object)((RfFunction)oldPair.getKey()), (Object)((String)oldPair.getValue())));
                    }
                    tempFunctionCallTree.add(new DVTPair((Object)function, (Object)((String)functionPair.getValue())));
                    foundFunction = true;
                }
                if (!foundFunction) continue;
                Check_4_28.this.addCallStackInformation(potentialHit.getParserPath(), potentialHit.getHid(), tempFunctionCallTree);
                potentialHitsToBeRemoved.add(potentialHit);
            }
            for (PotentialHit handledHit : potentialHitsToBeRemoved) {
                Check_4_28.this.potentialHits.remove(handledHit);
            }
        }

        public boolean isInLoop() {
            IRfNamedElement scope = ((HidHolder)this.holder).getScope();
            if (!(scope instanceof RfActionBlock)) {
                return false;
            }
            RfActionBlock block = (RfActionBlock)scope;
            while (!block.isLoop()) {
                scope = block.getEnclosingScope();
                if (!(scope instanceof RfActionBlock)) {
                    return false;
                }
                block = (RfActionBlock)scope;
            }
            if (!block.isLoop()) {
                return false;
            }
            return this.isValidBlockType(block);
        }

        private boolean isValidBlockType(RfActionBlock block) {
            if (Check_4_28.this.pCheckAPICallsInLoops.contains("for") && block.isFor()) {
                return true;
            }
            if (Check_4_28.this.pCheckAPICallsInLoops.contains("repeat") && block.isRepeat()) {
                return true;
            }
            if (Check_4_28.this.pCheckAPICallsInLoops.contains("foreach") && block.isForEach()) {
                return true;
            }
            if (Check_4_28.this.pCheckAPICallsInLoops.contains("while") && block.isWhile()) {
                return true;
            }
            if (Check_4_28.this.pCheckAPICallsInLoops.contains("do") && block.isDoWhile()) {
                return true;
            }
            return Check_4_28.this.pCheckAPICallsInLoops.contains("forever") && block.isForever();
        }

        @Override
        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }

    private final class SuperVisitor
    implements IHidVisitor<RfHid> {
        private final String enclosingFunctionName;
        private boolean foundSuper;

        private SuperVisitor(String enclosingFunctionName) {
            this.enclosingFunctionName = enclosingFunctionName;
        }

        public boolean visit(RfHid hidObject) {
            if (hidObject == null) {
                return true;
            }
            if (hidObject.getElement() == null) {
                return true;
            }
            if (hidObject.getElement().getName() == null) {
                return true;
            }
            if (!hidObject.getElement().getName().equals(this.enclosingFunctionName)) {
                return true;
            }
            if (hidObject.getParentHid() == null) {
                return true;
            }
            Hid parentHid = hidObject.getParentHid();
            if (parentHid.getElement() instanceof RfSuperImplicitVariable) {
                this.foundSuper = true;
                return false;
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }

        private boolean getFoundSuper() {
            return this.foundSuper;
        }
    }
}

