/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="21.1.14")
@CheckID(value="XVM.4.29")
@CheckName(value="XVM.4.29")
@CheckLabel(labels={RuleLabel.ARGUMENT, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Regular expressions should be syntactically valid")
@CheckDescription(value="This check fails when regular expression parameters from uvm functions are passed an invalid regular expression as a string literal or a constant string.\n\nThe following methods are checked:\n* uvm_pkg::uvm_re_match()\n* uvm_pkg::uvm_is_match()\n* uvm_pkg::uvm_reg_block::find_block()\n* uvm_pkg::uvm_reg_block::find_blocks()\n* uvm_pkg::uvm_config_db::set()\n* uvm_pkg::uvm_config_db::get()\n* uvm_pkg::uvm_cmdline_processor::get_arg_matches()\n\nCheck supports pre-waiving.")
public class Check_4_29
extends OVMComplianceCheck {
    private static final char UVM_RE_BRACKET_CHAR = '/';
    private static final int REGEX_MAX_LEN = 2040;
    private static final int SUPPORTED_METHODS_COUNT = 7;
    private Map<String, MethodInfo> supportedMethods = new HashMap<String, MethodInfo>(7);

    public Check_4_29(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.supportedMethods.put("uvm_re_match", new MethodInfo(null, "re"));
        this.supportedMethods.put("find_blocks", new MethodInfo("uvm_reg_block", "name"));
        this.supportedMethods.put("find_block", new MethodInfo("uvm_reg_block", "name"));
        this.supportedMethods.put("set", new MethodInfo("uvm_config_db", "inst_name"));
        this.supportedMethods.put("get", new MethodInfo("uvm_config_db", "inst_name"));
        this.supportedMethods.put("uvm_is_match", new MethodInfo(null, "expr"));
        this.supportedMethods.put("get_arg_matches", new MethodInfo("uvm_cmdline_processor", "match"));
    }

    @Override
    public void performCheckImpl() {
        RfHidVisitor visitor = new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                Check_4_29.this.notifyCheckAlive();
                if (Check_4_29.this.pathIsPrewaived(this.parserPath)) {
                    return true;
                }
                String argumentName = Check_4_29.this.checkIsSupportedMethod(hid);
                if (argumentName == null) {
                    return true;
                }
                Check_4_29.this.checkArgument(this.parserPath, hid, argumentName);
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
    }

    private boolean pathIsPrewaived(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this) || this.fOVMProject.isOVMFile(parserPath.path);
    }

    private String checkIsSupportedMethod(RfHid hid) {
        IRfNamedElement element = hid.getElement();
        if (!(element instanceof RfFunction)) {
            return null;
        }
        String name = element.getName();
        if (!this.supportedMethods.containsKey(name)) {
            return null;
        }
        MethodInfo current = this.supportedMethods.get(name);
        String parentClassName = null;
        HidAccess parentAccess = hid.getParentAccess();
        if (parentAccess != null) {
            IRfNamedElement associatedType = parentAccess.getAssociatedType();
            if (associatedType == null) {
                return null;
            }
            parentClassName = associatedType.getName();
        } else {
            Hid typeIDHid = hid.getParentHid();
            if (typeIDHid != null) {
                parentClassName = typeIDHid.getName();
            }
        }
        if (parentClassName != null && !parentClassName.equals(current.typeIDName)) {
            return null;
        }
        return current.regexArgName;
    }

    private void checkArgument(ParserPath parserPath, RfHid rfHid, String argumentName) {
        if (parserPath == null || rfHid == null || argumentName == null) {
            return;
        }
        List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
        if (methodCalls.isEmpty()) {
            return;
        }
        block0: for (MethodCall methodCall : methodCalls) {
            if (methodCall.argumentValuesMapRaw == null) {
                return;
            }
            for (Map.Entry argumentEntry : methodCall.argumentValuesMapRaw.entrySet()) {
                String regex;
                RfHid rfhid;
                String name;
                IRfNamedElement key = (IRfNamedElement)argumentEntry.getKey();
                if (key == null || !argumentName.equals(name = key.getName())) continue;
                String exprValue = null;
                IHidObject hid = (IHidObject)argumentEntry.getValue();
                if (hid instanceof RfHidImplicit) {
                    RfHidImplicit regexArgument = (RfHidImplicit)hid;
                    exprValue = regexArgument.getName();
                } else if (hid instanceof RfHid && (rfhid = (RfHid)hid).getElement() instanceof RfField && ((RfField)rfhid.getElement()).isConst()) {
                    exprValue = ((RfField)rfhid.getElement()).getInitialValue(false);
                }
                if (exprValue == null || this.expressionIsValid(regex = this.uvmGlobToReClone(exprValue))) continue block0;
                this.addHit(parserPath, methodCall.occurrence, "Regular expression '" + exprValue + "' in argument is invalid!");
                continue block0;
            }
        }
    }

    private String uvmGlobToReClone(String regex) {
        if (regex == null) {
            return null;
        }
        int len = regex.length();
        if (len > 2040) {
            return null;
        }
        if (len == 0 || len == 1 && regex.charAt(0) == '/') {
            return "";
        }
        char[] regexArr = regex.toCharArray();
        if (regexArr[0] == '/' && regexArr[len - 1] == '/') {
            return regex;
        }
        StringBuilder newRegex = new StringBuilder();
        newRegex.append('/');
        if (regexArr[0] != '^') {
            newRegex.append('^');
        }
        char[] cArray = regexArr;
        int n = regexArr.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '*': {
                    newRegex.append(".");
                    newRegex.append('*');
                    break;
                }
                case '+': {
                    newRegex.append(".");
                    newRegex.append('+');
                    break;
                }
                case '.': {
                    newRegex.append("\\");
                    newRegex.append('.');
                    break;
                }
                case '?': {
                    newRegex.append(".");
                    break;
                }
                case '[': {
                    newRegex.append("\\");
                    newRegex.append('[');
                    break;
                }
                case ']': {
                    newRegex.append("\\");
                    newRegex.append(']');
                    break;
                }
                case '(': {
                    newRegex.append("\\");
                    newRegex.append('(');
                    break;
                }
                case ')': {
                    newRegex.append("\\");
                    newRegex.append(')');
                    break;
                }
                default: {
                    newRegex.append(c);
                }
            }
            ++n2;
        }
        if (regexArr[len - 1] != '$') {
            newRegex.append('$');
        }
        newRegex.append('/');
        return newRegex.toString();
    }

    private boolean expressionIsValid(String regex) {
        if (regex == null) {
            return false;
        }
        int len = regex.length();
        if (len > 2040) {
            return false;
        }
        if (len > 1 && regex.charAt(0) == '(' && regex.charAt(len - 1) == ')') {
            regex = regex.substring(1, len - 1);
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
        return true;
    }

    private static final class MethodInfo {
        public String typeIDName;
        public String regexArgName;

        public MethodInfo(String typeIDName, String regexArgName) {
            this.typeIDName = typeIDName;
            this.regexArgName = regexArgName;
        }
    }
}

