/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.5.1.1")
@CheckName(value="XVM.5.1.1")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.METHOD, RuleLabel.REPORTING_MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="Use Methodology Methods or Macros for Logging")
@CheckDescription(value="All console logging / messaging must use only the methodology reporting methods or macros.\nDirectly using display / monitor / strobe /etc. is not allowed.\n\nImplementation Notes:\nThis rule verifies that the following are not called:\n- $display, $displayb, $displayh, displayo\n- $monitor, $monitorb, $monitorh, $monitoro\n- $strobe, $strobeb, $strobeh, $strobeo\n- $write, $writeb, $writeh, $writeo\n\nCheck supports pre-waiving.")
public class Check_5_1_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, banned method calls from static methods are skipped.", name="skipCallsInStaticMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pSkipCallsInStaticMethods;
    private static final String[] ILLEGAL_FUNCTION_CALLS = new String[]{"$display", "$displayb", "$displayh", "$displayo", "$monitor", "$monitorb", "$monitorh", "$monitoro", "$strobe", "$strobeb", "$strobeh", "$strobeo", "$write", "$writeb", "$writeh", "$writeo"};

    public Check_5_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            RfClass tmpClass = (RfClass)clazz;
            RfFileDef file = tmpClass.getFile();
            if (file == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            ArrayList<RfFunction> containers = new ArrayList<RfFunction>();
            List<RfFunction> localFunctionsAndTasks = tmpClass.getLocalMembers(RfFunction.class);
            if (localFunctionsAndTasks != null) {
                containers.addAll(localFunctionsAndTasks);
            }
            for (RfNamedElement rfNamedElement : containers) {
                if (this.pSkipCallsInStaticMethods && rfNamedElement instanceof RfFunction && ((RfFunction)rfNamedElement).isObjectStatic()) continue;
                List<RfFunctionCall> functionCalls = rfNamedElement.getFunctionCallsWithPrefix("", 2);
                for (RfFunctionCall functionCall : functionCalls) {
                    String[] stringArray = ILLEGAL_FUNCTION_CALLS;
                    int n = ILLEGAL_FUNCTION_CALLS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String illegalFunctionCallName = stringArray[n2];
                        if (functionCall.getName().equals(illegalFunctionCallName)) {
                            this.addHit(functionCall, "'" + illegalFunctionCallName + "' is used in '" + tmpClass.getName() + "' class");
                        }
                        ++n2;
                    }
                }
            }
        }
    }
}

