/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="17.1.2")
@CheckID(value="XVM.5.1.2")
@CheckName(value="XVM.5.1.2")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.REPORTING_MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="Legal message IDs")
@CheckDescription(value="Use only IDs specified in <idsFile> when calling `xvm_warning*, `xvm_error* and `xvm_fatal* macros.\n\nPath can be absolute, relative to working dir or with system variables.\nThe idsFile structure is:\n\n\"path_pattern11\",\"path_pattern12\",...,\"path_pattern1N\" : \"id1\", \"id2\", ... \"idN\"\n\"path_pattern21\",\"path_pattern22\",...,\"path_pattern2N\" : \"id1\", \"id2\", ... \"idN\"\n\"path_pattern31\",\"path_pattern32\",...,\"path_pattern3N\" : \"id1\", \"id2\", ... \"idN\"\n\nImplementation Notes: Only direct macro calls are checked, calling `xvm_warning*, `xvm_error* and `xvm_fatal* macros with wrong IDs from another macro will not be reported.")
public class Check_5_1_2
extends OVMComplianceCheck {
    private static final HashSet<String> UVM_MACRO_CALLS = new HashSet();
    private static final HashSet<String> OVM_MACRO_CALLS;
    public static final Pattern IDS_FILE_PATTERN;
    private HashSet<String> fMacroCalls;
    private Map<String, Set<Pattern>> fIdToPathPatterns = new HashMap<String, Set<Pattern>>();
    private HashMap<String, Pattern> fPatternCache = new HashMap();
    @CheckParameter(defaultValue="", description="Path to message IDs mapping file.", name="idsFile", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.STRING)
    private String pIDsFileValue;
    @CheckParameter(defaultValue="false", description="Ignore non-existent IDs file, otherwise add a configuration failure.", name="ignoreNonexistentIdsFile", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pIgnoreNonexistentIdsFileValue;

    static {
        UVM_MACRO_CALLS.add("`uvm_warning");
        UVM_MACRO_CALLS.add("`uvm_warning_begin");
        UVM_MACRO_CALLS.add("`uvm_warning_context");
        UVM_MACRO_CALLS.add("`uvm_warning_context_begin");
        UVM_MACRO_CALLS.add("`uvm_fatal");
        UVM_MACRO_CALLS.add("`uvm_fatal_begin");
        UVM_MACRO_CALLS.add("`uvm_fatal_context");
        UVM_MACRO_CALLS.add("`uvm_fatal_context_begin");
        UVM_MACRO_CALLS.add("`uvm_error");
        UVM_MACRO_CALLS.add("`uvm_error_begin");
        UVM_MACRO_CALLS.add("`uvm_error_context");
        UVM_MACRO_CALLS.add("`uvm_error_context_begin");
        OVM_MACRO_CALLS = new HashSet();
        OVM_MACRO_CALLS.add("`ovm_warning");
        OVM_MACRO_CALLS.add("`ovm_fatal");
        OVM_MACRO_CALLS.add("`ovm_error");
        IDS_FILE_PATTERN = Pattern.compile("\\s*\"([^\"]*)\"\\s*(,|:|)");
    }

    public Check_5_1_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        this.fMacroCalls = isOVMLib ? OVM_MACRO_CALLS : UVM_MACRO_CALLS;
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("all", this.fMacroCalls);
    }

    @Override
    public void performCheckImpl() {
        this.fIdToPathPatterns.clear();
        this.readIDsFileValue();
        if (this.fIdToPathPatterns.isEmpty()) {
            return;
        }
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            if (clazz == null || !(clazz instanceof RfClass)) continue;
            this.notifyCheckAlive();
            MacroCallInfo macroCallInfo = ((RfClass)clazz).getMacroCallInfo();
            this.checkMacroCall(macroCallInfo);
            List<RfFunction> methods = clazz.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            methods.addAll(clazz.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            if (methods.isEmpty()) continue;
            for (RfFunction function : methods) {
                this.checkMacroCall(function.getMacroCallInfo());
            }
        }
        for (RfNamedElement element : this.fOVMProject.getAllAssertsExpects()) {
            if (!(element instanceof RfAssertExpect)) continue;
            this.notifyCheckAlive();
            this.checkMacroCall(((RfAssertExpect)element).getMacroCallInfo());
        }
    }

    private void checkMacroCall(MacroCallInfo macroCallInfo) {
        if (macroCallInfo == null) {
            return;
        }
        List<MacroCallItem> macroCallItems = LintUtils.getMacroCallsInSet(macroCallInfo, this.fMacroCalls, false, false);
        if (macroCallItems == null) {
            return;
        }
        for (MacroCallItem macroCallItem : macroCallItems) {
            if (macroCallItem == null || !this.checkMacro(macroCallItem.getName(), macroCallItem.getMacroParameters()[0], macroCallItem.getParserPath())) continue;
            this.addHit(macroCallItem.getParserPath(), macroCallItem.getLineNumber(), "Illegal ID '" + macroCallItem.getMacroParameters()[0] + "' specified for " + macroCallItem.getName() + "!", null);
        }
    }

    private boolean checkMacro(String macroName, String id, ParserPath parserPath) {
        if (!this.fMacroCalls.contains(macroName)) {
            return false;
        }
        if (this.fIdToPathPatterns.isEmpty()) {
            return false;
        }
        String unquotedID = this.unquote(id);
        if (unquotedID == null) {
            return true;
        }
        return !this.matchIDForParserPath(unquotedID, parserPath);
    }

    private String unquote(String id) {
        if (!LintUtils.isStringLiteral(id)) {
            return null;
        }
        return id.substring(1, id.length() - 1);
    }

    private boolean matchIDForParserPath(String id, ParserPath parserPath) {
        Set<Pattern> patterns = this.fIdToPathPatterns.get(id);
        if (patterns == null || patterns.isEmpty()) {
            return false;
        }
        for (Pattern pathPattern : patterns) {
            if (!pathPattern.matcher(parserPath.path).matches()) continue;
            return true;
        }
        return false;
    }

    private void extractPatterns(String line) {
        if (line == null || line.isEmpty() || !line.contains(":")) {
            return;
        }
        HashSet<String> pathPatternStrings = new HashSet<String>();
        boolean readingPathPatterns = true;
        Matcher matcher = IDS_FILE_PATTERN.matcher(line);
        while (matcher.find()) {
            if (matcher.groupCount() != 2) continue;
            if (readingPathPatterns) {
                pathPatternStrings.add(matcher.group(1));
            } else {
                for (String pathPatternString : pathPatternStrings) {
                    try {
                        this.addToMap(matcher.group(1).trim(), pathPatternString);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        this.signalParamError("Invalid pattern '" + pathPatternString + "' in " + " '" + this.pIDsFileValue + "'", false);
                        return;
                    }
                }
            }
            if (!":".equals(matcher.group(2))) continue;
            readingPathPatterns = false;
            if (!pathPatternStrings.isEmpty()) continue;
            return;
        }
    }

    private void addToMap(String id, String patternString) {
        patternString = patternString.trim();
        patternString = LintUtils.replaceAllSystemVariables(this.fOVMProject.getProject(), patternString, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED);
        Set<Pattern> patternsSet = this.fIdToPathPatterns.get(id);
        if (patternsSet == null) {
            patternsSet = new HashSet<Pattern>();
            this.fIdToPathPatterns.put(id, patternsSet);
        }
        patternsSet.add(this.getPattern(patternString));
    }

    private void readIDsFileValue() {
        String replacedPathString = LintUtils.replaceAllSystemVariables(this.fOVMProject.getProject(), this.pIDsFileValue, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED);
        File file = new File(replacedPathString);
        if (!file.exists()) {
            file = new File(this.fOVMProject.getProject().getLocation().toFile(), replacedPathString);
        }
        if (!file.exists() || file.isDirectory()) {
            if (!this.pIgnoreNonexistentIdsFileValue) {
                this.signalParamError(String.valueOf(this.pIDsFileValue) + "' does not exist", false);
            }
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.extractPatterns(line);
                }
                reader.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.fOVMProject.notifyCheckException(this, e);
            this.signalParamError("Can't read '" + this.pIDsFileValue + "'", false);
        }
    }

    private Pattern getPattern(String string) {
        Pattern result = this.fPatternCache.get(string);
        if (result != null) {
            return result;
        }
        result = Pattern.compile(string);
        this.fPatternCache.put(string, result);
        return result;
    }
}

