/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractReportMacroIDCheck;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;

@CheckVersion(value="19.1.15")
@CheckID(value="XVM.5.1.2.3")
@CheckName(value="XVM.5.1.2.3")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.REPORTING_MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="Legal message IDs")
@CheckDescription(value="XVM report macros must use only IDs matched by the specified patterns.\n\nImplementation Notes: Only direct macro calls are checked, calling `xvm_info, `xvm_warning, `xvm_error and `xvm_fatal macros with wrong IDs from another macro will not be reported.\n\nCheck supports pre-waiving.")
public class Check_5_1_2_3
extends AbstractReportMacroIDCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of patterns to match the report macros IDs.", name="idPatterns", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pIDPatterns;

    public Check_5_1_2_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkFirstID(IHidObject idValue, HidOccurrence hidOccurence, String macroName, RfNamedElement scope) {
        if (scope.getFile() == null) {
            return;
        }
        if (!(idValue instanceof RfHidImplicit) || !((RfHidImplicit)idValue).isStringLiteral()) {
            return;
        }
        String literalID = this.unquote(((RfHidImplicit)idValue).getName());
        if (literalID == null) {
            return;
        }
        for (Pattern pIDPattern : this.pIDPatterns) {
            if (!pIDPattern.matcher(literalID).matches()) continue;
            return;
        }
        this.addHit(scope.getFile().getParserPath(), hidOccurence.getLine(), "Illegal ID \"" + literalID + "\" specified for `" + macroName + "!", null);
    }
}

