/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractInfoMacroCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="17.1.16")
@CheckID(value="XVM.5.1.3.6")
@CheckName(value="XVM.5.1.3.6")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.REPORTING_MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="Banned verbosity for `xvm_info messages. When 'bannedVerbosity' is empty, XVM_NONE will be the checked verbosity")
@CheckDescription(value="Do not use `xvm_info messages with <bannedVerbosity> verbosity.")
public class Check_5_1_3_6
extends AbstractInfoMacroCheck {
    @CheckParameter(defaultValue="false", description="When true only `xvm_info messages from loops are checked.", name="checkOnlyLoops", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pCheckOnlyLoops;
    @CheckParameter(defaultValue="", description="Comma separated list of XVM verbosities.", name="bannedVerbosity", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pBannedVerbosity;
    @CheckParameter(defaultValue="", description="Comma separated list of macros to be called after `xvm_info messages in order to allow the `xvm_info with any verbosity.", name="allowWhenMacrosAfter", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pAllowWhenMacrosAfter;
    private static Set<String> ovmVerbosity = new HashSet<String>(Arrays.asList("OVM_NONE", "OVM_LOW", "OVM_MEDIUM", "OVM_HIGH", "OVM_FULL", "OVM_DEBUG"));
    private static Set<String> uvmVerbosity = new HashSet<String>(Arrays.asList("UVM_NONE", "UVM_LOW", "UVM_MEDIUM", "UVM_HIGH", "UVM_FULL", "UVM_DEBUG"));

    public Check_5_1_3_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        if (this.pBannedVerbosity.isEmpty()) {
            this.pBannedVerbosity.add(OVMUtils.prependCapitalizedLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_NONE"));
        }
        for (String verbosity : this.pBannedVerbosity) {
            if (this.fOVMProject.getLibraryKind() == 1) {
                if (ovmVerbosity.contains(verbosity)) continue;
                this.signalParamError("Invalid verbosity: '" + verbosity + "'!", true);
                continue;
            }
            if (this.fOVMProject.getLibraryKind() != 2 || uvmVerbosity.contains(verbosity)) continue;
            this.signalParamError("Invalid verbosity: '" + verbosity + "'!", true);
        }
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        super.preBuildNotification(aRfProject);
        aRfProject.lintTrackMacrosByNames("all", this.pAllowWhenMacrosAfter);
    }

    @Override
    public void performCheckImpl() {
        this.onlyInLoop = this.pCheckOnlyLoops;
        this.bannedVerbosity = this.pBannedVerbosity;
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            if (clazz == null || !(clazz instanceof RfClass)) continue;
            this.notifyCheckAlive();
            List<RfFunction> methods = clazz.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            methods.addAll(clazz.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            methods.addAll(clazz.getConstructorsWithPrefix("new", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            if (methods.isEmpty()) continue;
            for (RfFunction function : methods) {
                this.checkMacroCall(function.getMacroCallInfo());
            }
        }
        for (RfNamedElement element : this.fOVMProject.getAllAssertsExpects()) {
            if (!(element instanceof RfAssertExpect)) continue;
            this.notifyCheckAlive();
            this.checkMacroCall(((RfAssertExpect)element).getMacroCallInfo());
        }
    }

    private void checkMacroCall(MacroCallInfo macroCallInfo) {
        Set<MacroCallItem> macroCallItems = this.getInvalidMacroCallItems(macroCallInfo);
        HashMap<Object, Object> macroCallItemsWithScopes = new HashMap();
        ArrayList<MacroCallItem> allowWhenMacroAfterCalls = new ArrayList();
        if (!this.pAllowWhenMacrosAfter.isEmpty()) {
            macroCallItemsWithScopes = this.getMacroCallWithScopes(macroCallItems);
            allowWhenMacroAfterCalls = LintUtils.getMacroCallsInSet(macroCallInfo, this.pAllowWhenMacrosAfter);
        }
        if (macroCallItems != null && !macroCallItems.isEmpty()) {
            for (MacroCallItem macroCallItem : macroCallItems) {
                if (!this.pAllowWhenMacrosAfter.isEmpty() && (this.pAllowWhenMacrosAfter.isEmpty() || this.checkExistingAllowedMacro(macroCallItem, (Set)macroCallItemsWithScopes.get(macroCallItem), allowWhenMacroAfterCalls))) continue;
                this.addHit(macroCallItem.getParserPath(), macroCallItem.getLineNumber(), String.valueOf(macroCallItem.getMacroParameters()[2]) + " verbosity used for `" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_info!"), macroCallItem.getReparseInfo());
            }
        }
    }

    private HashMap<MacroCallItem, Set<RfNamedElement>> getMacroCallWithScopes(Set<MacroCallItem> macroCallItems) {
        HashMap<MacroCallItem, Set<RfNamedElement>> macroCallItemsWithScopes = new HashMap<MacroCallItem, Set<RfNamedElement>>();
        for (MacroCallItem macroCallItem : macroCallItems) {
            RfDefElement defScope;
            RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(macroCallItem.getParserPath());
            if (fileDef == null || (defScope = fileDef.getScope(macroCallItem.getLineInfo().realOffset - 1, true)) == null) continue;
            HashSet<RfNamedElement> macroScopes = new HashSet<RfNamedElement>();
            RfNamedElement scope = defScope.getNamedElement();
            while (!(scope instanceof RfFunction) && !(scope instanceof RfAssertExpect) && scope != null) {
                macroScopes.add(scope);
                scope = scope.getEnclosingScope();
            }
            if (scope != null) {
                macroScopes.add(scope);
            }
            macroCallItemsWithScopes.put(macroCallItem, macroScopes);
        }
        return macroCallItemsWithScopes;
    }

    private boolean checkExistingAllowedMacro(MacroCallItem infoMacroCall, Set<RfNamedElement> scopes, List<MacroCallItem> allowWhenMacroAfterCalls) {
        if (allowWhenMacroAfterCalls == null || allowWhenMacroAfterCalls.isEmpty()) {
            return false;
        }
        for (MacroCallItem macroCallItem : allowWhenMacroAfterCalls) {
            RfNamedElement macroScope;
            RfDefElement defScope;
            RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(macroCallItem.getParserPath());
            if (fileDef == null || (defScope = fileDef.getScope(macroCallItem.getLineInfo().realOffset - 1, true)) == null || !scopes.contains(macroScope = defScope.getNamedElement()) || macroCallItem.getLineNumber() <= infoMacroCall.getLineNumber()) continue;
            return true;
        }
        return false;
    }
}

