/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractInfoMacroCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LintUtilsConstants;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="17.1.38")
@CheckID(value="XVM.5.1.3.7")
@CheckName(value="XVM.5.1.3.7")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.METHOD, RuleLabel.REPORTING_MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use methods that call `xvm_info messages with XVM_NONE verbosity")
@CheckDescription(value="Do not use methods that use XVM_NONE verbosity for `xvm_info messages because the printing of such messages cannot be disabled.")
public class Check_5_1_3_7
extends AbstractInfoMacroCheck {
    @CheckParameter(defaultValue="false", description="When true, method calls are allowed in non-run phases if they're outside loop blocks.", name="allowMethodCallsInNonRunPhases", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowMethodCallsInNonRunPhases;
    private String XVM_NONE;
    private static final String ERROR_MESSAGE_FORMAT = "Method: {0} calls `{1} with {2} verbosity";
    Set<RfFunction> methodsCallingXVMInfo;

    public Check_5_1_3_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.XVM_NONE = OVMUtils.prependCapitalizedLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_NONE");
        this.methodsCallingXVMInfo = new HashSet<RfFunction>();
    }

    @Override
    public void performCheckImpl() {
        RfNamedElement[] allTypes;
        this.methodsCallingXVMInfo.clear();
        RfNamedElement[] rfNamedElementArray = allTypes = this.fOVMProject.getRfProject().getAllTypes(false, false);
        int n = allTypes.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement type = rfNamedElementArray[n2];
            if (type != null) {
                List<RfFunction> tasks;
                List<RfFunction> constructors;
                ArrayList<RfFunction> methods = new ArrayList<RfFunction>();
                List<RfFunction> functions = type.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                if (functions != null) {
                    methods.addAll(functions);
                }
                if ((constructors = type.getConstructorsWithPrefix("new", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) != null) {
                    methods.addAll(constructors);
                }
                if ((tasks = type.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) != null) {
                    methods.addAll(tasks);
                }
                if (!methods.isEmpty()) {
                    for (RfFunction function : methods) {
                        Set<MacroCallItem> macroCallItems;
                        if (function.isPredefined() || (macroCallItems = this.getInvalidMacroCallItems(function.getMacroCallInfo())) == null || macroCallItems.isEmpty()) continue;
                        this.methodsCallingXVMInfo.add(function);
                    }
                }
            }
            ++n2;
        }
        for (RfNamedElement element : this.fOVMProject.getAllFunctionCallContainers()) {
            LocalHidVisitor visitor = new LocalHidVisitor(element);
            element.visitHidObject(this.fOVMProject.getRfProject(), visitor);
        }
    }

    private class LocalHidVisitor
    extends RfHidVisitor {
        private RfNamedElement container;
        private IRfNamedElement scope;

        public LocalHidVisitor(RfNamedElement container) {
            this.container = container;
        }

        public boolean visit(RfHid hid) {
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (element == null || !(element instanceof RfFunction)) {
                return true;
            }
            HashSet<RfFunction> functions = new HashSet<RfFunction>();
            functions.add((RfFunction)element);
            if (((RfFunction)element).isVirtual()) {
                functions.addAll(this.searchForPotentialMatchingMethods((RfFunction)element));
            }
            for (RfFunction function : functions) {
                IRfNamedElement holderScope;
                if (!Check_5_1_3_7.this.methodsCallingXVMInfo.contains(function)) continue;
                Check_5_1_3_7.this.notifyCheckAlive();
                if (Check_5_1_3_7.this.pAllowMethodCallsInNonRunPhases && this.isInLoop() && this.isInNonRunPhase()) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                if (!Check_5_1_3_7.this.pAllowWithVerbosityLevelGuard) {
                    for (MethodCall methodCall : methodCalls) {
                        Check_5_1_3_7.this.addHit(this.parserPath, methodCall.occurrence, String.valueOf(MessageFormat.format(Check_5_1_3_7.ERROR_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(function), Check_5_1_3_7.this.XVM_INFO, Check_5_1_3_7.this.XVM_NONE)) + "!");
                    }
                    continue;
                }
                if (this.holder instanceof RfHidHolder && (holderScope = ((HidHolder)this.holder).getScope()) instanceof RfActionBlock && ((RfActionBlock)holderScope).isConditional() && Check_5_1_3_7.this.isValidConditionOfActionBlock((RfActionBlock)holderScope)) continue;
                for (MethodCall methodCall : methodCalls) {
                    Check_5_1_3_7.this.addHit(this.parserPath, methodCall.occurrence, String.valueOf(MessageFormat.format(Check_5_1_3_7.ERROR_MESSAGE_FORMAT, LintUtils.getNamedElementFullName(function), Check_5_1_3_7.this.XVM_INFO, Check_5_1_3_7.this.XVM_NONE)) + " and is not properly guarded by a verbosity check!");
                }
            }
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            if (holder instanceof RfHidHolder) {
                this.scope = ((RfHidHolder)holder).getScope();
            }
        }

        private Set<RfFunction> searchForPotentialMatchingMethods(RfFunction function) {
            HashSet<RfFunction> result = new HashSet<RfFunction>();
            RfFunction enclosingFunction = this.container.getEnclosingScope(RfFunction.class);
            if (enclosingFunction == null) {
                return result;
            }
            RfClass enclosingClass = this.container.getEnclosingScope(RfClass.class);
            if (enclosingClass == null) {
                return result;
            }
            HashSet<RfClass> visited = new HashSet<RfClass>();
            this.analyzeChildren(visited, result, enclosingClass.getChildren(), enclosingFunction, function);
            return result;
        }

        private void analyzeChildren(Set<RfClass> visited, Set<RfFunction> result, Collection<RfClass> children, RfFunction enclosingFunction, RfFunction searchedFunction) {
            if (children == null || children.isEmpty()) {
                return;
            }
            for (RfClass child : children) {
                if (visited.contains(child)) continue;
                visited.add(child);
                RfFunction localMethod = child.getFunctionWithPrefix(enclosingFunction.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                if (localMethod == null) {
                    localMethod = child.getTaskWithPrefix(enclosingFunction.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                }
                if (localMethod == null) {
                    localMethod = child.getConstructorWithPrefix(enclosingFunction.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                }
                if (localMethod != null) continue;
                localMethod = child.getFunctionWithPrefix(searchedFunction.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                if (localMethod == null) {
                    localMethod = child.getTaskWithPrefix(searchedFunction.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                }
                if (localMethod == null) {
                    localMethod = child.getConstructorWithPrefix(searchedFunction.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                }
                if (localMethod != null) {
                    result.add(localMethod);
                }
                this.analyzeChildren(visited, result, child.getChildren(), enclosingFunction, searchedFunction);
            }
        }

        private boolean isInLoop() {
            if (!(this.scope instanceof RfActionBlock)) {
                return false;
            }
            RfActionBlock block = (RfActionBlock)this.scope;
            while (!block.isLoop()) {
                RfNamedElement currentScope = block.getEnclosingScope();
                if (!(currentScope instanceof RfActionBlock)) {
                    return false;
                }
                block = (RfActionBlock)currentScope;
            }
            return block.isLoop();
        }

        private boolean isInNonRunPhase() {
            RfFunction function = (RfFunction)this.scope.getEnclosingScope(RfFunction.class);
            if (function == null) {
                return false;
            }
            return LintUtilsConstants.NON_RUN_PHASE_FUNCTIONS.contains(function.getName());
        }
    }
}

