/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="18.1.20")
@CheckID(value="XVM.5.1.3.8")
@CheckName(value="XVM.5.1.3.8")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.ENUM, RuleLabel.ARGUMENT, RuleLabel.REPORTING_MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="Use xvm_verbosity enum elements as verbosity arguments for xvm_report_info method calls")
@CheckDescription(value="Only xvm_verbosity enum elements should be used as verbosity arguments for xvm_report_info method calls.\nThis prevents common mistakes such as using xvm_severity type enum as verbosity argument.\n\nCheck supports pre-waiving.")
public class Check_5_1_3_8
extends OVMComplianceCheck {
    private static final String HIT_RULE_MESSAGE = "No {0}_verbosity enum type argument for {0}_report_info method call!";
    private final String xvmVerbosityEnumName;
    private Set<String> xvmReports;

    public Check_5_1_3_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.xvmVerbosityEnumName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_verbosity");
        this.xvmReports = new HashSet<String>();
        if (this.fOVMProject.getLibraryKind() == 2) {
            this.xvmReports.add("uvm_pkg::uvm_report_info");
            this.xvmReports.add("uvm_pkg::uvm_report_catcher.uvm_report_info");
            this.xvmReports.add("uvm_pkg::uvm_report_object.uvm_report_info");
            this.xvmReports.add("uvm_pkg::uvm_sequence_item.uvm_report_info");
        } else if (this.fOVMProject.getLibraryKind() == 1) {
            this.xvmReports.add("ovm_pkg::ovm_report_info");
            this.xvmReports.add("ovm_pkg::ovm_report_object.ovm_report_info");
        }
    }

    @Override
    public void performCheckImpl() {
        LocalHidVisitor visitor = new LocalHidVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, visitor);
    }

    private boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private static final String VERBOSITY_PARAM_NAME = "verbosity";
        RfNamedElement scope;
        ParserPath parserPath;

        public boolean visit(IHidObject hidObject) {
            if (Check_5_1_3_8.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            if (this.scope.isPredefined()) {
                return true;
            }
            if (!(hidObject instanceof RfHidAccessArgs)) {
                return true;
            }
            RfHidAccessArgs hid = (RfHidAccessArgs)hidObject;
            MethodCall methodCall = hid.getMethodCall();
            if (methodCall == null || !(methodCall.method instanceof RfFunction)) {
                return true;
            }
            RfFunction method = (RfFunction)methodCall.method;
            if (!Check_5_1_3_8.this.xvmReports.contains(method.getFullName())) {
                return true;
            }
            Check_5_1_3_8.this.notifyCheckAlive();
            if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) {
                return true;
            }
            RfField verbosityParameter = ((RfFunction)methodCall.method).getArgumentWithPrefix(VERBOSITY_PARAM_NAME, 1);
            if (verbosityParameter == null) {
                return true;
            }
            IHidObject verbosityParamValue = (IHidObject)methodCall.argumentValuesMapRaw.get(verbosityParameter);
            if (!HidUtils.isHid((IHidObject)verbosityParamValue)) {
                Check_5_1_3_8.this.addHit(this.parserPath, hid.getOccurrence().getLine(), MessageFormat.format(Check_5_1_3_8.HIT_RULE_MESSAGE, OVMUtils.prependLibraryPrefixTo(Check_5_1_3_8.this.fOVMProject.getLibraryKind(), "")), null, false);
                return true;
            }
            IRfNamedElement verbosityParamValueElement = ((RfHid)verbosityParamValue).getElement();
            IRfScopeElement verbosityParamValueScope = verbosityParamValueElement.getEnclosingScope();
            if (verbosityParamValueScope instanceof RfStruct && ((RfStruct)verbosityParamValueScope).getAliasName().equals(Check_5_1_3_8.this.xvmVerbosityEnumName)) {
                return true;
            }
            Check_5_1_3_8.this.addHit(this.parserPath, hid.getOccurrence().getLine(), MessageFormat.format(Check_5_1_3_8.HIT_RULE_MESSAGE, OVMUtils.prependLibraryPrefixTo(Check_5_1_3_8.this.fOVMProject.getLibraryKind(), "")), null, false);
            return true;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

