/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfStringType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.23")
@CheckID(value="XVM.5.1.3.9")
@CheckName(value="XVM.5.1.3.9")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.REPORTING_MACRO, RuleLabel.ARGUMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Always guard with a verbosity check the message computation for xvm_report_info method calls and `xvm_info macro calls")
@CheckDescription(value="When the message parameter of a xvm_report_info and `xvm_info is generated before the method/macro call, \nit should be guarded with a verbosity check (xvm_report_enabled). Consequently, the string generation (which can be time consuming) is avoided when the string is never going to be used due to verbosity settings.\n\nExample:\nif (uvm_report_enabled(UVM_HIGH, \"check_xxxx\"))\n    string my_string = $sformatf(\"my_message_computation\");\nxvm_report_info(\"check_xxxx\", my_string, UVM_HIGH)\n`uvm_info(\"check_xxxx\", my_string, UVM_HIGH)\n\nImplementation notes:\nThe rule checks for assignments to the variable used in the message parameter of an xvm_report_info method call in the first enclosing scope which is not an if block and fails only for the assignments before the method call.\nThe right-hand side of the assignment must be $psprintf, $sformatf, concatenation, replication, toupper(), tolower(), substr() or anything if <checkAnyAssignment> is true.\n\nCheck supports pre-waiving.")
public class Check_5_1_3_9
extends OVMComplianceCheck {
    private Set<String> xvmReportInfoMethods;
    private Set<String> verbosityCheckFunctions = new HashSet<String>();
    private Set<String> predefinedStringFunctions;
    private Map<RfNamedElement, Map<String, Set<HidOccurrence>>> alreadyComputedStrings;
    @CheckParameter(defaultValue="false", description="When true any assignment to the variable used as message parameter is checked.", name="checkAnyAssignment", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckAnyAssignment;
    @CheckParameter(defaultValue="false", description="When true any usage of string after the message context will not flag the string processing.", name="checkUsageAfter", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckUsageAfter;

    public Check_5_1_3_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.verbosityCheckFunctions.add("get_report_verbosity_level");
        this.xvmReportInfoMethods = new HashSet<String>();
        if (this.fOVMProject.getLibraryKind() == 2) {
            this.xvmReportInfoMethods.add("uvm_pkg::uvm_report_info");
            this.xvmReportInfoMethods.add("uvm_pkg::uvm_report_catcher.uvm_report_info");
            this.xvmReportInfoMethods.add("uvm_pkg::uvm_report_object.uvm_report_info");
            this.xvmReportInfoMethods.add("uvm_pkg::uvm_sequence_item.uvm_report_info");
            this.verbosityCheckFunctions.add("uvm_report_enabled");
        } else if (this.fOVMProject.getLibraryKind() == 1) {
            this.xvmReportInfoMethods.add("ovm_pkg::ovm_report_info");
            this.xvmReportInfoMethods.add("ovm_pkg::ovm_report_object.ovm_report_info");
            this.verbosityCheckFunctions.add("ovm_report_enabled");
        }
        this.predefinedStringFunctions = new HashSet<String>();
        this.predefinedStringFunctions.add("$psprintf");
        this.predefinedStringFunctions.add("$sformatf");
        this.predefinedStringFunctions.add("tolower");
        this.predefinedStringFunctions.add("toupper");
        this.predefinedStringFunctions.add("substr");
        this.alreadyComputedStrings = new HashMap<RfNamedElement, Map<String, Set<HidOccurrence>>>();
    }

    @Override
    public void performCheckImpl() {
        this.alreadyComputedStrings.clear();
        this.getAllAlreadyComputedStrings();
        if (this.alreadyComputedStrings == null || this.alreadyComputedStrings.isEmpty()) {
            return;
        }
        Set<RfNamedElement> scopes = this.alreadyComputedStrings.keySet();
        for (final RfNamedElement currentScope : scopes) {
            currentScope.visitHidObject(null, new IHidVisitor<IHidObject>(){
                RfNamedElement scope;
                ParserPath parserPath;

                public boolean visit(IHidObject hidObject) {
                    String stringVariableName;
                    if (!HidUtils.isOperator((IHidObject)hidObject)) {
                        return true;
                    }
                    HidOperator hid = (HidOperator)hidObject;
                    if (!hid.isAssignment()) {
                        return true;
                    }
                    IHidObject left = hid.getLHValue();
                    if (left.getHidKind() == IHidObject.HidKind.IMPLICIT) {
                        stringVariableName = ((RfHidImplicit)left).getName();
                    } else if (left.getHidKind() == IHidObject.HidKind.HID) {
                        stringVariableName = ((RfHid)left).getName();
                    } else {
                        return true;
                    }
                    Map<String, Set<HidOccurrence>> alreadyComputedStringsInScope = Check_5_1_3_9.this.alreadyComputedStrings.get(currentScope);
                    if (!alreadyComputedStringsInScope.containsKey(stringVariableName)) {
                        return true;
                    }
                    Check_5_1_3_9.this.notifyCheckAlive();
                    ListContainer right = hid.getRHValues();
                    if (right == null || right.size() != 1) {
                        return true;
                    }
                    IHidObject rightValue = (IHidObject)right.get(0);
                    if (!Check_5_1_3_9.this.pCheckAnyAssignment && !Check_5_1_3_9.this.checkStringFunction(rightValue)) {
                        return true;
                    }
                    if (Check_5_1_3_9.this.pCheckUsageAfter && Check_5_1_3_9.this.checkIfUsedAfter(stringVariableName, this.scope)) {
                        return true;
                    }
                    if (Check_5_1_3_9.this.checkIfGuardedWithVerbosityCheck(this.scope)) {
                        return true;
                    }
                    Set<HidOccurrence> occurrences = alreadyComputedStringsInScope.get(stringVariableName);
                    if (occurrences == null || occurrences.isEmpty()) {
                        return true;
                    }
                    for (HidOccurrence occurrence : occurrences) {
                        int xvmReportInfoOffset;
                        int messageComputationOffset = hid.getOccurrence().getOffset();
                        if (messageComputationOffset > (xvmReportInfoOffset = occurrence.getOffset())) continue;
                        Check_5_1_3_9.this.addHit(this.parserPath, (HidOccurrence)hid.getOccurrence(), "Computation of string '" + stringVariableName + "' is not guarded by a verbosity check!");
                        return true;
                    }
                    return true;
                }

                public void setParserPath(ParserPath parserPath) {
                    this.parserPath = parserPath;
                }

                public void setHolder(IHidHolder holder) {
                    this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
                }

                public Class<IHidObject> getType() {
                    return IHidObject.class;
                }
            });
        }
    }

    private void getAllAlreadyComputedStrings() {
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidObject>(){
            RfNamedElement scope;
            ParserPath parserPath;

            public boolean visit(IHidObject hidObject) {
                if (this.scope.isPredefined()) {
                    return true;
                }
                if (Check_5_1_3_9.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (!(hidObject instanceof RfHidAccessArgs)) {
                    return true;
                }
                RfHidAccessArgs hid = (RfHidAccessArgs)hidObject;
                MethodCall methodCall = hid.getMethodCall();
                if (methodCall == null || !(methodCall.method instanceof RfFunction)) {
                    return true;
                }
                Check_5_1_3_9.this.notifyCheckAlive();
                RfFunction method = (RfFunction)methodCall.method;
                if (method.getFullName() == null || !Check_5_1_3_9.this.xvmReportInfoMethods.contains(method.getFullName())) {
                    return true;
                }
                if (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty()) {
                    return true;
                }
                RfField messageParameter = method.getArgumentWithPrefix("message", 1);
                if (messageParameter == null) {
                    return true;
                }
                IHidObject messageHid = (IHidObject)methodCall.argumentValuesMapRaw.get(messageParameter);
                if (messageHid == null) {
                    return true;
                }
                HidOccurrence occurrence = hid.getOccurrence();
                Set hids = HidUtils.flattenToUniqueHids((IHidObject)messageHid, (Set)HidFlatteningOption.NONE_EXCLUDED);
                Hid parent = null;
                if (messageHid instanceof RfHidAccessArgs) {
                    parent = ((RfHidAccessArgs)messageHid).getParentHid();
                }
                while (parent != null) {
                    hids.add(parent);
                    HidAccess parentAccess = parent.getParentAccess();
                    if (parentAccess == null) break;
                    parent = parentAccess.getParentHid();
                }
                Check_5_1_3_9.this.checkStringProcessingInMacroCall(hids, this.scope, occurrence);
                return true;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public void setHolder(IHidHolder holder) {
                this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
    }

    private RfNamedElement getFirstNonConditionalActionBlockScope(RfNamedElement scope) {
        while (scope instanceof RfActionBlock) {
            if (((RfActionBlock)scope).isConditional()) {
                scope = scope.getEnclosingScope();
                continue;
            }
            RfDefElement declaration = scope.getDeclaration();
            if (declaration == null || declaration.getReparseInfo() == null) break;
            scope = scope.getEnclosingScope();
        }
        return scope;
    }

    private boolean checkIfGuardedWithVerbosityCheck(RfNamedElement scope) {
        while (scope != null) {
            if (!(scope instanceof RfActionBlock)) {
                scope = scope.getEnclosingScope();
                continue;
            }
            if (!((RfActionBlock)scope).isConditional()) {
                scope = scope.getEnclosingScope();
                continue;
            }
            IHidObject conditionalExpression = ((RfActionBlock)scope).getConditionalBlockExpression();
            if (conditionalExpression == null) {
                String actionBlockExpression = ((RfActionBlock)scope).getExpression();
                for (String function : this.verbosityCheckFunctions) {
                    if (!actionBlockExpression.contains(function)) continue;
                    return true;
                }
            } else {
                Set uniqueHids = HidUtils.flattenToUniqueHids((IHidObject)conditionalExpression, (Set)HidFlatteningOption.NONE_EXCLUDED);
                for (IHid hid : uniqueHids) {
                    if (!this.verbosityCheckFunctions.contains(hid.getName())) continue;
                    return true;
                }
            }
            scope = scope.getEnclosingScope();
        }
        return false;
    }

    private boolean checkStringFunction(IHidObject rightValue) {
        if (rightValue instanceof RfHidOperator) {
            return ((RfHidOperator)rightValue).isVLOGConcatenation(true);
        }
        if (rightValue instanceof RfHidAccessArgs) {
            Hid parentHid = ((RfHidAccessArgs)rightValue).getParentHid();
            if (!(parentHid instanceof RfHid)) {
                return false;
            }
            IRfNamedElement element = ((RfHid)parentHid).getElement();
            if (!(element instanceof RfPredefinedFunction)) {
                return false;
            }
            return this.predefinedStringFunctions.contains(((RfHid)parentHid).getName());
        }
        if (rightValue instanceof RfHid) {
            IRfNamedElement element = ((RfHid)rightValue).getElement();
            if (!(element instanceof RfPredefinedFunction)) {
                return false;
            }
            return this.predefinedStringFunctions.contains(((RfHid)rightValue).getName());
        }
        return false;
    }

    private void checkStringProcessingInMacroCall(Set<IHid> hids, RfNamedElement scope, HidOccurrence occurrence) {
        if (hids == null || hids.isEmpty()) {
            return;
        }
        for (IHid hid : hids) {
            RfNamedElement fieldType;
            IRfNamedElement element;
            if (!(hid instanceof RfHid) || hid.isMethodCall(false) || !((element = ((RfHid)hid).getElement()) instanceof RfField) || (fieldType = LintUtils.getAssociatedFinalType((RfField)element)) == null || !(fieldType instanceof RfStringType) || !"string".equals(fieldType.getName())) continue;
            String stringVariableName = ((RfField)element).getName();
            RfNamedElement firstScope = this.getFirstNonConditionalActionBlockScope(scope);
            if (firstScope == null) continue;
            if (!this.alreadyComputedStrings.containsKey(firstScope)) {
                this.alreadyComputedStrings.put(firstScope, new HashMap());
            }
            if (!this.alreadyComputedStrings.get(firstScope).containsKey(stringVariableName)) {
                this.alreadyComputedStrings.get(firstScope).put(stringVariableName, new HashSet());
            }
            this.alreadyComputedStrings.get(firstScope).get(stringVariableName).add(occurrence);
        }
    }

    private boolean checkIfUsedAfter(final String stringName, final RfNamedElement scope) {
        if (!this.alreadyComputedStrings.containsKey(scope)) {
            return false;
        }
        return !scope.visitHidObject(null, new IHidVisitor<IHidObject>(){

            public boolean visit(IHidObject hidObject) {
                Set uniqueHids = null;
                if (hidObject instanceof RfHidAccessArgs) {
                    uniqueHids = HidUtils.flattenToUniqueHids((IHidObject)hidObject, (Set)HidFlatteningOption.NONE_EXCLUDED);
                } else {
                    if (!HidUtils.isOperator((IHidObject)hidObject)) {
                        return true;
                    }
                    HidOperator hidOperator = (HidOperator)hidObject;
                    if (!hidOperator.isAssignment()) {
                        return true;
                    }
                    IHidObject left = hidOperator.getLHValue();
                    if (left.getHidKind() == IHidObject.HidKind.IMPLICIT && ((RfHidImplicit)left).getName().equals(stringName)) {
                        return true;
                    }
                    if (left.getHidKind() == IHidObject.HidKind.HID && ((RfHid)left).getName().equals(stringName)) {
                        return true;
                    }
                    uniqueHids = hidOperator.getRHHids(HidFlatteningOption.NONE_EXCLUDED);
                }
                HidOccurrence hidOcc = null;
                for (IHid hid : uniqueHids) {
                    if (!hid.getName().equals(stringName)) continue;
                    hidOcc = hid.getOccurrence();
                }
                if (hidOcc == null) {
                    return true;
                }
                Set<HidOccurrence> stringOccurrencesInScope = Check_5_1_3_9.this.alreadyComputedStrings.get(scope).get(stringName);
                if (stringOccurrencesInScope == null || stringOccurrencesInScope.isEmpty()) {
                    return true;
                }
                for (HidOccurrence stringOcc : stringOccurrencesInScope) {
                    if (hidOcc == stringOcc || hidOcc.getOffset() >= stringOcc.getOffset()) continue;
                    return true;
                }
                return false;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

