/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="18.1.37")
@CheckID(value="XVM.5.1.5")
@CheckName(value="XVM.5.1.5")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.REPORTING_MACRO, RuleLabel.ARGUMENT, RuleLabel.NAME, RuleLabel.VERIFICATION})
@CheckTitle(value="First argument of XVM report macros must contain an object's name, full name, type name or a module hierarchical name")
@CheckDescription(value="First argument (ID) of XVM report macros must be a call of xvm_object.get_name(), xvm_object.get_full_name(), xvm_object.get_type_name() or a module hierarchical by using $sformatf(\"%m\") or $sformatf(\"%l\").\nThis rule keeps all the reporting macros IDs uniform and prevents from using generic strings.\n\nCheck supports pre-waiving.")
public class Check_5_1_5
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="get_type_name, get_full_name, get_name, $sformatf", description="Comma separated list of function calls that can be used as the first argument when calling a report macro: get_type_name, get_full_name, get_name and $sformatf.", name="allowedCalls", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pAllowedCalls;
    private static HashSet<String> allAllowedCalls = new HashSet();
    private HashSet<String> forbiddenReportMacros = new HashSet();

    static {
        allAllowedCalls.add("get_type_name");
        allAllowedCalls.add("get_full_name");
        allAllowedCalls.add("get_name");
        allAllowedCalls.add("$sformatf");
    }

    public Check_5_1_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.forbiddenReportMacros.addAll(XVMMacros.OVM_REPORT_MACROS);
        this.forbiddenReportMacros.addAll(XVMMacros.UVM_REPORT_MACROS);
    }

    @Override
    public void configure() {
        super.configure();
        for (String call : this.pAllowedCalls) {
            if (allAllowedCalls.contains(call)) continue;
            this.signalParamError("'" + call + "' is not an allowed call!", true);
        }
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("all", this.forbiddenReportMacros);
    }

    @Override
    public void performCheckImpl() {
        final HashMap validMacros = new HashMap();
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<IHidObject>(){
            RfNamedElement scope;
            ParserPath parserPath;
            StringBuilder macroName = new StringBuilder();
            Set<HidFlatteningOption> hidFlatteningOPtions = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS);
            String patternArgument = "\"%[mlML]\"";

            public boolean visit(IHidObject hidObject) {
                if (!(this.scope instanceof RfActionBlock)) {
                    return true;
                }
                if (!((RfActionBlock)this.scope).hasBeginEnd()) {
                    return true;
                }
                if (Check_5_1_5.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                if (hidObject instanceof RfHidOperator) {
                    if (((RfHidOperator)hidObject).isVLOGConcatenation(true)) {
                        Check_5_1_5.this.checkOperator((RfHidOperator)hidObject, validMacros, this.hidFlatteningOPtions, this.parserPath, this.macroName);
                    }
                    return true;
                }
                if (!(hidObject instanceof RfHid)) {
                    return true;
                }
                IRfNamedElement element = ((RfHid)hidObject).getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                Check_5_1_5.this.notifyCheckAlive();
                if (!Check_5_1_5.this.pAllowedCalls.contains(element.getName())) {
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)((RfHid)hidObject));
                    Check_5_1_5.this.checkMethodCalls(methodCalls, validMacros, this.hidFlatteningOPtions, this.parserPath, this.macroName);
                    return true;
                }
                HidOccurrence occurrence = ((RfHid)hidObject).getOccurrence();
                if (occurrence == null) {
                    return true;
                }
                ReparseInfo reparseInfo = (ReparseInfo)occurrence.getReparseInfo(ReparseInfo.class);
                if (reparseInfo == null || reparseInfo.getReparseStackSize() > 1) {
                    return true;
                }
                this.macroName.setLength(0);
                this.macroName.append("`").append(reparseInfo.getLastReparseMacroName());
                if (!Check_5_1_5.this.forbiddenReportMacros.contains(this.macroName.toString())) {
                    return true;
                }
                HashSet<Integer> occurencesSet = (HashSet<Integer>)validMacros.get(this.parserPath.path);
                if (occurencesSet == null) {
                    occurencesSet = new HashSet<Integer>();
                    validMacros.put(this.parserPath.path, occurencesSet);
                }
                if (((RfFunction)element).getName().equals("$sformatf") && Check_5_1_5.this.pAllowedCalls.contains("$sformatf")) {
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)((RfHid)hidObject));
                    if (methodCalls == null || methodCalls.isEmpty()) {
                        return true;
                    }
                    for (MethodCall methodCall : methodCalls) {
                        Iterator iterator = methodCall.argumentValuesMapRaw.entrySet().iterator();
                        Map.Entry formatString = iterator.next();
                        if (!(formatString.getKey() instanceof RfPredefinedField)) {
                            return true;
                        }
                        IHidObject value = (IHidObject)formatString.getValue();
                        if (!(value instanceof RfHidImplicit)) {
                            occurencesSet.add(-occurrence.getLine());
                            return true;
                        }
                        String name = ((RfHidImplicit)value).getName();
                        if (!name.matches(this.patternArgument)) continue;
                        occurencesSet.add(occurrence.getLine());
                    }
                } else {
                    occurencesSet.add(occurrence.getLine());
                }
                return true;
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }

            public void setHolder(IHidHolder holder) {
                this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }
        });
        try {
            this.fOVMProject.getRfProject().accept(new IRfDefElementVisitor(){
                StringBuilder macroName = new StringBuilder();
                String message;
                {
                    this.message = Check_5_1_5.this.getMessageForHit();
                }

                @Override
                public boolean visit(RfDefElement defElement) throws Exception {
                    return false;
                }

                @Override
                public void preVisit(RfDefElement defElement) throws Exception {
                    this.macroName.setLength(0);
                    if (!(defElement instanceof RfActionBlockDef)) {
                        return;
                    }
                    if (Check_5_1_5.this.checkPreWaivers(defElement.getDefFile().getParserPath())) {
                        return;
                    }
                    RfNamedElement namedElement = defElement.getNamedElement();
                    if (!(namedElement instanceof RfActionBlock)) {
                        return;
                    }
                    ReparseInfo reparseInfo = defElement.getReparseInfo();
                    if (reparseInfo == null || reparseInfo.getReparseStackSize() > 1) {
                        return;
                    }
                    Check_5_1_5.this.notifyCheckAlive();
                    this.macroName.append("`").append(reparseInfo.getLastReparseMacroName());
                    if (!Check_5_1_5.this.forbiddenReportMacros.contains(this.macroName.toString())) {
                        return;
                    }
                    HashSet occurencesSet = (HashSet)validMacros.get(defElement.getParserPath().path);
                    if (occurencesSet != null && occurencesSet.contains(defElement.getStartLine()) && !occurencesSet.contains(-defElement.getStartLine())) {
                        return;
                    }
                    Check_5_1_5.this.addHit(defElement.getDefFile().getParserPath(), defElement.getStartLine(), "First argument of macro '" + this.macroName + "' is not " + this.message, null);
                }

                @Override
                public void postVisit(RfDefElement defElement) throws Exception {
                }
            });
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String getMessageForHit() {
        StringBuilder message = new StringBuilder();
        ArrayList<String> allowedCallsAsList = new ArrayList<String>(this.pAllowedCalls);
        int size = allowedCallsAsList.size();
        if (size == 0) {
            return " an allowed function call!";
        }
        if (size == 1) {
            message.append(String.valueOf(this.getMessage((String)allowedCallsAsList.get(0))) + "!");
        } else {
            int i = 0;
            while (i < size - 2) {
                message.append(String.valueOf(this.getMessage((String)allowedCallsAsList.get(i))) + ", ");
                ++i;
            }
            message.append(String.valueOf(this.getMessage((String)allowedCallsAsList.get(size - 2))) + " or ");
            message.append(String.valueOf(this.getMessage((String)allowedCallsAsList.get(size - 1))) + "!");
        }
        return message.toString();
    }

    private String getMessage(String call) {
        if (call.equals("get_type_name")) {
            return "a type name";
        }
        if (call.equals("get_full_name")) {
            return "an object full name";
        }
        if (call.equals("get_name")) {
            return "an object name";
        }
        if (call.equals("$sformatf")) {
            return "a module hierarchical name";
        }
        return "";
    }

    private void checkOperator(RfHidOperator hidObject, HashMap<String, HashSet<Integer>> validMacros, Set<HidFlatteningOption> hidFlatteningOPtions, ParserPath parserPath, StringBuilder macroName) {
        HidOperatorOccurrence occurrence = hidObject.getOccurrence();
        ReparseInfo reparseInfo = (ReparseInfo)occurrence.getReparseInfo(ReparseInfo.class);
        if (reparseInfo == null || reparseInfo.getReparseStackSize() > 1) {
            return;
        }
        macroName.setLength(0);
        macroName.append("`").append(reparseInfo.getLastReparseMacroName());
        if (!this.forbiddenReportMacros.contains(macroName.toString())) {
            return;
        }
        Set rhHids = hidObject.getRHHids(hidFlatteningOPtions);
        this.findAllowedFunctionCall(rhHids, (HidOccurrence)occurrence, validMacros, parserPath);
    }

    private void checkMethodCalls(List<MethodCall> methodCalls, HashMap<String, HashSet<Integer>> validMacros, Set<HidFlatteningOption> hidFlatteningOPtions, ParserPath parserPath, StringBuilder macroName) {
        if (methodCalls == null || methodCalls.isEmpty()) {
            return;
        }
        for (MethodCall methodCall : methodCalls) {
            ReparseInfo reparseInfo = (ReparseInfo)methodCall.occurrence.getReparseInfo(ReparseInfo.class);
            if (reparseInfo == null || reparseInfo.getReparseStackSize() > 1) continue;
            macroName.setLength(0);
            macroName.append("`").append(reparseInfo.getLastReparseMacroName());
            if (!this.forbiddenReportMacros.contains(macroName.toString()) || methodCall.method.getName().equals(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_report_enabled")) || methodCall.argumentValuesMapRaw == null) continue;
            for (Map.Entry argumentValue : methodCall.argumentValuesMapRaw.entrySet()) {
                if (!(argumentValue.getKey() instanceof RfField)) continue;
                Set values = HidUtils.flattenToHids((IHidObject)((IHidObject)argumentValue.getValue()), hidFlatteningOPtions);
                this.findAllowedFunctionCall(values, methodCall.occurrence, validMacros, parserPath);
            }
        }
    }

    private void findAllowedFunctionCall(Set<IHid> values, HidOccurrence occurrence, HashMap<String, HashSet<Integer>> validMacros, ParserPath parserPath) {
        if (values == null || values.isEmpty()) {
            return;
        }
        for (IHid hid : values) {
            IRfNamedElement el;
            if (!(hid instanceof RfHid) || !((el = ((RfHid)hid).getElement()) instanceof RfFunction) || !this.pAllowedCalls.contains(el.getName())) continue;
            HashSet<Integer> occurencesSet = validMacros.get(parserPath.path);
            if (occurencesSet == null) {
                occurencesSet = new HashSet();
                validMacros.put(parserPath.path, occurencesSet);
            }
            occurencesSet.add(-occurrence.getLine());
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

