/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractXVMMacroCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="19.1.25")
@CheckID(value="XVM.5.1.6")
@CheckName(value="XVM.5.1.6")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.REPORTING_MACRO, RuleLabel.BUILD_PHASE, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use `xvm_fatal during build phase")
@CheckDescription(value="Do not use `xvm_fatal during build phase, use instead `xvm_error because it automatically causes a fatal error before entering run phase.\nUsing `xvm_error allows phases after the build phase to continue. Any further build errors, would be hidden had `xvm_fatal been used.\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="allowCallsFromNonComponents", defaultValue="false", isVisible=false)
public class Check_5_1_6
extends AbstractXVMMacroCheck {
    private static final HashSet<String> UVM_MACRO_CALLS = new HashSet<String>(Arrays.asList("`uvm_fatal"));
    private static final HashSet<String> OVM_MACRO_CALLS = new HashSet<String>(Arrays.asList("`ovm_fatal"));
    private HashSet<String> fMacroCalls;

    public Check_5_1_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        boolean isOVMLib = this.fOVMProject.getLibraryKind() == 1;
        this.fMacroCalls = isOVMLib ? OVM_MACRO_CALLS : UVM_MACRO_CALLS;
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("function", this.fMacroCalls);
    }

    @Override
    protected Set<String> getMacroCalls() {
        return this.fMacroCalls;
    }

    @Override
    protected List<RfFunction> getMethods(RfNamedElement component) {
        ArrayList<RfFunction> methods = new ArrayList<RfFunction>();
        methods.addAll(component.getFunctionsWithPrefix("build_phase", 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        return methods;
    }

    @Override
    protected String getFailMessage(MacroCallItem macroCall, RfFunction function, String functionCallStack) {
        return String.valueOf(macroCall.getName()) + " is used during build phase in '" + LintUtils.getNamedElementFullName(function) + "()'!" + (functionCallStack == null || functionCallStack.isEmpty() ? "" : " Call stack:" + functionCallStack);
    }
}

