/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractOverrideMethodCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="16.1.19")
@CheckID(value="XVM.5.2.1.1")
@CheckName(value="XVM.5.2.1.1")
@CheckLabel(labels={RuleLabel.FACTORY_OVERRIDE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Factory override methods must use compatible override types")
@CheckDescription(value="Override type must inherit from original type when used in factory override methods: set_type_override*() and set_inst_override*().\n\nCheck supports pre-waiving.")
public class Check_5_2_1_1
extends AbstractOverrideMethodCheck {
    public Check_5_2_1_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final Map<RfFunction, Function<RfHidAccessArgs, List<IHidObject>>> overrideMethodsMap = this.getOverrideMethodsMap();
        if (overrideMethodsMap == null) {
            return;
        }
        ArrayList<RfNamedElement> allFunctions = new ArrayList<RfNamedElement>();
        allFunctions.addAll(this.fOVMProject.getAllFunctions());
        allFunctions.addAll(this.fOVMProject.getAllTasks());
        RfHidVisitor visitor = new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                IRfNamedElement element = hid.getElement();
                Function handler = (Function)overrideMethodsMap.get(element);
                if (handler == null) {
                    return true;
                }
                Check_5_2_1_1.this.notifyCheckAlive();
                if (!hid.hasAccesses()) {
                    return true;
                }
                if (!(this.holder instanceof RfHidHolder)) {
                    return true;
                }
                IRfNamedElement enclosingScope = ((RfHidHolder)this.holder).getScope();
                for (HidAccess access : hid.getAccesses()) {
                    RfClass overrideClass;
                    List arguments;
                    RfClass originalClass;
                    List<? extends IHidObject> argumentValues;
                    if (!(access instanceof RfHidAccessArgs) || (argumentValues = ((RfHidAccessArgs)access).getArgumentValues()) == null || argumentValues.isEmpty() || (originalClass = this.getClassForArgument((IHidObject)(arguments = (List)handler.apply((RfHidAccessArgs)access)).get(0), (IRfScopeElement)enclosingScope, access)) == null || (overrideClass = this.getClassForArgument((IHidObject)arguments.get(1), (IRfScopeElement)enclosingScope, access)) == null || overrideClass.isSubClass(originalClass)) continue;
                    Check_5_2_1_1.this.addHit(this.parserPath, ((RfHidAccessArgs)access).getOccurrence(), "Override type '" + LintUtils.getNamedElementFullName(overrideClass) + "' is not compatible with original type '" + LintUtils.getNamedElementFullName(originalClass) + "'!");
                }
                return true;
            }

            /*
             * Unable to fully structure code
             */
            private RfClass getClassForArgument(IHidObject arg, IRfScopeElement enclosingScope, HidAccess access) {
                block22: {
                    if (arg instanceof RfHid && (element = ((RfHid)arg).getElement()) instanceof RfClass) {
                        return (RfClass)element;
                    }
                    if (!(arg instanceof RfHidOperator)) break block22;
                    rhValues = ((RfHidOperator)arg).getRHValues();
                    if (rhValues == null || rhValues.size() != 1) {
                        return null;
                    }
                    parameter = (IHidObject)rhValues.get(0);
                    parentAccess = null;
                    if (parameter instanceof IHid) {
                        parentAccess = ((IHid)parameter).getParentHid();
                    } else if (parameter instanceof RfHidAccessArgs) {
                        parentAccess = ((RfHidAccessArgs)parameter).getParentHid();
                    } else {
                        return null;
                    }
                    if (parentAccess != null) ** GOTO lbl49
                    argument = null;
                    if (!(rhValues.get(0) instanceof RfHidImplicit)) break block22;
                    argument = ((RfHidImplicit)rhValues.get(0)).getName();
                    if (argument.contains("\"")) {
                        argument = argument.substring(1, argument.length() - 1);
                    }
                    scope = (RfNamedElement)enclosingScope;
                    result = null;
                    argumentChunks = DVTStringUtil.split((Pattern)DVTStringUtil.COLON_COLON, (String)argument);
                    if (argumentChunks.length > 0) {
                        prefix = argumentChunks[argumentChunks.length - 1];
                        if (argumentChunks.length == 1) {
                            result = scope.getClassWithPrefix(prefix, 1, 3);
                            if (result == null) {
                                result = scope.getTypeAliasWithPrefix(prefix, 1, 3, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                            }
                        } else if (argumentChunks.length > 1) {
                            classScope = scope.getPackageWithPrefix(argumentChunks[0], 1);
                            if (classScope != null) {
                                result = classScope.getClassWithPrefix(prefix, 1, 1);
                            }
                            if (result == null) {
                                result = scope.getTypeAliasWithPrefix(prefix, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                            }
                        }
                    }
                    if (result == null) {
                        Check_5_2_1_1.access$0(Check_5_2_1_1.this, this.parserPath, ((RfHidAccessArgs)access).getOccurrence(), "Type '" + argument + "' could not be found!");
                        return null;
                    }
                    if (result instanceof RfTypeAlias) {
                        result = ((RfTypeAlias)result).getAssociatedType();
                    }
                    if (!(result instanceof RfClass)) break block22;
                    return (RfClass)result;
lbl-1000:
                    // 1 sources

                    {
                        if (parentAccess.getElement() instanceof RfClass) {
                            return (RfClass)parentAccess.getElement();
                        }
                        parentAccess = parentAccess.getParentHid();
lbl49:
                        // 2 sources

                        ** while (parentAccess != null)
                    }
                }
                return null;
            }
        };
        for (RfNamedElement function : allFunctions) {
            if (this.checkPreWaivers(function.getFile())) continue;
            function.visitHidObject(null, visitor);
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

