/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractOverrideMethodCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.utils.Utils;

@CheckVersion(value="17.1.9")
@CheckID(value="XVM.5.2.1.2")
@CheckName(value="XVM.5.2.1.2")
@CheckLabel(labels={RuleLabel.FACTORY_OVERRIDE, RuleLabel.METHOD, RuleLabel.FACTORY_CREATE, RuleLabel.VERIFICATION})
@CheckTitle(value="Factory overrides must be called before any create call")
@CheckDescription(value="Factory overrides must be called before any create call, otherwise the override will not have any effect on the created instance.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_5_2_1_2
extends AbstractOverrideMethodCheck {
    private static final Set<String> FACTORY_CREATE_FUNCTION_NAMES = new HashSet<String>();
    private RfClass objectRegistryClass;
    private RfClass componentRegistryClass;
    private RfClass objectWrapperClass;
    private RfClass factoryClass;
    private RfClass componentClass;
    private Set<RfFunction> overrideMethods;
    private String createStackString;
    private static final Comparator<Map.Entry<FileLineCall, RfFunction>> MAP_ENTRY_COMPARATOR;

    static {
        FACTORY_CREATE_FUNCTION_NAMES.add("create_object_by_type");
        FACTORY_CREATE_FUNCTION_NAMES.add("create_object_by_name");
        FACTORY_CREATE_FUNCTION_NAMES.add("create_component_by_type");
        FACTORY_CREATE_FUNCTION_NAMES.add("create_component_by_name");
        MAP_ENTRY_COMPARATOR = (e1, e2) -> {
            FileLineCall flc1 = (FileLineCall)e1.getKey();
            FileLineCall flc2 = (FileLineCall)e2.getKey();
            if (flc1.getFile().equals((Object)flc2.getFile())) {
                if (flc1.getLine() == flc2.getLine()) {
                    return flc1.getOffset() - flc2.getOffset();
                }
                return flc1.getLine() - flc2.getLine();
            }
            return flc1.getFile().compareTo(flc2.getFile());
        };
    }

    public Check_5_2_1_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.objectRegistryClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_registry"), true);
        this.componentRegistryClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_component_registry"), true);
        this.objectWrapperClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_wrapper"), true);
        this.factoryClass = this.fOVMProject.getRfProject().getClass(String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg")) + "::" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_factory"), true);
        this.componentClass = this.fOVMProject.fOvmComponent;
        if (this.objectRegistryClass == null || this.componentRegistryClass == null || this.objectWrapperClass == null || this.factoryClass == null || this.componentClass == null) {
            return;
        }
        this.overrideMethods = this.getOverrideMethods();
        if (this.overrideMethods == null) {
            return;
        }
        String xvmBuildPhaseMethodName = this.fOVMProject.getBuildPhaseMethodName();
        this.notifyCheckAlive();
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllComponents().values()) {
            RfFileDef file = rfNamedElement.getFile();
            if (file == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            RfFunction buildPhaseFunction = rfNamedElement.getLocalFunction(xvmBuildPhaseMethodName);
            if (buildPhaseFunction == null) continue;
            HashSet<RfFunction> visited = new HashSet<RfFunction>();
            this.collectRecursivelyOverrideCalls(buildPhaseFunction, new ArrayDeque<String>(), null, 0, visited, new boolean[1]);
        }
    }

    private void collectRecursivelyOverrideCalls(RfFunction function, Deque<String> functionCallStack, FileLineCall fileLineCall, int callIndex, Set<RfFunction> visited, boolean[] createFound) {
        if (this.isCreateFunction(function)) {
            if (!createFound[0]) {
                createFound[0] = true;
                this.createStackString = this.getStringFromStack(functionCallStack);
            }
            return;
        }
        if (this.overrideMethods.contains(function)) {
            if (createFound[0] && fileLineCall != null) {
                StringBuilder msg = new StringBuilder("override() is called after create()!");
                msg.append("\n\nOverride() stack:\n");
                msg.append(this.getStringFromStack(functionCallStack));
                msg.append("\n\nCreate() stack:\n");
                msg.append(this.createStackString);
                this.addHit(fileLineCall.getFile(), fileLineCall.getLine(), msg.toString(), null);
            }
            return;
        }
        if (function == null || function.isPredefined()) {
            return;
        }
        if (function == null || function.isPredefined() || visited.contains(function)) {
            return;
        }
        visited.add(function);
        RfFileDef functionFile = function.getFile();
        if (functionFile != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(functionFile.getParserPath(), this)) {
            return;
        }
        LocalHidVisitor visitor = new LocalHidVisitor();
        function.visitHidObject(this.fOVMProject.getRfProject(), visitor);
        List<Map.Entry<FileLineCall, RfFunction>> functionsToBeChecked = visitor.getFunctionsToBeChecked();
        for (Map.Entry<FileLineCall, RfFunction> entry : functionsToBeChecked) {
            RfFunction calledFunction = entry.getValue();
            FileLineCall fileLine = entry.getKey();
            if (this.fOVMProject.isOVMElement(calledFunction) && !this.isCreateFunction(calledFunction) && !this.overrideMethods.contains(calledFunction)) continue;
            String currentCall = String.valueOf(callIndex) + ": " + this.link(function) + "() - calls " + fileLine.getMethodCall() + "() in " + this.link(String.valueOf(Utils.getInstance().getFileName(fileLine.getFile().path)) + ":" + fileLine.getLine(), fileLine.getFile().path, fileLine.getLine());
            functionCallStack.addLast(currentCall);
            this.collectRecursivelyOverrideCalls(calledFunction, functionCallStack, fileLine, callIndex + 1, visited, createFound);
            functionCallStack.removeLast();
        }
        visited.remove(function);
    }

    private String getStringFromStack(Deque<String> queue) {
        return DVTStringUtil.join(queue, (String)"\n");
    }

    private boolean isCreateFunction(RfFunction function) {
        String functionName = function.getName();
        RfNamedElement enclosingScope = function.getEnclosingScope();
        if (!(enclosingScope instanceof RfClass)) {
            return false;
        }
        RfClass enclosingClass = (RfClass)enclosingScope;
        if (functionName.equals("create") && (LintUtils.isSubClassOf(enclosingClass, this.objectRegistryClass) || LintUtils.isSubClassOf(enclosingClass, this.componentRegistryClass))) {
            return true;
        }
        if (functionName.equals("create_component") && LintUtils.isSubClassOf(enclosingClass, this.componentClass)) {
            return true;
        }
        if (functionName.equals("create_object") && LintUtils.isSubClassOf(enclosingClass, this.objectWrapperClass)) {
            return true;
        }
        return FACTORY_CREATE_FUNCTION_NAMES.contains(functionName) && LintUtils.isSubClassOf(enclosingClass, this.factoryClass);
    }

    private Set<RfFunction> getOverrideMethods() {
        HashSet<RfFunction> overrideMethods = new HashSet<RfFunction>();
        RfPackage xvmPackage = this.getXVMPackage();
        if (xvmPackage == null) {
            return null;
        }
        Map<RfFunction, Function<RfHidAccessArgs, List<IHidObject>>> factoryOverride = this.getOverrideMethodsMap();
        if (factoryOverride == null) {
            return null;
        }
        overrideMethods.addAll(factoryOverride.keySet());
        RfFunction xvmMethod = null;
        RfClass xvmClass = null;
        xvmClass = this.getXVMClass(xvmPackage, "_component_registry");
        if (xvmClass == null) {
            return null;
        }
        xvmMethod = this.getXVMFunction(xvmClass, "set_type_override");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethods.add(xvmMethod);
        xvmMethod = this.getXVMFunction(xvmClass, "set_inst_override");
        if (xvmMethod == null) {
            return null;
        }
        overrideMethods.add(xvmMethod);
        return overrideMethods;
    }

    private static final class FileLineCall {
        ParserPath file;
        int line;
        int offset;
        String methodCall;

        public FileLineCall(ParserPath parserPath, int line, int offset, String methodCall) {
            this.file = parserPath;
            this.line = line;
            this.offset = offset;
            this.methodCall = methodCall;
        }

        public ParserPath getFile() {
            return this.file;
        }

        public int getLine() {
            return this.line;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getMethodCall() {
            return this.methodCall;
        }

        public int hashCode() {
            return Objects.hash(this.file, this.line, this.offset, this.methodCall);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileLineCall other = (FileLineCall)obj;
            if (this.line != other.line) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            if (!Objects.equals(this.file, other.file)) {
                return false;
            }
            return Objects.equals(this.methodCall, other.methodCall);
        }
    }

    private final class LocalHidVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;
        private Map<FileLineCall, RfFunction> functionsToBeChecked = new LinkedHashMap<FileLineCall, RfFunction>();

        private LocalHidVisitor() {
        }

        public List<Map.Entry<FileLineCall, RfFunction>> getFunctionsToBeChecked() {
            return this.functionsToBeChecked.entrySet().stream().sorted(MAP_ENTRY_COMPARATOR).collect(Collectors.toList());
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHid hid) {
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfFunction) || element.isPredefined()) {
                return true;
            }
            RfFunction calledFunction = (RfFunction)element;
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                this.functionsToBeChecked.put(new FileLineCall(this.parserPath, methodCall.occurrence.getLine(), methodCall.occurrence.getOffset(), HidUtils.toNiceString((IHidObject)hid)), calledFunction);
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

