/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_XVM_Names;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractNameCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.5.3.4")
@CheckName(value="XVM.5.3.4")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.ANALYSIS_PORT, RuleLabel.STYLING, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Naming of TLM Analysis Exports")
@CheckDescription(value="All analysis export instances must end with the '_analysis_export' suffix.\n\nExamples for default suffix = '_analysis_export':\nuvm_analysis_export my_analysis_export; // allowed\nuvm_analysis_export my_field; // not allowed\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_XVM_Names.class)
@CheckParameterOverride(name="suffix", defaultValue="_analysis_export", isVisible=true)
public class Check_5_3_4
extends AbstractNameCheck {
    private String clazzName;

    public Check_5_3_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void checkComponentNames() {
        for (RfNamedElement port : this.fOVMProject.getAllPorts()) {
            RfFileDef portFile = port.getFile();
            if (portFile != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(portFile.getParserPath(), this)) continue;
            RfClass clazz = LintUtils.getFieldFinalClassTypeOrNull((RfField)port);
            if (clazz == null) {
                return;
            }
            this.notifyCheckAlive();
            this.clazzName = clazz.getName();
            if (!this.clazzName.endsWith("_analysis_export")) continue;
            this.checkValidName(port);
        }
    }

    @Override
    protected String getHitMessage(RfNamedElement component, String suffixes) {
        return "Port '" + component.getName() + "' of type '" + this.clazzName + "' must have one of the following suffixes: " + suffixes + "!";
    }

    @Override
    protected Map<String, RfClass> getComponents() {
        return null;
    }
}

