/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.Map;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_XVM_5_3_5;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractNameCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.5.3.5")
@CheckName(value="XVM.5.3.5")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.TLM_PORT, RuleLabel.STYLING, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Naming of Get / Put Ports / Exports")
@CheckDescription(value="All get ports / exports must be named with an _get_port (or _get_export) suffix.\nAll put ports / exports must be named with an _put_port (or _put_export) suffix.\n\nExamples for default suffix values:\nuvm_get_port my_get_port; // allowed\nuvm_get_port my_field; // not allowed\n\nuvm_put_port test_put_port; // allowed\nuvm_put_port my_field; // not allowed\n\nuvm_get_export my_get_export; // allowed\nuvm_get_export my_field; // not allowed\n\nuvm_put_export test_put_export; // allowed\nuvm_put_export my_field; // not allowed\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_XVM_5_3_5.class)
@CheckParameterOverride(name="suffix", isVisible=false)
public class Check_5_3_5
extends AbstractNameCheck {
    public static final String GET_PORT_SUFFIX_PROPERTY = "getPortSuffix";
    public static final String GET_EXPORT_SUFFIX_PROPERTY = "getExportSuffix";
    public static final String PUT_PORT_SUFFIX_PROPERTY = "putPortSuffix";
    public static final String PUT_EXPORT_SUFFIX_PROPERTY = "putExportSuffix";
    private String clazzName;
    private String getPortSuffixesMessage;
    private String getExportSuffixesMessage;
    private String putPortSuffixesMessage;
    private String putExportSuffixesMessage;
    @CheckParameter(defaultValue="_get_port", description="Comma separated list of allowed suffixes for get ports.", name="getPortSuffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pGetPortSuffixes;
    @CheckParameter(defaultValue="_get_export", description="Comma separated list of allowed suffixes for get exports.", name="getExportSuffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pGetExportSuffixes;
    @CheckParameter(defaultValue="_put_port", description="Comma separated list of allowed suffixes for put ports.", name="putPortSuffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pPutPortSuffixes;
    @CheckParameter(defaultValue="_put_export", description="Comma separated list of allowed suffixes for put exports.", name="putExportSuffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pPutExportSuffixes;

    public Check_5_3_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkForEmptyParameters() {
        if (this.pGetPortSuffixes == null || this.pGetPortSuffixes.isEmpty()) {
            this.signalParamError("Parameter \"getPortSuffix\" must have at least one value!", true);
        }
        if (this.pGetExportSuffixes == null || this.pGetExportSuffixes.isEmpty()) {
            this.signalParamError("Parameter \"getExportSuffix\" must have at least one value!", true);
        }
        if (this.pPutPortSuffixes == null || this.pPutPortSuffixes.isEmpty()) {
            this.signalParamError("Parameter \"putPortSuffix\" must have at least one value!", true);
        }
        if (this.pPutExportSuffixes == null || this.pPutExportSuffixes.isEmpty()) {
            this.signalParamError("Parameter \"putExportSuffix\" must have at least one value!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        this.suffixesMessage = null;
        this.getPortSuffixesMessage = DVTStringUtil.join(this.pGetPortSuffixes, (String)", ");
        this.getExportSuffixesMessage = DVTStringUtil.join(this.pGetExportSuffixes, (String)", ");
        this.putPortSuffixesMessage = DVTStringUtil.join(this.pPutPortSuffixes, (String)", ");
        this.putExportSuffixesMessage = DVTStringUtil.join(this.pPutExportSuffixes, (String)", ");
        for (RfNamedElement port : this.fOVMProject.getAllPorts()) {
            RfFileDef portFile = port.getFile();
            if (portFile != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(portFile.getParserPath(), this)) continue;
            RfClass clazz = LintUtils.getFieldFinalClassTypeOrNull((RfField)port);
            if (clazz == null) {
                return;
            }
            this.notifyCheckAlive();
            this.clazzName = clazz.getName();
            if (this.clazzName.endsWith("_get_port")) {
                this.suffixesMessage = this.getPortSuffixesMessage;
                this.checkValidName(port, this.pGetPortSuffixes);
                continue;
            }
            if (this.clazzName.endsWith("_get_export")) {
                this.suffixesMessage = this.getExportSuffixesMessage;
                this.checkValidName(port, this.pGetExportSuffixes);
                continue;
            }
            if (this.clazzName.endsWith("_put_port")) {
                this.suffixesMessage = this.putPortSuffixesMessage;
                this.checkValidName(port, this.pPutPortSuffixes);
                continue;
            }
            if (!this.clazzName.endsWith("_put_export")) continue;
            this.suffixesMessage = this.putExportSuffixesMessage;
            this.checkValidName(port, this.pPutExportSuffixes);
        }
    }

    @Override
    protected String getHitMessage(RfNamedElement component, String suffixes) {
        return "Port '" + component.getName() + "' of type '" + this.clazzName + "' must have one of the following suffixes: " + suffixes + "!";
    }

    @Override
    protected Map<String, RfClass> getComponents() {
        return null;
    }
}

