/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_XVM_Names;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractNameCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.5.4.1")
@CheckName(value="XVM.5.4.1")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.TLM_PORT, RuleLabel.STYLING, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Naming of TLM FIFOs")
@CheckDescription(value="All TLM fifo instances must end with the '_fifo_h' suffix.\n\nExamples for default suffix = '_fifo_h':\nuvm_tlm_fifo my_fifo_h; // allowed\nuvm_tlm_fifo my_field; // not allowed\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_XVM_Names.class)
@CheckParameterOverride(name="suffix", defaultValue="_fifo_h", isVisible=true)
public class Check_5_4_1
extends AbstractNameCheck {
    private String clazzName;

    public Check_5_4_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void checkComponentNames() {
        for (RfNamedElement fifo : this.fOVMProject.getAllFifos()) {
            RfFileDef portFile = fifo.getFile();
            if (portFile != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(portFile.getParserPath(), this)) continue;
            RfClass clazz = LintUtils.getFieldFinalClassTypeOrNull((RfField)fifo);
            if (clazz == null) {
                return;
            }
            this.notifyCheckAlive();
            this.clazzName = clazz.getName();
            if (!this.clazzName.endsWith("_fifo") || this.clazzName.endsWith("_analysis_fifo")) continue;
            this.checkValidName(fifo);
        }
    }

    @Override
    protected String getHitMessage(RfNamedElement component, String suffixes) {
        return "FIFO '" + component.getName() + "' of type '" + this.clazzName + "' must have one of the following suffixes: " + suffixes + "!";
    }

    @Override
    protected Map<String, RfClass> getComponents() {
        return null;
    }
}

