/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Map;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_XVM_Names;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractNameCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.5.4.2")
@CheckName(value="XVM.5.4.2")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.ANALYSIS_PORT, RuleLabel.FIELD, RuleLabel.STYLING, RuleLabel.VERIFICATION})
@CheckTitle(value="Naming of TLM Analysis FIFOs")
@CheckDescription(value="All TLM analysis fifo instances must end with the '_analysis_fifo_h' suffix.\n\nExamples for default suffix = '_analysis_fifo_h':\nuvm_tlm_analysis_fifo my_analysis_fifo_h; // allowed\nuvm_tlm_analysis_fifo my_field; // not allowed\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckAutofix(value=Autofix_XVM_Names.class)
@CheckParameterOverride(name="suffix", defaultValue="_analysis_fifo_h", isVisible=true)
public class Check_5_4_2
extends AbstractNameCheck {
    private String clazzName;

    public Check_5_4_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void checkComponentNames() {
        for (RfNamedElement fifo : this.fOVMProject.getAllFifos()) {
            RfFileDef portFile = fifo.getFile();
            if (portFile != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(portFile.getParserPath(), this)) continue;
            RfClass clazz = LintUtils.getFieldFinalClassTypeOrNull((RfField)fifo);
            if (clazz == null) {
                return;
            }
            this.notifyCheckAlive();
            this.clazzName = clazz.getName();
            if (!this.clazzName.endsWith("_analysis_fifo")) continue;
            this.checkValidName(fifo);
        }
    }

    @Override
    protected String getHitMessage(RfNamedElement component, String suffixes) {
        return "FIFO '" + component.getName() + "' of type '" + this.clazzName + "' must have one of the following suffixes: " + suffixes + "!";
    }

    @Override
    protected Map<String, RfClass> getComponents() {
        return null;
    }
}

