/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.LinkedHashMap;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractCreatedInstanceNameCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="XVM.5.4.4")
@CheckName(value="XVM.5.4.4")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.FIELD, RuleLabel.NAME, RuleLabel.VERIFICATION})
@CheckTitle(value="For all fields of a XVM fifo type, the constructed string name must match the field name")
@CheckDescription(value="The constructed string name (with either factory create or new) must exactly match the name of the class member that is being created, because XVM builds the hierarchy tree for instance overrides based on the provided string names. See also 2.1.4.2.7\n\nImplementation Notes:\nFor all new and create calls, if the created field is a XVM fifo, perform the check.\nThe check is performed only if the field class type has a constructor with the first argument 'name'.\n\nExamples:\nm_analysis_fifo_h = new(\"m_analysis_fifo_h\", this);\nNot Allowed:\nm_analysis_fifo_h = new(\"analysis_fifo\", this);\n\nCheck supports pre-waiving.")
public class Check_5_4_4
extends AbstractCreatedInstanceNameCheck {
    public Check_5_4_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        LinkedHashMap<String, RfClass> allFifoClasses = new LinkedHashMap<String, RfClass>();
        for (RfNamedElement fifo : this.fOVMProject.getAllFifos()) {
            RfNamedElement fifoType;
            if (!(fifo instanceof RfAssociatedType) || (fifoType = LintUtils.getAssociatedFinalType((RfAssociatedType)fifo)) == null || !(fifoType instanceof RfClass) || allFifoClasses.containsKey(fifoType.getFullName())) continue;
            allFifoClasses.put(fifoType.getFullName(), (RfClass)fifoType);
        }
        this.checkCreatedInstanceName(allFifoClasses, "FIFO");
    }
}

