/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="18.1.24")
@CheckID(value="XVM.5.4.5")
@CheckName(value="XVM.5.4.5")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.TLM_PORT, RuleLabel.NAME, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not create TLM ports with null or empty name or parent")
@CheckDescription(value="When calling the constructor of a TLM port the name must be non-null and non-empty and the parent must be non-null.\n\nCheck supports pre-waiving.")
public class Check_5_4_5
extends OVMComplianceCheck {
    private final String XVM_PORT_BASE;
    private final String XVM_TLM_FIFO_BASE;
    private final Set<String> classNames;

    public Check_5_4_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.XVM_PORT_BASE = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_port_base");
        this.XVM_TLM_FIFO_BASE = this.fOVMProject.getLibraryKind() == 1 ? "tlm_fifo_base" : "uvm_tlm_fifo_base";
        this.classNames = new HashSet<String>(Arrays.asList(this.XVM_TLM_FIFO_BASE, this.XVM_PORT_BASE));
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        LocalHidVisitor visitor = new LocalHidVisitor();
        rfProject.visitHidObject(null, visitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    public class LocalHidVisitor
    extends RfHidVisitor {
        private Set<RfClass> childrenOfClasses = new HashSet<RfClass>();
        private static final String EMPTY_STRING = "\"\"";
        private static final String NULL_STRING = "null";
        private static final String NAME_STRING = "name";
        private static final String PARENT_STRING = "parent";

        public boolean visit(RfHid hid) {
            if (Check_5_4_5.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction functionElement = (RfFunction)element;
            if (!functionElement.isConstructor()) {
                return true;
            }
            RfNamedElement scope = functionElement.getEnclosingScope();
            if (!(scope instanceof RfClass)) {
                return true;
            }
            Check_5_4_5.this.notifyCheckAlive();
            RfClass classScope = (RfClass)scope;
            if (!this.isTLMPortClass(classScope)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            for (MethodCall methodCall : methodCalls) {
                if (!(methodCall.method instanceof RfFunction)) continue;
                RfField parentParameter = ((RfFunction)methodCall.method).getArgumentWithPrefix(PARENT_STRING, 1);
                if (parentParameter == null) {
                    return true;
                }
                RfField nameParameter = ((RfFunction)methodCall.method).getArgumentWithPrefix(NAME_STRING, 1);
                if (nameParameter == null) {
                    return true;
                }
                if (methodCall.occurrence == null) continue;
                int occurrenceLine = methodCall.occurrence.getLine();
                String elementFullName = LintUtils.getNamedElementFullName(functionElement);
                if (methodCall.argumentValuesMapRaw == null) {
                    Check_5_4_5.this.addHit(this.parserPath, occurrenceLine, "'null' or empty string is used for name in constructor '" + elementFullName + "'!", null);
                    Check_5_4_5.this.addHit(this.parserPath, occurrenceLine, "'null' is used for parent in constructor '" + elementFullName + "'!", null);
                    continue;
                }
                IHidObject parentParameterValue = (IHidObject)methodCall.argumentValuesMapRaw.get(parentParameter);
                IHidObject nameParameterValue = (IHidObject)methodCall.argumentValuesMapRaw.get(nameParameter);
                if (nameParameterValue == null || nameParameterValue instanceof RfHidImplicit && (NULL_STRING.equals(((RfHidImplicit)nameParameterValue).getName()) || EMPTY_STRING.equals(((RfHidImplicit)nameParameterValue).getName()))) {
                    Check_5_4_5.this.addHit(this.parserPath, occurrenceLine, "'null' or empty string is used for name in constructor '" + elementFullName + "'!", null);
                }
                if (parentParameterValue != null && (!(parentParameterValue instanceof RfHidImplicit) || !NULL_STRING.equals(((RfHidImplicit)parentParameterValue).getName()))) continue;
                Check_5_4_5.this.addHit(this.parserPath, occurrenceLine, "'null' is used for parent in constructor '" + elementFullName + "'!", null);
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        private boolean isTLMPortClass(RfClass classElement) {
            currentClass = classElement;
            if (!this.childrenOfClasses.contains(currentClass)) ** GOTO lbl9
            return true;
lbl-1000:
            // 1 sources

            {
                if (Check_5_4_5.this.classNames.contains(currentClass.getName())) {
                    this.childrenOfClasses.add(classElement);
                    return true;
                }
                currentClass = currentClass.getParent();
lbl9:
                // 2 sources

                ** while (currentClass != null)
            }
lbl10:
            // 1 sources

            return false;
        }
    }
}

