/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.regex.Pattern;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;

@CheckVersion(value="3.1")
@CheckID(value="XVM.7.1")
@CheckName(value="XVM.7.1")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.CLASS, RuleLabel.VERIFICATION, RuleLabel.EXTEND})
@CheckTitle(value="Only the following XVM classes can be extended")
@CheckDescription(value="The following classes are the only XVM classes allowed to be extended.\nAll other XVM classes from xvm_pkg are not allowed to be used as a base class.\n\nImplementation Notes:\nThis rule verifies only the direct extension, not any parent up the inheritance hierarchy.")
public class Check_7_1
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="xvm_object, xvm_component, xvm_env, xvm_agent, xvm_monitor, xvm_driver, xvm_sequencer, xvm_sequence, xvm_sequence_item, xvm_scoreboard, xvm_test", description="Comma separated list of class names, for example xvm_object, xvm_table_printer.", name="allowedClassNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pAllowedClassNameValues;
    @CheckParameter(defaultValue="", description="Comma separated list of class name patterns, for example \"xvm_seq.*\".", name="allowedClassPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    protected HashSet<Pattern> pAllowedClassPatternValues;

    public Check_7_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        String libPackageName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg");
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            this.checkAllowedClasses((RfClass)clazz, libPackageName);
        }
    }

    private void checkAllowedClasses(RfClass clazz, String libPackageName) {
        RfClass parent = clazz.getParent();
        if (parent == null) {
            return;
        }
        String parentName = parent.getName();
        if (this.pAllowedClassNameValues.contains(parentName)) {
            return;
        }
        for (Pattern pattern : this.pAllowedClassPatternValues) {
            if (pattern == null || !pattern.matcher(parentName).matches()) continue;
            return;
        }
        if (!this.isOVMPkgClass(parent, libPackageName)) {
            return;
        }
        this.addHit(clazz, "'" + clazz.getName() + "' extends '" + parentName + "' that is not allowed as a base class");
    }

    private boolean isOVMPkgClass(RfClass classs, String libPackageName) {
        RfNamedElement scope = classs.getEnclosingScope();
        while (scope != null) {
            if (scope instanceof RfPackage && libPackageName.equals(scope.getName())) {
                return true;
            }
            scope = scope.getEnclosingScope();
        }
        return false;
    }
}

