/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.utils.XVMLintUtils;
import ro.amiq.vlogdt.model.reflection.NamedElementAndString;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionCall;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

@CheckVersion(value="3.1")
@CheckID(value="XVM.7.2")
@CheckName(value="XVM.7.2")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.CLASS_INSTANTIATION, RuleLabel.VERIFICATION})
@CheckTitle(value="Only the following XVM classes can be instantiated")
@CheckDescription(value="The following classes are the only XVM classes allowed to be instantiated.\nAll the other XVM classes from the xvm_pkg are are forbidden for direct user use.\n\nImplementation Notes:\nIf the instantiated class name does not start with ''xvm'' and it cannot be resolved, it is ignored.\n\nCheck supports pre-waiving.")
public class Check_7_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="xvm_analysis_port, xvm_put_port, xvm_get_port, xvm_analysis_export, xvm_put_export, xvm_get_export, xvm_tlm_analysis_fifo, xvm_tlm_fifo, xvm_event", description="Comma separated list of class names, for example xvm_object, xvm_table_printer.", name="allowedClassNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pAllowedClassNamesValues;
    @CheckParameter(defaultValue="", description="Comma separated list of class name patterns, for example: \"xvm_(analysis|put|get)_port , xvm_s.*\".", name="allowedClassPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    protected HashSet<Pattern> pAllowedClassPatternsValues;

    public Check_7_2(OVMProject project, OVMComplianceCategory category) {
        super(project, category);
    }

    @Override
    public void performCheckImpl() {
        String libPackageName = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg");
        String libPrefix = this.fOVMProject.getLibraryKind() == 2 ? "uvm" : "ovm";
        for (RfFunctionCall createCall : this.fOVMProject.getAllCreateCalls()) {
            RfNamedElement createdType;
            if (this.checkPreWaivers(createCall.getFile())) continue;
            String createdTypeString = XVMLintUtils.getCreatedTypeSubString(createCall);
            if (createdTypeString == null) {
                this.addHit(createCall, "Error parsing create call: '" + createCall + "'");
                continue;
            }
            this.notifyCheckAlive();
            RfNamedElement createdElem = createCall.getLeftValue();
            if (createdElem == null || !(createdElem instanceof RfField) || createdElem.getEnclosingScope() == null) continue;
            RfNamedElement createCallEnclosingScope = createCall.getEnclosingScope(RfClass.class);
            if (createCallEnclosingScope instanceof RfClass) {
                createCallEnclosingScope = ((RfClass)createCallEnclosingScope).getDefaultSpecialization(null);
            }
            if ((createdType = LintUtils.getAssociatedFinalType((RfAssociatedType)createdElem, RfTypesResolver.create((IRfScopeElement)createCallEnclosingScope, createdElem.getEnclosingScope().getRfProject(), 0))) == null || createdType instanceof RfAssociatedType.RfUnresolvedTypeInfo) {
                if (!createdTypeString.startsWith(libPrefix)) continue;
                this.addHit(createCall, "Unknown type was created: '" + createdTypeString + "'");
                continue;
            }
            if (!(createdType instanceof RfClass)) {
                this.addHit(createCall, "Created type '" + createdType.getFullName() + "' is not a class");
                continue;
            }
            RfClass createdClass = (RfClass)createdType;
            this.checkAllowedClassInstantiation(createCall, createdClass, libPackageName, this.pAllowedClassNamesValues, this.pAllowedClassPatternsValues);
        }
        for (RfFunctionCall newCall : this.fOVMProject.getAllNewCalls()) {
            NamedElementAndString leftValueAndSelect;
            if (this.checkPreWaivers(newCall.getFile()) || newCall.isDynamicArrayNew() || (leftValueAndSelect = newCall.getLeftValueElementAndSelect()) == null) continue;
            this.notifyCheckAlive();
            IRfNamedElement constructedElem = leftValueAndSelect.getNameElement();
            if (constructedElem == null || !(constructedElem instanceof RfField)) continue;
            String select = leftValueAndSelect.getSelect();
            IRfNamedElement constructedType = ((RfField)constructedElem).getAssociatedTypeWithSelect(select, true);
            if (constructedType == null || !(constructedType instanceof RfClass)) {
                String createdTypeString = ((RfField)constructedElem).getAssociatedTypeName();
                if (createdTypeString != null && !createdTypeString.startsWith(libPrefix)) continue;
                this.addHit(newCall, "Unknown type was created for: '" + constructedElem.getName() + "'");
                continue;
            }
            this.checkAllowedClassInstantiation(newCall, (RfClass)constructedType, libPackageName, this.pAllowedClassNamesValues, this.pAllowedClassPatternsValues);
        }
    }

    protected void checkAllowedClassInstantiation(RfFunctionCall instatiation, RfClass classs, String libPackageName, Set<String> allowedClassNamesValues, Set<Pattern> allowedClassPatternValues) {
        String parentName = classs.getName();
        if (allowedClassNamesValues.contains(parentName)) {
            return;
        }
        for (Pattern pattern : allowedClassPatternValues) {
            if (pattern == null || !pattern.matcher(parentName).matches()) continue;
            return;
        }
        if (!this.isOVMPkgClass(classs, libPackageName)) {
            return;
        }
        this.addHit(instatiation, "Forbidden class instantiation: " + classs.getName());
    }

    private boolean isOVMPkgClass(RfClass classs, String libPackageName) {
        RfNamedElement scope = classs.getEnclosingScope();
        while (scope != null) {
            if (scope instanceof RfPackage && libPackageName.equals(scope.getName())) {
                return true;
            }
            scope = scope.getEnclosingScope();
        }
        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

