/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="3.1")
@CheckID(value="XVM.7.3")
@CheckName(value="XVM.7.3")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="Only the following macros can be used")
@CheckDescription(value="XVM comes with a number of macros that are difficult to learn, use, and debug.\n However, the following macros have proven useful and are specifically allowed.\n Allowed:\n`xvm_object_utils\n`xvm_object_param_utils\n`xvm_declare_p_sequencer\n`xvm_component_utils\n`xvm_component_param_utils\n`xvm_fatal\n`xvm_error\n`xvm_warning\n`xvm_info\n\nCheck supports pre-waiving.")
public class Check_7_3
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="xvm_object_utils, xvm_object_param_utils, xvm_declare_p_sequencer, xvm_component_utils, xvm_component_param_utils,xvm_fatal, xvm_error, xvm_warning, xvm_info", description="Comma separated list of specifically allowed macro patterns, for example \"xvm_field_.*\".", name="allowedMacrosPatterns", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_REGEX)
    private HashSet<Pattern> pAllowedMacrosPatternsValue;
    private HashSet<String> relevantMacros = new HashSet();

    public Check_7_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_ALL_MACROS));
        this.relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_ALL_MACROS));
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("all", this.relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        MacroDefVisitor visitor = new MacroDefVisitor();
        RfProject rfProject = this.fOVMProject.getRfProject();
        try {
            rfProject.accept(visitor);
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        for (RfNamedElement eachClass : this.fOVMProject.getAllNonXVMClasses()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(eachClass.getFile())) continue;
            RfClass eachRfClass = (RfClass)eachClass;
            this.checkMacroCalls(eachRfClass.getMacroCallInfo());
            List<RfFunction> functions = eachRfClass.getLocalMembers(RfFunction.class);
            if (functions == null || functions.isEmpty()) continue;
            for (RfFunction function : functions) {
                if (function == null) continue;
                this.checkMacroCalls(function.getMacroCallInfo());
            }
        }
    }

    private void checkMacroCalls(MacroCallInfo macroCallInfo) {
        if (macroCallInfo == null) {
            return;
        }
        List<MacroCallItem> macroItems = macroCallInfo.getItems();
        if (macroItems == null || macroItems.isEmpty()) {
            return;
        }
        for (MacroCallItem item : macroItems) {
            String macroName;
            if (item == null || item.getReparseInfo().getReparseStackSize() > 0 || (macroName = item.getName()) == null || macroName.isEmpty() || !this.relevantMacros.contains(macroName)) continue;
            String string = macroName = macroName.startsWith("`") ? macroName.substring(1) : macroName;
            if (this.isAllowed(macroName)) continue;
            this.addHit(item.getParserPath(), item.getLineNumber(), "Banned macro " + item.getName() + "!", null);
        }
    }

    private boolean isAllowed(String macroName) {
        if (this.pAllowedMacrosPatternsValue == null || this.pAllowedMacrosPatternsValue.isEmpty()) {
            return true;
        }
        for (Pattern pattern : this.pAllowedMacrosPatternsValue) {
            Matcher m;
            if (pattern == null || !(m = pattern.matcher(macroName)).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private class MacroDefVisitor
    implements IRfDefElementVisitor {
        private StringBuilder macroName = new StringBuilder();

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return false;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            if (Check_7_3.this.checkPreWaivers(defElement.getDefFile())) {
                return;
            }
            this.macroName.setLength(0);
            ReparseInfo reparseInfo = defElement.getReparseInfo();
            if (reparseInfo == null || reparseInfo.getReparseStackSize() > 1) {
                return;
            }
            this.macroName.append("`").append(reparseInfo.getLastReparseMacroName());
            if (!Check_7_3.this.relevantMacros.contains(this.macroName.toString())) {
                return;
            }
            this.macroName.setLength(0);
            this.macroName.append(reparseInfo.getLastReparseMacroName());
            if (Check_7_3.this.isAllowed(this.macroName.toString())) {
                return;
            }
            Check_7_3.this.addHit(defElement.getDefFile().getParserPath(), defElement.getStartLine(), "Banned macro `" + this.macroName + "!", null);
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }
    }
}

