/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_XVM_7_3_4;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleParamIssues;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="3.1")
@CheckID(value="XVM.7.3.4")
@CheckName(value="XVM.7.3.4")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.MACRO, RuleLabel.VERIFICATION})
@CheckTitle(value="No semicolon (;) after XVM macros")
@CheckDescription(value="The XVM macros are designed to be self contained and dont need a closing semicolon.In most cases, the semicolon is ignored, but in some cases it causes errors/warnings. Hence using semicolon is discouraged.\nNot allowed example:\n`xvm_object_utils(my_class);\n\nCheck supports auto-correcting.\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
@CheckAutofix(value=Autofix_XVM_7_3_4.class)
public class Check_7_3_4
extends AbstractSVTBSimpleParamIssues {
    public Check_7_3_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(112);
    }

    @Override
    protected String getFailMessage(String name) {
        return "Macro '" + name + "' is followed by a semicolon(;)";
    }

    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        HashMap<ParserPath, List<SVTBIssues>> resultMap = new HashMap<ParserPath, List<SVTBIssues>>();
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(112);
        if (allIssues == null || allIssues.isEmpty()) {
            return resultMap;
        }
        Set<ParserPath> allFilenamesWithIssues = allIssues.keySet();
        for (ParserPath eachFilenameWithIssues : allFilenamesWithIssues) {
            List<SVTBIssues> issues;
            RfFileDef filedef;
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(eachFilenameWithIssues, this) || (filedef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(eachFilenameWithIssues)) == null || (issues = allIssues.get(eachFilenameWithIssues)) == null || issues.isEmpty()) continue;
            this.notifyCheckAlive();
            ArrayList<SVTBIssues> resultList = new ArrayList<SVTBIssues>();
            for (SVTBIssues issue : issues) {
                if (!issue.getInfo().startsWith(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_"))) continue;
                resultList.add(issue);
            }
            resultMap.put(eachFilenameWithIssues, resultList);
        }
        return resultMap;
    }
}

