/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="3.1")
@CheckID(value="XVM.7.4")
@CheckName(value="XVM.7.4")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.MACRO, RuleLabel.METHOD, RuleLabel.UVM_SEQUENCE, RuleLabel.UVM_DO, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use the xvm_do macros")
@CheckDescription(value="The xvm_do (or xvm_do_*) macros make the simple sequence body method sequence unnecessarily complex.\nAdditionally, macros are difficult to debug as macros are expanded prior to any compiler checking. This generates errors that, to most users, don''t make sense.\n\nCheck supports pre-waiving.")
public class Check_7_4
extends OVMComplianceCheck {
    public Check_7_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        HashSet<String> relevantMacros = new HashSet<String>();
        relevantMacros.addAll(Arrays.asList(XVMMacros.OVM_SEQUENCE_BODY_MACROS));
        relevantMacros.addAll(Arrays.asList(XVMMacros.UVM_SEQUENCE_BODY_MACROS));
        aRfProject.lintTrackMacrosByNames("task", relevantMacros);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fSequences.isEmpty()) {
            return;
        }
        String libMacroDoName = "`" + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_do");
        for (RfClass sequence : this.fOVMProject.fSequences.values()) {
            List<MacroCallItem> macroItems;
            RfFunction bodyTask;
            if (this.checkPreWaivers(sequence.getFile()) || this.fOVMProject.isOVMElement(sequence) || (bodyTask = sequence.getLocalTask("body")) == null) continue;
            this.notifyCheckAlive();
            boolean isFailure = false;
            MacroCallInfo macroCallInfo = bodyTask.getMacroCallInfo();
            if (macroCallInfo != null && (macroItems = macroCallInfo.getItemsWithPrefix(libMacroDoName)) != null && !macroItems.isEmpty()) {
                for (MacroCallItem item : macroItems) {
                    this.addHit(item.getParserPath(), item.getLineNumber(), "Macro " + item.getName() + " found in '" + sequence.getName() + "' sequence", item.getReparseInfo());
                    isFailure = true;
                }
            }
            if (isFailure) continue;
            this.addPassedHit(sequence, "No " + libMacroDoName + "* macro used in '" + sequence.getName() + "' sequence.");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

