/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.HashSet;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="18.1.30")
@CheckID(value="XVM.7.5")
@CheckName(value="XVM.7.5")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.REPORTING_MACRO, RuleLabel.FINAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use XVM reporting macros inside final blocks")
@CheckDescription(value="Do not use XVM reporting macros inside final blocks, because they will not appear in the report summary.\n\nCheck supports pre-waiving.")
public class Check_7_5
extends OVMComplianceCheck {
    private HashSet<String> forbiddenReportMacros = new HashSet();

    public Check_7_5(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.forbiddenReportMacros.addAll(XVMMacros.OVM_REPORT_MACROS);
        this.forbiddenReportMacros.addAll(XVMMacros.UVM_REPORT_MACROS);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("all", this.forbiddenReportMacros);
    }

    @Override
    public void performCheckImpl() {
        MacroDefVisitor visitor = new MacroDefVisitor();
        try {
            this.fOVMProject.getRfProject().accept(visitor);
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private class MacroDefVisitor
    implements IRfDefElementVisitor {
        private StringBuilder macroName = new StringBuilder();

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return false;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            this.macroName.setLength(0);
            ReparseInfo reparseInfo = defElement.getReparseInfo();
            if (reparseInfo == null || reparseInfo.getReparseStackSize() > 1) {
                return;
            }
            RfNamedElement namedElement = defElement.getNamedElement();
            if (namedElement == null) {
                return;
            }
            RfFileDef file = namedElement.getFile();
            if (file == null) {
                return;
            }
            Check_7_5.this.notifyCheckAlive();
            if (Check_7_5.this.checkPreWaivers(file)) {
                return;
            }
            RfNamedElement scope = namedElement;
            boolean insideFinalBlock = false;
            while (scope != null) {
                if (scope instanceof RfActionBlock && ((RfActionBlock)scope).isFinal()) {
                    insideFinalBlock = true;
                    break;
                }
                scope = scope.getEnclosingScope();
            }
            if (!insideFinalBlock) {
                return;
            }
            this.macroName.append('`').append(reparseInfo.getLastReparseMacroName());
            if (!Check_7_5.this.forbiddenReportMacros.contains(this.macroName.toString())) {
                return;
            }
            Check_7_5.this.addHit(defElement.getDefFile().getParserPath(), defElement.getStartLine(), "XVM reporting macro '" + this.macroName + "' used in a final block!", null);
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }
    }
}

