/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.MacroCallInfo;
import ro.amiq.vlogdt.parser.MacroCallItem;

@CheckVersion(value="18.1.33")
@CheckID(value="XVM.7.6")
@CheckName(value="XVM.7.6")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.REGISTRATION_MACRO, RuleLabel.COMPONENT, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use XVM field macros in XVM components")
@CheckDescription(value="Do not use XVM field macros in XVM components.")
public class Check_7_6
extends OVMComplianceCheck {
    private HashSet<String> forbiddenReportMacros = new HashSet();

    public Check_7_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.forbiddenReportMacros.addAll(Arrays.asList(XVMMacros.OVM_FIELD_MACROS));
        this.forbiddenReportMacros.addAll(Arrays.asList(XVMMacros.UVM_FIELD_MACROS));
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("class", this.forbiddenReportMacros);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass component : this.fOVMProject.getAllComponents().values()) {
            this.notifyCheckAlive();
            this.checkMacroCalls(component);
        }
    }

    private void checkMacroCalls(RfClass clazz) {
        if (clazz == null) {
            return;
        }
        MacroCallInfo macroCallInfo = clazz.getMacroCallInfo();
        if (macroCallInfo == null) {
            return;
        }
        List<MacroCallItem> macroItems = macroCallInfo.getItems();
        if (macroItems == null || macroItems.isEmpty()) {
            return;
        }
        for (MacroCallItem item : macroItems) {
            String macroName;
            if (item == null || item.getReparseInfo().getReparseStackSize() > 0 || (macroName = item.getName()) == null || macroName.isEmpty() || !this.forbiddenReportMacros.contains(macroName)) continue;
            this.addHit(item.getParserPath(), item.getLineNumber(), "XVM field macro '" + item.getName() + "' is used in component '" + LintUtils.getNamedElementFullName(clazz) + "'!", null);
        }
    }
}

