/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractCheckUndocumentedApiUsages;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.XVMDocumentedAPI;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="20.1.42")
@CheckID(value="XVM.7.7")
@CheckName(value="XVM.7.7")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.DOCUMENTATION, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use undocumented XVM API")
@CheckDescription(value="Do not use undocumented XVM 1.2 API.")
public class Check_7_7
extends AbstractCheckUndocumentedApiUsages {
    private static final String RSP = "rsp";
    private static final String REQ = "req";
    private static final String UVM_PKG = "uvm_pkg";
    private static final String TYPE_ID = "type_id";
    private static final String TYPE_NAME = "type_name";
    private static final String UNDOCUMENTED_XVM_API_FOUND = "Undocumented UVM API found!";
    private static final String UNDOCUMENTED_XVM_ELEMENT_PATTERN = "{0} ''{1}'' is an undocumented UVM element!";
    private static final Set<String> ALLOWED_UNDOCUMENTED_ELEMENTS = new HashSet<String>();
    @CheckParameter(defaultValue="", description="Comma separated list of allowed undocumented fields full names.", name="allowedFields", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pAllowedFields;
    @CheckParameter(defaultValue="", description="Comma separated list of allowed undocumented methods full names.", name="allowedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pAllowedMethods;
    @CheckParameter(defaultValue="", description="Comma separated list of allowed undocumented classes full names.", name="allowedClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pAllowedClasses;
    @CheckParameter(defaultValue="", description="Comma separated list of allowed undocumented typedefs full names.", name="allowedTypedefs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pAllowedTypedefs;
    @CheckParameter(defaultValue="", description="Comma separated list of allowed undocumented macros names.", name="allowedMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected HashSet<String> pAllowedMacros;

    static {
        ALLOWED_UNDOCUMENTED_ELEMENTS.add(REQ);
        ALLOWED_UNDOCUMENTED_ELEMENTS.add(RSP);
        ALLOWED_UNDOCUMENTED_ELEMENTS.add(TYPE_ID);
        ALLOWED_UNDOCUMENTED_ELEMENTS.add(TYPE_NAME);
    }

    public Check_7_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected String getMessage(IRfNamedElement element) {
        if (!(element instanceof RfNamedElement)) {
            return UNDOCUMENTED_XVM_API_FOUND;
        }
        return MessageFormat.format(UNDOCUMENTED_XVM_ELEMENT_PATTERN, DVTStringUtil.capitalizeFirstLetter((String)LintUtils.getElementKind((RfNamedElement)element)), LintUtils.getNamedElementFullName((RfNamedElement)element));
    }

    @Override
    protected boolean isBannedCategory(RfNamedElement element) {
        ReparseInfo reparseInfo;
        String macroName;
        if (element == null || !this.fOVMProject.isOVMElement(element) || this.isException(element)) {
            return false;
        }
        String fullName = element.getFullName();
        if (fullName == null) {
            return false;
        }
        if (element instanceof RfField && (this.pAllowedFields.contains(fullName) || this.isDocumentedField(element, fullName))) {
            return false;
        }
        if (element instanceof RfClass && (this.pAllowedClasses.contains(fullName) || XVMDocumentedAPI.isDocumentedClass(fullName))) {
            return false;
        }
        if (element instanceof RfTypeAlias && (this.pAllowedTypedefs.contains(fullName) || XVMDocumentedAPI.isDocumentedType(fullName))) {
            return false;
        }
        if (element instanceof RfFunction && (this.pAllowedMethods.contains(fullName) || this.isDocumentedFunction(element))) {
            return false;
        }
        return element.getDeclaration() == null || element.getDeclaration().getReparseInfo() == null || !this.pAllowedMacros.contains(macroName = (reparseInfo = element.getDeclaration().getReparseInfo()).getLastReparseMacroName()) && !this.isAllowedMacro(macroName);
    }

    @Override
    protected boolean isAllowedMacro(String macroName) {
        return XVMDocumentedAPI.isDocumentedMacro(macroName);
    }

    private boolean isException(IRfNamedElement element) {
        String name = element.getName();
        if (name == null) {
            return false;
        }
        return element instanceof RfPackage && name.equals(UVM_PKG) || ALLOWED_UNDOCUMENTED_ELEMENTS.contains(name);
    }

    private boolean isDocumentedField(RfNamedElement element, String fullName) {
        RfStruct structScope;
        String fieldName;
        RfStruct enumScope;
        String structFullName;
        if (!(element instanceof RfField)) {
            return false;
        }
        RfField field = (RfField)element;
        if (field.isEnumElement() && field.getEnclosingScope() instanceof RfStruct && (this.pAllowedTypedefs.contains(structFullName = this.getStructFullName(enumScope = (RfStruct)field.getEnclosingScope())) || XVMDocumentedAPI.isDocumentedType(structFullName))) {
            return true;
        }
        if (field.getEnclosingScope() instanceof RfStruct && (this.pAllowedFields.contains(fieldName = String.valueOf(this.getStructFullName(structScope = (RfStruct)field.getEnclosingScope())) + "." + element.getName()) || XVMDocumentedAPI.isDocumentedVariable(fieldName))) {
            return true;
        }
        if (XVMDocumentedAPI.isDocumentedVariable(fullName) || XVMDocumentedAPI.isDocumentedConstant(fullName) || XVMDocumentedAPI.isDocumentedPort(fullName)) {
            return true;
        }
        DataType type = field.getDataType();
        if (type == null) {
            return true;
        }
        String typeName = type.toString();
        return this.pAllowedClasses.contains(typeName) || this.pAllowedTypedefs.contains(typeName) || XVMDocumentedAPI.isDocumentedClass(typeName) || XVMDocumentedAPI.isDocumentedType(typeName);
    }

    private boolean isDocumentedFunction(RfNamedElement element) {
        if (!(element instanceof RfFunction)) {
            return false;
        }
        if (XVMDocumentedAPI.isDocumentedMethod(element.getFullName())) {
            return true;
        }
        IRfNamedElement enclosingScope = element.getEnclosingScope(new HashSet<Class>(Arrays.asList(RfClass.class, RfSpecializedClass.class)));
        if (!(enclosingScope instanceof RfClass)) {
            return false;
        }
        RfClass enclosingClass = (RfClass)enclosingScope;
        String initialName = element.getName();
        while (enclosingClass != null) {
            List<RfFunction> members = enclosingClass.getFunctionsWithPrefix(initialName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (members.isEmpty()) {
                members = enclosingClass.getTasksWithPrefix(initialName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (members.isEmpty()) {
                members = enclosingClass.getConstructorsWithPrefix(initialName, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            for (RfNamedElement rfNamedElement : members) {
                if (!this.pAllowedMethods.contains(rfNamedElement.getFullName()) && !XVMDocumentedAPI.isDocumentedMethod(rfNamedElement.getFullName())) continue;
                return true;
            }
            enclosingClass = enclosingClass.getParent();
        }
        return false;
    }

    public String getStructFullName(RfStruct struct) {
        DVTStringBuilder result = new DVTStringBuilder();
        RfNamedElement scope = struct.getEnclosingScope();
        if (scope instanceof RfClass || scope instanceof RfModule || scope instanceof RfInterface || scope instanceof RfProgram || scope instanceof RfGenerateBlock) {
            result.append(scope.getName());
            result.append(".");
            scope = scope.getEnclosingScope();
        }
        if (scope instanceof RfPackage) {
            result.prepend(String.valueOf(scope.getName()) + "::");
        }
        result.append(struct.getAliasName());
        return result.toString();
    }

    @Override
    protected String getBannedMessage(RfField field, RfNamedElement element) {
        return this.getMessage(element);
    }

    @Override
    protected String getInheritBannedMessage(RfClass current) {
        if (this.checkClassParentAlias(current)) {
            return this.getMessage(current.getExtendedType().getType() == null ? current.getFullName() : current.getExtendedType().getType());
        }
        return this.getMessage(current.getParent() == null ? current : current.getParent());
    }

    private String getMessage(String element) {
        return MessageFormat.format(UNDOCUMENTED_XVM_ELEMENT_PATTERN, "Typedef", element);
    }
}

