/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="17.1.24")
@CheckID(value="XVM.9.2.8")
@CheckName(value="XVM.9.2.8")
@CheckLabel(labels={RuleLabel.NAME_SPACE, RuleLabel.PACKAGE, RuleLabel.COMPONENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Each verification component should be defined within a package")
@CheckDescription(value="You can have more than one package, and more than one class within each package. The same class name can be used in more than one package, in which case each occurrence would define a distinct class.\n\nCheck supports pre-waiving.")
public class Check_9_2_8
extends OVMComplianceCheck {
    public Check_9_2_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass component : this.fOVMProject.getAllComponents().values()) {
            this.notifyCheckAlive();
            if (this.checkPreWaivers(component.getFile()) || component.getEnclosingPackage() != null) continue;
            this.addHit(component, "Component '" + LintUtils.getNamedElementFullName(component) + "' is not defined inside a package!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

