/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

@CheckVersion(value="20.1.12")
@CheckID(value="XVM.9.2.9")
@CheckName(value="XVM.9.2.9")
@CheckLabel(labels={RuleLabel.NAME_SPACE, RuleLabel.GLOBAL, RuleLabel.INCLUDE, RuleLabel.VERIFICATION})
@CheckTitle(value="Include xvm_macros.svh only in global scope")
@CheckDescription(value="xvm_macros.svh should be included only in global scope and in files that contain any of the types specified in the <elementKind> parameter\nThis check also flags files that contain any of the specified types that import the XVM package, but do not include the xvm_macros.svh\n\nCheck supports pre-waiving.")
public class Check_9_2_9
extends OVMComplianceCheck {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getenv("DVT_DEBUG_VERISSIMO"));
    @CheckParameter(defaultValue="package, module, interface", description="Comma separated list of package, module, interface. One of these types of elements should be declared in files that include xvm_macros.svh", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKind;

    public Check_9_2_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        VlogPreprocessingInfo preprocessingTable = rfProject.getPreprocessingTable();
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        String lib = OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "");
        String libMacroFileName = String.valueOf(lib) + "_macros.svh";
        HashMap<ParserPath, RfNamedElement> allImports = this.allImports(lib);
        if (topFile == null) {
            return;
        }
        if (DEBUG) {
            DVTLogger.INSTANCE.logDebug("VERISSIMO_DEBUG: All project imports:");
            for (Map.Entry<ParserPath, RfNamedElement> entry : allImports.entrySet()) {
                DVTLogger.INSTANCE.logDebug("VERISSIMO_DEBUG: Importing in file '" + entry.getKey().path + "' and element '" + entry.getValue().getFullName() + "'");
            }
        }
        this.checkFile(topFile, libMacroFileName, allImports);
        this.notifyCheckAlive();
        for (Map.Entry<ParserPath, RfNamedElement> entry : allImports.entrySet()) {
            if (this.checkFileElementContent(entry.getKey())) continue;
            this.addHit(entry.getValue(), "The " + entry.getValue().getName() + " " + entry.getValue().getKindName() + " imports 'uvm_pkg' but the file does not include '" + libMacroFileName + "'!");
        }
    }

    public HashMap<ParserPath, RfNamedElement> allImports(String lib) {
        NullProtectedList<ImportInfo> imports;
        int n;
        RfInstanceHolder[] rfInstanceHolderArray;
        HashMap<ParserPath, RfNamedElement> allImports = new HashMap<ParserPath, RfNamedElement>();
        if (this.pElementKind.contains("module")) {
            RfModule[] allModules = this.fOVMProject.getRfProject().getAllModules();
            rfInstanceHolderArray = allModules;
            n = allModules.length;
            int n2 = 0;
            while (n2 < n) {
                RfModule rfModule = rfInstanceHolderArray[n2];
                imports = rfModule.getAllImportDeclarations();
                for (ImportInfo importInfo : imports) {
                    if (importInfo instanceof ExplicitImportInfo || !importInfo.getPackageName().equals(String.valueOf(lib) + "_pkg")) continue;
                    allImports.put(rfModule.getFile().getParserPath(), rfModule);
                }
                ++n2;
            }
        }
        if (this.pElementKind.contains("package")) {
            List<RfPackage> allPackages = this.fOVMProject.getRfProject().getAllPackages(true);
            for (RfPackage rfPackage : allPackages) {
                NullProtectedList<ImportInfo> imports2 = rfPackage.getAllImportDeclarations();
                for (ImportInfo importInfo : imports2) {
                    if (importInfo instanceof ExplicitImportInfo || !importInfo.getPackageName().equals(String.valueOf(lib) + "_pkg")) continue;
                    allImports.put(rfPackage.getFile().getParserPath(), rfPackage);
                }
            }
        }
        if (this.pElementKind.contains("interface")) {
            RfInterface[] allInterface = this.fOVMProject.getRfProject().getAllInterfaces();
            rfInstanceHolderArray = allInterface;
            n = allInterface.length;
            int n3 = 0;
            while (n3 < n) {
                RfInstanceHolder rfInterface = rfInstanceHolderArray[n3];
                imports = rfInterface.getAllImportDeclarations();
                for (ImportInfo importInfo : imports) {
                    if (importInfo instanceof ExplicitImportInfo || !importInfo.getPackageName().equals(String.valueOf(lib) + "_pkg")) continue;
                    allImports.put(rfInterface.getFile().getParserPath(), rfInterface);
                }
                ++n3;
            }
        }
        return allImports;
    }

    public void checkFile(VlogFileInstance root, String libMacroFileName, HashMap<ParserPath, RfNamedElement> allImports) {
        this.notifyCheckAlive();
        List<VlogFileInstance> files = root.getIncludedInstances();
        if (files != null && !files.isEmpty()) {
            for (VlogFileInstance file : files) {
                String name = LintUtils.getFileShortName(file.getParserPath().path);
                if (!name.equals(libMacroFileName) && this.fOVMProject.isOVMFile(name)) continue;
                this.checkFile(file, libMacroFileName, allImports);
            }
        }
        if (DEBUG) {
            DVTLogger.INSTANCE.logDebug("VERISSIMO_DEBUG: Checking file '" + root.getShortFileName() + "' index '" + root.getIndex() + "'");
        }
        if (root.getParserPath() != null) {
            RfNamedElement namedElement = root.getSemanticScope();
            if (DEBUG) {
                DVTLogger.INSTANCE.logDebug("VERISSIMO_DEBUG: Above file is included in element " + (namedElement == null ? "null" : String.valueOf(LintUtils.getElementKind(namedElement)) + " " + namedElement.getFullName()));
            }
            if (root.getShortFileName().equals(libMacroFileName)) {
                VlogFileInstance includingFileInfo = root.getIncludingFileInfo();
                VlogIncludingScope includingScope = root.getIncludingScope();
                if (!this.fOVMProject.getProjectWaivers().pathIsPrewaived(includingFileInfo.getParserPath(), this) && includingFileInfo != null && includingScope != null) {
                    if (!(namedElement instanceof RfLibrary)) {
                        this.addHit(includingFileInfo.getParserPath(), includingScope.getIncludingLine(), "'" + libMacroFileName + "' is included in " + LintUtils.getElementKind(namedElement) + " '" + LintUtils.getNamedElementFullName(namedElement) + "'!", null);
                    } else if (this.checkFileElementContent(includingFileInfo.getParserPath())) {
                        this.addHit(includingFileInfo.getParserPath(), includingScope.getIncludingLine(), "'" + libMacroFileName + "' is included in global scope in a file that doesn't contain any of the following: " + DVTStringUtil.join((Object[])this.pElementKind.toArray(), (String)", ") + "!", null);
                    } else {
                        if (DEBUG) {
                            DVTLogger.INSTANCE.logDebug("VERISSIMO_DEBUG: Removed import '" + includingFileInfo.getParserPath().path + "'");
                        }
                        allImports.remove(includingFileInfo.getParserPath());
                    }
                }
            }
        }
    }

    public boolean checkFileElementContent(ParserPath parserPath) {
        RfFileDef fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return false;
        }
        Collection<RfDefElement> defElements = fileDef.getChildren();
        if (defElements == null || defElements.isEmpty()) {
            return false;
        }
        for (RfDefElement defElement : defElements) {
            RfNamedElement namedElement = defElement.getNamedElement();
            if (namedElement == null) {
                return false;
            }
            if (DEBUG) {
                DVTLogger.INSTANCE.logDebug("VERISSIMO_DEBUG: Checking element " + namedElement.getFullName() + " in file " + parserPath.path);
            }
            if (!this.pElementKind.contains(namedElement.getKindName())) continue;
            return false;
        }
        return true;
    }
}

