/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_14_1_2;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="17.1.37")
@CheckID(value="OVM.6.2")
@CheckName(value="OVM.6.2")
@CheckTitle(value="Assertion reporting must occur through OVM report macros")
@CheckDescription(value="Assertions must not directly report errors to the console. All error / warning / info messages must be through the `ovm_* report macros. Test pass / fail status parsing depends on the consistent XVM message format.\n\nImplementation notes: `ovm_* report macros must be in the else block of the assertion.")
@CheckParameterOverride(name="errorReportingMacros", defaultValue="`ovm_info, `ovm_warning, `ovm_error, `ovm_fatal")
public class Check_OVM_6_2
extends Check_SVTB_14_1_2 {
    public Check_OVM_6_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("assert_else", this.pUsedErrorReportingMacrosValue);
    }

    @Override
    protected boolean checkAssertionKind(RfAssertExpect tmpAssertion) {
        return !tmpAssertion.isAssert();
    }

    @Override
    protected boolean checkAssertion(RfAssertExpect tmpAssertion) {
        return !this.checkMacroReporting(tmpAssertion);
    }

    @Override
    protected String getFailMessage() {
        return "Assertion reporting is not done through report macros";
    }

    @Override
    protected String getPassMessage() {
        return "No assertions without report macros in else branch found";
    }
}

