/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IReparseElement;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

@CheckVersion(value="21.1.19")
@CheckID(value="R.1000")
@CheckName(value="R.1000")
@CheckLabel(labels={RuleLabel.UVM_IEEE, RuleLabel.VERIFICATION})
@CheckTitle(value="UVM IEEE 1800.2-2020 Standard Compliance")
@CheckDescription(value="This rule flags the UVM API used in the project according to the following possible types of API: removed, deprecated, non-standard, deviation, implementation, contribution.\nRemoved API is no longer available in the UVM IEEE 1800.2-2020 standard and library implementation.\nDeprecated API is marked as deprecated in the UVM IEEE 1800.2-2020 standard and library implementation and can only be used if the deprecated flag(UVM_ENABLE_DEPRECATED_API) is defined.\nThe API that is available in the UVM IEEE 1800.2-2020 library implementation, but not in the standard is considered non-standard.\nDeviation API is available in the UVM IEEE 1800.2-2020 library implementation but deviates from the UVM IEEE 1800.2-2020 standard and it is specified in the library documentation.\nContribution API is available in the UVM IEEE 1800.2-2020 library implementation but are only considered for contribution to the UVM IEEE 1800.2-2020 standard.\nImplementation API is available in the UVM IEEE 1800.2-2020 library implementation but it is not considered for contribution to the UVM IEEE 1800.2-2020 standard.")
public class Check_R_1000
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="macro, typedef, class, method, field", description="Comma separated list of element kinds to check: macro, typedef, class, method, field", name="elementKinds", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pElementKinds;
    @CheckParameter(defaultValue="removed, deprecated, non-standard, deviation, contribution, implementation", description="Comma separated list of problematic UVM IEEE API types: removed, deprecated, non-standard, deviation, contribution, implementation", name="problematicAPITypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pProblematicAPITypes;
    @CheckParameter(defaultValue="macro_parameters, class_parameters, arguments", description="Comma separated list of UVM IEEE parameters and arguments to be checked: macro_parameters, class_parameters, arguments", name="checkParametersAndArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pCheckParametersAndArguments;
    @CheckParameter(defaultValue="", description="Comma separated list of full names of UVM typedefs to be skipped.", name="skipTypedefs", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pSkipTypedefs;
    @CheckParameter(defaultValue="", description="Comma separated list of full names of UVM methods to be skipped.", name="skipMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pSkipMethods;
    @CheckParameter(defaultValue="", description="Comma separated list of full names of UVM public fields to be skipped.", name="skipFields", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pSkipFields;
    @CheckParameter(defaultValue="", description="Comma separated list of full names of UVM macros to be skipped.", name="skipMacros", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pSkipMacros;
    private Map<String, APIDetails> macrosAPI;
    private Map<String, APIDetails> typedefsAPI;
    private Map<String, APIDetails> classesAPI;
    private Map<String, APIDetails> methodsAPI;
    private Map<String, APIDetails> fieldsAPI;
    private Map<APIDetails, List<APIParameterDetails>> macrosParametersAPI;
    private Map<APIDetails, List<APIParameterDetails>> classesParametersAPI;
    private Map<APIDetails, List<APIParameterDetails>> methodsParametersAPI;
    static int QUALIFIED_NAME_OPTIONS = 3;

    public Check_R_1000(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.macrosAPI = new HashMap<String, APIDetails>();
        this.typedefsAPI = new HashMap<String, APIDetails>();
        this.classesAPI = new HashMap<String, APIDetails>();
        this.methodsAPI = new HashMap<String, APIDetails>();
        this.fieldsAPI = new HashMap<String, APIDetails>();
        this.macrosParametersAPI = new HashMap<APIDetails, List<APIParameterDetails>>();
        this.classesParametersAPI = new HashMap<APIDetails, List<APIParameterDetails>>();
        this.methodsParametersAPI = new HashMap<APIDetails, List<APIParameterDetails>>();
        boolean valid = this.collectInfo();
        if (!valid) {
            this.addHit(new ParserPath("none"), 0, "Error during API collecting.", null);
            return;
        }
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor());
        if (!this.pElementKinds.contains("class") && !this.pElementKinds.contains("typedef")) {
            return;
        }
        this.fOVMProject.getRfProject().accept(new NamedElementVisitor());
    }

    private boolean collectInfo() {
        boolean returnedValue;
        block26: {
            returnedValue = true;
            URL file = OVMUtils.class.getResource("/ro/amiq/vlogdt/linter/ruleset/full_api_1800.2-2020-1.1.properties");
            BufferedReader reader = null;
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(file.openStream(), StandardCharsets.UTF_8));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        String[] splits = DVTStringUtil.split((String)" ", (String)line);
                        if (splits == null || splits.length != 8) continue;
                        this.notifyCheckAlive();
                        int type = Integer.parseInt(splits[0]);
                        String fullName = splits[1];
                        boolean isDeprecated = Integer.parseInt(splits[2]) == 1;
                        boolean isContribution = Integer.parseInt(splits[3]) == 1;
                        boolean isImplementation = Integer.parseInt(splits[4]) == 1;
                        boolean isDeviation = Integer.parseInt(splits[5]) == 1;
                        boolean isNonStandard = Integer.parseInt(splits[6]) == 1;
                        int numberOfParameters = Integer.parseInt(splits[7]);
                        APIDetails details = new APIDetails(fullName, isDeprecated, isContribution, isImplementation, isDeviation, isNonStandard, numberOfParameters);
                        switch (type) {
                            case 0: {
                                this.macrosAPI.put(fullName, details);
                                break;
                            }
                            case 1: {
                                this.typedefsAPI.put(fullName, details);
                                break;
                            }
                            case 2: {
                                this.classesAPI.put(fullName, details);
                                break;
                            }
                            case 3: {
                                this.methodsAPI.put(fullName, details);
                                break;
                            }
                            case 4: {
                                this.fieldsAPI.put(fullName, details);
                                break;
                            }
                        }
                        if (numberOfParameters == 0) continue;
                        ArrayList<APIParameterDetails> parameterDetails = new ArrayList<APIParameterDetails>();
                        while (numberOfParameters != 0 && (line = reader.readLine()) != null) {
                            --numberOfParameters;
                            splits = DVTStringUtil.split((String)", ", (String)line);
                            if (splits == null || splits.length != 6) continue;
                            type = Integer.parseInt(splits[0]);
                            fullName = splits[1];
                            int argumentNumber = Integer.parseInt(splits[2]);
                            String argumentName = splits[3];
                            String argumentType = splits[4];
                            boolean hasDefaultValue = Integer.parseInt(splits[5]) == 1;
                            parameterDetails.add(new APIParameterDetails(fullName, argumentNumber, argumentName, argumentType, hasDefaultValue));
                        }
                        switch (type) {
                            case 0: {
                                this.macrosParametersAPI.put(details, parameterDetails);
                                break;
                            }
                            case 2: {
                                this.classesParametersAPI.put(details, parameterDetails);
                                break;
                            }
                            case 3: {
                                this.methodsParametersAPI.put(details, parameterDetails);
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    returnedValue = false;
                    if (reader == null) break block26;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                        returnedValue = false;
                    }
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        returnedValue = false;
                    }
                }
            }
        }
        return returnedValue;
    }

    private IRfNamedElement getArgType(RfField field) {
        IRfNamedElement associatedType;
        IRfNamedElement prevType = associatedType = field.getAssociatedTypeNoLastLevelParams();
        while (associatedType instanceof RfTypeAlias || associatedType instanceof RfStruct) {
            if (associatedType instanceof RfTypeAlias) {
                prevType = associatedType;
                associatedType = ((RfTypeAlias)associatedType).getAssociatedTypeNoLastLevelParams();
            }
            if (!(associatedType instanceof RfStruct)) continue;
            IRfNamedElement structType = ((RfStruct)associatedType).getEnumBaseType();
            if (structType == null) {
                associatedType = prevType;
                break;
            }
            associatedType = structType;
        }
        return associatedType;
    }

    private boolean isUVMElement(RfNamedElement element) {
        if (element == null) {
            return false;
        }
        RfFileDef file = element.getFile();
        if (file == null) {
            return false;
        }
        String fileName = file.getName();
        if (fileName == null) {
            return false;
        }
        return this.isUVMElement(fileName);
    }

    private boolean isUVMElement(String fileName) {
        return this.fOVMProject.isOVMFile(fileName);
    }

    private String getErrorMessage(int APIType, IRfNamedElement elem, String errorType, IRfScopeElement scope, RfHid hid) {
        String elementName = LintUtils.getElementSignature(elem, hid, scope, QUALIFIED_NAME_OPTIONS | 4);
        String errorMessage = "";
        switch (APIType) {
            case 1: {
                errorMessage = "Typedef";
                break;
            }
            case 2: {
                errorMessage = "Class";
                break;
            }
            case 3: {
                elementName = String.valueOf(elementName) + "()";
                errorMessage = "Method";
                break;
            }
            case 4: {
                errorMessage = "Field";
                break;
            }
        }
        errorMessage = String.valueOf(errorMessage) + " " + elementName + " is " + errorType + "!";
        return errorMessage;
    }

    @Override
    public void clean() {
        super.clean();
        if (this.macrosAPI != null) {
            this.macrosAPI.clear();
        }
        if (this.typedefsAPI != null) {
            this.typedefsAPI.clear();
        }
        if (this.classesAPI != null) {
            this.classesAPI.clear();
        }
        if (this.methodsAPI != null) {
            this.methodsAPI.clear();
        }
        if (this.fieldsAPI != null) {
            this.fieldsAPI.clear();
        }
        if (this.macrosParametersAPI != null) {
            this.macrosParametersAPI.clear();
        }
        if (this.classesParametersAPI != null) {
            this.classesParametersAPI.clear();
        }
        if (this.methodsParametersAPI != null) {
            this.methodsParametersAPI.clear();
        }
    }

    private static class APIDetails {
        private String fullName;
        private boolean isDeprecated;
        private boolean isContribution;
        private boolean isImplementation;
        private boolean isDeviation;
        private boolean isNonStandard;
        private int numberOfParameters;

        public APIDetails(String fulName, boolean isDeprecated, boolean isContribution, boolean isImplementation, boolean isDeviation, boolean isNonStandard, int numberOfParameters) {
            this.fullName = fulName;
            this.isDeprecated = isDeprecated;
            this.isContribution = isContribution;
            this.isImplementation = isImplementation;
            this.isDeviation = isDeviation;
            this.isNonStandard = isNonStandard;
            this.numberOfParameters = numberOfParameters;
        }

        public String getFullName() {
            return this.fullName;
        }

        public boolean isDeprecated() {
            return this.isDeprecated;
        }

        public boolean isContribution() {
            return this.isContribution;
        }

        public boolean isImplementation() {
            return this.isImplementation;
        }

        public boolean isDeviation() {
            return this.isDeviation;
        }

        public boolean isNonStandard() {
            return this.isNonStandard;
        }

        public int getNumberOfParameters() {
            return this.numberOfParameters;
        }

        public int hashCode() {
            return this.fullName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof APIDetails)) {
                return false;
            }
            return this.fullName.equals(((APIDetails)obj).getFullName());
        }
    }

    private static class APIParameterDetails {
        private String fullName;
        private int argumentNumber;
        private String argumentName;
        private String argumentType;
        boolean hasDefaultValue;

        public APIParameterDetails(String fullName, int argumentNumber, String argumentName, String argumentType, boolean hasDefaultValue) {
            this.fullName = fullName;
            this.argumentNumber = argumentNumber;
            this.argumentName = argumentName;
            this.argumentType = argumentType;
            this.hasDefaultValue = hasDefaultValue;
        }

        public String getFullName() {
            return this.fullName;
        }

        public int getArgumentNumber() {
            return this.argumentNumber;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentType() {
            return this.argumentType;
        }

        public boolean hasDefaultValue() {
            return this.hasDefaultValue;
        }

        public int hashCode() {
            return (String.valueOf(this.fullName) + " " + this.argumentName).hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof APIParameterDetails)) {
                return false;
            }
            return (String.valueOf(this.fullName) + " " + this.argumentName).equals(String.valueOf(((APIParameterDetails)obj).getFullName()) + " " + ((APIParameterDetails)obj).getArgumentName());
        }
    }

    private final class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath parserPath;
        private IRfScopeElement scope;

        private LocalHidVisitor() {
        }

        public void setHolder(IHidHolder holder) {
            this.scope = ((RfHidHolder)holder).getScope();
        }

        public boolean visit(IHidObject hidObject) {
            ReparseInfo.ReparseElement reparseElem;
            ReparseInfo.ReparseElement[] reparseStack;
            Hid localHid;
            RfHid hid = null;
            if (hidObject instanceof RfHid) {
                hid = (RfHid)hidObject;
            }
            if (hidObject instanceof RfHidAccess && (localHid = ((RfHidAccess)hidObject).getParentHid()) instanceof RfHid) {
                hid = (RfHid)localHid;
            }
            if (hidObject instanceof RfHidOperator) {
                RfHidImplicit hidImplicit;
                IReparseElement reparseElement;
                RfHidImplicit hidImplicit2;
                IReparseElement reparseElement2;
                RfHidOperator operator = (RfHidOperator)hidObject;
                IHidObject lhValue = operator.getLHValue();
                if (lhValue instanceof RfHidImplicit && (reparseElement2 = (hidImplicit2 = (RfHidImplicit)lhValue).getLastReparseElement()) instanceof ReparseInfo.ReparseElement && this.checkReparseInfo((ReparseInfo.ReparseElement)reparseElement2, operator.getOccurrence().getLine())) {
                    return true;
                }
                ListContainer rhValues = operator.getRHValues();
                if (rhValues != null && !rhValues.isEmpty() && rhValues.get(0) instanceof RfHidImplicit && (reparseElement = (hidImplicit = (RfHidImplicit)rhValues.get(0)).getLastReparseElement()) instanceof ReparseInfo.ReparseElement && this.checkReparseInfo((ReparseInfo.ReparseElement)reparseElement, operator.getOccurrence().getLine())) {
                    return true;
                }
                return true;
            }
            if (hid == null) {
                return true;
            }
            Check_R_1000.this.notifyCheckAlive();
            IRfNamedElement element = hid.getElement();
            if (element == null || !(element instanceof RfNamedElement)) {
                return true;
            }
            APIDetails api = null;
            IReparseInfo reparseInfo = hid.getReparseInfo();
            if (reparseInfo != null && reparseInfo instanceof ReparseInfo && (reparseStack = ((ReparseInfo)reparseInfo).getReparseStack()) != null && reparseStack.length != 0 && this.checkReparseInfo(reparseElem = reparseStack[0], hid.getOccurrence().getLine())) {
                return true;
            }
            if (!Check_R_1000.this.isUVMElement((RfNamedElement)element)) {
                IRfNamedElement fieldElement = null;
                if (element instanceof RfField) {
                    fieldElement = ((RfField)element).getAssociatedTypeNoLastLevelParams();
                }
                if (fieldElement == null) {
                    return true;
                }
                if (!Check_R_1000.this.isUVMElement((RfNamedElement)fieldElement)) {
                    return true;
                }
                element = fieldElement;
            }
            if (element instanceof RfClass) {
                if (!Check_R_1000.this.pElementKinds.contains("class")) {
                    return true;
                }
                RfClass clazz = (RfClass)element;
                api = Check_R_1000.this.classesAPI.get(clazz.getQualifiedName(this.scope, null, QUALIFIED_NAME_OPTIONS));
                this.analyzeApi(2, api, hid, element, this.scope);
                return true;
            }
            if (element instanceof RfFunction) {
                ListContainer accesses;
                if (!Check_R_1000.this.pElementKinds.contains("method")) {
                    return true;
                }
                RfFunction function = (RfFunction)element;
                String functionName = function.getQualifiedName(this.scope, null, QUALIFIED_NAME_OPTIONS);
                if (Check_R_1000.this.pSkipMethods.contains(functionName)) {
                    return true;
                }
                api = Check_R_1000.this.methodsAPI.get(functionName);
                this.analyzeApi(3, api, hid, function, this.scope);
                if (api == null) {
                    return true;
                }
                if (!Check_R_1000.this.pCheckParametersAndArguments.contains("arguments")) {
                    return true;
                }
                List<APIParameterDetails> parametersList = Check_R_1000.this.methodsParametersAPI.get(api);
                if (parametersList == null) {
                    parametersList = new ArrayList<APIParameterDetails>();
                }
                if ((accesses = hid.getAccesses()) == null || accesses.isEmpty()) {
                    return true;
                }
                HidAccess access = (HidAccess)accesses.get(0);
                if (!(access instanceof RfHidAccessArgs)) {
                    return true;
                }
                RfHidAccessArgs accessArgs = (RfHidAccessArgs)access;
                List<? extends IHidObject> argumentValues = accessArgs.getArgumentValues();
                boolean isNamed = false;
                ArrayList<APIParameterDetails> parameterListAPIToRemove = new ArrayList<APIParameterDetails>();
                int argumentNo = -1;
                for (IHidObject iHidObject : argumentValues) {
                    RfHid lhValueHid;
                    IRfNamedElement argumentElement;
                    RfHidOperator argumentOperator;
                    IHidObject lhValue;
                    ++argumentNo;
                    if (!(iHidObject instanceof RfHidOperator) || !((lhValue = (argumentOperator = (RfHidOperator)iHidObject).getLHValue()) instanceof RfHid) || !((argumentElement = (lhValueHid = (RfHid)lhValue).getElement()) instanceof RfField)) continue;
                    RfField argumentField = (RfField)argumentElement;
                    if (MethodCallUtils.isNamedConnected((IHidObject)argumentOperator)) {
                        isNamed = true;
                    }
                    APIParameterDetails parameterAPI = null;
                    if (isNamed) {
                        for (APIParameterDetails parameter : parametersList) {
                            if (!parameter.getArgumentName().equals(lhValueHid.getName())) continue;
                            parameterAPI = parameter;
                            break;
                        }
                    } else if (argumentNo < parametersList.size()) {
                        parameterAPI = parametersList.get(argumentNo);
                    }
                    if (parameterAPI == null) continue;
                    IRfNamedElement assocType = Check_R_1000.this.getArgType(argumentField);
                    String type = assocType.getName();
                    if (assocType instanceof RfField && ((RfField)assocType).isTypeParameter()) {
                        type = "type";
                    }
                    if (!parameterAPI.getArgumentType().equals(type)) {
                        if (assocType instanceof RfClass && !type.equals("type")) {
                            RfClass parameterClass = Check_R_1000.this.fOVMProject.getRfProject().getClass(parameterAPI.getArgumentType(), false);
                            if (parameterClass == null || parameterClass.isChildOfClass((RfClass)assocType)) {
                                Check_R_1000.this.addHit(this.parserPath, hid, "Method '" + LintUtils.getNamedElementFullName(function) + "' argument '" + argumentField.getName() + "' has now the '" + parameterAPI.getArgumentType() + "' type instead of '" + type + "'!");
                            }
                        } else {
                            Check_R_1000.this.addHit(this.parserPath, hid, "Method '" + LintUtils.getNamedElementFullName(function) + "' argument '" + argumentField.getName() + "' has now the '" + parameterAPI.getArgumentType() + "' type instead of '" + type + "'!");
                        }
                    }
                    parameterListAPIToRemove.add(parameterAPI);
                }
                for (APIParameterDetails aPIParameterDetails : parametersList) {
                    if (parameterListAPIToRemove.contains(aPIParameterDetails) || aPIParameterDetails.hasDefaultValue()) continue;
                    Check_R_1000.this.addHit(this.parserPath, hid, "Method '" + LintUtils.getNamedElementFullName(function) + "' requires argument '" + aPIParameterDetails.getArgumentName() + "' of type " + aPIParameterDetails.getArgumentType() + "!");
                }
                return true;
            }
            if (element instanceof RfField) {
                if (!Check_R_1000.this.pElementKinds.contains("field")) {
                    return true;
                }
                RfField field = (RfField)element;
                String fieldName = field.getQualifiedName(this.scope, null, QUALIFIED_NAME_OPTIONS);
                if (Check_R_1000.this.pSkipFields.contains(fieldName)) {
                    return true;
                }
                RfNamedElement fieldScope = field.getEnclosingScope();
                if (fieldScope instanceof RfStruct) {
                    fieldName = field.getFullNameLabel();
                    RfStruct scopeStruct = (RfStruct)fieldScope;
                    if (scopeStruct.isEnum()) {
                        return true;
                    }
                }
                api = Check_R_1000.this.fieldsAPI.get(fieldName);
                this.analyzeApi(4, api, hid, field, this.scope);
                return true;
            }
            return true;
        }

        private boolean checkReparseInfo(ReparseInfo.ReparseElement reparseElem, int line) {
            if (Check_R_1000.this.isUVMElement(LintUtils.getFileShortName(reparseElem.getReparseMacroFile().path))) {
                if (!Check_R_1000.this.pElementKinds.contains("macro")) {
                    return true;
                }
                if (Check_R_1000.this.pSkipMacros.contains(reparseElem.getReparseMacroName())) {
                    return true;
                }
                APIDetails api = Check_R_1000.this.macrosAPI.get(reparseElem.getReparseMacroName());
                this.analyzeMacroApi(api, line, reparseElem.getReparseMacroName());
                if (api == null) {
                    return true;
                }
                if (!Check_R_1000.this.pCheckParametersAndArguments.contains("macro_parameters")) {
                    return true;
                }
                List<APIParameterDetails> parametersList = Check_R_1000.this.macrosParametersAPI.get(api);
                VlogMacroInfo reparseMacroInfo = reparseElem.getTransientReparseMacroInfo();
                if (reparseMacroInfo == null || reparseMacroInfo.getMacroText() == null) {
                    return true;
                }
                String[] macroParameters = reparseMacroInfo.getMacroText().getParameters();
                if (parametersList == null && macroParameters == null) {
                    return true;
                }
                if (macroParameters == null || macroParameters.length == 0) {
                    if (parametersList != null) {
                        for (APIParameterDetails parameter : parametersList) {
                            if (parameter.hasDefaultValue()) continue;
                            Check_R_1000.this.addHit(this.parserPath, line, "Parameter '" + parameter.getArgumentName() + "' is missing for macro '" + reparseElem.getReparseMacroName() + "'!", null);
                        }
                    }
                    return true;
                }
                if (parametersList == null || parametersList.isEmpty()) {
                    String[] stringArray = macroParameters;
                    int n = macroParameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String macroParameter = stringArray[n2];
                        Check_R_1000.this.addHit(this.parserPath, line, "Parameter '" + macroParameter + "' for macro '" + reparseElem.getReparseMacroName() + "' is now removed!", null);
                        ++n2;
                    }
                    return true;
                }
                if (parametersList.size() == macroParameters.length) {
                    return true;
                }
                if (parametersList.size() > macroParameters.length) {
                    int i = macroParameters.length;
                    while (i < parametersList.size()) {
                        APIParameterDetails parameter = parametersList.get(i);
                        if (!parameter.hasDefaultValue()) {
                            Check_R_1000.this.addHit(this.parserPath, line, "Parameter '" + parameter.getArgumentName() + "' is missing for macro '" + reparseElem.getReparseMacroName() + "'!", null);
                        }
                        ++i;
                    }
                } else {
                    int i = parametersList.size();
                    while (i < macroParameters.length) {
                        String macroParameter = macroParameters[i];
                        Check_R_1000.this.addHit(this.parserPath, line, "Parameter '" + macroParameter + "' for macro '" + reparseElem.getReparseMacroName() + "' is now removed!", null);
                        ++i;
                    }
                }
                return true;
            }
            return false;
        }

        private void analyzeApi(int APIType, APIDetails api, RfHid hid, IRfNamedElement element, IRfScopeElement scope) {
            if (api == null) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("removed")) {
                    Check_R_1000.this.addHit(this.parserPath, hid, Check_R_1000.this.getErrorMessage(APIType, element, "removed", scope, hid));
                }
                return;
            }
            if (api.isDeprecated()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("deprecated")) {
                    Check_R_1000.this.addHit(this.parserPath, hid, Check_R_1000.this.getErrorMessage(APIType, element, "deprecated", scope, hid));
                }
                return;
            }
            if (api.isContribution()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("contribution")) {
                    Check_R_1000.this.addHit(this.parserPath, hid, Check_R_1000.this.getErrorMessage(APIType, element, "a potential contribution to the UVM library", scope, hid));
                }
                return;
            }
            if (api.isDeviation()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("deviation")) {
                    Check_R_1000.this.addHit(this.parserPath, hid, Check_R_1000.this.getErrorMessage(APIType, element, "a deviation from the UVM library", scope, hid));
                }
                return;
            }
            if (api.isImplementation()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("implementation")) {
                    Check_R_1000.this.addHit(this.parserPath, hid, Check_R_1000.this.getErrorMessage(APIType, element, "an Accelera implementation to the UVM library", scope, hid));
                }
                return;
            }
            if (api.isNonStandard() && Check_R_1000.this.pProblematicAPITypes.contains("non-standard")) {
                Check_R_1000.this.addHit(this.parserPath, hid, Check_R_1000.this.getErrorMessage(APIType, element, "non-standard", scope, hid));
            }
        }

        private void analyzeMacroApi(APIDetails api, int line, String macroName) {
            if (api == null) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("removed")) {
                    Check_R_1000.this.addHit(this.parserPath, line, "Macro " + macroName + " is removed!", null);
                }
                return;
            }
            if (api.isDeprecated()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("deprecated")) {
                    Check_R_1000.this.addHit(this.parserPath, line, "Macro " + macroName + " is deprecated!", null);
                }
                return;
            }
            if (api.isContribution()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("contribution")) {
                    Check_R_1000.this.addHit(this.parserPath, line, "Macro " + macroName + " is a potential contribution to the UVM library!", null);
                }
                return;
            }
            if (api.isDeviation()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("deviation")) {
                    Check_R_1000.this.addHit(this.parserPath, line, "Macro " + macroName + " is a deviation from the UVM library!", null);
                }
                return;
            }
            if (api.isImplementation()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("implementation")) {
                    Check_R_1000.this.addHit(this.parserPath, line, "Macro " + macroName + " is an Accelera implementation to the UVM library!", null);
                }
                return;
            }
            if (api.isNonStandard() && Check_R_1000.this.pProblematicAPITypes.contains("non-standard")) {
                Check_R_1000.this.addHit(this.parserPath, line, "Macro " + macroName + " is non-standard!", null);
            }
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    private final class NamedElementVisitor
    implements IRfNamedElementVisitor {
        private NamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            IRfNamedElement type;
            Check_R_1000.this.notifyCheckAlive();
            if (namedElement instanceof RfSpecializedClass) {
                RfSpecializedClass specializedClass = (RfSpecializedClass)namedElement;
                this.analyzeSpecialisedClass(namedElement, specializedClass, specializedClass);
            } else if (namedElement instanceof RfClass) {
                RfClass clazz = (RfClass)namedElement;
                RfClass parent = clazz.getParent();
                if (parent instanceof RfSpecializedClass) {
                    this.analyzeSpecialisedClass(namedElement, (RfSpecializedClass)parent, clazz);
                } else {
                    this.checkClass(namedElement, parent, clazz);
                }
            }
            if (namedElement instanceof RfAssociatedType && (type = ((RfAssociatedType)namedElement).getAssociatedType()) instanceof RfTypeAlias) {
                this.analyzeTypedef(namedElement, (RfTypeAlias)type, namedElement.getEnclosingScope());
            }
            if (namedElement instanceof RfField) {
                RfClass assocType = LintUtils.getFieldFinalClassTypeOrNull((RfField)namedElement);
                if (assocType == null) {
                    return true;
                }
                if (assocType instanceof RfSpecializedClass) {
                    this.analyzeSpecialisedClass(namedElement, (RfSpecializedClass)assocType, namedElement.getEnclosingScope());
                } else {
                    this.checkClass(namedElement, assocType, namedElement.getEnclosingScope());
                }
            }
            return true;
        }

        public void analyzeSpecialisedClass(RfNamedElement visitedElement, RfSpecializedClass clazz, IRfNamedElement scope) {
            if (!Check_R_1000.this.isUVMElement(clazz)) {
                return;
            }
            if (!Check_R_1000.this.pElementKinds.contains("class")) {
                return;
            }
            Map<String, IELParamValue> parameterValues = clazz.getLocalElabConstantValues();
            if (parameterValues == null) {
                return;
            }
            for (Map.Entry<String, IELParamValue> entry : parameterValues.entrySet()) {
                IRfNamedElement element = entry.getValue().getNamedElement();
                if (!(element instanceof RfSpecializedClass)) continue;
                this.analyzeSpecialisedClass(visitedElement, (RfSpecializedClass)element, scope);
            }
            this.checkClass(visitedElement, clazz, scope);
        }

        public void checkClass(RfNamedElement visitedElement, RfClass clazz, IRfNamedElement scope) {
            if (!Check_R_1000.this.isUVMElement(clazz)) {
                return;
            }
            if (!Check_R_1000.this.pElementKinds.contains("class")) {
                return;
            }
            APIDetails api = Check_R_1000.this.classesAPI.get(clazz.getQualifiedName((IRfScopeElement)scope, null, QUALIFIED_NAME_OPTIONS));
            this.analyzeApi(2, api, visitedElement, clazz, clazz);
            if (api == null) {
                return;
            }
            if (!Check_R_1000.this.pCheckParametersAndArguments.contains("class_parameters")) {
                return;
            }
            List<APIParameterDetails> parametersListAPI = Check_R_1000.this.classesParametersAPI.get(api);
            Map<String, IELParamValue> classParametersValues = null;
            if (clazz instanceof RfSpecializedClass) {
                classParametersValues = ((RfSpecializedClass)clazz).getLocalElabConstantValues();
            }
            if (classParametersValues == null && (parametersListAPI == null || parametersListAPI.isEmpty())) {
                return;
            }
            if (classParametersValues == null || classParametersValues.isEmpty()) {
                if (parametersListAPI != null) {
                    for (APIParameterDetails parameter : parametersListAPI) {
                        if (parameter.hasDefaultValue()) continue;
                        Check_R_1000.this.addHit(visitedElement, "Class '" + LintUtils.getNamedElementFullName(clazz) + "' requires parameter '" + parameter.getArgumentType() + "' " + parameter.getArgumentName() + "!");
                    }
                }
                return;
            }
            if (parametersListAPI == null || parametersListAPI.isEmpty()) {
                if (classParametersValues != null) {
                    for (Map.Entry<String, IELParamValue> parameterValue : classParametersValues.entrySet()) {
                        if (!(parameterValue.getValue() instanceof ELParamValues.ParamValueType)) continue;
                        Check_R_1000.this.addHit(visitedElement, "Class '" + LintUtils.getNamedElementFullName(clazz) + "' parameter " + parameterValue.getKey() + " is now removed!");
                    }
                }
                return;
            }
            ArrayList<APIParameterDetails> parametersAPIToRemove = new ArrayList<APIParameterDetails>();
            HashMap<String, IELParamValue> classParametersToRemove = new HashMap<String, IELParamValue>();
            block2: for (APIParameterDetails parameterAPI : parametersListAPI) {
                for (Map.Entry<String, IELParamValue> entry : classParametersValues.entrySet()) {
                    if (!(entry.getValue() instanceof ELParamValues.ParamValueType) || !entry.getKey().equals(parameterAPI.getArgumentName())) continue;
                    parametersAPIToRemove.add(parameterAPI);
                    classParametersToRemove.put(entry.getKey(), entry.getValue());
                    continue block2;
                }
            }
            ArrayList<APIParameterDetails> copyParametersListAPI = new ArrayList<APIParameterDetails>();
            for (APIParameterDetails parameterAPI : parametersListAPI) {
                if (parametersAPIToRemove.contains(parameterAPI)) continue;
                copyParametersListAPI.add(parameterAPI);
            }
            HashMap<String, IELParamValue> copyClassParameters = new HashMap<String, IELParamValue>();
            for (Map.Entry<String, IELParamValue> entry : classParametersValues.entrySet()) {
                if (!(entry.getValue() instanceof ELParamValues.ParamValueType) || classParametersToRemove.get(entry.getKey()) != null) continue;
                copyClassParameters.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : copyClassParameters.entrySet()) {
                Check_R_1000.this.addHit(visitedElement, "Class '" + LintUtils.getNamedElementFullName(clazz) + "' parameter " + entry.getKey() + " is now removed!");
            }
            for (APIParameterDetails aPIParameterDetails : copyParametersListAPI) {
                if (aPIParameterDetails.hasDefaultValue()) continue;
                Check_R_1000.this.addHit(visitedElement, "Class '" + LintUtils.getNamedElementFullName(clazz) + "' requires parameter '" + aPIParameterDetails.getArgumentType() + "' " + aPIParameterDetails.getArgumentName() + "!");
            }
        }

        public void analyzeTypedef(RfNamedElement namedElement, RfTypeAlias typeAlias, IRfNamedElement scope) {
            if (!Check_R_1000.this.isUVMElement(typeAlias)) {
                return;
            }
            if (!Check_R_1000.this.pElementKinds.contains("typedef")) {
                return;
            }
            if (typeAlias.getName().equals("type_id")) {
                return;
            }
            if (Check_R_1000.this.pSkipTypedefs.contains(typeAlias.getQualifiedName((IRfScopeElement)scope, null, QUALIFIED_NAME_OPTIONS))) {
                return;
            }
            APIDetails api = Check_R_1000.this.typedefsAPI.get(typeAlias.getQualifiedName((IRfScopeElement)scope, null, QUALIFIED_NAME_OPTIONS));
            this.analyzeApi(1, api, namedElement, typeAlias, null);
        }

        public void analyzeApi(int APIType, APIDetails api, RfNamedElement visitedElement, RfNamedElement checkElement, IRfScopeElement scope) {
            if (api == null) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("removed")) {
                    Check_R_1000.this.addHit(visitedElement, Check_R_1000.this.getErrorMessage(APIType, checkElement, "removed", scope, null));
                }
                return;
            }
            if (api.isDeprecated()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("deprecated")) {
                    Check_R_1000.this.addHit(visitedElement, Check_R_1000.this.getErrorMessage(APIType, checkElement, "deprecated", scope, null));
                }
                return;
            }
            if (api.isContribution()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("contribution")) {
                    Check_R_1000.this.addHit(visitedElement, Check_R_1000.this.getErrorMessage(APIType, checkElement, "a potential contribution to the UVM library", scope, null));
                }
                return;
            }
            if (api.isDeviation()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("deviation")) {
                    Check_R_1000.this.addHit(visitedElement, Check_R_1000.this.getErrorMessage(APIType, checkElement, "a deviation from the UVM library", scope, null));
                }
                return;
            }
            if (api.isImplementation()) {
                if (Check_R_1000.this.pProblematicAPITypes.contains("implementation")) {
                    Check_R_1000.this.addHit(visitedElement, Check_R_1000.this.getErrorMessage(APIType, checkElement, "an Accelera implementation to the UVM library", scope, null));
                }
                return;
            }
            if (api.isNonStandard() && Check_R_1000.this.pProblematicAPITypes.contains("non-standard")) {
                Check_R_1000.this.addHit(visitedElement, Check_R_1000.this.getErrorMessage(APIType, checkElement, "non-standard", scope, null));
            }
        }
    }
}

