/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_14_1_2;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="17.1.37")
@CheckID(value="UVM.6.2")
@CheckName(value="UVM.6.2")
@CheckLabel(labels={RuleLabel.CHECKING, RuleLabel.REPORTING_MACRO, RuleLabel.ASSERTION, RuleLabel.VERIFICATION})
@CheckTitle(value="Assertion reporting must occur through UVM report macros")
@CheckDescription(value="Assertions must not directly report errors to the console. All error / warning / info messages must be through the `uvm_* report macros. Test pass / fail status parsing depends on the consistent UVM message format.\n\nImplementation notes: `uvm_* report macros must be in the else block of the assertion.\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="errorReportingMacros", defaultValue="`uvm_info, `uvm_info_context, `uvm_warning, `uvm_warning_context, `uvm_error, `uvm_error_context, `uvm_fatal, `uvm_fatal_context")
public class Check_UVM_6_2
extends Check_SVTB_14_1_2 {
    public Check_UVM_6_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackMacrosByNames("assert_else", this.pUsedErrorReportingMacrosValue);
    }

    @Override
    protected boolean checkAssertionKind(RfAssertExpect tmpAssertion) {
        return !tmpAssertion.isAssert();
    }

    @Override
    protected boolean checkAssertion(RfAssertExpect tmpAssertion) {
        return !this.checkMacroReporting(tmpAssertion);
    }

    @Override
    protected String getFailMessage() {
        return "Assertion reporting is not done through report macros";
    }

    @Override
    protected String getPassMessage() {
        return "No assertions without report macros in else branch found";
    }
}

