/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

class FormatStringVisitor
implements IHidVisitor<IHidObject> {
    RfNamedElement scope;
    private Map<RfHidOperator, RfField> declaratedFields;
    private Map<ParserPath, List<RfHidOperator>> allCreateCalls = new HashMap<ParserPath, List<RfHidOperator>>();
    private Map<ParserPath, Set<RfField>> allVariableUsedInCreateCalls;
    OVMProject proj;
    ParserPath parserPath;
    OVMComplianceCheck check;

    public FormatStringVisitor(OVMProject fOVMProject, OVMComplianceCheck check) {
        this.declaratedFields = new HashMap<RfHidOperator, RfField>();
        this.allVariableUsedInCreateCalls = new HashMap<ParserPath, Set<RfField>>();
        this.proj = fOVMProject;
        this.check = check;
    }

    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public void setHolder(IHidHolder holder) {
        this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
    }

    public Map<ParserPath, List<RfHidOperator>> getAllCreateCalls() {
        return this.allCreateCalls;
    }

    public Map<ParserPath, Set<RfField>> getAllVariableUsedInCreateCalls() {
        return this.allVariableUsedInCreateCalls;
    }

    public Map<RfHidOperator, RfField> getDeclaratedFields() {
        return this.declaratedFields;
    }

    public boolean visit(IHidObject hidObject) {
        RfFileDef file = this.scope.getFile();
        if (file == null) {
            return true;
        }
        if (this.proj.getProjectWaivers().pathIsPrewaived(this.parserPath, this.check)) {
            return true;
        }
        if (this.scope.isPredefined()) {
            return true;
        }
        if (this.proj.isOVMFile(file.getName())) {
            return true;
        }
        RfNamedElement container = this.scope.getClosestTypeContainer();
        if (this.proj.isOVMElement(container)) {
            return true;
        }
        switch (hidObject.getHidKind()) {
            case OPERATOR: {
                ListContainer rhValues;
                RfField element;
                RfHidOperator operator = (RfHidOperator)hidObject;
                if (operator.getLHValue() instanceof RfHidImplicit && (element = this.scope.getLocalMember(RfField.class, ((RfHidImplicit)operator.getLHValue()).getName(), true)) != null) {
                    this.declaratedFields.put(operator, element);
                }
                if ((rhValues = operator.getRHValues()) == null || rhValues.isEmpty()) {
                    return true;
                }
                IHidObject rightHid = (IHidObject)rhValues.get(0);
                if (rightHid instanceof RfHid) {
                    IRfNamedElement element2 = ((RfHid)rightHid).getElement();
                    if (!(element2 instanceof RfFunction)) {
                        return true;
                    }
                    MethodCall methodCall = MethodCallUtils.getMethodCall((IHidObject)rightHid, (IRfNamedElement)element2, null, null, (boolean)false, null);
                    if (methodCall == null || methodCall.method == null) {
                        return true;
                    }
                    if (!methodCall.method.getName().equals("new") && !methodCall.method.getName().equals("create")) {
                        return true;
                    }
                    if (this.allCreateCalls.containsKey(this.parserPath)) {
                        this.allCreateCalls.get(this.parserPath).add(operator);
                    } else {
                        this.allCreateCalls.put(this.parserPath, new ArrayList());
                        this.allCreateCalls.get(this.parserPath).add(operator);
                    }
                    return true;
                }
                if (!(rightHid instanceof RfHidAccessArgs)) {
                    return true;
                }
                MethodCall methodCall = ((RfHidAccessArgs)rightHid).getMethodCall();
                if (methodCall == null || methodCall.method == null) {
                    return true;
                }
                switch (methodCall.method.getName()) {
                    case "create": {
                        if (this.allCreateCalls.containsKey(this.parserPath)) {
                            this.allCreateCalls.get(this.parserPath).add(operator);
                            break;
                        }
                        this.allCreateCalls.put(this.parserPath, new ArrayList());
                        this.allCreateCalls.get(this.parserPath).add(operator);
                        break;
                    }
                    case "new": {
                        if (this.allCreateCalls.containsKey(this.parserPath)) {
                            this.allCreateCalls.get(this.parserPath).add(operator);
                            break;
                        }
                        this.allCreateCalls.put(this.parserPath, new ArrayList());
                        this.allCreateCalls.get(this.parserPath).add(operator);
                        break;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public Class<IHidObject> getType() {
        return IHidObject.class;
    }
}

