/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.guidelines;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

class FoundModification
implements IHidVisitor<IHidObject> {
    RfNamedElement scope;
    RfHidOperator assignModification;
    MethodCall sformatModification;
    RfField argument;
    HidOperatorOccurrence createCallOccurrence;

    public FoundModification(RfField argument, HidOperatorOccurrence createCallOccurrence) {
        this.argument = argument;
        this.createCallOccurrence = createCallOccurrence;
        this.assignModification = null;
    }

    public void setHolder(IHidHolder holder) {
        this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
    }

    public boolean visit(IHidObject hidObject) {
        switch (hidObject.getHidKind()) {
            case OPERATOR: {
                RfHidOperator operator = (RfHidOperator)hidObject;
                if (!operator.isAssignment()) {
                    return true;
                }
                if (operator.getOccurrence().getOffset() > this.createCallOccurrence.getOffset()) {
                    return true;
                }
                IHidObject lhValue = operator.getLHValue();
                if (lhValue instanceof RfHidImplicit) {
                    lhValue = (IHidObject)this.scope.getLocalMember(RfField.class, ((RfHidImplicit)operator.getLHValue()).getName(), true);
                    if (lhValue == null) {
                        return true;
                    }
                    if (!lhValue.equals(this.argument)) {
                        return true;
                    }
                } else if (lhValue instanceof RfHid) {
                    if (((RfHid)lhValue).getElement() == null || !((RfHid)lhValue).getElement().equals(this.argument)) {
                        return true;
                    }
                } else {
                    return true;
                }
                if (this.assignModification == null) {
                    this.assignModification = operator;
                    break;
                }
                if (this.assignModification == null || this.assignModification.getOccurrence().getOffset() >= operator.getOccurrence().getOffset()) break;
                this.assignModification = operator;
                break;
            }
            case HID: {
                RfHid hid = (RfHid)hidObject;
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                if (!"$sformat".equals(element.getName())) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    Iterator iterator;
                    Map.Entry outputVariable;
                    if (methodCall.occurrence.getOffset() > this.createCallOccurrence.getOffset() || !((outputVariable = (iterator = methodCall.argumentValuesMapRaw.entrySet().iterator()).next()).getValue() instanceof RfHid) || !((RfHid)((Object)outputVariable.getValue())).getElement().equals(this.argument)) continue;
                    if (this.sformatModification == null) {
                        this.sformatModification = methodCall;
                        continue;
                    }
                    if (this.sformatModification.occurrence.getOffset() >= methodCall.occurrence.getOffset()) continue;
                    this.sformatModification = methodCall;
                }
                break;
            }
        }
        return true;
    }

    public Class<IHidObject> getType() {
        return IHidObject.class;
    }

    public RfHidOperator getAssignModification() {
        return this.assignModification;
    }

    public MethodCall getSformatModification() {
        return this.sformatModification;
    }
}

