/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.linter.launch.AbstractLintLaunchShortcut;
import ro.amiq.dvt.linter.ruleset.DVTRulesetKind;
import ro.amiq.dvt.startup.DVTProjectImporter;
import ro.amiq.vlogdt.linter.launch.AbstractVlogLintLaunchShortcut;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.utils.OVMUtils;

public class BuildContributorDummyLaunchShortcut
extends AbstractVlogLintLaunchShortcut {
    private final IProject project;
    private String options;

    public BuildContributorDummyLaunchShortcut(IProject project, String options) {
        this.project = project;
        this.options = options;
    }

    public void launch() {
        this.launch(this.project, (IResource)this.project, "ro.amiq.dvt.linter.launch.mode");
    }

    protected DVTRulesetKind getRulesetKind() {
        String lib = System.getenv("DVT_LINTER_LIB");
        if (!"ovm".equals(lib)) {
            lib = "uvm";
        }
        if (System.getenv("DVT_LINTER_BASIC") != null && System.getenv("DVT_LINTER_BASIC").equalsIgnoreCase("true")) {
            this.options = String.valueOf(this.options) + ",ruleset_kind=basic";
            return RulesetKind.getBasicRulesetFor(lib);
        }
        if (System.getenv("DVT_LINTER_COMPLIANCE") != null && System.getenv("DVT_LINTER_COMPLIANCE").equalsIgnoreCase("true")) {
            this.options = String.valueOf(this.options) + ",ruleset_kind=compliance";
            return RulesetKind.getComplianceRulesetFor(lib);
        }
        if (System.getenv("DVT_LINTER_RTL") != null && System.getenv("DVT_LINTER_RTL").equalsIgnoreCase("true")) {
            this.options = String.valueOf(this.options) + ",ruleset_kind=rtl";
            return RulesetKind.getRtlRulesetFor();
        }
        if (System.getenv("DVT_LINTER_DEAD_CODE") != null && System.getenv("DVT_LINTER_DEAD_CODE").equalsIgnoreCase("true")) {
            this.options = String.valueOf(this.options) + ",ruleset_kind=dead_code";
            return RulesetKind.getDeadCodeRulesetFor();
        }
        if (System.getenv("DVT_LINTER_UVM_IEEE") != null && System.getenv("DVT_LINTER_UVM_IEEE").equalsIgnoreCase("true")) {
            this.options = String.valueOf(this.options) + ",ruleset_kind=uvm_ieee";
            return RulesetKind.getUVMIEEERulesetFor();
        }
        if (System.getenv("DVT_LINTER_PERFORMANCE") != null && System.getenv("DVT_LINTER_PERFORMANCE").equalsIgnoreCase("true")) {
            this.options = String.valueOf(this.options) + ",ruleset_kind=performance";
            return RulesetKind.getPerformanceRulesetFor();
        }
        if (System.getenv("DVT_LINTER_NON_STANDARD") != null && System.getenv("DVT_LINTER_NON_STANDARD").equalsIgnoreCase("true")) {
            this.options = String.valueOf(this.options) + ",ruleset_kind=non_standard";
            return RulesetKind.getNonStandardRulesetFor();
        }
        if (System.getenv("DVT_LINTER_CUSTOM_RULESET") != null && System.getenv("DVT_LINTER_CUSTOM_RULESET").equalsIgnoreCase("true")) {
            this.options = String.valueOf(this.options) + ",ruleset_kind=custom";
            return RulesetKind.getCustom();
        }
        return RulesetKind.getFullRulesetFor(lib);
    }

    @Override
    protected AbstractLintLaunchShortcut.LaunchOptions getLaunchOptions(IProject project, IResource resource) throws CoreException {
        String baselineReportLocation;
        String includeHTMLCode;
        String openReportValue;
        AbstractLintLaunchShortcut.LaunchOptions result = super.getLaunchOptions(project, resource);
        String libraryKind = this.options.contains("library_kind=ovm") ? "ovm" : "uvm";
        if (this.options.contains("ruleset_kind=custom")) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", RulesetKind.getCustom().toString());
            String rulesetValue = this.getOptionValue("ruleset=");
            if (rulesetValue != null) {
                result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-file", rulesetValue);
            } else {
                result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-file", OVMUtils.getPathToPropertyFile(project, "verissimo", "ruleset.xml").getAbsolutePath());
            }
        } else if (this.options.contains("ruleset_kind=all")) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", RulesetKind.getFullRulesetFor(libraryKind).toString());
        } else if (this.options.contains("ruleset_kind=compliance")) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", RulesetKind.getComplianceRulesetFor(libraryKind).toString());
        } else if (this.options.contains("ruleset_kind=rtl")) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", RulesetKind.getRtlRulesetFor().toString());
        } else if (this.options.contains("ruleset_kind=dead_code")) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", RulesetKind.getDeadCodeRulesetFor().toString());
        } else if (this.options.contains("ruleset_kind=uvm_ieee")) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", RulesetKind.getUVMIEEERulesetFor().toString());
        } else if (this.options.contains("ruleset_kind=performance")) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", RulesetKind.getPerformanceRulesetFor().toString());
        } else if (this.options.contains("ruleset_kind=non_standard")) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", RulesetKind.getNonStandardRulesetFor().toString());
        } else {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", RulesetKind.getBasicRulesetFor(libraryKind).toString());
        }
        String waiversValue = this.getOptionValue("waivers=");
        if (waiversValue != null) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.waivers-file", waiversValue);
        }
        if ((openReportValue = this.getOptionValue("open_report=")) != null) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.project", project.getName());
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", "Import from HTML report");
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.first-edit", true);
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.html-import-location", openReportValue);
        }
        if ((includeHTMLCode = this.getOptionValue("include_html_code=")) != null && includeHTMLCode.equalsIgnoreCase("true")) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.include-code-html-report", true);
        }
        if ((baselineReportLocation = this.getOptionValue("baseline_report=")) != null && !baselineReportLocation.isEmpty()) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.baseline-report-location", baselineReportLocation);
            String prewaive_unchanged_files = this.getOptionValue("prewaive_unchanged_files=");
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.prewaive-unchanged-files", prewaive_unchanged_files != null && prewaive_unchanged_files.equalsIgnoreCase("true"));
        }
        result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.launched-from-cli", true);
        if (DVTProjectImporter.isLintTestMode()) {
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", DVTProjectImporter.getLintTestRulesetKindName());
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.ruleset-file", OVMUtils.getPathToPropertyFile(project, "test_lint", "ruleset.xml").getAbsolutePath());
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.waivers-file", OVMUtils.getPathToPropertyFile(project, "test_lint", "waivers.xml").getAbsolutePath());
            result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.manual-checks-status-file", OVMUtils.getPathToPropertyFile(project, "test_lint", "manual_checks_status.xml").getAbsolutePath());
            if (DVTProjectImporter.getLintTestImportHTMLReportLocation() != null) {
                result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.html-import-location", DVTProjectImporter.getLintTestImportHTMLReportLocation());
            }
            if (DVTProjectImporter.getLintTestAutoExportHTMLReportLocation() != null) {
                result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.auto-export-html-report", true);
                result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.html-report-location", DVTProjectImporter.getLintTestAutoExportHTMLReportLocation());
            }
            if (DVTProjectImporter.getLintTestBaselineReportLocation() != null) {
                result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.baseline-report-location", DVTProjectImporter.getLintTestBaselineReportLocation());
                result.newLaunchConfig.setAttribute("ro.amiq.dvt.linter.launch.prewaive-unchanged-files", DVTProjectImporter.getLintTestPrewaiveUnchangedFiles());
            }
        }
        return result;
    }

    private String getOptionValue(String option) {
        int index = this.options.indexOf(option);
        if (index == -1) {
            return null;
        }
        index += option.length();
        String value = this.options.substring(index);
        if ((index = value.indexOf(44)) != -1) {
            value = value.substring(0, index);
        }
        return value;
    }
}

