/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.launch;

public enum LintingMode {
    LINT_PROJECT("Lint the project", "Perform a full linting of the specified project."),
    LINT_FILE("Lint the current file", "Perform linting only on the selected file."),
    ALWAYS_ASK("Always ask", "For each linter invocation, specify if you want to lint the project or just a file."),
    DETECT_FROM_SELECTION("Detect from selection", "Determine if the linting is performed on the project or just for a file by the current selection.");

    private final String fName;
    private final String fDescription;

    private LintingMode(String name, String description) {
        this.fName = name;
        this.fDescription = description;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public static LintingMode[] getAllModes() {
        return new LintingMode[]{LINT_PROJECT, LINT_FILE, ALWAYS_ASK, DETECT_FROM_SELECTION};
    }

    public static LintingMode from(String name) {
        if (name == null) {
            return null;
        }
        LintingMode[] lintingModeArray = LintingMode.getAllModes();
        int n = lintingModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LintingMode mode = lintingModeArray[n2];
            if (mode.getName().equals(name.trim())) {
                return mode;
            }
            ++n2;
        }
        return null;
    }
}

