/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.ResourceSelectionDialog;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.vlogdt.linter.launch.LintingMode;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;

public class MainLintConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static final String WAIVER_DEFAULT_TEXT = "Default waiver file: ";
    private static final String MANUAL_CHECKS_STATUS_DEFAULT_TEXT = "Default manual checks status file: ";
    private static final String HTML_REPORT_DEFAULT_LOCATION = "Default HTML report location: ";
    private static final String BASELINE_REPORT_DEFAULT_LOCATION = "Default baseline report location: ";
    protected Combo fLintingModeCombo;
    protected Text fProjectField;
    protected Button fProjectButton;
    protected Button fEnableOVMButton;
    protected Text fRulesetFileField;
    protected Combo fRulesetKindCombo;
    protected Button fRulesetSystemLocationButton;
    protected Button fRulesetWorkspaceLocationButton;
    protected Button fRulesetVariablesButton;
    protected Label fRulesetFileText;
    protected Text fWaiversFileField;
    protected Button fWaiversSystemLocationButton;
    protected Button fWaiversWorkspaceLocationButton;
    protected Button fWaiversVariablesButton;
    protected Text fManualChecksStatusFileField;
    protected Button fManualChecksStatusSystemLocationButton;
    protected Button fManualChecksStatusWorkspaceLocationButton;
    protected Button fManualChecksStatusVariablesButton;
    protected Text fHTMLReportField;
    protected Button fHTMLReportSystemLocationButton;
    protected Button fHTMLReportWorkspaceLocationButton;
    protected Button fHTMLReportVariablesButton;
    protected Button fEnableIncludeCodeHTMLReportButton;
    protected Button fEnableAutoExportHTMLReportButton;
    protected Button fEnableAutoExportHTMLReportOpenButton;
    protected Text fBaselineReportFileField;
    protected Button fEnablePrewaiveUnchangedFilesButton;
    protected Button fBaselineReportSystemLocationButton;
    protected Button fBaselineReportWorkspaceLocationButton;
    protected Button fBaselineReportVariablesButton;
    protected Text fProcessTimeoutField;
    protected Text fSessionTimeoutField;
    protected Text fCheckTimeoutField;
    protected SelectionAdapter fSelectionAdapter;
    protected boolean fInitializing = false;
    private boolean fUserEdited = false;
    private final ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (!MainLintConfigurationTab.this.fInitializing) {
                MainLintConfigurationTab.this.setDirty(true);
                MainLintConfigurationTab.this.fUserEdited = true;
                if (e.getSource() == MainLintConfigurationTab.this.fRulesetKindCombo) {
                    MainLintConfigurationTab.this.updateRulesetComponent();
                    MainLintConfigurationTab.this.updateWaiversComponent(3);
                    MainLintConfigurationTab.this.updateManualChecksStatusComponent(3);
                    MainLintConfigurationTab.this.updateHTMLReportComponent(3);
                    MainLintConfigurationTab.this.updateBaselineReportComponent(3);
                }
                if (e.getSource() == MainLintConfigurationTab.this.fLintingModeCombo) {
                    MainLintConfigurationTab.this.updateProjectComponent();
                }
                MainLintConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        }
    };
    private final SelectionAdapter fCheckboxSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (!MainLintConfigurationTab.this.fInitializing) {
                MainLintConfigurationTab.this.setDirty(true);
                MainLintConfigurationTab.this.fUserEdited = true;
                MainLintConfigurationTab.this.updateLaunchConfigurationDialog();
                if (e.getSource() == MainLintConfigurationTab.this.fEnableAutoExportHTMLReportButton) {
                    if (!MainLintConfigurationTab.this.fEnableAutoExportHTMLReportButton.getSelection()) {
                        MainLintConfigurationTab.this.fEnableAutoExportHTMLReportOpenButton.setSelection(false);
                        MainLintConfigurationTab.this.fEnableAutoExportHTMLReportOpenButton.setEnabled(false);
                    } else {
                        MainLintConfigurationTab.this.fEnableAutoExportHTMLReportOpenButton.setEnabled(true);
                    }
                }
            }
        }
    };
    private final SelectionAdapter fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MainLintConfigurationTab.this.setDirty(true);
            Object source = e.getSource();
            if (source == MainLintConfigurationTab.this.fProjectButton) {
                MainLintConfigurationTab.this.handleProjectButtonSelected();
            } else if (source == MainLintConfigurationTab.this.fRulesetWorkspaceLocationButton) {
                MainLintConfigurationTab.this.handleWorkspaceLocationButtonSelected(MainLintConfigurationTab.this.fRulesetFileField, 1);
            } else if (source == MainLintConfigurationTab.this.fRulesetSystemLocationButton) {
                MainLintConfigurationTab.this.handleSystemLocationButtonSelected(MainLintConfigurationTab.this.fRulesetFileField, 1);
            } else if (source == MainLintConfigurationTab.this.fRulesetVariablesButton) {
                MainLintConfigurationTab.this.handleVariablesButtonSelected(MainLintConfigurationTab.this.fRulesetFileField);
            } else if (source == MainLintConfigurationTab.this.fWaiversWorkspaceLocationButton) {
                MainLintConfigurationTab.this.handleWorkspaceLocationButtonSelected(MainLintConfigurationTab.this.fWaiversFileField, 1);
            } else if (source == MainLintConfigurationTab.this.fWaiversSystemLocationButton) {
                MainLintConfigurationTab.this.handleSystemLocationButtonSelected(MainLintConfigurationTab.this.fWaiversFileField, 1);
            } else if (source == MainLintConfigurationTab.this.fWaiversVariablesButton) {
                MainLintConfigurationTab.this.handleVariablesButtonSelected(MainLintConfigurationTab.this.fWaiversFileField);
            } else if (source == MainLintConfigurationTab.this.fManualChecksStatusWorkspaceLocationButton) {
                MainLintConfigurationTab.this.handleWorkspaceLocationButtonSelected(MainLintConfigurationTab.this.fManualChecksStatusFileField, 1);
            } else if (source == MainLintConfigurationTab.this.fManualChecksStatusSystemLocationButton) {
                MainLintConfigurationTab.this.handleSystemLocationButtonSelected(MainLintConfigurationTab.this.fManualChecksStatusFileField, 1);
            } else if (source == MainLintConfigurationTab.this.fManualChecksStatusVariablesButton) {
                MainLintConfigurationTab.this.handleVariablesButtonSelected(MainLintConfigurationTab.this.fManualChecksStatusFileField);
            } else if (source == MainLintConfigurationTab.this.fHTMLReportWorkspaceLocationButton) {
                MainLintConfigurationTab.this.handleWorkspaceLocationButtonSelected(MainLintConfigurationTab.this.fHTMLReportField, 2);
            } else if (source == MainLintConfigurationTab.this.fHTMLReportSystemLocationButton) {
                MainLintConfigurationTab.this.handleSystemLocationButtonSelected(MainLintConfigurationTab.this.fHTMLReportField, 2);
            } else if (source == MainLintConfigurationTab.this.fHTMLReportVariablesButton) {
                MainLintConfigurationTab.this.handleVariablesButtonSelected(MainLintConfigurationTab.this.fHTMLReportField);
            } else if (source == MainLintConfigurationTab.this.fBaselineReportWorkspaceLocationButton) {
                MainLintConfigurationTab.this.handleWorkspaceLocationButtonSelected(MainLintConfigurationTab.this.fBaselineReportFileField, 2);
            } else if (source == MainLintConfigurationTab.this.fBaselineReportSystemLocationButton) {
                MainLintConfigurationTab.this.handleSystemLocationButtonSelected(MainLintConfigurationTab.this.fBaselineReportFileField, 2);
            } else if (source == MainLintConfigurationTab.this.fBaselineReportVariablesButton) {
                MainLintConfigurationTab.this.handleVariablesButtonSelected(MainLintConfigurationTab.this.fBaselineReportFileField);
            }
        }
    };
    private final FocusListener fFocusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            if (e.getSource() == MainLintConfigurationTab.this.fWaiversFileField) {
                MainLintConfigurationTab.this.updateWaiversComponent(1);
            } else if (e.getSource() == MainLintConfigurationTab.this.fManualChecksStatusFileField) {
                MainLintConfigurationTab.this.updateManualChecksStatusComponent(1);
            } else if (e.getSource() == MainLintConfigurationTab.this.fHTMLReportField) {
                MainLintConfigurationTab.this.updateHTMLReportComponent(1);
            } else if (e.getSource() == MainLintConfigurationTab.this.fBaselineReportFileField) {
                MainLintConfigurationTab.this.updateBaselineReportComponent(1);
            }
        }

        public void focusLost(FocusEvent e) {
            if (e.getSource() == MainLintConfigurationTab.this.fWaiversFileField) {
                MainLintConfigurationTab.this.updateWaiversComponent(2);
            } else if (e.getSource() == MainLintConfigurationTab.this.fManualChecksStatusFileField) {
                MainLintConfigurationTab.this.updateManualChecksStatusComponent(2);
            } else if (e.getSource() == MainLintConfigurationTab.this.fHTMLReportField) {
                MainLintConfigurationTab.this.updateHTMLReportComponent(2);
            } else if (e.getSource() == MainLintConfigurationTab.this.fBaselineReportFileField) {
                MainLintConfigurationTab.this.updateBaselineReportComponent(2);
            }
        }
    };
    private final VerifyListener fVerifyListener = e -> {
        Text text = (Text)e.getSource();
        String oldValue = text.getText();
        String newValue = String.valueOf(oldValue.substring(0, e.start)) + e.text + oldValue.substring(e.end);
        if (newValue.isEmpty()) {
            return;
        }
        try {
            Integer.parseUnsignedInt(newValue);
        }
        catch (NumberFormatException numberFormatException) {
            e.doit = false;
        }
    };

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        this.createGeneralComponent(mainComposite);
        this.createRulesetComponent(mainComposite);
        this.createWaiversFileComponent(mainComposite);
        this.createManualChecksStatusFileComponent(mainComposite);
        this.createHTMLReportLocationComponent(mainComposite);
        this.createBaselineReportFileComponent(mainComposite);
        this.createTimeoutComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 1);
        Dialog.applyDialogFont((Control)parent);
    }

    protected void createGeneralComponent(Composite parent) {
        LintingMode[] lintingModes;
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        Label lintingModeText = new Label((Composite)group, 16384);
        lintingModeText.setText("Linting mode:");
        gridData = new GridData(4, 0x1000000, false, false);
        lintingModeText.setLayoutData((Object)gridData);
        this.fLintingModeCombo = new Combo((Composite)group, 12);
        LintingMode[] lintingModeArray = lintingModes = LintingMode.getAllModes();
        int n = lintingModes.length;
        int n2 = 0;
        while (n2 < n) {
            LintingMode mode = lintingModeArray[n2];
            this.fLintingModeCombo.add(mode.getName());
            ++n2;
        }
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.fLintingModeCombo.setLayoutData((Object)gridData);
        this.fLintingModeCombo.addModifyListener(this.fModifyListener);
        this.fLintingModeCombo.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fLintingModeCombo, group.getText());
        Label projectText = new Label((Composite)group, 16384);
        projectText.setText("Project:");
        gridData = new GridData(4, 0x1000000, false, false);
        projectText.setLayoutData((Object)gridData);
        this.fProjectField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fProjectField.setLayoutData((Object)data);
        this.fProjectField.addModifyListener(this.fModifyListener);
        this.addControlAccessibleListener((Control)this.fProjectField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        gridData = new GridData(0x1000008, 0x1000000, false, false, 2, 1);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fProjectButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab__Browse_Workspace____3, null);
        this.fProjectButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fProjectButton, String.valueOf(group.getText()) + " " + this.fProjectButton.getText());
    }

    protected void createRulesetComponent(Composite parent) {
        RulesetKind[] rulesetKinds;
        Group group = new Group(parent, 0);
        group.setText("Ruleset");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        Composite rulesetComposite = new Composite((Composite)group, 0);
        rulesetComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        rulesetComposite.setLayout((Layout)layout);
        this.fEnableOVMButton = new Button(rulesetComposite, 32);
        this.fEnableOVMButton.setText("Run XVM rules as OVM");
        this.fEnableOVMButton.addSelectionListener((SelectionListener)this.fCheckboxSelection);
        Label rulesetKindText = new Label((Composite)group, 16384);
        rulesetKindText.setText("Kind:");
        gridData = new GridData(4, 0x1000000, false, false);
        rulesetKindText.setLayoutData((Object)gridData);
        this.fRulesetKindCombo = new Combo((Composite)group, 12);
        RulesetKind[] rulesetKindArray = rulesetKinds = RulesetKind.getForLintConfig();
        int n = rulesetKinds.length;
        int n2 = 0;
        while (n2 < n) {
            RulesetKind kind = rulesetKindArray[n2];
            this.fRulesetKindCombo.add(kind.toString());
            ++n2;
        }
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.fRulesetKindCombo.setLayoutData((Object)gridData);
        this.fRulesetKindCombo.addModifyListener(this.fModifyListener);
        this.fRulesetKindCombo.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fRulesetKindCombo, group.getText());
        this.fRulesetFileText = new Label((Composite)group, 16384);
        this.fRulesetFileText.setText("File:");
        gridData = new GridData(4, 0x1000000, false, false);
        this.fRulesetFileText.setLayoutData((Object)gridData);
        this.fRulesetFileField = new Text((Composite)group, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.fRulesetFileField.setLayoutData((Object)gridData);
        this.fRulesetFileField.addModifyListener(this.fModifyListener);
        this.addControlAccessibleListener((Control)this.fRulesetFileField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        gridData = new GridData(0x1000008, 0x1000000, false, false, 2, 1);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fRulesetWorkspaceLocationButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab__Browse_Workspace____3, null);
        this.fRulesetWorkspaceLocationButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fRulesetWorkspaceLocationButton, String.valueOf(group.getText()) + " " + this.fRulesetWorkspaceLocationButton.getText());
        this.fRulesetSystemLocationButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Brows_e_File_System____4, null);
        this.fRulesetSystemLocationButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fRulesetSystemLocationButton, String.valueOf(group.getText()) + " " + this.fRulesetSystemLocationButton.getText());
        this.fRulesetVariablesButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_32, null);
        this.fRulesetVariablesButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fRulesetVariablesButton, String.valueOf(group.getText()) + " " + this.fRulesetVariablesButton.getText());
    }

    protected void createWaiversFileComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Waivers");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        Label waiversFileText = new Label((Composite)group, 16384);
        waiversFileText.setText("File:");
        gridData = new GridData(4, 0x1000000, false, false);
        waiversFileText.setLayoutData((Object)gridData);
        this.fWaiversFileField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fWaiversFileField.setLayoutData((Object)data);
        this.fWaiversFileField.addModifyListener(this.fModifyListener);
        this.fWaiversFileField.addFocusListener(this.fFocusListener);
        this.addControlAccessibleListener((Control)this.fWaiversFileField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        gridData = new GridData(0x1000008, 0x1000000, false, false, 2, 1);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fWaiversWorkspaceLocationButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_Wor_kspace____6, null);
        this.fWaiversWorkspaceLocationButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fWaiversWorkspaceLocationButton, String.valueOf(group.getText()) + " " + this.fWaiversWorkspaceLocationButton.getText());
        this.fWaiversSystemLocationButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_F_ile_System____7, null);
        this.fWaiversSystemLocationButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fWaiversSystemLocationButton, String.valueOf(group.getText()) + " " + this.fWaiversSystemLocationButton.getText());
        this.fWaiversVariablesButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_32, null);
        this.fWaiversVariablesButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fWaiversVariablesButton, String.valueOf(group.getText()) + " " + this.fWaiversVariablesButton.getText());
    }

    protected void createManualChecksStatusFileComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Manual Checks Status");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        Label manualChecksStatusFileText = new Label((Composite)group, 16384);
        manualChecksStatusFileText.setText("File:");
        gridData = new GridData(4, 0x1000000, false, false);
        manualChecksStatusFileText.setLayoutData((Object)gridData);
        this.fManualChecksStatusFileField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fManualChecksStatusFileField.setLayoutData((Object)data);
        this.fManualChecksStatusFileField.addModifyListener(this.fModifyListener);
        this.fManualChecksStatusFileField.addFocusListener(this.fFocusListener);
        this.addControlAccessibleListener((Control)this.fManualChecksStatusFileField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        gridData = new GridData(0x1000008, 0x1000000, false, false, 2, 1);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fManualChecksStatusWorkspaceLocationButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_Wor_kspace____6, null);
        this.fManualChecksStatusWorkspaceLocationButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fManualChecksStatusWorkspaceLocationButton, String.valueOf(group.getText()) + " " + this.fManualChecksStatusWorkspaceLocationButton.getText());
        this.fManualChecksStatusSystemLocationButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_F_ile_System____7, null);
        this.fManualChecksStatusSystemLocationButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fManualChecksStatusSystemLocationButton, String.valueOf(group.getText()) + " " + this.fManualChecksStatusSystemLocationButton.getText());
        this.fManualChecksStatusVariablesButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_32, null);
        this.fManualChecksStatusVariablesButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fManualChecksStatusVariablesButton, String.valueOf(group.getText()) + " " + this.fManualChecksStatusVariablesButton.getText());
    }

    protected void createHTMLReportLocationComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("HTML Report");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        Composite includeCodeComposite = new Composite((Composite)group, 0);
        includeCodeComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        includeCodeComposite.setLayout((Layout)layout);
        this.fEnableIncludeCodeHTMLReportButton = new Button(includeCodeComposite, 32);
        this.fEnableIncludeCodeHTMLReportButton.setText("Include the source files in the HTML Report");
        this.fEnableIncludeCodeHTMLReportButton.addSelectionListener((SelectionListener)this.fCheckboxSelection);
        Composite openReportComposite = new Composite((Composite)group, 0);
        openReportComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        openReportComposite.setLayout((Layout)layout);
        this.fEnableAutoExportHTMLReportButton = new Button(openReportComposite, 32);
        this.fEnableAutoExportHTMLReportButton.setText("Auto-export HTML Report");
        this.fEnableAutoExportHTMLReportButton.addSelectionListener((SelectionListener)this.fCheckboxSelection);
        this.fEnableAutoExportHTMLReportOpenButton = new Button(openReportComposite, 32);
        this.fEnableAutoExportHTMLReportOpenButton.setText("Open the HTML report after export");
        this.fEnableAutoExportHTMLReportOpenButton.addSelectionListener((SelectionListener)this.fCheckboxSelection);
        this.fEnableAutoExportHTMLReportOpenButton.setEnabled(false);
        Label htmlReportLocationText = new Label((Composite)group, 16384);
        htmlReportLocationText.setText("Folder:");
        gridData = new GridData(4, 0x1000000, false, false);
        htmlReportLocationText.setLayoutData((Object)gridData);
        this.fHTMLReportField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fHTMLReportField.setLayoutData((Object)data);
        this.fHTMLReportField.addModifyListener(this.fModifyListener);
        this.fHTMLReportField.addFocusListener(this.fFocusListener);
        this.addControlAccessibleListener((Control)this.fHTMLReportField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        gridData = new GridData(0x1000008, 0x1000000, false, false, 2, 1);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fHTMLReportWorkspaceLocationButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_Wor_kspace____6, null);
        this.fHTMLReportWorkspaceLocationButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fHTMLReportWorkspaceLocationButton, String.valueOf(group.getText()) + " " + this.fHTMLReportWorkspaceLocationButton.getText());
        this.fHTMLReportSystemLocationButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_F_ile_System____7, null);
        this.fHTMLReportSystemLocationButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fHTMLReportSystemLocationButton, String.valueOf(group.getText()) + " " + this.fHTMLReportSystemLocationButton.getText());
        this.fHTMLReportVariablesButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_32, null);
        this.fHTMLReportVariablesButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fHTMLReportVariablesButton, String.valueOf(group.getText()) + " " + this.fHTMLReportVariablesButton.getText());
    }

    protected void createBaselineReportFileComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Baseline report");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        Composite baselineReportComposite = new Composite((Composite)group, 0);
        baselineReportComposite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        baselineReportComposite.setLayout((Layout)layout);
        this.fEnablePrewaiveUnchangedFilesButton = new Button(baselineReportComposite, 32);
        this.fEnablePrewaiveUnchangedFilesButton.setText("Prewaive unchanged files");
        this.fEnablePrewaiveUnchangedFilesButton.addSelectionListener((SelectionListener)this.fCheckboxSelection);
        Label baselineReportFileText = new Label((Composite)group, 16384);
        baselineReportFileText.setText("Report:");
        gridData = new GridData(4, 0x1000000, false, false);
        baselineReportFileText.setLayoutData((Object)gridData);
        this.fBaselineReportFileField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fBaselineReportFileField.setLayoutData((Object)data);
        this.fBaselineReportFileField.addModifyListener(this.fModifyListener);
        this.fBaselineReportFileField.addFocusListener(this.fFocusListener);
        this.addControlAccessibleListener((Control)this.fBaselineReportFileField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        gridData = new GridData(0x1000008, 0x1000000, false, false, 2, 1);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fBaselineReportWorkspaceLocationButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_Wor_kspace____6, null);
        this.fBaselineReportWorkspaceLocationButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fBaselineReportWorkspaceLocationButton, String.valueOf(group.getText()) + " " + this.fBaselineReportWorkspaceLocationButton.getText());
        this.fBaselineReportSystemLocationButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_F_ile_System____7, null);
        this.fBaselineReportSystemLocationButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fBaselineReportSystemLocationButton, String.valueOf(group.getText()) + " " + this.fBaselineReportSystemLocationButton.getText());
        this.fBaselineReportVariablesButton = this.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_32, null);
        this.fBaselineReportVariablesButton.addSelectionListener((SelectionListener)this.fSelectionListener);
        this.addControlAccessibleListener((Control)this.fBaselineReportVariablesButton, String.valueOf(group.getText()) + " " + this.fBaselineReportVariablesButton.getText());
    }

    protected void createTimeoutComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Timeout:");
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        Label processTimeoutText = new Label((Composite)group, 16384);
        processTimeoutText.setText("Process timeout(in seconds):");
        gridData = new GridData(4, 0x1000000, false, false);
        processTimeoutText.setLayoutData((Object)gridData);
        this.fProcessTimeoutField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fProcessTimeoutField.setLayoutData((Object)data);
        this.fProcessTimeoutField.addModifyListener(this.fModifyListener);
        this.fProcessTimeoutField.addVerifyListener(this.fVerifyListener);
        this.addControlAccessibleListener((Control)this.fProcessTimeoutField, group.getText());
        Label sessionTimeoutText = new Label((Composite)group, 16384);
        sessionTimeoutText.setText("Session timeout(in seconds):");
        gridData = new GridData(4, 0x1000000, false, false);
        sessionTimeoutText.setLayoutData((Object)gridData);
        this.fSessionTimeoutField = new Text((Composite)group, 2048);
        data = new GridData(768);
        data.widthHint = 200;
        this.fSessionTimeoutField.setLayoutData((Object)data);
        this.fSessionTimeoutField.addModifyListener(this.fModifyListener);
        this.fSessionTimeoutField.addVerifyListener(this.fVerifyListener);
        this.addControlAccessibleListener((Control)this.fSessionTimeoutField, group.getText());
        Label checkTimeoutText = new Label((Composite)group, 16384);
        checkTimeoutText.setText("Check timeout(in seconds):");
        gridData = new GridData(4, 0x1000000, false, false);
        checkTimeoutText.setLayoutData((Object)gridData);
        this.fCheckTimeoutField = new Text((Composite)group, 2048);
        data = new GridData(768);
        data.widthHint = 200;
        this.fCheckTimeoutField.setLayoutData((Object)data);
        this.fCheckTimeoutField.addModifyListener(this.fModifyListener);
        this.fCheckTimeoutField.addVerifyListener(this.fVerifyListener);
        this.addControlAccessibleListener((Control)this.fCheckTimeoutField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
    }

    private void updateRulesetComponent() {
        this.setEnabledRulesetComponent(!this.isPredefinedRulesetKind());
    }

    private void updateWaiversComponent(int source) {
        String waiversText = this.fWaiversFileField.getText();
        String newWaiversText = null;
        if (source == 1 && waiversText.startsWith(WAIVER_DEFAULT_TEXT)) {
            newWaiversText = "";
        } else if ((source == 2 || source == 3 && !this.fWaiversFileField.isFocusControl()) && (waiversText.equals("") || waiversText.startsWith(WAIVER_DEFAULT_TEXT))) {
            RulesetKind rulesetKind = RulesetKind.from(this.fRulesetKindCombo.getText().trim());
            if (rulesetKind == null) {
                rulesetKind = RulesetKind.getPrefered();
            }
            newWaiversText = "Default waiver file: .dvt" + File.separator + rulesetKind.getPrefix() + "_" + "waivers.xml";
        }
        if (newWaiversText != null) {
            this.fWaiversFileField.setText(newWaiversText);
        }
    }

    private void updateManualChecksStatusComponent(int source) {
        String manualChecksStatusText = this.fManualChecksStatusFileField.getText();
        String newManualChecksStatusText = null;
        if (source == 1 && manualChecksStatusText.startsWith(MANUAL_CHECKS_STATUS_DEFAULT_TEXT)) {
            newManualChecksStatusText = "";
        } else if ((source == 2 || source == 3 && !this.fManualChecksStatusFileField.isFocusControl()) && (manualChecksStatusText.equals("") || manualChecksStatusText.startsWith(MANUAL_CHECKS_STATUS_DEFAULT_TEXT))) {
            RulesetKind rulesetKind = RulesetKind.from(this.fRulesetKindCombo.getText().trim());
            if (rulesetKind == null) {
                rulesetKind = RulesetKind.getPrefered();
            }
            newManualChecksStatusText = "Default manual checks status file: .dvt" + File.separator + rulesetKind.getPrefix() + "_" + "manual_checks_status.xml";
        }
        if (newManualChecksStatusText != null) {
            this.fManualChecksStatusFileField.setText(newManualChecksStatusText);
        }
    }

    private void updateHTMLReportComponent(int source) {
        String HTMLReportLocationText = this.fHTMLReportField.getText();
        String newHTMLReportLocationText = null;
        if (source == 1 && HTMLReportLocationText.startsWith(HTML_REPORT_DEFAULT_LOCATION)) {
            newHTMLReportLocationText = "";
        } else if ((source == 2 || source == 3 && !this.fHTMLReportField.isFocusControl()) && (HTMLReportLocationText.equals("") || HTMLReportLocationText.startsWith(HTML_REPORT_DEFAULT_LOCATION))) {
            newHTMLReportLocationText = "Default HTML report location: Project Directory";
        }
        if (newHTMLReportLocationText != null) {
            this.fHTMLReportField.setText(newHTMLReportLocationText);
        }
    }

    private void updateBaselineReportComponent(int source) {
        String baselineReportLocationText = this.fBaselineReportFileField.getText();
        String newBaselineReportLocationText = null;
        if (source == 1 && baselineReportLocationText.startsWith(BASELINE_REPORT_DEFAULT_LOCATION)) {
            newBaselineReportLocationText = "";
        } else if ((source == 2 || source == 3 && !this.fHTMLReportField.isFocusControl()) && (baselineReportLocationText.equals("") || baselineReportLocationText.startsWith(HTML_REPORT_DEFAULT_LOCATION))) {
            newBaselineReportLocationText = "Default baseline report location: Project Directory";
        }
        if (newBaselineReportLocationText != null) {
            this.fBaselineReportFileField.setText(newBaselineReportLocationText);
        }
    }

    private void updateProjectComponent() {
        this.setEnabledProjectComponent(this.isProjectSpecificLintingMode());
    }

    private boolean isPredefinedRulesetKind() {
        String rulesetKind = this.fRulesetKindCombo.getText() == null ? "" : this.fRulesetKindCombo.getText();
        return RulesetKind.isPredefined(rulesetKind);
    }

    private boolean isCustomRulesetKind() {
        RulesetKind kind = RulesetKind.from(this.fRulesetKindCombo.getText());
        return kind != null && kind.equals((Object)RulesetKind.CUSTOM);
    }

    private boolean isPossibleOVMRulesetKind() {
        RulesetKind kind = RulesetKind.from(this.fRulesetKindCombo.getText());
        return kind != null && (kind.equals((Object)RulesetKind.SV_UVM_COMPLIANCE) || kind.equals((Object)RulesetKind.VERISSIMO_ALL_UVM) || kind.equals((Object)RulesetKind.VERISSIMO_BASIC_UVM));
    }

    private boolean isProjectSpecificLintingMode() {
        String lintingMode = this.fLintingModeCombo.getText() == null ? "" : this.fLintingModeCombo.getText();
        LintingMode mode = LintingMode.from(lintingMode);
        return mode == null || mode == LintingMode.LINT_PROJECT || mode == LintingMode.ALWAYS_ASK;
    }

    private void setEnabledRulesetComponent(boolean enabled) {
        this.fRulesetFileField.setEnabled(enabled);
        this.fRulesetFileText.setEnabled(enabled);
        this.fRulesetSystemLocationButton.setEnabled(enabled);
        this.fRulesetWorkspaceLocationButton.setEnabled(enabled);
        this.fRulesetVariablesButton.setEnabled(enabled);
        if (this.isCustomRulesetKind() || this.isPossibleOVMRulesetKind()) {
            this.fEnableOVMButton.setEnabled(true);
        } else {
            this.fEnableOVMButton.setEnabled(false);
            this.fEnableOVMButton.setSelection(false);
        }
    }

    private void setEnabledProjectComponent(boolean enabled) {
        this.fProjectField.setEnabled(enabled);
        this.fProjectButton.setEnabled(enabled);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("ro.amiq.dvt.linter.launch.first-edit", true);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        this.updateGeneralComponent(configuration);
        this.updateRulesetComponent(configuration);
        this.updateWaiversComponent(configuration);
        this.updateWaiversComponent(3);
        this.updateManualChecksStatusComponent(configuration);
        this.updateManualChecksStatusComponent(3);
        this.updateHTMLReportComponent(configuration);
        this.updateHTMLReportComponent(3);
        this.updateBaselineReportComponent(configuration);
        this.updateBaselineReportComponent(3);
        this.updateTimeoutComponent(configuration);
        this.fInitializing = false;
        this.setDirty(false);
    }

    protected void updateGeneralComponent(ILaunchConfiguration configuration) {
        String project = null;
        try {
            project = configuration.getAttribute("ro.amiq.dvt.linter.launch.project", "");
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fProjectField.setText(project);
        String lintingMode = null;
        try {
            lintingMode = configuration.getAttribute("ro.amiq.dvt.linter.launch.linting-mode", LintingMode.LINT_PROJECT.getName());
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fLintingModeCombo.setText(lintingMode);
        this.updateProjectComponent();
    }

    protected void updateRulesetComponent(ILaunchConfiguration configuration) {
        ArrayList<String> items;
        String rulesetKind = null;
        try {
            rulesetKind = configuration.getAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", RulesetKind.getPrefered().toString());
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        if (RulesetKind.from(rulesetKind) == RulesetKind.IMPORT_FROM_HTML && !(items = new ArrayList<String>(Arrays.asList(this.fRulesetKindCombo.getItems()))).contains(rulesetKind)) {
            this.fRulesetKindCombo.add(rulesetKind);
        }
        this.fRulesetKindCombo.setText(rulesetKind);
        String rulesetFile = null;
        try {
            rulesetFile = configuration.getAttribute("ro.amiq.dvt.linter.launch.ruleset-file", "");
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fRulesetFileField.setText(rulesetFile);
        boolean enableOVM = false;
        try {
            enableOVM = configuration.getAttribute("ro.amiq.dvt.linter.launch.library-ovm", false);
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        if (this.isCustomRulesetKind() || this.isPossibleOVMRulesetKind()) {
            this.fEnableOVMButton.setSelection(enableOVM);
        }
        this.updateRulesetComponent();
    }

    protected void updateWaiversComponent(ILaunchConfiguration configuration) {
        String waiversFile = null;
        try {
            waiversFile = configuration.getAttribute("ro.amiq.dvt.linter.launch.waivers-file", "");
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fWaiversFileField.setText(waiversFile);
    }

    protected void updateManualChecksStatusComponent(ILaunchConfiguration configuration) {
        String manualChecksStatusFile = null;
        try {
            manualChecksStatusFile = configuration.getAttribute("ro.amiq.dvt.linter.launch.manual-checks-status-file", "");
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fManualChecksStatusFileField.setText(manualChecksStatusFile);
    }

    protected void updateHTMLReportComponent(ILaunchConfiguration configuration) {
        String htmlReportLocation = null;
        try {
            htmlReportLocation = configuration.getAttribute("ro.amiq.dvt.linter.launch.html-report-location", "");
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fHTMLReportField.setText(htmlReportLocation);
        boolean includeHTMLCode = false;
        try {
            includeHTMLCode = configuration.getAttribute("ro.amiq.dvt.linter.launch.include-code-html-report", false);
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fEnableIncludeCodeHTMLReportButton.setSelection(includeHTMLCode);
        boolean enableAutoExport = false;
        try {
            enableAutoExport = configuration.getAttribute("ro.amiq.dvt.linter.launch.auto-export-html-report", false);
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fEnableAutoExportHTMLReportButton.setSelection(enableAutoExport);
        this.fEnableAutoExportHTMLReportOpenButton.setEnabled(enableAutoExport);
        boolean enableOpenReport = false;
        try {
            enableOpenReport = configuration.getAttribute("ro.amiq.dvt.linter.launch.auto-export-html-open-report", false);
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fEnableAutoExportHTMLReportOpenButton.setSelection(enableOpenReport);
    }

    protected void updateBaselineReportComponent(ILaunchConfiguration configuration) {
        boolean prewaiveUnchanged = false;
        try {
            prewaiveUnchanged = configuration.getAttribute("ro.amiq.dvt.linter.launch.prewaive-unchanged-files", false);
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fEnablePrewaiveUnchangedFilesButton.setSelection(prewaiveUnchanged);
        String baselineReportFile = null;
        try {
            baselineReportFile = configuration.getAttribute("ro.amiq.dvt.linter.launch.baseline-report-location", "");
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fBaselineReportFileField.setText(baselineReportFile);
    }

    protected void updateTimeoutComponent(ILaunchConfiguration configuration) {
        int processTimeoutValue = 0;
        int sessionTimeoutValue = 0;
        int checkTimeoutValue = 0;
        try {
            processTimeoutValue = configuration.getAttribute("ro.amiq.dvt.linter.launch.process_timeout_value", 0);
            sessionTimeoutValue = configuration.getAttribute("ro.amiq.dvt.linter.launch.session_timeout_value", 0);
            checkTimeoutValue = configuration.getAttribute("ro.amiq.dvt.linter.launch.check_timeout_value", 0);
        }
        catch (CoreException ce) {
            DVTLogger.INSTANCE.logError(ExternalToolsMessages.ExternalToolsMainTab_Error_reading_configuration_10, (Throwable)ce);
        }
        this.fProcessTimeoutField.setText(processTimeoutValue == 0 ? "" : "" + processTimeoutValue);
        this.fSessionTimeoutField.setText(sessionTimeoutValue == 0 ? "" : "" + sessionTimeoutValue);
        this.fCheckTimeoutField.setText(checkTimeoutValue == 0 ? "" : "" + checkTimeoutValue);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String project = this.fProjectField.getText().trim();
        if (project.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.project", null);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.project", project);
        }
        String rulesetKind = this.fRulesetKindCombo.getText().trim();
        if (rulesetKind.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", null);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", rulesetKind);
        }
        String rulesetFile = this.fRulesetFileField.getText().trim();
        if (rulesetFile.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.ruleset-file", null);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.ruleset-file", rulesetFile);
        }
        boolean enableOVM = this.fEnableOVMButton.getSelection();
        configuration.setAttribute("ro.amiq.dvt.linter.launch.library-ovm", enableOVM);
        String lintingMode = this.fLintingModeCombo.getText().trim();
        if (lintingMode.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.linting-mode", null);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.linting-mode", lintingMode);
        }
        String waiversFile = this.fWaiversFileField.getText().trim();
        if (waiversFile.startsWith(WAIVER_DEFAULT_TEXT)) {
            waiversFile = "";
        }
        if (waiversFile.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.waivers-file", null);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.waivers-file", waiversFile);
        }
        String manualChecksStatusFile = this.fManualChecksStatusFileField.getText().trim();
        if (manualChecksStatusFile.startsWith(MANUAL_CHECKS_STATUS_DEFAULT_TEXT)) {
            manualChecksStatusFile = "";
        }
        if (manualChecksStatusFile.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.manual-checks-status-file", null);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.manual-checks-status-file", manualChecksStatusFile);
        }
        String htmlReportLocation = this.fHTMLReportField.getText().trim();
        if (htmlReportLocation.startsWith(HTML_REPORT_DEFAULT_LOCATION)) {
            htmlReportLocation = "";
        }
        if (htmlReportLocation.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.html-report-location", null);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.html-report-location", htmlReportLocation);
        }
        boolean enablePrewaiveUnchangedFiles = this.fEnablePrewaiveUnchangedFilesButton.getSelection();
        configuration.setAttribute("ro.amiq.dvt.linter.launch.prewaive-unchanged-files", enablePrewaiveUnchangedFiles);
        String baselineReportLocation = this.fBaselineReportFileField.getText().trim();
        if (baselineReportLocation.startsWith(BASELINE_REPORT_DEFAULT_LOCATION)) {
            baselineReportLocation = "";
        }
        if (baselineReportLocation.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.baseline-report-location", null);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.baseline-report-location", baselineReportLocation);
        }
        boolean enableIncludeCodeHTMLReport = this.fEnableIncludeCodeHTMLReportButton.getSelection();
        configuration.setAttribute("ro.amiq.dvt.linter.launch.include-code-html-report", enableIncludeCodeHTMLReport);
        boolean enableAutoExportHTMLReport = this.fEnableAutoExportHTMLReportButton.getSelection();
        configuration.setAttribute("ro.amiq.dvt.linter.launch.auto-export-html-report", enableAutoExportHTMLReport);
        boolean enableAutoExportHTMLOpenReport = this.fEnableAutoExportHTMLReportOpenButton.getSelection();
        configuration.setAttribute("ro.amiq.dvt.linter.launch.auto-export-html-open-report", enableAutoExportHTMLOpenReport);
        if (this.fUserEdited) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.first-edit", null);
        }
        String processTimeoutValue = this.fProcessTimeoutField.getText().trim();
        try {
            Integer.parseUnsignedInt(processTimeoutValue);
        }
        catch (NumberFormatException numberFormatException) {
            processTimeoutValue = "";
        }
        if (processTimeoutValue.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.process_timeout_value", 0);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.process_timeout_value", Integer.parseUnsignedInt(processTimeoutValue));
        }
        String sessionTimeoutValue = this.fSessionTimeoutField.getText().trim();
        try {
            Integer.parseUnsignedInt(sessionTimeoutValue);
        }
        catch (NumberFormatException numberFormatException) {
            sessionTimeoutValue = "";
        }
        if (sessionTimeoutValue.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.session_timeout_value", 0);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.session_timeout_value", Integer.parseUnsignedInt(sessionTimeoutValue));
        }
        String checkTimeoutValue = this.fCheckTimeoutField.getText().trim();
        try {
            Integer.parseUnsignedInt(checkTimeoutValue);
        }
        catch (NumberFormatException numberFormatException) {
            checkTimeoutValue = "";
        }
        if (checkTimeoutValue.length() == 0) {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.check_timeout_value", 0);
        } else {
            configuration.setAttribute("ro.amiq.dvt.linter.launch.check_timeout_value", Integer.parseUnsignedInt(checkTimeoutValue));
        }
    }

    public String getName() {
        return ExternalToolsMessages.ExternalToolsMainTab__Main_17;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        this.setMessage(null);
        boolean newConfig = false;
        try {
            newConfig = launchConfig.getAttribute("ro.amiq.dvt.linter.launch.first-edit", false);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return this.validateProject(newConfig) && this.validateRuleset(newConfig) && this.validateFileVariable(this.fWaiversFileField) && this.validateFileVariable(this.fManualChecksStatusFileField) && this.validateBaselineReport();
    }

    protected boolean validateProject(boolean newConfig) {
        String projectName = this.fProjectField.getText().trim();
        if (!projectName.isEmpty()) {
            Path projectPath = new Path(null, projectName);
            if (!projectPath.isValidSegment(projectName)) {
                this.setErrorMessage("Project name '" + projectName + "' not valid.");
                return false;
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null || !project.exists()) {
                this.setErrorMessage("Project '" + projectName + "' does not exist.");
                return false;
            }
        }
        return true;
    }

    protected boolean validateRuleset(boolean newConfig) {
        String rulesetKind = this.fRulesetKindCombo.getText().trim();
        String rulesetFile = this.fRulesetFileField.getText().trim();
        if (rulesetKind.isEmpty()) {
            if (newConfig) {
                this.setErrorMessage(null);
                this.setMessage("Please specify the ruleset kind you would like to use.");
            } else if (rulesetFile.isEmpty()) {
                this.setErrorMessage("Ruleset kind name can not be empty");
                this.setMessage(null);
            }
            return false;
        }
        if (!this.isPredefinedRulesetKind()) {
            if (rulesetFile.isEmpty()) {
                if (newConfig) {
                    this.setErrorMessage(null);
                    this.setMessage("Please specify the ruleset file you would like to use or choose a predefined ruleset kind.");
                } else {
                    this.setErrorMessage("Ruleset file name can not be empty");
                    this.setMessage(null);
                }
                return false;
            }
            try {
                this.validateVaribles(rulesetFile);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getStatus().getMessage());
                return false;
            }
        }
        return true;
    }

    protected boolean validateFileVariable(Text field) {
        String file = field.getText().trim();
        if (file.length() > 0) {
            try {
                this.validateVaribles(file);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getStatus().getMessage());
                return false;
            }
        }
        return true;
    }

    protected boolean validateBaselineReport() {
        String baselinceReportPath = this.fBaselineReportFileField.getText().trim();
        if (baselinceReportPath.isEmpty() || baselinceReportPath.startsWith(BASELINE_REPORT_DEFAULT_LOCATION)) {
            return true;
        }
        try {
            baselinceReportPath = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(baselinceReportPath);
        }
        catch (CoreException coreException) {
            this.setErrorMessage("Baseline report path is not valid!");
            return false;
        }
        File htmlFile = new File(baselinceReportPath, "index.html");
        if (!htmlFile.exists()) {
            this.setErrorMessage("Could not find a report at the baseline report path specified!");
            return false;
        }
        File codeFolder = new File(baselinceReportPath, "code");
        if (!codeFolder.exists() || !codeFolder.isDirectory()) {
            this.setWarningMessage("The baseline report does not have source code!");
        }
        return true;
    }

    private void validateVaribles(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        manager.validateStringVariables(expression);
    }

    protected void handleProjectButtonSelected() {
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project");
        dialog.setMessage("Select the project");
        ArrayList dvtProjects = Utils.getNatureMatchingProjects((String[])new String[]{"ro.amiq.vhdldt.VhdlNature", "ro.amiq.vlogdt.VlogNature", "ro.amiq.edt.enature", "ro.amiq.slndt.slnnature", "ro.amiq.dvt.dvtnature"});
        if (dvtProjects == null) {
            dialog.setElements((Object[])new IProject[0]);
        } else {
            dialog.setElements(dvtProjects.toArray());
        }
        if (dialog.open() == 0) {
            this.fProjectField.setText(((IProject)dialog.getFirstResult()).getName());
        }
    }

    protected void handleSystemLocationButtonSelected(Text textField, int resourceType) {
        String path = null;
        if (resourceType == 1) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 0);
            fileDialog.setFileName(textField.getText());
            path = fileDialog.open();
        } else if (resourceType == 2) {
            DirectoryDialog dirDialog = new DirectoryDialog(this.getShell(), 0);
            dirDialog.setText(textField.getText());
            path = dirDialog.open();
        }
        if (path != null) {
            textField.setText(path);
        }
    }

    protected void handleWorkspaceLocationButtonSelected(Text textField, int resourceType) {
        String message = null;
        if (resourceType == 1) {
            message = "&Select a file:";
        } else if (resourceType == 2) {
            message = "&Select a folder:";
        }
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), message, resourceType);
        dialog.open();
        IStructuredSelection result = dialog.getResult();
        if (result == null) {
            return;
        }
        Object resource = result.getFirstElement();
        String expression = null;
        if (resource instanceof IFile) {
            expression = this.newVariableExpression("workspace_loc", ((IFile)resource).getFullPath().toOSString());
        }
        if (resource instanceof IFolder) {
            expression = this.newVariableExpression("workspace_loc", ((IFolder)resource).getFullPath().toOSString());
        }
        if (expression != null) {
            textField.setText(expression);
        }
    }

    protected String newVariableExpression(String varName, String arg) {
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(varName, arg);
    }

    private void handleVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.insert(variable);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuilder stripped = new StringBuilder();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    private static class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }
}

