/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.launch;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.startup.DVTProjectImporter;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.ProgressPrinter;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.OVMComplianceBuilder;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ReportManager;
import ro.amiq.vlogdt.linter.SingleFileLintingBuilder;
import ro.amiq.vlogdt.linter.launch.LintConfigurationContainer;
import ro.amiq.vlogdt.linter.launch.LintingMode;
import ro.amiq.vlogdt.linter.report.VerissimoReportConverterCommon;
import ro.amiq.vlogdt.linter.report.model.RReport;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.ui.HTML5ReportGenerator;
import ro.amiq.vlogdt.linter.ui.OVMComplianceReport;
import ro.amiq.vlogdt.linter.ui.OVMComplianceReportInput;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class SVLintLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private static final String VAR_PROJECT_NAME = "project_name";
    private static final String VAR_PROJECT_LOC = "project_loc";

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new LinterLaunch(configuration, mode, null);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(String.valueOf(configuration.getName()) + "...", 3);
        if (monitor.isCanceled()) {
            return;
        }
        String lintingModeAttr = null;
        try {
            lintingModeAttr = configuration.getAttribute("ro.amiq.dvt.linter.launch.linting-mode", LintingMode.LINT_PROJECT.getName());
        }
        catch (CoreException e) {
            this.abort(e.getStatus().getMessage(), null, 150);
            return;
        }
        LintingMode lintingMode = LintingMode.from(lintingModeAttr);
        if (lintingMode == null) {
            this.abort("Invalid linting mode: '" + (Object)((Object)lintingMode) + "'!", null, 150);
            return;
        }
        boolean lintProject = lintingMode == LintingMode.LINT_PROJECT;
        String projectName = configuration.getAttribute("ro.amiq.dvt.linter.launch.project", "");
        IProject project = null;
        IResource resource = DVTPlugin.getSelectionManager().getLastSelectedResource();
        if (lintingMode == LintingMode.ALWAYS_ASK) {
            DVTPair<Boolean, Boolean> result = this.getAlwaysAskDialogResult(projectName, resource);
            if (((Boolean)result.getValue()).booleanValue()) {
                return;
            }
            lintProject = (Boolean)result.getKey();
        } else if (lintingMode == LintingMode.DETECT_FROM_SELECTION) {
            if (resource instanceof IProject) {
                lintProject = true;
                project = (IProject)resource;
                projectName = project.getName();
            } else if (resource instanceof IFile) {
                lintProject = false;
            } else {
                this.abort("Unable to identify a valid project or file from the selection", null, 150);
                return;
            }
        }
        if (lintProject) {
            if (projectName == null || projectName.trim().length() == 0) {
                if (resource != null) {
                    project = resource.getProject();
                }
                if (project == null || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                    project = DVTPlugin.getSelectionManager().getLastSelectedProject();
                }
                if (project == null || !project.isAccessible() || !project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                    project = Utils.selectProject((String[])new String[]{"ro.amiq.vlogdt.VlogNature"}, (String)"Select a project:", null, null);
                }
                if (project == null) {
                    this.abort("Project name is empty and no project exists in workspace.", null, 150);
                    return;
                }
                projectName = project.getName();
            } else {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName.trim());
            }
        } else if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            project = file.getProject();
        } else {
            this.abort("Unable to identify a valid file for linting.", null, 150);
            return;
        }
        if (project == null || !project.exists() || !project.isOpen()) {
            this.abort("Project '" + projectName + "' does not exist or is not opened.", null, 150);
            return;
        }
        IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
        ArrayList<IValueVariable> variables = new ArrayList<IValueVariable>();
        IValueVariable projectLocVar = varManager.newValueVariable(VAR_PROJECT_LOC, "");
        projectLocVar.setValue(project.getLocation().toOSString());
        variables.add(projectLocVar);
        IValueVariable projectNameVar = varManager.newValueVariable(VAR_PROJECT_NAME, "");
        projectNameVar.setValue(project.getName());
        variables.add(projectNameVar);
        IValueVariable[] variablesArr = variables.toArray(new IValueVariable[variables.size()]);
        varManager.removeVariables(variablesArr);
        varManager.addVariables(variablesArr);
        boolean enableOVM = false;
        String waiversFileName = null;
        String manualChecksStatusFileName = null;
        String rulesetFileAttr = null;
        String rulesetFileName = null;
        String rulesetKindAttr = null;
        String htmlReportLocation = null;
        String htmlImportLocation = null;
        String baselineReportLocation = null;
        boolean enableIncludeCodeHTMLReport = false;
        boolean enableAutoExportHTMLReport = false;
        boolean enableAutoExportHTMLOpenReport = false;
        boolean prewaivedUnchanged = false;
        int processTimeoutValue = 0;
        int sessionTimeoutValue = 0;
        int checkTimeoutValue = 0;
        boolean launchedFromCLI = false;
        try {
            enableOVM = configuration.getAttribute("ro.amiq.dvt.linter.launch.library-ovm", false);
            String waiversFileAttr = configuration.getAttribute("ro.amiq.dvt.linter.launch.waivers-file", "");
            waiversFileName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(waiversFileAttr);
            String manualChecksStatusFileAttr = configuration.getAttribute("ro.amiq.dvt.linter.launch.manual-checks-status-file", "");
            manualChecksStatusFileName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(manualChecksStatusFileAttr);
            String htmlReportLocationAttr = configuration.getAttribute("ro.amiq.dvt.linter.launch.html-report-location", "");
            htmlReportLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(htmlReportLocationAttr);
            String htmlImportLocationAttr = configuration.getAttribute("ro.amiq.dvt.linter.launch.html-import-location", "");
            htmlImportLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(htmlImportLocationAttr);
            prewaivedUnchanged = configuration.getAttribute("ro.amiq.dvt.linter.launch.prewaive-unchanged-files", false);
            String baselineReportLocationAttr = configuration.getAttribute("ro.amiq.dvt.linter.launch.baseline-report-location", "");
            baselineReportLocation = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(baselineReportLocationAttr);
            rulesetKindAttr = configuration.getAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", "");
            rulesetFileAttr = configuration.getAttribute("ro.amiq.dvt.linter.launch.ruleset-file", "");
            enableIncludeCodeHTMLReport = configuration.getAttribute("ro.amiq.dvt.linter.launch.include-code-html-report", false);
            enableAutoExportHTMLReport = configuration.getAttribute("ro.amiq.dvt.linter.launch.auto-export-html-report", false);
            if (enableAutoExportHTMLReport) {
                enableAutoExportHTMLOpenReport = configuration.getAttribute("ro.amiq.dvt.linter.launch.auto-export-html-open-report", false);
            }
            processTimeoutValue = configuration.getAttribute("ro.amiq.dvt.linter.launch.process_timeout_value", 0);
            sessionTimeoutValue = configuration.getAttribute("ro.amiq.dvt.linter.launch.session_timeout_value", 0);
            checkTimeoutValue = configuration.getAttribute("ro.amiq.dvt.linter.launch.check_timeout_value", 0);
            launchedFromCLI = configuration.getAttribute("ro.amiq.dvt.linter.launch.launched-from-cli", false);
        }
        catch (CoreException e) {
            this.abort(e.getStatus().getMessage(), null, 150);
            return;
        }
        RulesetKind rulesetKind = RulesetKind.from(rulesetKindAttr, enableOVM);
        if (rulesetKind == null) {
            this.abort("Ruleset kind '" + rulesetKindAttr + "' is not valid.", null, 150);
            return;
        }
        String filePrefix = rulesetKind.getPrefix();
        File waiversFile = null;
        waiversFile = waiversFileName.isEmpty() ? OVMUtils.getPathToPropertyFile(project, filePrefix, "waivers.xml") : new File(waiversFileName);
        if (!(DVTProjectImporter.isLintTestMode() || waiversFile.exists() || waiversFileName.isEmpty())) {
            this.abort("Waivers file: " + waiversFileName + " does not exist.", null, 150);
            return;
        }
        File manualChecksStatusFile = null;
        manualChecksStatusFile = manualChecksStatusFileName.isEmpty() ? OVMUtils.getPathToPropertyFile(project, filePrefix, "manual_checks_status.xml") : new File(manualChecksStatusFileName);
        if (!rulesetKind.isPredefined()) {
            try {
                rulesetFileName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(rulesetFileAttr);
            }
            catch (CoreException e) {
                this.abort(e.getStatus().getMessage(), null, 150);
                return;
            }
        } else {
            rulesetFileName = "";
        }
        File rulesetFile = new File(rulesetFileName);
        if (rulesetKind.isPredefined() || rulesetFileName.isEmpty()) {
            URL url = OVMUtils.getDefaultRulesetURL(rulesetKind);
            rulesetFile = new File(url.getFile());
        } else {
            rulesetFile = new File(rulesetFileName);
        }
        if (!(DVTProjectImporter.isLintTestMode() || rulesetKind.isPredefined() || rulesetFile.exists() || rulesetFileName.isEmpty())) {
            this.abort("Ruleset file: " + rulesetFileName + " does not exist.", null, 150);
            return;
        }
        if (baselineReportLocation != null && !baselineReportLocation.isEmpty()) {
            File data0js = new File(String.valueOf(baselineReportLocation) + File.separator + "js" + File.separator + "data0.js");
            File data1js = new File(String.valueOf(baselineReportLocation) + File.separator + "js" + File.separator + "data1.js");
            if (!data0js.exists() || !data1js.exists()) {
                this.abort("Baseline report: " + baselineReportLocation + " does not exist or it's corrupted.", null, 150);
                return;
            }
        }
        LintConfigurationContainer configurationContainer = new LintConfigurationContainer(configuration.getName(), project, rulesetKind, rulesetFile, waiversFile, manualChecksStatusFile, htmlReportLocation, htmlImportLocation, baselineReportLocation, enableOVM ? 1 : -1, null, null, enableIncludeCodeHTMLReport, enableAutoExportHTMLReport, enableAutoExportHTMLOpenReport, lintingMode, processTimeoutValue, sessionTimeoutValue, checkTimeoutValue, prewaivedUnchanged, launchedFromCLI);
        this.run(configurationContainer, launch, lintProject);
    }

    private void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "ro.amiq.vlogdt", code, message, exception));
    }

    public void run(final LintConfigurationContainer config, final ILaunch launch, final boolean lintProject) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IProject project = config.getProject();
                RfProject rfProject = RfManager.getInstance().getRfProject(project);
                if (rfProject == null) {
                    return;
                }
                try {
                    if (!lintProject) {
                        if (!rfProject.getProjectState().equals((Object)RfProjectState.BUILT)) {
                            SVLintLaunchConfigurationDelegate.this.openErrorMessage("Full build required", "Linting the current file is not available after restore. Please start a full build and try again!");
                            return;
                        }
                        IFile selectedFile = SingleFileLintingBuilder.getInstance().getSelectedFile();
                        if (selectedFile == null) {
                            SVLintLaunchConfigurationDelegate.this.openErrorMessage("Current file error", "Unable to identify an open file. Please open a file you would like to lint!");
                            return;
                        }
                        List fileInstances = RfMixedLangManager.getInstance().getFileInstances(project, DVTFileUtils.getInstance().resource2parser((IResource)selectedFile));
                        if (fileInstances == null || fileInstances.isEmpty()) {
                            SVLintLaunchConfigurationDelegate.this.openErrorMessage("Current file error", "Linting cannot be performed for the selected file! Make sure you select a SystemVerilog/Verilog file.");
                            return;
                        }
                    }
                    OVMProject ovmProject = OVMComplianceBuilder.getInstance().getOVMProject(project);
                    OVMComplianceReportInput editorInput = new OVMComplianceReportInput(config);
                    if (ovmProject != null) {
                        if (config.equals(ovmProject.getConfiguration())) {
                            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)editorInput);
                            if (editorPart != null) {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)editorPart);
                                SVLintLaunchConfigurationDelegate.this.maximizeEditor((IWorkbenchPart)editorPart);
                                return;
                            }
                            ovmProject = OVMComplianceBuilder.getInstance().createOVMProject(config, lintProject);
                        } else {
                            OVMComplianceReportInput editorInput2 = new OVMComplianceReportInput(ovmProject.getConfiguration());
                            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)editorInput2);
                            if (editorPart != null) {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editorPart, false);
                            }
                            ovmProject = OVMComplianceBuilder.getInstance().createOVMProject(config, lintProject);
                        }
                    } else {
                        ovmProject = OVMComplianceBuilder.getInstance().createOVMProject(config, lintProject);
                    }
                    rfProject.setOvmProject(ovmProject);
                    project.setSessionProperty(DVTStartupConstants.QN_DVT_DONT_RESTORE, (Object)true);
                    if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
                        return;
                    }
                    ovmProject.initializeProcessEndTime();
                    ovmProject.checkWaivers();
                    if (config.getRulesetKind() == RulesetKind.IMPORT_FROM_HTML) {
                        ovmProject.readRReport();
                    }
                    if (!lintProject) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                            try {
                                try {
                                    SingleFileLintingBuilder.getInstance().startSingleFileIncrementalAndLinting(project);
                                }
                                catch (Exception e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    rfProject.stopLintTracking();
                                    DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                                    if (launch instanceof LinterLaunch) {
                                        ((LinterLaunch)launch).setFinised(true);
                                    }
                                    SVLintLaunchConfigurationDelegate.this.removeVariables();
                                }
                            }
                            finally {
                                DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                                if (launch instanceof LinterLaunch) {
                                    ((LinterLaunch)launch).setFinised(true);
                                }
                                SVLintLaunchConfigurationDelegate.this.removeVariables();
                            }
                        });
                    } else {
                        ovmProject.preFullBuildNotification(rfProject);
                        if (config.isLaunchedFromCLI() || !ovmProject.isImportHTML()) {
                            IBuildDoneListener[] buildDoneListener;
                            buildDoneListener = new IBuildDoneListener[]{(buildFinishReason, projectName) -> {
                                if (!IBuildDoneListener.BuildFinishReason.isFullBuild((IBuildDoneListener.BuildFinishReason)buildFinishReason)) {
                                    return;
                                }
                                if (BuildConfigManager.isPrecompiledDbSaveMode((IProject)project) && BuildConfigManager.needsPrecompiledLoadAutoTrigger((IProject)project)) {
                                    return;
                                }
                                DVTMixedLangModelManager.getInstance().removeBuildDoneListener(buildDoneListener[0]);
                                OVMProject localOvmProject = OVMComplianceBuilder.getInstance().getOVMProject(project);
                                if (IBuildDoneListener.BuildFinishReason.isCanceled((IBuildDoneListener.BuildFinishReason)buildFinishReason) || localOvmProject.hasTimedOutDuringBuild()) {
                                    localOvmProject.clean(true, true);
                                    rfProject.stopLintTracking();
                                    OVMComplianceBuilder.getInstance().removeOVMProject(project);
                                    DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                                    return;
                                }
                                SVLintLaunchConfigurationDelegate.this.openEditorReport(config, launch, project, rfProject, editorInput);
                            }};
                            DVTMixedLangModelManager.getInstance().addBuildDoneListener(buildDoneListener[0]);
                            if (!DVTBuildUtils.buildWithProgressDialog((IProject)project)) {
                                DVTMixedLangModelManager.getInstance().removeBuildDoneListener(buildDoneListener[0]);
                                DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                                return;
                            }
                        } else {
                            SVLintLaunchConfigurationDelegate.this.openEditorReport(config, launch, project, rfProject, editorInput);
                        }
                    }
                }
                catch (XMLException e) {
                    OVMUtils.configError(e);
                }
                catch (Exception e) {
                    rfProject.stopLintTracking();
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    protected void openEditorReport(final LintConfigurationContainer config, final ILaunch launch, final IProject project, final RfProject rfProject, final OVMComplianceReportInput editorInput) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)editorInput, (String)"ro.amiq.vlogdt.linter.ui.OVMComplianceReport", (boolean)true);
                        if (editorPart != null) {
                            ((OVMComplianceReport)editorPart).updateArchitecturePostBuild();
                        }
                        SVLintLaunchConfigurationDelegate.this.maximizeEditor((IWorkbenchPart)editorPart);
                        if (config.getAutoExportHTMLReport()) {
                            ProgressPrinter.INSTANCE.printProgress(project, "Generating Verissimo HTML Report...", false);
                            final AtomicBoolean jobDone = new AtomicBoolean(false);
                            Job job = new Job("Generating Verissimo HTML Report"){

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        OVMProject ovmProject = OVMComplianceBuilder.getInstance().getOVMProject(project);
                                        String location = config.getHTMLReportLocation();
                                        if (location == null || location.isEmpty()) {
                                            location = project.getLocation().toOSString();
                                        }
                                        monitor.beginTask("Generating Verissimo HTML Report", 100);
                                        boolean hasCompilationErrors = DVTProblemManager.getInstance().getAllProblems(project, DVTProblemMatcher.all(), null).stream().anyMatch(problem -> !problem.isWaived() && problem.getSeverity() == Severity.ERROR);
                                        ovmProject.setCompilationErrors(hasCompilationErrors);
                                        File[] files = null;
                                        if (ovmProject.getConfiguration().getBaselineReportLocation() == null || ovmProject.getConfiguration().getBaselineReportLocation().isEmpty()) {
                                            files = HTML5ReportGenerator.generateWithoutOpen(location, ovmProject, monitor);
                                        } else {
                                            RReport changesReport = VerissimoReportConverterCommon.convertToRReport(ovmProject, HTML5ReportGenerator.collectInfo(ovmProject), null, monitor, HTML5ReportGenerator::subprogressMonitorSuplier, true);
                                            if (ovmProject.getReportManager().getBaselineReport() != null) {
                                                changesReport.setBaselineReportLocation(ovmProject.getReportManager().getBaselineReport().getLocation());
                                            }
                                            files = HTML5ReportGenerator.generateWithoutOpen(changesReport, location, ovmProject, monitor, ReportManager.ReportType.CHANGES);
                                        }
                                        jobDone.set(true);
                                        if (config.getAutoExportHTMLOpenReport()) {
                                            HTML5ReportGenerator.refreshAndOpenReport(files[1], ovmProject.getNumberOfHits(), monitor);
                                        }
                                        if (monitor.isCanceled()) {
                                            IStatus iStatus = Status.CANCEL_STATUS;
                                            return iStatus;
                                        }
                                        ProgressPrinter.INSTANCE.printProgress(project, "HTML report generated at: " + location + "/verissimo" + ovmProject.getConfiguration().getBaselineReportLocation() == null || ovmProject.getConfiguration().getBaselineReportLocation().isEmpty() ? "" : "_" + (Object)((Object)ReportManager.ReportType.CHANGES) + "_html_report/index.html", false);
                                        IStatus iStatus = Status.OK_STATUS;
                                        return iStatus;
                                    }
                                    finally {
                                        jobDone.set(true);
                                        monitor.done();
                                    }
                                }
                            };
                            job.setUser(true);
                            job.setPriority(30);
                            job.schedule();
                            while (!jobDone.get()) {
                                if (Display.getDefault().readAndDispatch()) continue;
                                Display.getDefault().sleep();
                            }
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        rfProject.stopLintTracking();
                        DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                        if (launch instanceof LinterLaunch) {
                            ((LinterLaunch)launch).setFinised(true);
                        }
                        SVLintLaunchConfigurationDelegate.this.removeVariables();
                    }
                }
                finally {
                    DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                    if (launch instanceof LinterLaunch) {
                        ((LinterLaunch)launch).setFinised(true);
                    }
                    SVLintLaunchConfigurationDelegate.this.removeVariables();
                }
            }
        });
    }

    private void openErrorMessage(String title, String message) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> new MessageDialog(DVTUiUtils.getActiveWorkbenchWindow().getShell(), title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0).open());
    }

    private void maximizeEditor(IWorkbenchPart editorPart) {
        try {
            if (editorPart == null) {
                return;
            }
            IWorkbenchPartSite site = editorPart.getSite();
            if (site == null) {
                return;
            }
            IWorkbenchPage page = site.getPage();
            if (page == null) {
                return;
            }
            IWorkbenchPartReference partReference = page.getActivePartReference();
            if (partReference == null) {
                return;
            }
            page.setPartState(partReference, 1);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void removeVariables() {
        try {
            IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
            ArrayList<IValueVariable> variables = new ArrayList<IValueVariable>();
            variables.add(varManager.newValueVariable(VAR_PROJECT_LOC, ""));
            variables.add(varManager.newValueVariable(VAR_PROJECT_NAME, ""));
            varManager.removeVariables(variables.toArray(new IValueVariable[variables.size()]));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private DVTPair<Boolean, Boolean> getAlwaysAskDialogResult(String projectNameAttribute, IResource resource) {
        DVTPair result = new DVTPair((Object)true, (Object)false);
        AtomicBoolean dialogResult = new AtomicBoolean();
        AtomicBoolean dialogCanceled = new AtomicBoolean(false);
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            LintingModeInputDialog dialog;
            String tempProjectName = projectNameAttribute;
            if ((tempProjectName == null || tempProjectName.isEmpty()) && resource != null) {
                tempProjectName = resource.getProject().getName();
            }
            if ((dialog = new LintingModeInputDialog(DVTUiUtils.getActiveWorkbenchWindow().getShell(), tempProjectName)).open() == 1) {
                dialogCanceled.set(true);
                return;
            }
            dialogResult.set(dialog.lintProject());
        });
        if (dialogCanceled.get()) {
            result.setValue((Object)true);
        }
        result.setKey((Object)dialogResult.get());
        return result;
    }

    private static class LinterLaunch
    extends Launch {
        private boolean finished = false;

        public LinterLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
            super(launchConfiguration, mode, locator);
        }

        public void setFinised(boolean finished) {
            this.finished = finished;
        }

        public boolean isTerminated() {
            return this.finished;
        }

        public boolean isDisconnected() {
            return this.finished;
        }
    }

    private static class LintingModeInputDialog
    extends Dialog {
        private boolean lintProject = true;
        private String projectName;

        public LintingModeInputDialog(Shell parent, String projectName) {
            super(parent);
            this.projectName = projectName;
        }

        protected Control createDialogArea(Composite parent) {
            Group group = new Group(parent, 0);
            group.setText("Do you want to lint the project or just the current file?");
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            GridData gridData = new GridData(768);
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)gridData);
            Composite buttonComposite = new Composite((Composite)group, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            gridData = new GridData(4, 0x1000000, false, false, 2, 1);
            buttonComposite.setLayout((Layout)layout);
            buttonComposite.setLayoutData((Object)gridData);
            final Button projectButton = new Button(buttonComposite, 16);
            projectButton.setText("Project" + (this.projectName == null || this.projectName.isEmpty() ? "" : " '" + this.projectName + "'"));
            projectButton.setSelection(true);
            projectButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (projectButton.getSelection()) {
                        lintProject = true;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            final Button fileButton = new Button(buttonComposite, 16);
            fileButton.setText("File");
            fileButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (fileButton.getSelection()) {
                        lintProject = false;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            return group;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Linting Mode");
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        public boolean lintProject() {
            return this.lintProject;
        }
    }
}

