/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.launch;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.VerissimoCompilationChecks;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.OVMComplianceBuilder;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.launch.VerissimoAfterCompilationLauncherCommon;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class VerissimoAfterCompilationLauncher
extends VerissimoAfterCompilationLauncherCommon
implements IBuildDoneListener {
    private static VerissimoAfterCompilationLauncher fInstance;
    private static final Object fSyncInstance;
    private BUILD_DONE_STATE_ACTION buildDoneAction;

    static {
        fSyncInstance = new Object();
    }

    private VerissimoAfterCompilationLauncher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerissimoAfterCompilationLauncher getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VerissimoAfterCompilationLauncher();
            }
        }
        return fInstance;
    }

    @Override
    protected void createOVMProject(RfProject rfProject, boolean resetProject) {
        OVMProject ovmProject = OVMComplianceBuilder.getInstance().getOVMProject(rfProject.getProject());
        if (ovmProject == null || !ovmProject.isStartedFromBuildConfig() || resetProject) {
            ovmProject = this.getNewOVMProject(rfProject, false);
            OVMComplianceBuilder.getInstance().addOVMProject(ovmProject);
        }
        ovmProject.preFullBuildNotification(rfProject);
    }

    @Override
    protected void scheduleOrPerformLinting(IProject project, Set<ParserPath> changedFiles) {
        this.buildDoneAction = changedFiles == null ? BUILD_DONE_STATE_ACTION.FULL_LINTING : BUILD_DONE_STATE_ACTION.INCREMENTAL_LINTING;
    }

    public void lint(final IProject project, final Set<ParserPath> changedFiles) {
        VerissimoCompilationChecks verissimoChecks;
        final Job currentJob = Job.getJobManager().currentJob();
        String projectName = project.getName();
        if (currentJob != null) {
            currentJob.setProperty(IDVTConstants.BUILD_JOB_PROJECT_NAME, (Object)projectName);
        }
        if ((verissimoChecks = BuildConfigManager.getVerissimoChecks((IProject)project)) == null || verissimoChecks.getChecksKind().isEmpty()) {
            return;
        }
        IProgressMonitor progressMonitor = (IProgressMonitor)this.progressMonitors.get(project);
        if (progressMonitor == null || OVMComplianceBuilder.getInstance().getOVMProject(project).hasTimedOutDuringBuild()) {
            this.releaseLicense();
            return;
        }
        final IProgressMonitor monitor = progressMonitor;
        OVMProject ovmProject = OVMComplianceBuilder.getInstance().getOVMProject(project);
        ovmProject.initialize(ovmProject.getRfProject(), false, true);
        if (PrecompiledDBUtils.containsPrecompiledInvocation((IProject)project)) {
            LintUtils.createPrewaiverForPrecompiledCode(ovmProject);
        }
        DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

            public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                try {
                    ArrayList<OVMComplianceCheck> checks = OVMComplianceBuilder.getInstance().getChecks(project);
                    if (checks != null) {
                        monitor.beginTask("Running: ", checks.size());
                        OVMComplianceBuilder.getInstance().build(project, monitor, false, changedFiles);
                    }
                }
                finally {
                    monitor.done();
                    VerissimoAfterCompilationLauncher.this.releaseLicense();
                    VerissimoAfterCompilationLauncher.this.progressMonitors.remove(project);
                    if (currentJob != null) {
                        currentJob.setProperty(IDVTConstants.BUILD_JOB_PROJECT_NAME, null);
                    }
                }
            }
        };
        try {
            if (op != null) {
                DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, "Running checks", op, false);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void projectClean(IProject project) {
        OVMProject ovmProject = OVMComplianceBuilder.getInstance().getOVMProject(project);
        if (ovmProject == null || !ovmProject.isStartedFromBuildConfig()) {
            return;
        }
        this.fullBuiltProjects.remove(project);
        ovmProject.clean(true, true);
    }

    @Override
    protected boolean getLicense() {
        return DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"});
    }

    @Override
    protected void addBuildDoneListener() {
        this.buildDoneAction = BUILD_DONE_STATE_ACTION.DO_NOTHING;
        DVTMixedLangModelManager.getInstance().addBuildDoneListener((IBuildDoneListener)this);
    }

    public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        DVTMixedLangModelManager.getInstance().removeBuildDoneListener((IBuildDoneListener)this);
        IProject project = Utils.getProject((String)projectName);
        if (project == null) {
            return;
        }
        if (IBuildDoneListener.BuildFinishReason.isFullBuild((IBuildDoneListener.BuildFinishReason)buildFinishReason) && (IBuildDoneListener.BuildFinishReason.isCanceled((IBuildDoneListener.BuildFinishReason)buildFinishReason) || OVMComplianceBuilder.getInstance().getOVMProject(project).hasTimedOutDuringBuild())) {
            this.releaseLicense();
            return;
        }
        switch (this.buildDoneAction) {
            case FULL_LINTING: {
                this.lint(project, null);
                break;
            }
            case INCREMENTAL_LINTING: {
                this.lint(project, this.lastModifiedFiles);
                break;
            }
        }
        this.buildDoneAction = BUILD_DONE_STATE_ACTION.DO_NOTHING;
    }

    @Override
    public void reportException(XMLException e) {
        OVMUtils.configError(e);
    }

    @Override
    protected void clearMarkersAndBuilder(IProject project) {
        if (project == null) {
            return;
        }
        LintingProblemsManager.getInstance().clearMarkers(project);
        OVMComplianceBuilder.getInstance().removeOVMProject(project);
    }

    private static enum BUILD_DONE_STATE_ACTION {
        DO_NOTHING,
        FULL_LINTING,
        INCREMENTAL_LINTING;

    }
}

