/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.launch;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.VerissimoChecksKind;
import ro.amiq.dvt.buildconfig.VerissimoCompilationChecks;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManager;
import ro.amiq.vlogdt.linter.launch.LintConfigurationContainer;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;

public abstract class VerissimoAfterCompilationLauncherCommon
implements IBuildEventManagerListener {
    public static final String PREDEFINED_PREWAIVER_NAME = "Lint modified files";
    protected final Map<IProject, IProgressMonitor> progressMonitors = new HashMap<IProject, IProgressMonitor>();
    protected Set<ParserPath> lastModifiedFiles = new HashSet<ParserPath>();
    protected Set<IProject> fullBuiltProjects = new HashSet<IProject>();

    public void setupLinting(IProject project, IProgressMonitor monitor, boolean fullBuild) {
        VerissimoCompilationChecks verissimoChecks;
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        OVMProject ovmProject = rfProject.getOvmProject();
        if (ovmProject != null) {
            if (fullBuild && !ovmProject.lintProject()) {
                ovmProject.clean(true, true);
                rfProject.setOvmProject(null);
            } else if (!ovmProject.isStartedFromBuildConfig()) {
                return;
            }
        }
        if ((verissimoChecks = BuildConfigManager.getVerissimoChecks((IProject)project)) == null || verissimoChecks.getChecksKind().isEmpty()) {
            if (rfProject.isLintingEnabled() && ovmProject != null && ovmProject.isStartedFromBuildConfig()) {
                this.stopLintTracking(rfProject);
            }
            return;
        }
        DVTPair<RulesetKind, String> ruleset = this.getRuleset(project);
        File rulesetFile = new File((String)ruleset.getValue());
        if (ruleset.getKey() == RulesetKind.CUSTOM && !rulesetFile.exists()) {
            return;
        }
        if (!fullBuild && !verissimoChecks.getChecksKind().contains(VerissimoChecksKind.INCREMENTAL_BUILD)) {
            return;
        }
        if (!this.getLicense()) {
            return;
        }
        boolean resetProject = fullBuild;
        try {
            this.createOVMProject(rfProject, resetProject);
            this.registerBuildListenerLinting();
            this.progressMonitors.put(project, monitor);
        }
        catch (XMLException e) {
            this.reportException(e);
            this.releaseLicense();
        }
    }

    public void notifyFullBuild(IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        VerissimoCompilationChecks verissimoChecks = BuildConfigManager.getVerissimoChecks((IProject)project);
        if (verissimoChecks == null || verissimoChecks.getChecksKind().isEmpty()) {
            return;
        }
        if (rfProject != null && this.checkProjectState(rfProject)) {
            this.fullBuiltProjects.add(project);
        }
        if (!verissimoChecks.getChecksKind().contains(VerissimoChecksKind.FULL_BUILD)) {
            return;
        }
        if (BuildConfigManager.isPrecompiledDbSaveMode((IProject)project) && BuildConfigManager.needsPrecompiledLoadAutoTrigger((IProject)project)) {
            return;
        }
        this.scheduleOrPerformLinting(project, null);
    }

    public void notifyIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        VerissimoCompilationChecks verissimoChecks = BuildConfigManager.getVerissimoChecks((IProject)project);
        if (verissimoChecks == null || verissimoChecks.getChecksKind().isEmpty()) {
            return;
        }
        if (!verissimoChecks.getChecksKind().contains(VerissimoChecksKind.INCREMENTAL_BUILD)) {
            return;
        }
        this.scheduleOrPerformLinting(project, this.lastModifiedFiles);
    }

    public void notifyCleanBuild(IProject project) {
    }

    public DVTPair<RulesetKind, String> getRuleset(IProject project) {
        String rulesetPath = BuildConfigManager.getVerissimoRulesetPath((IProject)project);
        if (rulesetPath == null || rulesetPath.isEmpty()) {
            return new DVTPair((Object)RulesetKind.VERISSIMO_BASIC_UVM, (Object)"");
        }
        String resolvedPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)rulesetPath, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)project, (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
        return new DVTPair((Object)RulesetKind.CUSTOM, (Object)resolvedPath);
    }

    public String getWaiversPath(IProject project) {
        return DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)BuildConfigManager.getVerissimoWaiversPath((IProject)project), DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)project, (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
    }

    private void registerBuildListenerLinting() {
        BuildEventManager.getInstance().registerListener((IBuildEventManagerListener)this);
        this.addBuildDoneListener();
    }

    public OVMProject getNewOVMProject(RfProject rfProject, boolean isInBathcMode) {
        DVTPair<RulesetKind, String> ruleset = this.getRuleset(rfProject.getProject());
        RulesetKind rulesetKind = (RulesetKind)((Object)ruleset.getKey());
        String rulesetPath = (String)ruleset.getValue();
        String waiversPath = this.getWaiversPath(rfProject.getProject());
        File rulesetFile = new File(rulesetPath);
        File waiversFile = new File(waiversPath);
        LintConfigurationContainer config = new LintConfigurationContainer("", rfProject.getProject(), rulesetKind, rulesetFile, waiversFile, null, null, 2, null, null);
        OVMProject ovmProject = new OVMProject(config, isInBathcMode);
        ovmProject.setStartedFromBuildConfig(true);
        rfProject.setOvmProject(ovmProject);
        ovmProject.initializeProcessEndTime();
        ovmProject.checkWaivers();
        ovmProject.initialize(rfProject, true, true);
        return ovmProject;
    }

    public void calculateAndSetModifiedFiles(IncrementalDeltaContainer delta) {
        if (delta == null) {
            return;
        }
        this.lastModifiedFiles = new HashSet<ParserPath>();
        for (Map.Entry<ParserPath, Set<IRfNamedElement>> entry : delta.getDelta().entrySet()) {
            this.lastModifiedFiles.add(entry.getKey());
            for (IRfNamedElement element : entry.getValue()) {
                IRfDefElement elementDeclaration = element.getDeclaration();
                if (elementDeclaration == null || elementDeclaration.getParserPath() == null) continue;
                this.lastModifiedFiles.add(elementDeclaration.getParserPath());
            }
        }
    }

    public boolean isEnabled(IProject project) {
        VerissimoCompilationChecks verissimoChecks = BuildConfigManager.getVerissimoChecks((IProject)project);
        return verissimoChecks != null && !verissimoChecks.getChecksKind().isEmpty();
    }

    public boolean isEnabled(IProject project, boolean incremental) {
        boolean hasProject = this.progressMonitors.containsKey(project);
        if (!hasProject) {
            return false;
        }
        VerissimoCompilationChecks verissimoChecks = BuildConfigManager.getVerissimoChecks((IProject)project);
        if (verissimoChecks == null || verissimoChecks.getChecksKind().isEmpty()) {
            return false;
        }
        if (!incremental && verissimoChecks.getChecksKind().contains(VerissimoChecksKind.FULL_BUILD)) {
            return true;
        }
        return incremental && verissimoChecks.getChecksKind().contains(VerissimoChecksKind.INCREMENTAL_BUILD);
    }

    public boolean projectWasFullBuilt(IProject project) {
        return this.fullBuiltProjects.contains(project);
    }

    protected void releaseLicense() {
        DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
    }

    protected boolean checkProjectState(RfProject project) {
        return project.getMixedLangProjectParent() != null && project.getMixedLangProjectParent().isBuildDone();
    }

    private void stopLintTracking(RfProject rfProject) {
        this.clearResults(rfProject);
        this.fullBuiltProjects.remove(rfProject.getProject());
        if (rfProject != null) {
            rfProject.stopLintTracking();
        }
    }

    public void clearResults(RfProject rfProject) {
        IProject project = rfProject.getProject();
        OVMProject ovmProject = rfProject.getOvmProject();
        ovmProject.clean(true, true);
        VerissimoAutofixManager.getInstance().cleanCanonicalPathsCache();
        this.clearMarkersAndBuilder(project);
    }

    public abstract void reportException(XMLException var1);

    public abstract void projectClean(IProject var1);

    protected abstract void addBuildDoneListener();

    protected abstract void scheduleOrPerformLinting(IProject var1, Set<ParserPath> var2);

    protected abstract void createOVMProject(RfProject var1, boolean var2);

    protected abstract boolean getLicense();

    protected abstract void clearMarkersAndBuilder(IProject var1);
}

