/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.report;

import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang.mutable.MutableInt;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.annotations.AnnotationCcField;
import ro.amiq.vlogdt.linter.annotations.AnnotationField;
import ro.amiq.vlogdt.linter.annotations.AnnotationFsField;
import ro.amiq.vlogdt.linter.annotations.AnnotationGitField;
import ro.amiq.vlogdt.linter.annotations.AnnotationGitProcessor;
import ro.amiq.vlogdt.linter.annotations.AnnotationManager;
import ro.amiq.vlogdt.linter.annotations.AnnotationP4Field;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;
import ro.amiq.vlogdt.linter.annotations.AnnotationSvnField;
import ro.amiq.vlogdt.linter.annotations.AnnotationType;
import ro.amiq.vlogdt.linter.autofixes.EditParameters;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixError;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixResult;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.report.VerissimoReportConverter;
import ro.amiq.vlogdt.linter.report.VerissimoReportWriter;
import ro.amiq.vlogdt.linter.report.model.RCategory;
import ro.amiq.vlogdt.linter.report.model.RCheck;
import ro.amiq.vlogdt.linter.report.model.REdit;
import ro.amiq.vlogdt.linter.report.model.RError;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.report.model.RInfo;
import ro.amiq.vlogdt.linter.report.model.RPreWaiver;
import ro.amiq.vlogdt.linter.report.model.RReport;
import ro.amiq.vlogdt.linter.report.model.RWaiver;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.standard.checks.OVMComplianceManualCheck;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.waivers.MessagePattern;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;

public class VerissimoReportConverterCommon {
    public static RReport convertToRReport(OVMProject ovmProject, String[] partialInfo, List<String> infoKeyValues, IProgressMonitor monitor, BiFunction<IProgressMonitor, Integer, IProgressMonitor> subprogressMonitorSupplier) {
        return VerissimoReportConverterCommon.convertToRReport(ovmProject, partialInfo, infoKeyValues, monitor, subprogressMonitorSupplier, false, false);
    }

    public static RReport convertToRReport(OVMProject ovmProject, String[] partialInfo, List<String> infoKeyValues, IProgressMonitor monitor, BiFunction<IProgressMonitor, Integer, IProgressMonitor> subprogressMonitorSupplier, boolean isChangesReport) {
        return VerissimoReportConverterCommon.convertToRReport(ovmProject, partialInfo, infoKeyValues, monitor, subprogressMonitorSupplier, isChangesReport, false);
    }

    public static RReport convertToRReport(OVMProject ovmProject, String[] partialInfo, List<String> infoKeyValues, IProgressMonitor monitor, BiFunction<IProgressMonitor, Integer, IProgressMonitor> subprogressMonitorSupplier, boolean isChangesReport, boolean removeHidden) {
        RReport report = new RReport();
        int monitorTicks = 80;
        AnnotationResults annotationCreationDates = null;
        if (ovmProject.getIncludeCreationDate() || ovmProject.getRulesetConfiguration().getIncludeCreationDate()) {
            annotationCreationDates = VerissimoReportConverterCommon.buildCreationDates(ovmProject, subprogressMonitorSupplier.apply(monitor, monitorTicks /= 2));
        }
        VerissimoReportConverterCommon.buildLabelsSection(ovmProject, report);
        AnnotationResults annotationResults = VerissimoReportConverterCommon.buildAnnotationSection(ovmProject, subprogressMonitorSupplier.apply(monitor, monitorTicks), report);
        VerissimoReportConverterCommon.buildCategoriesChecksHitsEditsErrorsSection(ovmProject, annotationResults, annotationCreationDates, report, isChangesReport, removeHidden);
        VerissimoReportConverterCommon.buildWaiversSection(ovmProject, report);
        VerissimoReportConverterCommon.buildInfoSection(ovmProject, partialInfo, report);
        VerissimoReportConverterCommon.buildFilesSection(ovmProject, report);
        VerissimoReportConverterCommon.buildInfoKeyValuesSection(infoKeyValues, report);
        VerissimoReportConverterCommon.buildReportSection(ovmProject, report);
        return report;
    }

    private static void buildInfoSection(OVMProject ovmProject, String[] partialInfo, RReport report) {
        report.setCommonSegments(new MutableInt(0));
        ZonedDateTime date = LocalDateTime.now().atZone(ZoneId.systemDefault());
        RInfo infoWrapper = new RInfo.Builder().withVersion(partialInfo[0]).withUserName(System.getProperty("user.name", "DVT")).withDate(date.format(DateTimeFormatter.RFC_1123_DATE_TIME)).withRuleSet(String.valueOf(ovmProject.getRulesetName() == null ? ovmProject.getConfiguration().getRulesetKind().toString() : ovmProject.getRulesetName()) + " Report").withProject(partialInfo[1]).withCommonSegmentsInfo(ovmProject.getRulesetConfiguration().getIncludeHTMLCode() || ovmProject.getIncludeHTMLCode() ? Arrays.asList("0") : Arrays.asList("undefined")).withDataFilesSize("-1").withEffortEstimation(Boolean.toString(ovmProject.getRulesetConfiguration().getHasEffortEstimation())).withNofCompiledLines(ovmProject.getNofCompiledLines()).withNofCompiledLinesPerFile(ovmProject.getNofCompiledLinesPerFile()).withLintRunTime(ovmProject.getLintRunTime()).withBuildRunTime(ovmProject.getBuildRunTime()).withLicenseWaitTime(ovmProject.getLicenseWaitTime()).withTimedOutSession(ovmProject.fTimedOutSession).withTimedOutChecks(ovmProject.fTimedOutChecks).withCreationDate(ovmProject.getRulesetConfiguration().getIncludeCreationDate() || ovmProject.getIncludeCreationDate()).withUUID(UUID.randomUUID().toString()).withCommiterDate(ovmProject.getIncludeCodeDate() ? AnnotationGitProcessor.INSTANCE.getCommiterDate() : "").withCompilationErrors(ovmProject.hasCompilationErrors()).build();
        report.setInfoWrapper(infoWrapper);
    }

    private static AnnotationResults buildAnnotationSection(OVMProject ovmProject, IProgressMonitor monitor, RReport report) {
        ArrayList<Set<String>> annotationStrings = new ArrayList<Set<String>>();
        AnnotationManager annotationManager = ovmProject.getRulesetConfiguration().getAnnotationManager();
        AnnotationResults annotationResults = null;
        if (annotationManager != null) {
            annotationResults = annotationManager.process(ovmProject.getComplianceCategories(), monitor);
        }
        if (monitor.isCanceled()) {
            return null;
        }
        if (annotationResults != null) {
            AnnotationResults.AnnotationStrings[] annotationStringsArray = annotationResults.getStrings();
            int n = annotationStringsArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationResults.AnnotationStrings annotationString = annotationStringsArray[n2];
                LinkedHashSet<String> strings = new LinkedHashSet<String>();
                for (String string : annotationString.getStrings()) {
                    strings.add(string);
                }
                annotationStrings.add(strings);
                ++n2;
            }
        }
        if (annotationResults != null && annotationResults.getInfos() != null) {
            report.setAnnotationInfos(new LinkedList<AnnotationResults.AnnotationInfo>(Arrays.asList(annotationResults.getInfos())));
        }
        report.setAnnotationStrings(annotationStrings);
        if (report.getAnnotationInfos() != null) {
            int i = 0;
            while (i < report.getAnnotationInfos().size()) {
                if (report.getAnnotationInfos().get(i).getType() == AnnotationType.LABEL.ordinal()) {
                    LinkedHashSet labels = new LinkedHashSet();
                    report.getLabels().stream().forEach(x -> {
                        boolean bl = labels.add(x.getValue());
                    });
                    report.getAnnotationStrings().set(i, labels);
                    break;
                }
                ++i;
            }
        }
        return annotationResults;
    }

    private static AnnotationResults buildCreationDates(OVMProject ovmProject, IProgressMonitor monitor) {
        AnnotationResults annotationResult;
        AnnotationManager annotationManager;
        if (VerissimoReportConverterCommon.binaryExists("git")) {
            annotationManager = new AnnotationManager();
            annotationManager.addAnnotation(AnnotationType.GIT.name(), AnnotationType.GIT, Collections.emptySet(), AnnotationGitField.COMMITTER_TIME);
            annotationResult = annotationManager.process(ovmProject.getComplianceCategories(), monitor);
            if (annotationResult.getStrings().length > 0 && !annotationResult.getStrings()[0].getStrings().isEmpty()) {
                return annotationResult;
            }
        }
        if (VerissimoReportConverterCommon.binaryExists("p4")) {
            annotationManager = new AnnotationManager();
            annotationManager.addAnnotation(AnnotationType.P4.name(), AnnotationType.P4, Collections.emptySet(), AnnotationP4Field.DATE);
            annotationResult = annotationManager.process(ovmProject.getComplianceCategories(), monitor);
            if (annotationResult.getStrings().length > 0 && !annotationResult.getStrings()[0].getStrings().isEmpty()) {
                return annotationResult;
            }
        }
        if (VerissimoReportConverterCommon.binaryExists("svn")) {
            annotationManager = new AnnotationManager();
            annotationManager.addAnnotation(AnnotationType.SVN.name(), AnnotationType.SVN, Collections.emptySet(), AnnotationSvnField.DATE);
            annotationResult = annotationManager.process(ovmProject.getComplianceCategories(), monitor);
            if (annotationResult.getStrings().length > 0 && !annotationResult.getStrings()[0].getStrings().isEmpty()) {
                return annotationResult;
            }
        }
        if (VerissimoReportConverterCommon.binaryExists("cleartool")) {
            annotationManager = new AnnotationManager();
            annotationManager.addAnnotation(AnnotationType.CC.name(), AnnotationType.CC, Collections.emptySet(), AnnotationCcField.DATE);
            annotationResult = annotationManager.process(ovmProject.getComplianceCategories(), monitor);
            if (annotationResult.getStrings().length > 0 && !annotationResult.getStrings()[0].getStrings().isEmpty()) {
                return annotationResult;
            }
        }
        annotationManager = new AnnotationManager();
        annotationManager.addAnnotation(AnnotationType.FS.name(), AnnotationType.FS, Collections.emptySet(), AnnotationFsField.LAST_MODIFIED);
        annotationResult = annotationManager.process(ovmProject.getComplianceCategories(), monitor);
        return annotationResult;
    }

    private static boolean binaryExists(String name) {
        try {
            Runtime.getRuntime().exec(name);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void buildLabelsSection(OVMProject ovmProject, RReport report) {
        Set<RuleLabel> allLabels = RuleLabel.getLabelsFromCategories(ovmProject.getComplianceCategories());
        ArrayList<RuleLabel> labels = new ArrayList<RuleLabel>(allLabels);
        report.setLabels(labels);
    }

    private static void buildCategoriesChecksHitsEditsErrorsSection(OVMProject ovmProject, AnnotationResults annotationResults, AnnotationResults annotationCreationDates, RReport report, boolean isChangesReport, boolean removeHidden) {
        int checksIndex = -1;
        int categoriesIndex = -1;
        RHit.setHitCounter(0);
        RCheck.setCheckCounter(0);
        ArrayList<RCategory> rCategories = new ArrayList<RCategory>();
        ArrayList<RCheck> rChecks = new ArrayList<RCheck>();
        ArrayList<RHit> rHits = new ArrayList<RHit>();
        LinkedHashMap<IPath, Integer> paths = new LinkedHashMap<IPath, Integer>();
        ArrayList<OVMComplianceCategory> categories = ovmProject.getComplianceCategories();
        for (OVMComplianceCategory category : categories) {
            if (category.getChecks().isEmpty()) continue;
            RCategory rCategory = new RCategory(category.getName(), category.getDescription(), ++categoriesIndex);
            rCategories.add(rCategory);
            ArrayList<OVMComplianceCheck> checks = category.getChecks();
            for (OVMComplianceCheck check : checks) {
                ++checksIndex;
                boolean manualCheck = false;
                if (check instanceof OVMComplianceManualCheck) {
                    manualCheck = true;
                }
                RCheck rCheck = new RCheck(check.getName(), check.getTitle(), check.getVersion(), check.getLabels(), check.getFullDescription(), check.getEffort(), categoriesIndex, -1, check.getID(), check.getSeverity(), check.getRunTime(), check.isAutocorrectable(), manualCheck, check.isAutoCorrectEnabled());
                rCheck.setParameters(VerissimoReportConverterCommon.getReportParameters(check));
                rCheck.setAutocorrectParameters(VerissimoReportConverterCommon.getReportAutocorrectParameters(check));
                if (annotationResults != null) {
                    List<List<Integer>> annotationStringIndexesLists = annotationResults.getStringIndexes(check);
                    for (List<Integer> annotationStringIndexList : annotationStringIndexesLists) {
                        if (annotationStringIndexList == null || annotationStringIndexList.size() == 1 && annotationStringIndexList.get(0) == -1) {
                            rCheck.addAnnotationStringIndex(new ArrayList<Integer>());
                            continue;
                        }
                        rCheck.addAnnotationStringIndex(annotationStringIndexList);
                    }
                }
                rCategory.addCheck(rCheck);
                rChecks.add(rCheck);
                if (!check.isEnabled()) {
                    rCheck.setCheckStatus(CheckStatus.DISABLED.ordinal());
                    continue;
                }
                if (check instanceof OVMComplianceManualCheck) {
                    rCheck.setCheckStatus(((OVMComplianceManualCheck)check).getStatus().ordinal());
                    continue;
                }
                rCheck.setCheckStatus(CheckStatus.PASSED.ordinal());
                Map<String, Map<IFile, List<EditParameters>>> editsWithSignatures = VerissimoReportConverterCommon.createEditsWithSignatures(ovmProject, check);
                Map<String, VerissimoAutofixError> errorsWithSignatures = VerissimoReportConverterCommon.createErrorsWithSignatures(ovmProject, check);
                ArrayList<OVMComplianceCheckHit> hits = check.getAllHitsForRReport(isChangesReport);
                for (OVMComplianceCheckHit hit : hits) {
                    Set<String> hitCompareAnnotations;
                    List<List<Integer>> annotationStringIndexesLists;
                    List<OVMComplianceHit.DetailsLink> detailsLinks;
                    if (removeHidden && hit.isHidden() || isChangesReport && hit.getCompareAnnotations() != null && hit.getCompareAnnotations().contains("Common")) continue;
                    RHit rHit = new RHit(hit.getSeverity().ordinal(), checksIndex, VerissimoReportWriter.indexPath(paths, hit.getParserPath().path), hit.getLine(), hit.getDetails(), hit.getMacroPath(), hit.isFixed(), hit.isHidden());
                    rHits.add(rHit);
                    List<String[]> macroParts = hit.getMacroPathParts();
                    if (macroParts != null && !macroParts.isEmpty()) {
                        for (String[] macroPart : macroParts) {
                            int index = VerissimoReportWriter.indexPath(paths, macroPart[1]);
                            String file = "";
                            if (paths.size() > index) {
                                file = macroPart[1];
                            }
                            RHit.MacroPathWrapper macroPathWrapper = new RHit.MacroPathWrapper(macroPart[0], index, file, macroPart[2]);
                            rHit.addMacroPath(macroPathWrapper);
                        }
                    }
                    if ((detailsLinks = hit.getDetailsLinks()) != null && !detailsLinks.isEmpty()) {
                        for (OVMComplianceHit.DetailsLink detailsLink : detailsLinks) {
                            RHit.DetailsLinkWrapper detailsLinkWrapper = new RHit.DetailsLinkWrapper(detailsLink.offset, detailsLink.length, VerissimoReportWriter.indexPath(paths, detailsLink.file), detailsLink.line);
                            rHit.addDetailsLinkWrapper(detailsLinkWrapper);
                        }
                    }
                    rHit.addHitSources(0);
                    rHit.setFile(hit.getParserPath().path);
                    if (annotationResults != null) {
                        annotationStringIndexesLists = annotationResults.getStringIndexes(hit);
                        for (List<Integer> annotationStringIndexList : annotationStringIndexesLists) {
                            if (annotationStringIndexList == null || annotationStringIndexList.size() == 1 && annotationStringIndexList.get(0) == -1) {
                                rHit.addAnnotationStringIndex(new ArrayList<Integer>());
                                continue;
                            }
                            rHit.addAnnotationStringIndex(annotationStringIndexList);
                        }
                    }
                    rHit.populateAnnotationStringsValues(report.getAnnotationStrings());
                    if (annotationCreationDates != null) {
                        annotationStringIndexesLists = annotationCreationDates.getStringIndexes(hit);
                        List<Integer> annotationStringIndexList = annotationStringIndexesLists.get(0);
                        AnnotationResults.AnnotationStrings[] annotationStringsList = annotationCreationDates.getStrings();
                        if (annotationStringIndexList != null && (annotationStringIndexList.size() != 1 || annotationStringIndexList.get(0) != -1) && annotationStringsList.length > 0) {
                            Integer annotationStringIndex = annotationStringIndexList.get(0);
                            List<String> annotationStrings = annotationStringsList[0].getStrings();
                            if (annotationStringIndex != null && !annotationStrings.isEmpty()) {
                                String creationDate = annotationStrings.get(annotationStringIndex);
                                long timestamp = LocalDate.parse(creationDate, AnnotationField.DEFAULT_DATE_FORMATTER).atStartOfDay().toEpochSecond(ZoneOffset.UTC);
                                rHit.addCreationDate(timestamp);
                            }
                        }
                    }
                    if ((hitCompareAnnotations = hit.getCompareAnnotations()) != null) {
                        rHit.setCompareAnnotations(hitCompareAnnotations);
                    }
                    rCheck.addHit(rHit);
                    VerissimoReportConverterCommon.buildAutocorrectEdits(editsWithSignatures, check, rCheck, hit, rHit);
                    VerissimoReportConverterCommon.buildAutocorrectError(errorsWithSignatures, check, hit, rHit);
                }
            }
        }
        report.setCategories(rCategories);
        report.setChecks(rChecks);
        report.appendHits(rHits);
        report.setPaths(paths);
    }

    private static Map<String, Map<IFile, List<EditParameters>>> createEditsWithSignatures(OVMProject ovmProject, OVMComplianceCheck check) {
        if (!check.isAutocorrectable() || !check.isAutoCorrectEnabled()) {
            return null;
        }
        VerissimoAutofixResult result = ovmProject.getAutofixResult(check);
        if (result == null) {
            return null;
        }
        Map<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> edits = result.getEdits();
        if (edits == null) {
            return null;
        }
        HashMap<String, Map<IFile, List<EditParameters>>> editsWithSignatures = new HashMap<String, Map<IFile, List<EditParameters>>>();
        for (Map.Entry<OVMComplianceCheckHit, Map<IFile, List<EditParameters>>> entry : edits.entrySet()) {
            editsWithSignatures.put(entry.getKey().getSignature(), entry.getValue());
        }
        return editsWithSignatures;
    }

    private static Map<String, VerissimoAutofixError> createErrorsWithSignatures(OVMProject ovmProject, OVMComplianceCheck check) {
        if (!check.isAutocorrectable() || !check.isAutoCorrectEnabled()) {
            return null;
        }
        VerissimoAutofixResult result = ovmProject.getAutofixResult(check);
        if (result == null) {
            return null;
        }
        List<VerissimoAutofixError> errors = result.getErrors();
        if (errors == null) {
            return null;
        }
        HashMap<String, VerissimoAutofixError> errorsWithSignatures = new HashMap<String, VerissimoAutofixError>();
        for (VerissimoAutofixError error : errors) {
            errorsWithSignatures.put(error.getHit().getSignature(), error);
        }
        return errorsWithSignatures;
    }

    private static void buildAutocorrectEdits(Map<String, Map<IFile, List<EditParameters>>> edits, OVMComplianceCheck check, RCheck rCheck, OVMComplianceCheckHit hit, RHit rHit) {
        if (!check.isAutocorrectable() || !check.isAutoCorrectEnabled() || edits == null || hit == null) {
            return;
        }
        Map<IFile, List<EditParameters>> changesInAllFiles = edits.get(hit.getSignature());
        if (changesInAllFiles == null) {
            return;
        }
        ArrayList<REdit> allEdits = new ArrayList<REdit>();
        for (Map.Entry<IFile, List<EditParameters>> entry : changesInAllFiles.entrySet()) {
            IFile file = entry.getKey();
            String filename = file.getLocation().toOSString();
            List<EditParameters> editParametersLst = entry.getValue();
            allEdits.addAll(editParametersLst.stream().map(editParameters -> new REdit(rCheck, rHit, filename, (EditParameters)editParameters)).collect(Collectors.toList()));
        }
        rHit.setAutocorrectEdits(allEdits);
        rCheck.addAutocorrectEdits(allEdits);
    }

    private static void buildAutocorrectError(Map<String, VerissimoAutofixError> errors, OVMComplianceCheck check, OVMComplianceCheckHit hit, RHit rHit) {
        String additionalInfo;
        if (!check.isAutocorrectable() || !check.isAutoCorrectEnabled() || errors == null || hit == null) {
            return;
        }
        VerissimoAutofixError error = errors.get(hit.getSignature());
        if (error == null) {
            return;
        }
        String reason = error.getReason();
        if (reason == null || reason.isEmpty()) {
            reason = "internal error";
        }
        if ((additionalInfo = error.getAdditionalInformation()) == null) {
            additionalInfo = "";
        }
        rHit.setAutocorrectError(new RError(rHit, reason, additionalInfo));
    }

    private static void buildFilesSection(OVMProject ovmProject, RReport report) {
        HashSet<ParserPath> allImportedFiles = ovmProject.getAllImportedFiles();
        LinkedHashMap<String, Set<RCheck>> preWaivedFilesToCheckMap = new LinkedHashMap<String, Set<RCheck>>();
        LinkedHashMap<String, String> allFilesHashesMap = new LinkedHashMap<String, String>();
        List<RCheck> allChecks = report.getChecks();
        for (ParserPath parserPath : allImportedFiles) {
            String file;
            if (parserPath == null || (file = parserPath.path) == null || file.indexOf("__vlog__") != -1) continue;
            String hash = parserPath.getMd5() == null ? "NULLHASH" : DVTStringUtil.bytes2hex((byte[])parserPath.getMd5()).toUpperCase();
            allFilesHashesMap.put(file, hash);
            LinkedHashSet<RCheck> prewaivedFileForChecks = new LinkedHashSet<RCheck>();
            for (RCheck check : allChecks) {
                if ("NONEXISTENT_ID_ERROR".equals(check.getCheckID())) continue;
                OVMComplianceCheck ovmComplicanceCheck = ovmProject.getCheck(check.getCheckName());
                if (!ovmProject.getProjectWaivers().pathIsPrewaived(new ParserPath(file), ovmComplicanceCheck)) continue;
                prewaivedFileForChecks.add(check);
            }
            preWaivedFilesToCheckMap.put(file, prewaivedFileForChecks);
        }
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        for (IPath path : report.getPaths().keySet()) {
            String pathOS = path.toOSString();
            files.add(pathOS);
            if (allFilesHashesMap.containsKey(pathOS) || pathOS.equals("none")) continue;
            ParserPath parserPath = new ParserPath(pathOS);
            String hash = parserPath.getMd5() == null ? "NULLHASH" : DVTStringUtil.bytes2hex((byte[])parserPath.getMd5()).toUpperCase();
            allFilesHashesMap.put(pathOS, hash);
        }
        report.setFiles(files);
        report.setAllFilesHashesMap(allFilesHashesMap);
        report.setPrewaivedFilesForChecks(preWaivedFilesToCheckMap);
    }

    private static void buildInfoKeyValuesSection(List<String> infoKeyValues, RReport report) {
        report.setInfoKeyValues(infoKeyValues);
    }

    private static void buildWaiversSection(OVMProject ovmProject, RReport report) {
        ArrayList<RWaiver> rWaivers = new ArrayList<RWaiver>();
        ArrayList<RPreWaiver> rPreWaivers = new ArrayList<RPreWaiver>();
        if (ovmProject.getProjectWaivers() == null) {
            return;
        }
        List<PostWaiver> postWaivers = ovmProject.getProjectWaivers().getPostWaivers();
        if (postWaivers == null) {
            return;
        }
        for (PostWaiver postWaiver : postWaivers) {
            ArrayList<RHit> rWaivedFailures = new ArrayList<RHit>();
            LinkedList<String> messagePatterns = new LinkedList<String>();
            for (OVMComplianceCheckHit hit : postWaiver.getWaivedFailures()) {
                RHit rHit = new RHit(hit.getSeverity().ordinal(), 0, 0, hit.getLine(), hit.getDetails(), hit.getMacroPath(), false, hit.isHidden());
                rHit.setFile(hit.getParserPath().path);
                rHit.setCheckName(hit.getCheck().getName());
                rWaivedFailures.add(rHit);
            }
            for (MessagePattern messagePattern : postWaiver.getMessagePatterns()) {
                String pattern = messagePattern.toString();
                messagePatterns.add(pattern);
            }
            RWaiver rWaiver = new RWaiver(postWaiver.getName(), postWaiver.getDescription(), postWaiver.getStatus().name(), postWaiver.getApplyOn(), postWaiver.getPathsApplyOn(), postWaiver.getCheckNames(), postWaiver.getPathRegexType(), postWaiver.getRawPaths(), postWaiver.getElements(), postWaiver.getLineRanges(), postWaiver.getMessageRegexType(), messagePatterns, postWaiver.getFilePath(), rWaivedFailures, postWaiver.getLineNoInXMLFile());
            rWaivers.add(rWaiver);
        }
        report.setPostWaivers(rWaivers);
        List<PreWaiver> preWaivers = ovmProject.getProjectWaivers().getPreWaivers();
        if (preWaivers == null) {
            return;
        }
        for (PreWaiver preWaiver : preWaivers) {
            RPreWaiver rPreWaiver = new RPreWaiver(preWaiver.getName(), preWaiver.getDescription(), preWaiver.getApplyOn(), preWaiver.getPathsApplyOn(), preWaiver.getType().name(), preWaiver.getCheckNames(), preWaiver.getPathRegexType(), preWaiver.getRawPaths(), preWaiver.getElements(), preWaiver.getFilePath(), preWaiver.getPrewaivedFiles());
            rPreWaivers.add(rPreWaiver);
        }
        report.setPreWaivers(rPreWaivers);
    }

    private static void buildReportSection(OVMProject ovmProject, RReport report) {
        String buildConfigFullPath = VerissimoReportConverter.getBuildConfigFullPath(ovmProject);
        report.setBuildFile(buildConfigFullPath);
        report.setWaiversFile(ovmProject.getProjectWaivers().getWaiversFile());
        report.setBaselineReportLocation(ovmProject.getConfiguration().getBaselineReportLocation());
        if (ovmProject.getConfiguration().getRulesetKind() == RulesetKind.IMPORT_FROM_HTML && ovmProject.getTempRulesetkind() != null) {
            report.setRulesetKind(ovmProject.getTempRulesetkind());
            if (ovmProject.getTempRulesetkind().isPredefined()) {
                URL url = OVMUtils.getDefaultRulesetURL(ovmProject.getTempRulesetkind());
                report.setRulesetFile(url.getFile());
            } else {
                report.setRulesetFile(ovmProject.getRulesetFile());
            }
        } else {
            report.setRulesetKind(ovmProject.getConfiguration().getRulesetKind());
            report.setRulesetFile(ovmProject.getRulesetFile());
        }
    }

    private static List<List<String>> getReportParameters(OVMComplianceCheck check) {
        ArrayList<List<String>> parameters = new ArrayList<List<String>>();
        Map<String, String> parameterUserValues = check.getProperties();
        for (Map<String, String> parameter : check.getParametersToDisplay()) {
            String parameterName = parameter.get("name");
            String parameterDescription = parameter.get("description");
            String parameterDefaultValue = parameter.get("defaultValue");
            String parameterValue = parameterUserValues.get(parameterName);
            parameters.add(Arrays.asList(parameterName, parameterDescription, parameterDefaultValue, parameterValue));
        }
        return parameters;
    }

    private static List<List<String>> getReportAutocorrectParameters(OVMComplianceCheck check) {
        ArrayList<List<String>> parameters = new ArrayList<List<String>>();
        Map<String, String> parameterUserValues = check.getAutoCorrectInput();
        for (Map<String, String> parameter : check.getAutocorrectParametersToDisplay()) {
            String parameterName = parameter.get("name");
            String parameterDescription = parameter.get("description");
            String parameterDefaultValue = parameter.get("defaultValue");
            String parameterValue = parameterUserValues.get(parameterName);
            parameters.add(Arrays.asList(parameterName, parameterDescription, parameterDefaultValue, parameterValue));
        }
        return parameters;
    }
}

