/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;
import ro.amiq.vlogdt.linter.annotations.AnnotationType;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.report.model.RCategory;
import ro.amiq.vlogdt.linter.report.model.RCheck;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.report.model.RPreWaiver;
import ro.amiq.vlogdt.linter.report.model.RReport;
import ro.amiq.vlogdt.linter.report.model.RWaiver;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.waivers.LineRange;
import ro.amiq.vlogdt.linter.waivers.WaiverType;

public class VerissimoReportReader {
    public static final List<Integer> MERGED_REPORT_ANNOTATION_LOCATIONS = Arrays.asList(0, 1, 2, 3);
    private static final int ABBREVIATION_SIZE = 200;
    private static final int EXTRA_COMPARE_INFO_NO = 4;

    public static RReport readReportFiles(String location) throws IOException, JSONException {
        RHit.setHitCounter(0);
        RCheck.setCheckCounter(0);
        RReport reportInfo = VerissimoReportReader.readReportInfo(new File(location, "js/data0.js"));
        File additionalInfoFile = new File(location, "verissimo.html.report");
        VerissimoReportReader.readAdditionalInfo(reportInfo, additionalInfoFile);
        File verissimoInfo = new File(location, "verissimo.info");
        Map<String, String> annotationsFromFile = VerissimoReportReader.readAnnotationsFromFile(verissimoInfo);
        Set<Map.Entry<String, String>> entrySet = annotationsFromFile.entrySet();
        int nofAnnotationsFromFile = 0;
        for (Map.Entry<String, String> entry : entrySet) {
            String title = entry.getKey();
            String value = entry.getValue();
            List<AnnotationResults.AnnotationInfo> haInfo = reportInfo.getAnnotationInfos();
            if (haInfo.stream().anyMatch(x -> x.getTitle().equals(title))) {
                List<Set<String>> haStrings = reportInfo.getAnnotationStrings();
                int i = 0;
                for (AnnotationResults.AnnotationInfo infoKey : haInfo) {
                    if (infoKey.getTitle().equals(title)) {
                        Set<String> strings = haStrings.get(i);
                        strings.add(value);
                    }
                    ++i;
                }
            } else {
                ++nofAnnotationsFromFile;
                reportInfo.addAnnotationString(new LinkedHashSet<String>(Arrays.asList(value)));
            }
            reportInfo.addAnnotationInfo(title, new HashSet<Integer>(MERGED_REPORT_ANNOTATION_LOCATIONS), AnnotationType.TAG.ordinal());
        }
        int noOfHitsFiles = Integer.parseInt(reportInfo.getInfoWrapper().getDataFilesSize());
        int i = 1;
        while (i <= noOfHitsFiles) {
            File dataFile = new File(location, "js/data" + i + ".js");
            if (dataFile.exists()) {
                List<RHit> readReportHits = VerissimoReportReader.readReportHits(dataFile, reportInfo, nofAnnotationsFromFile, annotationsFromFile);
                reportInfo.appendHits(readReportHits);
            }
            ++i;
        }
        reportInfo.setLocation(location);
        return reportInfo;
    }

    private static Map<String, String> readAnnotationsFromFile(File verissimoInfo) throws FileNotFoundException, IOException {
        LinkedHashMap<String, String> annotationMappings = new LinkedHashMap<String, String>();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(verissimoInfo));){
                String inputLine;
                while ((inputLine = bufferedReader.readLine()) != null) {
                    String[] keyValuePair = inputLine.split("=");
                    if (keyValuePair == null || keyValuePair.length != 2) continue;
                    annotationMappings.put(keyValuePair[0].trim(), keyValuePair[1].trim());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return annotationMappings;
    }

    private static List<RHit> readReportHits(File dataX, RReport report, int noOfAnnotationsFromFile, Map<String, String> annotationsFromFile) throws FileNotFoundException, IOException, JSONException {
        ArrayList<RHit> populateHits = new ArrayList();
        List<RCheck> checks = report.getChecks();
        Set<String> files = report.getFiles();
        List<Set<String>> haStrings = report.getAnnotationStrings();
        Throwable throwable = null;
        Object var9_10 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(dataX));){
            String inputLine;
            StringBuilder hitsSB = new StringBuilder();
            while ((inputLine = bufferedReader.readLine()) != null) {
                if ("VerissimoData.hits = VerissimoData.hits.concat([".equals(inputLine)) {
                    hitsSB.append("[");
                    continue;
                }
                if ("]);".equals(inputLine)) {
                    hitsSB.append("]");
                    break;
                }
                hitsSB.append(inputLine);
            }
            JSONArray arr = new JSONArray(hitsSB.toString());
            populateHits = VerissimoReportReader.populateHits(report, arr, checks, files, noOfAnnotationsFromFile, haStrings, annotationsFromFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return populateHits;
    }

    private static List<RHit> populateHits(RReport report, JSONArray arr, List<RCheck> checks, Set<String> files, int noOfAnnotationsFromFile, List<Set<String>> annotationStrings, Map<String, String> annotationsFromFile) throws JSONException {
        ArrayList<RHit> hits = new ArrayList<RHit>();
        int maxFileCode = Integer.MIN_VALUE;
        int i = 0;
        while (i < arr.length()) {
            Set<String> set;
            JSONArray hitArr = arr.getJSONArray(i);
            int hitSeverity = hitArr.getInt(0);
            int checkIndex = hitArr.getInt(1);
            int indexPath = hitArr.getInt(2);
            int hitLine = hitArr.getInt(3);
            String hitDetails = VerissimoReportReader.unescAmpersand(hitArr.getString(5));
            boolean isFixed = false;
            Object sixthValue = hitArr.get(6);
            if (sixthValue instanceof Boolean) {
                isFixed = (Boolean)sixthValue;
            }
            RHit hit = new RHit(hitSeverity, checkIndex, indexPath, hitLine, hitDetails, null, isFixed, false);
            if (files.size() > indexPath) {
                hit.setFile((String)files.toArray()[indexPath]);
            }
            JSONArray macroPartsArr = hitArr.getJSONArray(4);
            int j = 0;
            while (j < macroPartsArr.length()) {
                JSONArray macroPart = macroPartsArr.getJSONArray(j);
                String macroName = macroPart.getString(0);
                int index = macroPart.getInt(1);
                String file = "";
                if (files.size() > index) {
                    file = (String)files.toArray()[index];
                }
                String line = macroPart.getString(2);
                hit.addMacroPath(new RHit.MacroPathWrapper(macroName, index, file, line));
                ++j;
            }
            JSONArray detailsLinkArr = hitArr.getJSONArray(6);
            int j2 = 0;
            while (j2 < detailsLinkArr.length()) {
                JSONArray detailLink = detailsLinkArr.getJSONArray(j2);
                int offset = detailLink.getInt(0);
                int length = detailLink.getInt(1);
                int index = detailLink.getInt(2);
                String line = detailLink.getString(3);
                hit.addDetailsLinkWrapper(new RHit.DetailsLinkWrapper(offset, length, index, line));
                ++j2;
            }
            JSONArray hitSourcesArr = hitArr.getJSONArray(7);
            int j3 = 0;
            while (j3 < hitSourcesArr.length()) {
                int hitSource = hitSourcesArr.getInt(j3);
                hit.addHitSources(hitSource);
                maxFileCode = Math.max(maxFileCode, hitSource);
                ++j3;
            }
            hit.addCreationDate(hitArr.optLong(8));
            JSONArray compareAnnotationsIndexesArr = hitArr.optJSONArray(9);
            if (compareAnnotationsIndexesArr != null) {
                int j4 = 0;
                while (j4 < compareAnnotationsIndexesArr.length()) {
                    int compareAnnotationsIndex = compareAnnotationsIndexesArr.getInt(j4);
                    hit.addCompareAnnotationBasedOnIndex(compareAnnotationsIndex);
                    ++j4;
                }
            }
            int compareHitOrigin = hitArr.optInt(11);
            hit.setCompareHitOriginBasedOnIndex(compareHitOrigin);
            int currentStringPosition = 0;
            int j5 = 12;
            while (j5 < hitArr.length()) {
                set = annotationStrings.get(currentStringPosition);
                ArrayList<Integer> annotationIndexes = new ArrayList<Integer>();
                ArrayList<String> annotationStringValues = new ArrayList<String>();
                JSONArray hitIndexesJSONArray = hitArr.getJSONArray(j5);
                int k = 0;
                while (k < hitIndexesJSONArray.length()) {
                    int index = hitIndexesJSONArray.getInt(k);
                    if (!set.isEmpty() && index < set.size()) {
                        annotationStringValues.add((String)set.toArray()[index]);
                    } else {
                        annotationStringValues.add("");
                    }
                    annotationIndexes.add(index);
                    ++k;
                }
                hit.addAnnotationStringsValues(annotationStringValues);
                hit.addAnnotationStringIndex(annotationIndexes);
                ++currentStringPosition;
                ++j5;
            }
            j5 = 0;
            while (j5 < noOfAnnotationsFromFile) {
                set = annotationStrings.get(currentStringPosition);
                if (set != null && !set.isEmpty()) {
                    String string = (String)set.toArray()[0];
                    ArrayList<Integer> annotationIndexes = new ArrayList<Integer>();
                    ArrayList<String> annotationStringValues = new ArrayList<String>();
                    annotationIndexes.add(0);
                    annotationStringValues.add(string);
                    hit.addAnnotationStringsValues(annotationStringValues);
                    hit.addAnnotationStringIndex(annotationIndexes);
                    ++currentStringPosition;
                }
                ++j5;
            }
            for (Map.Entry<String, String> entry : annotationsFromFile.entrySet()) {
                String title = entry.getKey();
                String value = entry.getValue();
                List<AnnotationResults.AnnotationInfo> annotationInfos = report.getAnnotationInfos();
                if (!annotationInfos.stream().anyMatch(x -> x.getTitle().equals(title))) continue;
                int indexOfAnnotationTitle = -1;
                for (AnnotationResults.AnnotationInfo key : annotationInfos) {
                    ++indexOfAnnotationTitle;
                    if (key.getTitle().equals(title)) break;
                }
                List<List<String>> annotationStringValues = hit.getAnnotationStringsValues();
                annotationStringValues.get(indexOfAnnotationTitle).add(value);
                Set<String> setOfValues = report.getAnnotationStrings().get(indexOfAnnotationTitle);
                int indexOfAnnotationValue = new ArrayList<String>(setOfValues).indexOf(value);
                if (indexOfAnnotationValue == -1) continue;
                hit.getAnnotationStringIndexes().get(indexOfAnnotationTitle).add(indexOfAnnotationValue);
            }
            checks.get(checkIndex).addHit(hit);
            hits.add(hit);
            ++i;
        }
        report.setMaxSourceCode(maxFileCode);
        return hits;
    }

    /*
     * Exception decompiling
     */
    public static RReport readReportInfo(File data0) throws IOException, JSONException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[0, 1, 14] lbl136 : CaseStatement: default:\u000a, @NONE, blocks:[0, 1, 14] lbl136 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, Integer> getNofCompiledLinesPerFile(StringBuilder filesSB, List<String> fileNames) throws JSONException {
        HashMap<String, Integer> nofCompiledLinesPerFile = new HashMap<String, Integer>();
        JSONArray arr = new JSONArray(filesSB.toString());
        int i = 0;
        while (i < arr.length()) {
            if (arr.get(i) instanceof JSONArray) {
                JSONArray fileInfo = (JSONArray)arr.get(i);
                String filename = fileInfo.optString(0);
                int indexInAllFiles = fileInfo.optInt(0, -1);
                if (indexInAllFiles != -1) {
                    filename = fileNames.get(indexInAllFiles);
                }
                nofCompiledLinesPerFile.put(filename, fileInfo.optInt(2));
            }
            if (arr.get(i) instanceof String) {
                nofCompiledLinesPerFile.put((String)arr.get(i), 0);
            }
            ++i;
        }
        return nofCompiledLinesPerFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readExtraCompareInfoFile(String location) throws FileNotFoundException, IOException {
        File file = new File(location, "compare.info");
        if (file == null) return null;
        if (!file.exists()) return null;
        if (!file.isFile()) {
            return null;
        }
        String[] extraCompareInfo = new String[4];
        Throwable throwable = null;
        Object var5_5 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String inputLine = bufferedReader.readLine();
            if (inputLine == null) return null;
            if (!inputLine.equals("var compareData = [")) {
                return null;
            }
            int i = 0;
            while (true) {
                if (i >= 4) {
                    return extraCompareInfo;
                }
                inputLine = bufferedReader.readLine();
                extraCompareInfo[i] = inputLine.substring(1, inputLine.length() - 2);
                ++i;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private static void parseReportFile(BufferedReader bufferedReader, StringBuilder sb) throws IOException {
        String inputLine;
        sb.append("[");
        while ((inputLine = bufferedReader.readLine()) != null) {
            if ("],".equals(inputLine)) {
                sb.append("]");
                break;
            }
            sb.append(inputLine);
        }
    }

    private static List<RCategory> populateCateogies(JSONArray arr) throws JSONException {
        ArrayList<RCategory> categories = new ArrayList<RCategory>();
        JSONArray categoryArr = new JSONArray();
        try {
            int i = 0;
            while (i < arr.length()) {
                categoryArr = arr.getJSONArray(i);
                String categoryName = categoryArr.getString(0);
                String categoryDescription = categoryArr.getString(1);
                RCategory category = new RCategory(categoryName, categoryDescription, i);
                categories.add(category);
                ++i;
            }
        }
        catch (JSONException jSONException) {
            throw new JSONException("The Categories section may contain incorrect data on line: \n" + StringUtils.abbreviate((String)categoryArr.toString(), (int)200));
        }
        return categories;
    }

    private static List<RCheck> populateChecks(JSONArray arr, List<RCategory> categories, List<RuleLabel> allLabels) throws JSONException {
        ArrayList<RCheck> checks = new ArrayList<RCheck>();
        JSONArray checkArr = new JSONArray();
        try {
            int i = 0;
            while (i < arr.length()) {
                JSONArray autocorrectParametersArr;
                JSONArray parametersArr;
                checkArr = arr.getJSONArray(i);
                String checkName = checkArr.getString(0);
                String checkTitle = checkArr.getString(1);
                String checkDescription = checkArr.getString(2);
                int checkEffort = checkArr.getInt(3);
                int categoryIndex = checkArr.getInt(4);
                int checkStatus = checkArr.getInt(5);
                String checkID = checkArr.getString(7);
                int checkSeverity = checkArr.getInt(8);
                long checkRunTime = checkArr.getLong(9);
                int checkAutocorrectable = checkArr.optInt(10);
                int checkManualCheck = checkArr.optInt(11);
                int hasAutocorrectEnabled = checkArr.optInt(12);
                JSONArray checkLabelsIndexArray = checkArr.optJSONArray(16);
                Set<RuleLabel> checkLabels = VerissimoReportReader.getLabelsForCheck(allLabels, checkLabelsIndexArray);
                RCheck check = new RCheck(checkName, checkTitle, null, checkLabels, checkDescription, checkEffort, categoryIndex, checkStatus, checkID, checkSeverity == -1 ? null : CheckStatus.getCheckStatus(checkSeverity), checkRunTime, checkAutocorrectable == 1, checkManualCheck == 1, hasAutocorrectEnabled == 1);
                JSONArray compareAnnotationsIndexesArr = checkArr.optJSONArray(13);
                if (compareAnnotationsIndexesArr != null) {
                    int j = 0;
                    while (j < compareAnnotationsIndexesArr.length()) {
                        int compareAnnotationsIndex = compareAnnotationsIndexesArr.getInt(j);
                        check.addCompareAnnotationBasedOnIndex(compareAnnotationsIndex);
                        ++j;
                    }
                }
                if ((parametersArr = checkArr.optJSONArray(14)) != null) {
                    int j = 0;
                    while (j + 3 < parametersArr.length()) {
                        String parameterName = parametersArr.getString(j);
                        String parameterDescription = parametersArr.getString(j + 1);
                        String parameterDefaultValue = parametersArr.getString(j + 2);
                        String parameterUserValue = parametersArr.getString(j + 3);
                        check.addParameter(Arrays.asList(parameterName, parameterDescription, parameterDefaultValue, parameterUserValue));
                        j += 4;
                    }
                }
                if ((autocorrectParametersArr = checkArr.optJSONArray(15)) != null) {
                    int j = 0;
                    while (j + 3 < autocorrectParametersArr.length()) {
                        String parameterName = autocorrectParametersArr.getString(j);
                        String parameterDescription = autocorrectParametersArr.getString(j + 1);
                        String parameterDefaultValue = autocorrectParametersArr.getString(j + 2);
                        String parameterUserValue = autocorrectParametersArr.getString(j + 3);
                        check.addAutocorrectParameter(Arrays.asList(parameterName, parameterDescription, parameterDefaultValue, parameterUserValue));
                        j += 4;
                    }
                }
                categories.get(categoryIndex).addCheck(check);
                checks.add(check);
                ++i;
            }
        }
        catch (JSONException jSONException) {
            throw new JSONException("The Checks section may contain incorrect data on line: \n" + StringUtils.abbreviate((String)checkArr.toString(), (int)200));
        }
        return checks;
    }

    private static Set<RuleLabel> getLabelsForCheck(List<RuleLabel> allLabels, JSONArray checkLabelsArray) throws JSONException {
        LinkedHashSet<RuleLabel> checkLabels = new LinkedHashSet<RuleLabel>();
        if (checkLabelsArray == null) {
            return checkLabels;
        }
        int indexLabel = 0;
        while (indexLabel < checkLabelsArray.length()) {
            RuleLabel ruleLabel;
            int labelIndex = checkLabelsArray.getInt(indexLabel);
            if (labelIndex <= allLabels.size() && (ruleLabel = allLabels.get(labelIndex)) != null) {
                checkLabels.add(ruleLabel);
            }
            ++indexLabel;
        }
        return checkLabels;
    }

    private static Set<String> populateFiles(JSONArray arr, List<RCheck> checks, List<String> fileNames, RReport reportInfo) throws JSONException {
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        int i = 0;
        while (i < arr.length()) {
            try {
                JSONArray fileInfo = arr.getJSONArray(i);
                String filename = fileInfo.optString(0);
                int indexInAllFiles = fileInfo.optInt(0, -1);
                if (indexInAllFiles != -1) {
                    filename = fileNames.get(indexInAllFiles);
                }
                files.add(filename);
                JSONArray checksArr = fileInfo.getJSONArray(1);
                LinkedHashSet<RCheck> prewaivedCheckForFile = new LinkedHashSet<RCheck>();
                int j = 0;
                while (j < checksArr.length()) {
                    int checkIndex = checksArr.getInt(j);
                    RCheck check = checks.get(checkIndex);
                    prewaivedCheckForFile.add(check);
                    ++j;
                }
                reportInfo.putFilePrewaivedFilesForChecks(filename, prewaivedCheckForFile);
            }
            catch (JSONException jSONException) {
                try {
                    files.add(arr.getString(i));
                }
                catch (JSONException jSONException2) {
                    throw new JSONException("The Files section may contain incorrect data on line: \n" + StringUtils.abbreviate((String)arr.toString(), (int)200));
                }
            }
            ++i;
        }
        return files;
    }

    private static LinkedList<LinkedHashMap<String, String>> populateAllFiles(JSONArray arr, List<RCheck> checks, RReport reportInfo) throws JSONException {
        LinkedHashMap<String, String> allFilesHashesMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> allBaselineFilesHashesMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> allFilesWithBaselineFilesMap = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < arr.length()) {
            try {
                JSONArray fileInfo = arr.getJSONArray(i);
                String filename = fileInfo.getString(0);
                JSONArray checksArr = fileInfo.getJSONArray(1);
                LinkedHashSet<RCheck> prewaivedCheckForFile = new LinkedHashSet<RCheck>();
                int j = 0;
                while (j < checksArr.length()) {
                    int checkIndex = checksArr.getInt(j);
                    RCheck check = checks.get(checkIndex);
                    prewaivedCheckForFile.add(check);
                    ++j;
                }
                reportInfo.putFilePrewaivedFilesForChecks(filename, prewaivedCheckForFile);
                String hash = fileInfo.optString(2);
                allFilesHashesMap.put(filename, hash);
                String baselineHash = fileInfo.optString(3);
                String baselineFilename = fileInfo.optString(4);
                if (baselineFilename.isEmpty()) {
                    baselineFilename = filename;
                }
                if (baselineHash != null && !baselineHash.isEmpty() && baselineFilename != null && !baselineFilename.isEmpty()) {
                    allBaselineFilesHashesMap.put(baselineFilename, baselineHash);
                    allFilesWithBaselineFilesMap.put(filename, baselineFilename);
                }
            }
            catch (JSONException jSONException) {
                try {
                    allFilesHashesMap.put(arr.getString(i), "");
                }
                catch (JSONException jSONException2) {
                    throw new JSONException("The All Files section may contain incorrect data on line: \n" + StringUtils.abbreviate((String)arr.toString(), (int)200));
                }
            }
            ++i;
        }
        return new LinkedList<LinkedHashMap<String, String>>(Arrays.asList(allFilesHashesMap, allBaselineFilesHashesMap, allFilesWithBaselineFilesMap));
    }

    private static List<RWaiver> populateWaivers(JSONArray arr) throws JSONException {
        ArrayList<RWaiver> waivers = new ArrayList<RWaiver>();
        JSONArray waiverArr = new JSONArray();
        JSONArray tempArr = new JSONArray();
        try {
            int i = 0;
            while (i < arr.length()) {
                waiverArr = arr.getJSONArray(i);
                String waiverName = waiverArr.getString(0);
                String waiverDescription = waiverArr.getString(1);
                String waiverStatus = waiverArr.getString(2);
                int waiverApplyOn = waiverArr.getInt(3);
                String waiverChecks = waiverArr.getString(4);
                int waiverPathRegexType = waiverArr.getInt(5);
                String waiverPaths = waiverArr.getString(6);
                String waiverLineRanges = waiverArr.getString(7);
                int waiverMessageRegexType = waiverArr.getInt(8);
                String waiverMessagePatterns = waiverArr.getString(9);
                String waiverFile = waiverArr.getString(10);
                String waiverElements = waiverArr.optString(11);
                int waiverLineNoInXMLFile = waiverArr.optInt(12);
                int waiverPathsApplyOn = waiverArr.optInt(13, 1);
                tempArr = new JSONArray(waiverChecks);
                ArrayList<String> checkNames = new ArrayList<String>();
                int j = 0;
                while (j < tempArr.length()) {
                    checkNames.add(tempArr.getString(j));
                    ++j;
                }
                tempArr = new JSONArray(waiverPaths);
                ArrayList<String> paths = new ArrayList<String>();
                int j2 = 0;
                while (j2 < tempArr.length()) {
                    paths.add(tempArr.getString(j2));
                    ++j2;
                }
                tempArr = new JSONArray(waiverElements);
                HashMap<String, String> elements = new HashMap<String, String>();
                JSONArray elementsArr = new JSONArray();
                int j3 = 0;
                while (j3 < tempArr.length()) {
                    elementsArr = tempArr.getJSONArray(j3);
                    String elementType = elementsArr.getString(0);
                    String elementName = "";
                    if (elementsArr.length() >= 2) {
                        elementName = elementsArr.getString(1);
                    }
                    elements.put(elementType, elementName);
                    ++j3;
                }
                tempArr = new JSONArray(waiverLineRanges);
                ArrayList<LineRange> lineRanges = new ArrayList<LineRange>();
                int j4 = 0;
                while (j4 < tempArr.length()) {
                    lineRanges.add(new LineRange(tempArr.getString(j4), false));
                    ++j4;
                }
                tempArr = new JSONArray(waiverMessagePatterns);
                ArrayList<String> messagePatterns = new ArrayList<String>();
                int j5 = 0;
                while (j5 < tempArr.length()) {
                    messagePatterns.add(tempArr.getString(j5));
                    ++j5;
                }
                String waiverApplyOnValue = waiverApplyOn == 1 ? "matched" : "not-matched";
                String waiverPathRegexTypeValue = waiverPathRegexType == 1 ? "perl" : "simple";
                String waiverMessageRegexTypeValue = waiverMessageRegexType == 1 ? "perl" : "simple";
                String waiverPathsApplyOnValue = waiverPathsApplyOn == 1 ? "matched" : "not-matched";
                RWaiver waiver = new RWaiver(waiverName, waiverDescription, waiverStatus, waiverApplyOnValue, waiverPathsApplyOnValue, checkNames, waiverPathRegexTypeValue, paths, elements, lineRanges, waiverMessageRegexTypeValue, messagePatterns, waiverFile, new ArrayList<RHit>(), waiverLineNoInXMLFile);
                waivers.add(waiver);
                ++i;
            }
        }
        catch (JSONException jSONException) {
            throw new JSONException("The Waivers section may contain incorrect data on line: \n" + StringUtils.abbreviate((String)waiverArr.toString(), (int)200));
        }
        return waivers;
    }

    private static List<RPreWaiver> populatePreWaivers(JSONArray arr, List<String> fileNames) throws JSONException {
        ArrayList<RPreWaiver> prewaivers = new ArrayList<RPreWaiver>();
        JSONArray prewaiverArr = new JSONArray();
        try {
            int i = 0;
            while (i < arr.length()) {
                prewaiverArr = arr.getJSONArray(i);
                String prewaiverName = prewaiverArr.getString(0);
                String prewaiverDescription = prewaiverArr.getString(1);
                int prewaiverApplyOn = prewaiverArr.getInt(2);
                String prewaiverChecks = prewaiverArr.getString(3);
                int prewaiverPathRegexType = prewaiverArr.getInt(4);
                String prewaiverPaths = prewaiverArr.getString(5);
                String prewaiverElements = prewaiverArr.getString(6);
                String waiverFile = prewaiverArr.getString(7);
                String prewaivedFilesString = prewaiverArr.optString(8);
                int prewaiverType = prewaiverArr.optInt(9);
                int prewaiverPathsApplyOn = prewaiverArr.optInt(10, 1);
                prewaiverArr = new JSONArray(prewaiverChecks);
                ArrayList<String> checkNames = new ArrayList<String>();
                int j = 0;
                while (j < prewaiverArr.length()) {
                    checkNames.add(prewaiverArr.getString(j));
                    ++j;
                }
                prewaiverArr = new JSONArray(prewaiverPaths);
                ArrayList<String> paths = new ArrayList<String>();
                int j2 = 0;
                while (j2 < prewaiverArr.length()) {
                    paths.add(prewaiverArr.getString(j2));
                    ++j2;
                }
                prewaiverArr = new JSONArray(prewaiverElements);
                HashMap<String, String> elements = new HashMap<String, String>();
                JSONArray elementsArr = new JSONArray();
                int j3 = 0;
                while (j3 < prewaiverArr.length()) {
                    elementsArr = prewaiverArr.getJSONArray(j3);
                    String elementType = elementsArr.getString(0);
                    String elementName = "";
                    if (elementsArr.length() >= 2) {
                        elementName = elementsArr.getString(1);
                    }
                    elements.put(elementType, elementName);
                    ++j3;
                }
                HashSet<String> prewaivedFiles = new HashSet<String>();
                if (!prewaivedFilesString.isEmpty()) {
                    prewaiverArr = new JSONArray(prewaivedFilesString);
                    int j4 = 0;
                    while (j4 < prewaiverArr.length()) {
                        int fileIndex = prewaiverArr.getInt(j4);
                        if (fileIndex < fileNames.size()) {
                            prewaivedFiles.add(fileNames.get(fileIndex));
                        }
                        ++j4;
                    }
                }
                String prewaiverApplyOnValue = prewaiverApplyOn == 1 ? "matched" : "not-matched";
                String prewaiverPathsApplyOnValue = prewaiverPathsApplyOn == 1 ? "matched" : "not-matched";
                String prewaiverPathRegexTypeValue = prewaiverPathRegexType == 1 ? "perl" : "simple";
                String prewaiverTypeValue = prewaiverType == 1 ? WaiverType.READ_ONLY.name() : WaiverType.FILE.name();
                RPreWaiver prewaiver = new RPreWaiver(prewaiverName, prewaiverDescription, prewaiverApplyOnValue, prewaiverPathsApplyOnValue, prewaiverTypeValue, checkNames, prewaiverPathRegexTypeValue, paths, elements, waiverFile, prewaivedFiles);
                prewaivers.add(prewaiver);
                ++i;
            }
        }
        catch (JSONException jSONException) {
            throw new JSONException("The PreWaivers section may contain incorrect data on line: \n" + StringUtils.abbreviate((String)prewaiverArr.toString(), (int)200));
        }
        return prewaivers;
    }

    private static List<AnnotationResults.AnnotationInfo> populateAnnotationInfos(JSONArray arr) throws JSONException {
        LinkedList<AnnotationResults.AnnotationInfo> annotationInfos = new LinkedList<AnnotationResults.AnnotationInfo>();
        JSONArray annotationInfoArr = new JSONArray();
        try {
            int i = 0;
            while (i < arr.length()) {
                annotationInfoArr = arr.getJSONArray(i);
                String title = annotationInfoArr.getString(0);
                HashSet<Integer> locations = new HashSet<Integer>();
                JSONArray locationsArr = annotationInfoArr.getJSONArray(1);
                int j = 0;
                while (j < locationsArr.length()) {
                    locations.add(locationsArr.getInt(j));
                    ++j;
                }
                int type = AnnotationType.TAG.ordinal();
                if (annotationInfoArr.length() > 2) {
                    type = annotationInfoArr.getInt(2);
                }
                annotationInfos.add(new AnnotationResults.AnnotationInfo(title, locations, type));
                ++i;
            }
        }
        catch (JSONException jSONException) {
            throw new JSONException("The Annotation Infos section may contain incorrect data on line: \n" + StringUtils.abbreviate((String)annotationInfoArr.toString(), (int)200));
        }
        return annotationInfos;
    }

    private static List<Set<String>> populateAnnotationStrings(JSONArray arr) throws JSONException {
        ArrayList<Set<String>> annotationStrings = new ArrayList<Set<String>>();
        int i = 0;
        while (i < arr.length()) {
            JSONArray stringsArr = arr.getJSONArray(i);
            LinkedHashSet<String> strings = new LinkedHashSet<String>();
            int j = 0;
            while (j < stringsArr.length()) {
                strings.add(stringsArr.getString(j));
                ++j;
            }
            annotationStrings.add(strings);
            ++i;
        }
        return annotationStrings;
    }

    private static void checkSectionExistance(StringBuilder builder, String sectionName) throws JSONException {
        if (builder.length() == 0) {
            throw new JSONException("The section '" + sectionName + "' is missing!");
        }
    }

    private static void checkSectionExistance(DVTStringBuilder builder, String sectionName) throws JSONException {
        if (builder.length() == 0) {
            throw new JSONException("The section '" + sectionName + "' is missing!");
        }
    }

    private static void readAdditionalInfo(RReport reportInfo, File additionalInfoFile) {
        LinkedList<String> lines = new LinkedList<String>();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(additionalInfoFile));){
                String inputLine;
                while ((inputLine = bufferedReader.readLine()) != null) {
                    lines.add(inputLine);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        reportInfo.setBuildFile(!lines.isEmpty() ? (String)lines.get(0) : "");
        reportInfo.setWaiversFile(lines.size() > 1 ? (String)lines.get(1) : "");
        reportInfo.setRulesetKind(RulesetKind.from(lines.size() > 2 ? (String)lines.get(2) : ""));
        reportInfo.setRulesetFile(lines.size() > 3 ? (String)lines.get(3) : "");
        if (reportInfo.getBaselineReportLocation() == null) {
            reportInfo.setBaselineReportLocation(lines.size() > 4 ? (String)lines.get(4) : "");
        }
    }

    private static String unescAmpersand(String string) {
        return DVTStringUtil.unescapeXMLString((String)string, (boolean)false);
    }

    public static String unescapeHTML(String string) {
        return StringEscapeUtils.unescapeHtml((String)string);
    }
}

