/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.report;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.JarUtils;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ReportManager;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.report.HtmlCodeFilesWriter;
import ro.amiq.vlogdt.linter.report.model.RCategory;
import ro.amiq.vlogdt.linter.report.model.RCheck;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.report.model.RInfo;
import ro.amiq.vlogdt.linter.report.model.RPreWaiver;
import ro.amiq.vlogdt.linter.report.model.RReport;
import ro.amiq.vlogdt.linter.report.model.RWaiver;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.ui.HTML5ReportGenerator;
import ro.amiq.vlogdt.linter.waivers.LineRange;
import ro.amiq.vlogdt.linter.waivers.WaiverType;

public class VerissimoReportWriter {
    public static final IPath NONE_PATH = Path.fromOSString((String)"none");
    public static final int MAX_DATA_SIZE = 0x200000;
    public static final int COMMON_SEGMENTS_INFO_INDEX = 5;

    public static boolean writeReportDataFromObject(RReport reportInfo, Consumer<String> errorHandler, File[] files, IProgressMonitor monitor, boolean isMergeReport, boolean isDiffReport) {
        try {
            if (monitor.isCanceled()) {
                return false;
            }
            LinkedHashMap<String, Set<RCheck>> preWaivedFilesForChecksMap = reportInfo.getPrewaivedFilesForChecks();
            if (monitor.isCanceled()) {
                return false;
            }
            ArrayList<String> dataFiles = VerissimoReportWriter.getDataFiles(reportInfo, monitor);
            reportInfo.getInfoWrapper().setDataFilesSize(Integer.toString(dataFiles.size() - 1));
            StringBuilder infoSB = VerissimoReportWriter.buildInfoString(reportInfo);
            HashMap<IPath, Integer> fileToIndexMap = new HashMap<IPath, Integer>();
            StringBuilder resultSB = new StringBuilder();
            StringBuilder allFilesSB = VerissimoReportWriter.getAllFiles(reportInfo, preWaivedFilesForChecksMap, fileToIndexMap);
            resultSB.append("var VerissimoData = {\n").append((CharSequence)infoSB).append((CharSequence)VerissimoReportWriter.getCategories(reportInfo)).append((CharSequence)VerissimoReportWriter.getChecks(reportInfo)).append((CharSequence)VerissimoReportWriter.getFiles(reportInfo, preWaivedFilesForChecksMap, fileToIndexMap)).append((CharSequence)allFilesSB).append((CharSequence)VerissimoReportWriter.getWaivers(reportInfo)).append((CharSequence)VerissimoReportWriter.getPreWaivers(reportInfo, fileToIndexMap)).append((CharSequence)VerissimoReportWriter.getAnnotationInfos(reportInfo)).append((CharSequence)VerissimoReportWriter.getAnnotationStrings(reportInfo)).append("hits : []\n").append("};");
            VerissimoReportWriter.appendLoader(resultSB);
            dataFiles.set(0, resultSB.toString());
            ZonedDateTime date = LocalDateTime.now().atZone(ZoneId.systemDefault());
            File jsFile = new File(files[0], "js");
            StringBuilder includeSB = new StringBuilder();
            int i = 0;
            while (i < dataFiles.size()) {
                includeSB.append("<script src='").append("js/data").append(i).append(".js").append('?').append(date.toEpochSecond()).append("'></script>");
                if (!VerissimoReportWriter.writeStringToFile(new File(jsFile, "data" + i + ".js"), dataFiles.get(i), errorHandler)) {
                    return false;
                }
                ++i;
            }
            String indexContent = VerissimoReportWriter.readStringFromFile(files[1], errorHandler);
            if (indexContent == null) {
                return false;
            }
            if (!VerissimoReportWriter.writeStringToFile(files[1], indexContent = indexContent.replace("<meta http-equiv=\"date\" content=\"\">", "<meta http-equiv=\"date\" content=\"" + reportInfo.getInfoWrapper().getDate() + "\">").replace("<script src=\"js/data.js\"></script>", includeSB.toString()), errorHandler)) {
                return false;
            }
            List<String> infoKeyValues = reportInfo.getInfoKeyValues();
            if (infoKeyValues != null) {
                StringBuilder mappingsSB = new StringBuilder();
                for (String pair : infoKeyValues) {
                    mappingsSB.append(pair).append("\n");
                }
                if (!VerissimoReportWriter.writeStringToFile(files[3], mappingsSB.toString(), errorHandler)) {
                    return false;
                }
            }
            StringBuilder buildSB = new StringBuilder();
            if (reportInfo.getInfoWrapper().isCompareReport()) {
                rulesetKind = reportInfo.getRulesetKind();
                rulesetKindString = "";
                if (rulesetKind != null) {
                    rulesetKindString = rulesetKind.toString();
                }
                buildSB.append(reportInfo.getBuildFile()).append("\n").append(reportInfo.getWaiversFile()).append("\n").append(rulesetKindString).append("\n").append(reportInfo.getRulesetFile()).append("\n");
            } else if (isMergeReport) {
                buildSB.append("Merge report").append("\n");
            } else if (isDiffReport) {
                buildSB.append("Diff report").append("\n");
            } else {
                rulesetKind = reportInfo.getRulesetKind();
                rulesetKindString = "";
                if (rulesetKind != null) {
                    rulesetKindString = rulesetKind.toString();
                }
                buildSB.append(reportInfo.getBuildFile()).append("\n").append(reportInfo.getWaiversFile()).append("\n").append(rulesetKindString).append("\n").append(reportInfo.getRulesetFile()).append("\n").append(reportInfo.getBaselineReportLocation()).append("\n");
            }
            if (!VerissimoReportWriter.writeStringToFile(files[2], buildSB.toString(), errorHandler)) {
                return false;
            }
        }
        finally {
            monitor.done();
        }
        return true;
    }

    public static StringBuilder getWaivers(RReport reportInfo) {
        StringBuilder waiversStringBuilder = new StringBuilder();
        List<RWaiver> waivers = reportInfo.getPostWaivers();
        if (waivers == null) {
            waivers = new ArrayList<RWaiver>();
        }
        for (RWaiver waiver : waivers) {
            StringBuilder checksSB = new StringBuilder("[");
            for (String checkName : waiver.getCheckNames()) {
                checksSB.append(VerissimoReportWriter.esc(checkName)).append(',');
            }
            VerissimoReportWriter.removeLastChar(checksSB);
            checksSB.append("]");
            StringBuilder pathsSB = new StringBuilder("[");
            for (String path : waiver.getPaths()) {
                pathsSB.append(VerissimoReportWriter.esc(path)).append(',');
            }
            VerissimoReportWriter.removeLastChar(pathsSB);
            pathsSB.append("]");
            StringBuilder lineRangesSB = new StringBuilder("[");
            for (LineRange lineRange : waiver.getLineRanges()) {
                lineRangesSB.append(VerissimoReportWriter.esc("" + lineRange.getStartLine() + ':' + lineRange.getEndLine())).append(',');
            }
            VerissimoReportWriter.removeLastChar(lineRangesSB);
            lineRangesSB.append("]");
            StringBuilder messagePatternsSB = new StringBuilder("[");
            for (String messagePattern : waiver.getMessagePatterns()) {
                messagePatternsSB.append(VerissimoReportWriter.esc(messagePattern)).append(',');
            }
            VerissimoReportWriter.removeLastChar(messagePatternsSB);
            messagePatternsSB.append("]");
            StringBuilder elementsSB = new StringBuilder("[");
            for (Map.Entry<String, String> entry : waiver.getElements().entrySet()) {
                elementsSB.append("[").append(entry.getKey()).append(',').append(entry.getValue()).append("]").append(',');
            }
            VerissimoReportWriter.removeLastChar(elementsSB);
            elementsSB.append("]");
            waiversStringBuilder.append("[").append(VerissimoReportWriter.esc(waiver.getName())).append(',').append(VerissimoReportWriter.esc(waiver.getDescription())).append(',').append(VerissimoReportWriter.esc(waiver.getStatus())).append(',').append(VerissimoReportWriter.esc(waiver.getApplyOn().equals("matched") ? "1" : "0")).append(',').append(VerissimoReportWriter.esc(checksSB.toString())).append(',').append(VerissimoReportWriter.esc(waiver.getPathsRegexType().equals("perl") ? "1" : "0")).append(',').append(VerissimoReportWriter.esc(pathsSB.toString())).append(',').append(VerissimoReportWriter.esc(lineRangesSB.toString())).append(',').append(VerissimoReportWriter.esc(waiver.getMessageRegexType().equals("perl") ? "1" : "0")).append(',').append(VerissimoReportWriter.esc(messagePatternsSB.toString())).append(',').append(VerissimoReportWriter.esc(waiver.getWaiverFile())).append(',').append(VerissimoReportWriter.esc(elementsSB.toString())).append(',').append(VerissimoReportWriter.esc(String.valueOf(waiver.getLineNoInXMLFile()))).append(',').append(VerissimoReportWriter.esc("not-matched".equals(waiver.getPathsApplyOn()) ? "0" : "1")).append("],\n");
        }
        VerissimoReportWriter.removeLastChar(waiversStringBuilder);
        waiversStringBuilder.insert(0, "waivers : [\n").append("],\n");
        return waiversStringBuilder;
    }

    public static StringBuilder getPreWaivers(RReport reportInfo, Map<IPath, Integer> fileToIndexMap) {
        StringBuilder preWaiversStringBuilder = new StringBuilder();
        List<RPreWaiver> preWaivers = reportInfo.getPreWaivers();
        if (preWaivers == null) {
            preWaivers = new ArrayList<RPreWaiver>();
        }
        for (RPreWaiver preWaiver : preWaivers) {
            StringBuilder checksSB = new StringBuilder("[");
            for (String checkName : preWaiver.getCheckNames()) {
                checksSB.append(VerissimoReportWriter.esc(checkName)).append(',');
            }
            VerissimoReportWriter.removeLastChar(checksSB);
            checksSB.append("]");
            StringBuilder pathsSB = new StringBuilder("[");
            for (String path : preWaiver.getPaths()) {
                pathsSB.append(VerissimoReportWriter.esc(path)).append(',');
            }
            VerissimoReportWriter.removeLastChar(pathsSB);
            pathsSB.append("]");
            StringBuilder elementsSB = new StringBuilder("[");
            for (Map.Entry<String, String> entry : preWaiver.getElements().entrySet()) {
                elementsSB.append("[").append(entry.getKey()).append(',').append(entry.getValue()).append("]").append(',');
            }
            VerissimoReportWriter.removeLastChar(elementsSB);
            elementsSB.append("]");
            StringBuilder prewaivedFilesSB = new StringBuilder("[");
            TreeSet<Integer> prewaivedFilesTree = new TreeSet<Integer>();
            for (String file : preWaiver.getPrewaivedFiles()) {
                Integer index = fileToIndexMap.get(Path.fromOSString((String)file));
                if (index == null) continue;
                prewaivedFilesTree.add(index);
            }
            prewaivedFilesSB.append(prewaivedFilesTree.stream().map(Object::toString).collect(Collectors.joining(",")));
            VerissimoReportWriter.removeLastChar(prewaivedFilesSB);
            prewaivedFilesSB.append("]");
            preWaiversStringBuilder.append("[").append(VerissimoReportWriter.esc(preWaiver.getName())).append(',').append(VerissimoReportWriter.esc(preWaiver.getDescription())).append(',').append(VerissimoReportWriter.esc(preWaiver.getApplyOn().equals("matched") ? "1" : "0")).append(',').append(VerissimoReportWriter.esc(checksSB.toString())).append(',').append(VerissimoReportWriter.esc(preWaiver.getPathRegexType().equals("perl") ? "1" : "0")).append(',').append(VerissimoReportWriter.esc(pathsSB.toString())).append(',').append(VerissimoReportWriter.esc(elementsSB.toString())).append(",").append(VerissimoReportWriter.esc(preWaiver.getWaiverFile())).append(",").append(VerissimoReportWriter.esc(prewaivedFilesSB.toString())).append(",").append(VerissimoReportWriter.esc(preWaiver.getType().equals(WaiverType.READ_ONLY.name()) ? "1" : "0")).append(',').append(VerissimoReportWriter.esc("not-matched".equals(preWaiver.getPathsApplyOn()) ? "0" : "1")).append("],\n");
        }
        VerissimoReportWriter.removeLastChar(preWaiversStringBuilder);
        preWaiversStringBuilder.insert(0, "prewaivers : [\n").append("],\n");
        return preWaiversStringBuilder;
    }

    public static StringBuilder getCategories(RReport reportInfo) {
        StringBuilder categoriesSB = new StringBuilder();
        List<RCategory> categories = reportInfo.getCategories();
        for (RCategory categoryWrapper : categories) {
            categoriesSB.append('[').append(VerissimoReportWriter.esc(categoryWrapper.getName())).append(',').append(VerissimoReportWriter.esc(categoryWrapper.getDescription())).append(',').append(categoryWrapper.getCheckIndexesAsString()).append("],\n");
        }
        VerissimoReportWriter.removeLastChar(categoriesSB);
        categoriesSB.insert(0, "categories : [\n").append("],\n");
        return categoriesSB;
    }

    public static StringBuilder getChecks(RReport reportInfo) {
        StringBuilder checksSB = new StringBuilder();
        List<RCheck> checks = reportInfo.getChecks();
        Map<RuleLabel, Integer> allLabelsMap = VerissimoReportWriter.getAllLabelsMap(reportInfo);
        for (RCheck checkWrapper : checks) {
            checksSB.append('[').append(VerissimoReportWriter.esc(checkWrapper.getCheckName())).append(',').append(VerissimoReportWriter.esc(checkWrapper.getCheckTitle())).append(',').append(VerissimoReportWriter.esc(checkWrapper.getCheckDescription())).append(',').append(checkWrapper.getEffort()).append(',').append(checkWrapper.getCategoryIndex()).append(',').append(checkWrapper.getCheckStatus()).append(',').append(checkWrapper.getHitIndexesAsString()).append(',').append(VerissimoReportWriter.esc(checkWrapper.getCheckID())).append(',').append(checkWrapper.getSeverity() == null ? "-1" : Integer.valueOf(checkWrapper.getSeverity().ordinal())).append(',').append(checkWrapper.getRunTime()).append(',').append(checkWrapper.isAutocorrectable() ? "1" : "0").append(',').append(checkWrapper.isManualCheck() ? "1" : "0").append(',').append(checkWrapper.isAutocorrectEnabled() ? "1" : "0").append(',').append(checkWrapper.getCompareAnnotationsIndexesAsString()).append(',').append(checkWrapper.getParametersAsString()).append(',').append(checkWrapper.getAutocorrectParametersAsString()).append(',').append(checkWrapper.getLabelIndexesAsString(allLabelsMap)).append("],\n");
        }
        VerissimoReportWriter.removeLastChar(checksSB);
        checksSB.insert(0, "checks : [\n").append("],\n");
        return checksSB;
    }

    private static Map<RuleLabel, Integer> getAllLabelsMap(RReport reportInfo) {
        List<RuleLabel> allLabels = reportInfo.getLabels();
        Map<RuleLabel, Integer> allLabelsMap = IntStream.range(0, allLabels.size()).boxed().collect(Collectors.toMap(allLabels::get, i -> i));
        return allLabelsMap;
    }

    public static StringBuilder getFiles(RReport reportInfo, Map<String, Set<RCheck>> preWaivedFilesForChecksMap, Map<IPath, Integer> fileToIndexMap) {
        StringBuilder filesSB = new StringBuilder();
        Set<String> filesWrappers = reportInfo.getFiles();
        Map<String, Integer> nofCompiledLinesPerFile = reportInfo.getInfoWrapper().getNofCompiledLinesPerFile();
        String noneFile = "none";
        for (String fileWrapper : filesWrappers) {
            Set<RCheck> preWaivedChecksForFile = preWaivedFilesForChecksMap.get(fileWrapper);
            Integer indexInAllFiles = fileToIndexMap.get(Path.fromOSString((String)fileWrapper));
            if (indexInAllFiles != null) {
                filesSB.append("[").append(indexInAllFiles).append(", [");
            } else {
                filesSB.append("[").append(VerissimoReportWriter.esc(noneFile)).append(", [");
            }
            if (preWaivedChecksForFile != null && !preWaivedChecksForFile.isEmpty()) {
                for (RCheck check : preWaivedChecksForFile) {
                    filesSB.append(check.getCheckIndex()).append(",");
                }
                VerissimoReportWriter.removeLastChar(filesSB);
            }
            filesSB.append("], ");
            Integer compiledLines = nofCompiledLinesPerFile.get(fileWrapper);
            if (compiledLines == null) {
                compiledLines = 0;
            }
            filesSB.append(compiledLines);
            filesSB.append("],\n");
        }
        VerissimoReportWriter.removeLastChar(filesSB);
        filesSB.insert(0, "files : [\n").append("],\n");
        return filesSB;
    }

    public static StringBuilder getAllFiles(RReport reportInfo, Map<String, Set<RCheck>> preWaivedFilesForChecksMap, Map<IPath, Integer> fileToIndexMap) {
        StringBuilder allFilesSB = new StringBuilder();
        LinkedHashMap<String, String> allFilesHashesMap = reportInfo.getAllFilesHashesMap();
        for (Map.Entry<String, String> entry : allFilesHashesMap.entrySet()) {
            String baselineFileHash;
            String baselineFileName;
            String fileWrapper = entry.getKey();
            if (fileWrapper == null || Path.fromOSString((String)fileWrapper).lastSegment().startsWith("__vlog__")) continue;
            VerissimoReportWriter.indexPath(fileToIndexMap, fileWrapper);
            String fileHash = entry.getValue() == null ? "NULLHASH" : entry.getValue();
            Set<RCheck> preWaivedChecksForFile = preWaivedFilesForChecksMap.get(fileWrapper);
            allFilesSB.append("[").append(VerissimoReportWriter.esc(fileWrapper)).append(", [");
            if (preWaivedChecksForFile != null && !preWaivedChecksForFile.isEmpty()) {
                for (RCheck check : preWaivedChecksForFile) {
                    allFilesSB.append(check.getCheckIndex()).append(",");
                }
                VerissimoReportWriter.removeLastChar(allFilesSB);
            }
            allFilesSB.append("]");
            allFilesSB.append(", ").append(VerissimoReportWriter.esc(fileHash));
            LinkedHashMap<String, String> allBaselineFilesHashesMap = reportInfo.getAllBaselineFilesHashesMap();
            LinkedHashMap<String, String> allFilesWithBaselineFilesMap = reportInfo.getAllFilesWithBaselineFilesMap();
            if (!(!reportInfo.getInfoWrapper().isCompareReport() || allBaselineFilesHashesMap == null || allBaselineFilesHashesMap.isEmpty() || allFilesWithBaselineFilesMap == null || allFilesWithBaselineFilesMap.isEmpty() || (baselineFileName = allFilesWithBaselineFilesMap.get(fileWrapper)) == null || baselineFileName.isEmpty() || (baselineFileHash = allBaselineFilesHashesMap.get(baselineFileName)) == null || baselineFileHash.isEmpty())) {
                allFilesSB.append(", ").append(VerissimoReportWriter.esc(baselineFileHash));
                allFilesSB.append(", ").append(VerissimoReportWriter.esc(baselineFileName));
            }
            allFilesSB.append("],\n");
        }
        VerissimoReportWriter.removeLastChar(allFilesSB);
        allFilesSB.insert(0, "all_files : [\n").append("],\n");
        return allFilesSB;
    }

    public static StringBuilder getAnnotationInfos(RReport reportInfo) {
        StringBuilder annotationInfosSB = new StringBuilder();
        List<AnnotationResults.AnnotationInfo> haInfos = reportInfo.getAnnotationInfos();
        if (haInfos != null) {
            for (AnnotationResults.AnnotationInfo entry : haInfos) {
                String title = entry.getTitle();
                int[] locations = entry.getLocations().stream().mapToInt(i -> i).toArray();
                Arrays.sort(locations);
                annotationInfosSB.append('[').append(VerissimoReportWriter.esc(title)).append(',');
                annotationInfosSB.append('[');
                int[] nArray = locations;
                int n = locations.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer loc = nArray[n2];
                    annotationInfosSB.append(loc).append(",");
                    ++n2;
                }
                VerissimoReportWriter.removeLastChar(annotationInfosSB);
                annotationInfosSB.append("],").append(entry.getType());
                annotationInfosSB.append("],\n");
            }
        }
        VerissimoReportWriter.removeLastChar(annotationInfosSB);
        annotationInfosSB.insert(0, "annotation_infos: [\n").append("],\n");
        return annotationInfosSB;
    }

    public static StringBuilder getAnnotationStrings(RReport reportInfo) {
        StringBuilder annotationStringsSB = new StringBuilder();
        List<Set<String>> haStrings = reportInfo.getAnnotationStrings();
        for (Set<String> list : haStrings) {
            annotationStringsSB.append('[');
            for (String string : list) {
                annotationStringsSB.append(VerissimoReportWriter.esc(string)).append(",\n");
            }
            VerissimoReportWriter.removeLastChar(annotationStringsSB);
            annotationStringsSB.append("],\n");
        }
        VerissimoReportWriter.removeLastChar(annotationStringsSB);
        annotationStringsSB.insert(0, "annotation_strings: [\n").append("],\n");
        return annotationStringsSB;
    }

    public static ArrayList<String> getDataFiles(RReport reportInfo, IProgressMonitor monitor) {
        ArrayList<String> dataFiles = new ArrayList<String>();
        dataFiles.add(null);
        StringBuilder hitsSB = new StringBuilder(0x233333);
        List hits = reportInfo.getHits().stream().filter(hit -> !hit.isFixed()).collect(Collectors.toList());
        for (RHit hitWrapper : hits) {
            if (hitWrapper.isHidden()) continue;
            hitsSB.append('[').append(hitWrapper.getHitSeverity()).append(',').append(hitWrapper.getCheckIndex()).append(',').append(hitWrapper.getIndexPath()).append(',').append(hitWrapper.getHitLine()).append(',');
            hitsSB.append('[');
            List<RHit.MacroPathWrapper> macroParts = hitWrapper.getMacroParts();
            if (macroParts != null && !macroParts.isEmpty()) {
                for (RHit.MacroPathWrapper macroPathWrapper : macroParts) {
                    hitsSB.append('[').append(VerissimoReportWriter.esc(macroPathWrapper.getMacroName())).append(',').append(macroPathWrapper.getIndex()).append(',').append(VerissimoReportWriter.esc(macroPathWrapper.getLine())).append("],");
                }
            }
            VerissimoReportWriter.removeLastChar(hitsSB);
            hitsSB.append("],");
            hitsSB.append(VerissimoReportWriter.esc(VerissimoReportWriter.escAmpersand(hitWrapper.getHitDetails()))).append(',');
            hitsSB.append('[');
            List<RHit.DetailsLinkWrapper> detailsLinks = hitWrapper.getDetailsLinks();
            if (detailsLinks != null && !detailsLinks.isEmpty()) {
                for (RHit.DetailsLinkWrapper detailsLinkWrapper : detailsLinks) {
                    hitsSB.append('[').append(detailsLinkWrapper.getOffset()).append(',').append(detailsLinkWrapper.getLength()).append(',').append(detailsLinkWrapper.getIndex()).append(',').append(VerissimoReportWriter.esc(detailsLinkWrapper.getLine())).append("],");
                }
            }
            VerissimoReportWriter.removeLastChar(hitsSB);
            hitsSB.append("],");
            hitsSB.append('[');
            List<Integer> hitSources = hitWrapper.getHitSources();
            for (Integer hitSource : hitSources) {
                hitsSB.append(hitSource).append(',');
            }
            VerissimoReportWriter.removeLastChar(hitsSB);
            hitsSB.append("],");
            hitsSB.append(hitWrapper.getCreationDate()).append(',');
            List<Integer> compareAnnotationsIndexes = hitWrapper.getCompareAnnotationsIndexes();
            if (compareAnnotationsIndexes == null || compareAnnotationsIndexes.isEmpty()) {
                hitsSB.append("[],");
            } else {
                hitsSB.append('[');
                for (Integer index : compareAnnotationsIndexes) {
                    hitsSB.append(index).append(',');
                }
                VerissimoReportWriter.removeLastChar(hitsSB);
                hitsSB.append("],");
            }
            hitsSB.append(hitWrapper.getCompareModifiedStatus()).append(',');
            Integer compareHitOrigin = hitWrapper.getCompareHitOriginIndex();
            if (compareHitOrigin == null) {
                hitsSB.append("0,");
            } else {
                hitsSB.append(compareHitOrigin).append(',');
            }
            List<List<Integer>> haStringIndexesLists = hitWrapper.getAnnotationStringIndexes();
            if (haStringIndexesLists != null && !haStringIndexesLists.isEmpty()) {
                for (List<Integer> haStringIndexList : haStringIndexesLists) {
                    if (haStringIndexList.isEmpty()) {
                        hitsSB.append("[],");
                        continue;
                    }
                    hitsSB.append('[');
                    for (Integer haStringIndex : haStringIndexList) {
                        hitsSB.append(haStringIndex).append(',');
                    }
                    VerissimoReportWriter.removeLastChar(hitsSB);
                    hitsSB.append("],");
                }
            }
            VerissimoReportWriter.removeLastChar(hitsSB);
            hitsSB.append("],\n");
            if (hitsSB.length() <= 0x200000) continue;
            if (monitor.isCanceled()) {
                return null;
            }
            VerissimoReportWriter.removeLastChar(hitsSB);
            VerissimoReportWriter.wrappConcatenation(hitsSB);
            VerissimoReportWriter.appendLoader(hitsSB);
            dataFiles.add(hitsSB.toString());
            hitsSB = new StringBuilder(0x233333);
        }
        VerissimoReportWriter.removeLastChar(hitsSB);
        VerissimoReportWriter.wrappConcatenation(hitsSB);
        VerissimoReportWriter.appendLoader(hitsSB);
        dataFiles.add(hitsSB.toString());
        return dataFiles;
    }

    public static StringBuilder buildInfoString(RReport reportInfo) {
        RInfo infoWrapper = reportInfo.getInfoWrapper();
        StringBuilder infoSB = new StringBuilder();
        VerissimoReportWriter.appendInfoElements(new String[]{infoWrapper.getVersion(), infoWrapper.getUserName(), infoWrapper.getDate(), infoWrapper.getRuleSet(), infoWrapper.getProject()}, infoSB);
        List<String> commonSegmentsInfo = infoWrapper.getCommonSegmentsInfo();
        infoSB.append('[');
        for (String commonSegmentInfo : commonSegmentsInfo) {
            infoSB.append("undefined".equals(commonSegmentInfo) ? commonSegmentInfo : VerissimoReportWriter.esc(commonSegmentInfo)).append(',');
        }
        VerissimoReportWriter.removeLastChar(infoSB);
        infoSB.append("],\n");
        Boolean codeHTMLCheck = false;
        String baselineLocation = "";
        if (reportInfo.getBaselineReportLocation() != null && !reportInfo.getBaselineReportLocation().isEmpty()) {
            File codeFolder = new File(reportInfo.getBaselineReportLocation(), "code");
            baselineLocation = reportInfo.getBaselineReportLocation();
            if (codeFolder.exists() && codeFolder.isDirectory()) {
                codeHTMLCheck = true;
            }
        }
        VerissimoReportWriter.appendInfoElements(new String[]{infoWrapper.getDataFilesSize(), Boolean.toString(infoWrapper.hasEffortEstimation()), Integer.toString(infoWrapper.getNofCompiledLines()), Long.toString(infoWrapper.getLintRunTime()), Long.toString(infoWrapper.getBuildRunTime()), Long.toString(infoWrapper.getLicenseWaitTime()), Boolean.toString(infoWrapper.isTimedOutSession()), Boolean.toString(infoWrapper.isTimedOutChecks()), "['" + Boolean.toString(infoWrapper.isCompareReport()) + "','" + infoWrapper.getBaselineReportUUID() + "','" + infoWrapper.getCurrentReportUUID() + "']", Boolean.toString(infoWrapper.setIncludeCreationDate()), infoWrapper.getUUID(), infoWrapper.getCommiterDate(), Boolean.toString(infoWrapper.hasCompilationErrors()), baselineLocation, Boolean.toString(codeHTMLCheck)}, infoSB);
        VerissimoReportWriter.removeLastChar(infoSB);
        infoSB.insert(0, "info : [\n").append("],\n");
        return infoSB;
    }

    public static void appendInfoElements(String[] info, StringBuilder infoSB) {
        int i = 0;
        while (i < info.length) {
            if ("undefined".equals(info[i])) {
                infoSB.append("undefined").append(",\n");
            } else if (info[i].startsWith("[")) {
                infoSB.append(info[i]).append(",\n");
            } else {
                infoSB.append(VerissimoReportWriter.esc(info[i])).append(",\n");
            }
            ++i;
        }
    }

    public static File[] writeReportFilesStructure(String location, OVMProject ovmProject, List<String> infoKeyValues, boolean createReportFolder, Consumer<String> errorHandler, IProgressMonitor monitor) {
        return VerissimoReportWriter.writeReportFilesStructure(location, ovmProject, infoKeyValues, createReportFolder, errorHandler, monitor, null);
    }

    public static File[] writeReportFilesStructure(String location, OVMProject ovmProject, List<String> infoKeyValues, boolean createReportFolder, Consumer<String> errorHandler, IProgressMonitor monitor, ReportManager.ReportType reportType) {
        File[] files = VerissimoReportWriter.computeReportFiles(location, ovmProject, infoKeyValues, reportType);
        if (createReportFolder && !VerissimoReportWriter.writeReportFolder(files, errorHandler)) {
            return null;
        }
        if (!VerissimoReportWriter.writeStaticFiles(files, errorHandler)) {
            return null;
        }
        monitor.worked(5);
        if (monitor.isCanceled()) {
            return null;
        }
        return files;
    }

    public static boolean writeReport(HtmlCodeFilesWriter writer, RReport report, File[] files, boolean includeHTMLCode, IProgressMonitor monitor, BiFunction<IProgressMonitor, Integer, IProgressMonitor> subprogressMonitorSupplier) {
        return VerissimoReportWriter.writeReport(writer, report, files, includeHTMLCode, monitor, subprogressMonitorSupplier, false, false);
    }

    public static boolean writeReport(HtmlCodeFilesWriter writer, RReport report, File[] files, boolean includeHTMLCode, IProgressMonitor monitor, BiFunction<IProgressMonitor, Integer, IProgressMonitor> subprogressMonitorSupplier, boolean isMergeReport, boolean isDiffReport) {
        if (includeHTMLCode) {
            if (!VerissimoReportWriter.writeReportDataFromObject(report, HTML5ReportGenerator::errorHandler, files, subprogressMonitorSupplier.apply(monitor, 80), isMergeReport, isDiffReport)) {
                return false;
            }
            if (!writer.writeCodeFiles(files, report, HTML5ReportGenerator::errorHandler, subprogressMonitorSupplier.apply(monitor, 10))) {
                return false;
            }
        } else if (!VerissimoReportWriter.writeReportDataFromObject(report, HTML5ReportGenerator::errorHandler, files, subprogressMonitorSupplier.apply(monitor, 90), isMergeReport, isDiffReport)) {
            return false;
        }
        monitor.worked(5);
        return !monitor.isCanceled();
    }

    public static File[] computeReportFiles(String location, OVMProject ovmProject, List<String> infoKeyValues) {
        return VerissimoReportWriter.computeReportFiles(location, ovmProject, infoKeyValues, null);
    }

    public static File[] computeReportFiles(String location, OVMProject ovmProject, List<String> infoKeyValues, ReportManager.ReportType reportType) {
        String prefix = "verissimo";
        if (ovmProject != null) {
            RulesetKind ruleset = ovmProject.getConfiguration().getRulesetKind();
            prefix = ruleset.getPrefix();
        }
        String prefix_file = prefix;
        if (reportType != null) {
            prefix_file = String.valueOf(prefix_file) + "_" + reportType.getReportName().toLowerCase();
        }
        File reportFolder = new File(location, String.valueOf(prefix_file) + "_html_report");
        File indexFile = new File(reportFolder, "index.html");
        File htmlReportFile = new File(reportFolder, String.valueOf(prefix.replace('_', '.')) + ".html.report");
        File infoFile = infoKeyValues != null ? new File(reportFolder, "verissimo.info") : null;
        return new File[]{reportFolder, indexFile, htmlReportFile, infoFile};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeReportFolder(File[] files, Consumer<String> errorHandler) {
        if (files[0].exists()) {
            if (!files[0].isDirectory()) {
                errorHandler.accept("ERROR: Can't create report directory '" + files[0].getAbsolutePath() + "', it is an existing file!");
                return false;
            }
            if (!files[0].canWrite()) {
                errorHandler.accept("ERROR: Can't create report directory '" + files[0].getAbsolutePath() + "', it exists and has no write access!");
                return false;
            }
            errorHandler.accept("WARNING: Report directory '" + files[0].getAbsolutePath() + "' exists, contents will be overwritten!");
            try {
                DVTFileUtils.getInstance().removeRecursive(files[0].toPath());
            }
            catch (IOException iOException) {
                errorHandler.accept("ERROR: Can't remove existing report directory '" + files[0].getAbsolutePath() + "'!");
                return false;
            }
        }
        if (!files[0].mkdirs()) {
            errorHandler.accept("ERROR: Can't create report directory '" + files[0].getAbsolutePath() + "'!");
            return false;
        }
        return true;
    }

    public static boolean writeStaticFiles(File[] files, Consumer<String> errorHandler) {
        try {
            files[2].createNewFile();
        }
        catch (IOException iOException) {
            errorHandler.accept("ERROR: Can't write report file '" + files[2].getAbsolutePath() + "'!");
            return false;
        }
        try {
            JarUtils.extractDirectory((String)"/resources/verissimo_html_report", HTML5ReportGenerator.class, (boolean)true, (String)files[0].toString(), (boolean)false);
        }
        catch (IOException iOException) {
            errorHandler.accept("ERROR: Can't write report contents!");
            return false;
        }
        File codeHtml = new File(files[0], "code.html");
        if (codeHtml.exists()) {
            codeHtml.delete();
        }
        return true;
    }

    public static boolean copyHtmlCodeFiles(File[] files, RReport reportInfo, Consumer<String> errorHandler, IProgressMonitor monitor) {
        Map<Integer, String> sourceLocations = reportInfo.getSourcesLocations();
        for (Map.Entry<Integer, String> entry : sourceLocations.entrySet()) {
            File srcFile = new File(entry.getValue());
            if (!srcFile.isDirectory()) continue;
            File dstFile = new File(files[0], "code" + File.separatorChar + entry.getKey().toString());
            try {
                FileUtils.copyDirectory((File)srcFile, (File)dstFile);
            }
            catch (IOException iOException) {
                errorHandler.accept("ERROR: Can't copy report folder '" + srcFile.getAbsolutePath() + "' to '" + dstFile.getAbsolutePath() + "'.");
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeHtmlCodeFiles(File[] files, RReport report, Consumer<String> errorHandler, IProgressMonitor monitor) {
        Set<IPath> paths = report.getPaths().keySet();
        MutableInt commonSegments = report.getCommonSegments();
        try {
            if (paths.isEmpty()) {
                return true;
            }
            String codeHtml = null;
            try {
                codeHtml = DVTStringUtil.streamToString((InputStream)JarUtils.getFileStream((String)"/resources/verissimo_html_report/code.html", VerissimoReportWriter.class));
            }
            catch (IOException iOException) {
                errorHandler.accept("ERROR: Can't extract 'code.html' contents!");
                monitor.done();
                return false;
            }
            IPath codePath = Path.fromOSString((String)files[0].getAbsolutePath()).append("code");
            monitor.beginTask("Generating HTML code files...", paths.size());
            for (IPath path : paths) {
                if (monitor.isCanceled()) {
                    return false;
                }
                if (NONE_PATH.equals((Object)path)) continue;
                File file = path.toFile();
                if (file.isFile()) {
                    IPath htmlPath = codePath.append("0").append(path.removeFirstSegments(commonSegments.intValue())).addFileExtension("html");
                    IPath relativePath = codePath.makeRelativeTo(htmlPath);
                    StringBuilder content = new StringBuilder();
                    BufferedReader reader = null;
                    try {
                        try {
                            reader = new BufferedReader(new FileReader(file));
                            String line = null;
                            while ((line = reader.readLine()) != null) {
                                content.append(StringEscapeUtils.escapeHtml((String)line)).append('\n');
                            }
                        }
                        catch (IOException iOException) {
                            errorHandler.accept("ERROR: Can't write code file '" + path.toOSString() + "'!");
                            DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
                            monitor.done();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        DVTUtilsCommon.INSTANCE.closeClosable(reader);
                        throw throwable;
                    }
                    DVTUtilsCommon.INSTANCE.closeClosable((Closeable)reader);
                    String htmlContent = codeHtml.replace("#title#", path.lastSegment()).replace("#css#", relativePath.append("css/code.css").toOSString()).replace("#js#", relativePath.append("js/code.js").toOSString()).replace("#content#", content.toString());
                    File htmlFile = htmlPath.toFile();
                    htmlFile.getParentFile().mkdirs();
                    if (!VerissimoReportWriter.writeStringToFile(htmlFile, htmlContent, errorHandler)) {
                        return false;
                    }
                }
                monitor.worked(1);
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    public static void appendLoader(StringBuilder sb) {
        sb.append('\n').append("VerissimoReport.loading();");
    }

    public static void wrappConcatenation(StringBuilder sb) {
        sb.insert(0, "VerissimoData.hits = VerissimoData.hits.concat([\n").append("]);\n");
    }

    public static void removeLastChar(StringBuilder sb) {
        int pos = sb.length() - 1;
        if (pos >= 0 && sb.charAt(pos) == ',') {
            sb.deleteCharAt(pos);
        } else if (pos >= 1 && sb.charAt(pos) == '\n' && sb.charAt(pos - 1) == ',') {
            sb.delete(pos - 1, pos);
        }
    }

    public static String esc(String string) {
        return '\'' + StringEscapeUtils.escapeJavaScript((String)string) + '\'';
    }

    private static String escAmpersand(String string) {
        return DVTStringUtil.escapeXMLString((String)string, (boolean)false);
    }

    public static boolean writeStringToFile(File file, String content, Consumer<String> errorHandler) {
        try {
            Files.write(file.toPath(), content.getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            errorHandler.accept("ERROR: Can't write report file '" + file.getAbsolutePath() + "'!");
            return false;
        }
        return true;
    }

    public static String readStringFromFile(File file, Consumer<String> errorHandler) {
        try {
            return new String(Files.readAllBytes(file.toPath()));
        }
        catch (IOException iOException) {
            errorHandler.accept("ERROR: Can't read report file '" + file.getAbsolutePath() + "'!");
            return null;
        }
    }

    public static int indexPath(Map<IPath, Integer> paths, String file) {
        IPath path = Path.fromOSString((String)file);
        Integer index = paths.get(path);
        if (index == null) {
            index = paths.size();
            paths.put(path, index);
        }
        return index;
    }
}

