/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.report.model;

import java.util.LinkedHashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.report.VerissimoReportWriter;
import ro.amiq.vlogdt.linter.report.model.RCheck;

public class RCategory {
    private String name;
    private String description;
    private Integer index;
    private Set<RCheck> checks;

    public RCategory(String name, String description, Integer index) {
        this.name = name;
        this.description = description;
        this.index = index;
        this.checks = new LinkedHashSet<RCheck>();
    }

    public RCategory(RCategory category) {
        this.name = category.name;
        this.description = category.description;
        this.index = category.index;
        this.checks = new LinkedHashSet<RCheck>();
        category.checks.stream().forEach(x -> {
            boolean bl = this.checks.add(new RCheck((RCheck)x));
        });
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Set<RCheck> getChecks() {
        return this.checks;
    }

    public void setChecks(Set<RCheck> checks) {
        this.checks = checks;
    }

    public boolean addCheck(RCheck c) {
        return this.checks.add(c);
    }

    public RCategory getSelf() {
        return this;
    }

    public String getCheckIndexesAsString() {
        StringBuilder indexes = new StringBuilder("[");
        for (RCheck checkWrapper : this.checks) {
            indexes.append(checkWrapper.getCheckIndex()).append(',');
        }
        VerissimoReportWriter.removeLastChar(indexes);
        indexes.append("]");
        return indexes.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RCategory other = (RCategory)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.description;
    }
}

